/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import com.local.entities.ProjectDesdac;
import java.io.Serializable;
import org.modcs.tools.spn.gui.graphview.GraphView;
import org.modcs.tools.spn.model.DelayParameter;
import org.modcs.tools.spn.model.EDSPN;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.simulator.entities.ModelGenerator;

public class Identifier
implements Serializable {
    private static final long serialVersionUID = 5185493280236746516L;
    private String identifier;
    private double value;

    public double getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public Identifier(String identifier) {
        this.identifier = identifier;
    }

    public Identifier(String identifier, double value) {
        this.identifier = identifier;
        this.value = value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public static boolean isValid(String text) {
        char[] array = text.toCharArray();
        if (!Character.isLetter(array[0])) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (Character.isDigit(c) || Character.isLetter(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return Identifier.isValid(this.identifier);
    }

    public static Identifier parse(String text) {
        int i;
        if (!Identifier.isValid(text)) {
            return null;
        }
        EDSPN edspn = null;
        edspn = ProjectDesdac.isIsImpoting() ? ModelGenerator.getEdspn() : GraphView.getEdspn();
        for (i = 0; i < edspn.getDelayParameters().size(); ++i) {
            DelayParameter delayParameter = edspn.getDelayParameters().get(i);
            if (!text.equals(delayParameter.getName())) continue;
            return new Identifier(text, delayParameter.getValue());
        }
        for (i = 0; i < edspn.getPlaces().size(); ++i) {
            Place place = edspn.getPlaces().get(i);
            if (!text.equals(place.getName())) continue;
            return new Identifier(text);
        }
        return null;
    }

    public double evaluate() {
        int i;
        EDSPN edspn = null;
        edspn = ProjectDesdac.isIsImpoting() ? ModelGenerator.getEdspn() : GraphView.getEdspn();
        for (i = 0; i < edspn.getDelayParameters().size(); ++i) {
            DelayParameter delayParameter = edspn.getDelayParameters().get(i);
            if (!this.identifier.equals(delayParameter.getName())) continue;
            return delayParameter.getValue();
        }
        for (i = 0; i < edspn.getPlaces().size(); ++i) {
            Place place = edspn.getPlaces().get(i);
            if (!this.identifier.equals(place.getName())) continue;
            return place.getMarking();
        }
        return -1.0;
    }

    public String toString() {
        return this.identifier;
    }
}

