/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartTransient {
    public JPanel getChart(ArrayList<Double> values, double time) {
        return this.getChart(values, time, "R(t)", "Reliability Values");
    }

    public JPanel getChart(ArrayList<Double> values, double time, double minimumRange, double maximumRange) {
        DefaultXYDataset dataset = new DefaultXYDataset();
        dataset.addSeries((Comparable)((Object)"R(t)"), ChartTransient.createSeries(values, time));
        Chart chart2 = new Chart((XYDataset)dataset, "Reliability Values", true, minimumRange, maximumRange);
        return chart2.getJPanelChart();
    }

    public JPanel getChart(ArrayList<Double> values, double time, String text1, String text2) {
        DefaultXYDataset dataset = new DefaultXYDataset();
        dataset.addSeries((Comparable)((Object)text1), ChartTransient.createSeries(values, time));
        Chart chart2 = new Chart((XYDataset)dataset, text2, true, new double[0]);
        return chart2.getJPanelChart();
    }

    public JPanel getChart(ArrayList<Double> values, double time, String text1, String text2, double minimumRange, double maximumRange) {
        DefaultXYDataset dataset = new DefaultXYDataset();
        dataset.addSeries((Comparable)((Object)text1), ChartTransient.createSeries(values, time));
        Chart chart2 = new Chart((XYDataset)dataset, text2, true, minimumRange, maximumRange);
        return chart2.getJPanelChart();
    }

    public JPanel getChart(double[][] series, String text1, String text2) {
        DefaultXYDataset dataset = new DefaultXYDataset();
        dataset.addSeries((Comparable)((Object)text1), series);
        Chart chart2 = new Chart((XYDataset)dataset, text2, true, new double[0]);
        return chart2.getJPanelChart();
    }

    private static double[][] createSeries(ArrayList<Double> values, double timeStamp) {
        double[][] series = new double[2][values.size()];
        for (int i = 0; i < values.size(); ++i) {
            series[0][i] = (double)(i + 1) * timeStamp;
            series[1][i] = values.get(i);
        }
        return series;
    }

    public static void main(String ... args) {
        ChartTransient chartTransient = new ChartTransient();
        ArrayList<Double> doubles = new ArrayList<Double>();
        for (int i = 0; i < 40; ++i) {
            double d = i * i;
            doubles.add(new Double(d));
        }
        JPanel panelChart = chartTransient.getChart(doubles, 1.0);
        JFrame jFrame = new JFrame();
        jFrame.add(panelChart);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class Chart {
        private JFreeChart jFreeChar = null;
        private XYDataset xyDataSet1 = null;

        public Chart(XYDataset dataset1, String name, boolean isDiscrete, double ... rangesValues) {
            this.setXYDataSet1(dataset1);
            this.jFreeChar = ChartFactory.createXYLineChart((String)name, (String)"Domain", (String)"Rannge", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            this.jFreeChar.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = (XYPlot)this.jFreeChar.getPlot();
            plot.setBackgroundPaint((Paint)new Color(0xFFFFD0));
            plot.setDomainGridlinesVisible(true);
            plot.setBackgroundPaint((Paint)Color.lightGray);
            plot.setDomainGridlinePaint((Paint)Color.white);
            plot.setRangeGridlinePaint((Paint)Color.white);
            TickUnitSource ticks = NumberAxis.createIntegerTickUnits();
            NumberAxis domain = (NumberAxis)plot.getDomainAxis();
            domain.setStandardTickUnits(ticks);
            NumberAxis range = (NumberAxis)plot.getRangeAxis();
            range.setStandardTickUnits(ticks);
            if (rangesValues.length != 0) {
                range.setAutoRange(false);
                range.setRange(rangesValues[0], rangesValues[1]);
            }
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, true);
            plot.setRenderer((XYItemRenderer)renderer);
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            BasicStroke stroke = new BasicStroke(3.0f, 1, 2);
            renderer.setBaseOutlineStroke((Stroke)stroke);
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(4);
            StandardXYItemLabelGenerator generator = new StandardXYItemLabelGenerator("{2}", format, format);
            renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)generator);
            renderer.setBaseItemLabelsVisible(true);
        }

        public void setXYDataSet1(XYDataset xyDataSet) {
            this.xyDataSet1 = xyDataSet;
        }

        public JFreeChart getJFreeChar() {
            return this.jFreeChar;
        }

        public JPanel getJPanelChart() {
            ChartPanel jpanelResult = new ChartPanel(this.getJFreeChar(), true, true, true, true, true);
            return jpanelResult;
        }
    }
}

