/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui;

import com.thoughtworks.xstream.XStream;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.experiment.ExperimentResult;
import org.modcs.tools.spn.gui.graphview.ChartTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDialogExperimentOutput
extends JDialog {
    private ArrayList<ExperimentResult> experimentResults;
    private double[][] series;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanelGraph;

    public JDialogExperimentOutput(Frame parent, boolean modal, double[][] series, ArrayList<ExperimentResult> experimentResults) {
        super(parent, modal);
        this.initComponents();
        ChartTransient chartTransient = new ChartTransient();
        JPanel chartPanel = chartTransient.getChart(series, "Delay Value", "Experiment Output");
        Util.refreshScreen(chartPanel, this.jPanelGraph);
        this.experimentResults = experimentResults;
        this.series = series;
    }

    private void initComponents() {
        this.jPanelGraph = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Experiment Result");
        this.jPanelGraph.setBorder(BorderFactory.createTitledBorder("Experiment Result"));
        GroupLayout jPanelGraphLayout = new GroupLayout(this.jPanelGraph);
        this.jPanelGraph.setLayout(jPanelGraphLayout);
        jPanelGraphLayout.setHorizontalGroup(jPanelGraphLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 759, Short.MAX_VALUE));
        jPanelGraphLayout.setVerticalGroup(jPanelGraphLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 496, Short.MAX_VALUE));
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogExperimentOutput.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Save XML");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogExperimentOutput.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelGraph, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelGraph, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.saveFileAs();
    }

    private void saveFileAs() {
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.setFileSelectionMode(0);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.getName() == null) {
                    return false;
                }
                if (f.getName().endsWith(".xml")) {
                    return true;
                }
                return f.isDirectory();
            }

            public String getDescription() {
                return "XML files (.xml)";
            }
        };
        fc.setFileFilter(fileFilter);
        fc.showSaveDialog(this);
        File file = fc.getSelectedFile();
        if (file != null) {
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            try {
                XStream xstream = new XStream();
                try {
                    FileOutputStream fs = new FileOutputStream(file);
                    xstream.toXML(this.experimentResults, (OutputStream)fs);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            }
        }
    }
}

