/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.modcs.tools.spn.model.Arc;
import org.modcs.tools.spn.model.expressions.IfElseExpression;

public class JDialogArcProperties
extends JDialog {
    private int multiplicity;
    protected Arc arc;
    public static final String PROP_ARC = "arc";
    private IfElseExpression ifElseExpression;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JTextField jTextFieldMultiplicity;

    public Arc getArc() {
        return this.arc;
    }

    public void setArc(Arc arc) {
        Arc oldArc = this.arc;
        this.arc = arc;
        this.propertyChangeSupport.firePropertyChange(PROP_ARC, oldArc, arc);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public JDialogArcProperties(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public JDialogArcProperties(Frame parent, boolean enabled, Arc arc) {
        this(parent, enabled);
        this.setArc(arc);
        this.multiplicity = arc.getMultiplicity();
        if (this.arc.getMultiplicityExpression() != null) {
            this.jTextFieldMultiplicity.setText(this.arc.getMultiplicityExpression().getStringCondition());
        } else {
            this.jTextFieldMultiplicity.setText(this.multiplicity + "");
        }
    }

    private void initComponents() {
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextFieldMultiplicity = new JTextField();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Arc Properties");
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogArcProperties.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogArcProperties.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Arc Properties"));
        this.jPanel1.setToolTipText("Arc Properties");
        this.jTextFieldMultiplicity.setToolTipText("You can insert Labels and IFELSE expressions like (IF(#Place>0):(256)ELSE(26))");
        this.jTextFieldMultiplicity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogArcProperties.this.jTextFieldMultiplicityActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Multiplicity:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jTextFieldMultiplicity, -1, 265, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMultiplicity, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap()));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        String stringTemp = this.jTextFieldMultiplicity.getText();
        int multi = 0;
        IfElseExpression expression = null;
        expression = IfElseExpression.parse(stringTemp);
        if (expression == null) {
            try {
                multi = Integer.parseInt(stringTemp);
                this.arc.setMultiplicity(multi);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, "Error: Delay");
            }
        } else {
            this.arc.setMultiplicityExpression(expression);
        }
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.ifElseExpression == null) {
            this.arc.setMultiplicity(this.multiplicity);
        } else {
            this.arc.setMultiplicityExpression(this.ifElseExpression);
        }
        this.dispose();
    }

    private void jTextFieldMultiplicityActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JDialogArcProperties dialog = new JDialogArcProperties((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

