/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import com.local.entities.ProjectDesdac;
import com.local.gui.JFrameDesdacTool;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.modcs.tools.Util.Util;
import org.modcs.tools.rbd.blocks.InterfaceCalculatorRBD;
import org.modcs.tools.rbd.blocks.bounds.SDPMethod;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.JDialogResultsRBD;
import org.modcs.tools.rbd.gui.ParametersResultsRBD;
import org.modcs.tools.rbd.gui.ResultAnalisysScreen;

public class ReliabilityAnalisysScreen
extends JDialog {
    private boolean fromDataCenter;
    private JFrameDesdacTool jFrame;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBoxAvailability;
    private JCheckBox jCheckBoxAvailabilityInstant;
    private JCheckBox jCheckBoxMTTF;
    private JCheckBox jCheckBoxMTTR;
    private JCheckBox jCheckBoxReliability;
    private JCheckBox jCheckBoxUnreliability;
    private JComboBox jComboBoxCalculation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextField1;
    private JTextField jTextFieldNumSamplingPoints;

    public ReliabilityAnalisysScreen(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public ReliabilityAnalisysScreen(Frame parent, boolean modal, boolean fromDataCenter) {
        this(parent, modal);
        this.fromDataCenter = fromDataCenter;
        if (parent instanceof JFrameDesdacTool) {
            this.jFrame = (JFrameDesdacTool)parent;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jCheckBoxReliability = new JCheckBox();
        this.jCheckBoxUnreliability = new JCheckBox();
        this.jCheckBoxMTTF = new JCheckBox();
        this.jCheckBoxMTTR = new JCheckBox();
        this.jCheckBoxAvailabilityInstant = new JCheckBox();
        this.jCheckBoxAvailability = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jTextFieldNumSamplingPoints = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel3 = new JPanel();
        this.jComboBoxCalculation = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Reliability Analisys");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Choose Metrics"));
        this.jCheckBoxReliability.setSelected(true);
        this.jCheckBoxReliability.setText("Reliability");
        this.jCheckBoxUnreliability.setSelected(true);
        this.jCheckBoxUnreliability.setText("Unreliability");
        this.jCheckBoxUnreliability.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReliabilityAnalisysScreen.this.jCheckBoxUnreliabilityActionPerformed(evt);
            }
        });
        this.jCheckBoxMTTF.setSelected(true);
        this.jCheckBoxMTTF.setText("Mean Time to Failure");
        this.jCheckBoxMTTR.setSelected(true);
        this.jCheckBoxMTTR.setText("Mean Time to Repair");
        this.jCheckBoxAvailabilityInstant.setSelected(true);
        this.jCheckBoxAvailabilityInstant.setText("Instantaneous Availability");
        this.jCheckBoxAvailability.setSelected(true);
        this.jCheckBoxAvailability.setText("Steady-State Availability");
        this.jLabel1.setText("Evaluation Time");
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReliabilityAnalisysScreen.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("# Sampling points");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -1, 335, Short.MAX_VALUE).addComponent(this.jCheckBoxUnreliability).addComponent(this.jCheckBoxAvailability).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxReliability).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 79, Short.MAX_VALUE).addComponent(this.jCheckBoxAvailabilityInstant)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxMTTF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 35, Short.MAX_VALUE).addComponent(this.jCheckBoxMTTR)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldNumSamplingPoints, -1, 226, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 226, Short.MAX_VALUE)))).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -2, -1, -2).addContainerGap())));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxMTTF).addComponent(this.jCheckBoxMTTR)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAvailability).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxReliability).addComponent(this.jCheckBoxAvailabilityInstant)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxUnreliability).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldNumSamplingPoints, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(25, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(206, 206, 206).addComponent(this.jSeparator1, -2, 10, -2).addContainerGap(-1, Short.MAX_VALUE))));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jButton1.setText("Run");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReliabilityAnalisysScreen.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReliabilityAnalisysScreen.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(222, Short.MAX_VALUE).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1)).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Choose Calculation Type"));
        this.jComboBoxCalculation.setModel(new DefaultComboBoxModel<String>(new String[]{"Standard Calculation", "Sum of Disjoint Products"}));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBoxCalculation, -2, -1, -2).addContainerGap(180, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jComboBoxCalculation, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 255, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void executeAnalisys() {
        ProjectDesdac projectDesdac = null;
        if (this.getParent() instanceof JFrameDesdacTool) {
            JFrameDesdacTool jFrameDesdacTool = (JFrameDesdacTool)this.getParent();
            projectDesdac = jFrameDesdacTool.getProjectDesdac();
        }
        if (!GraphViewRBD.app.getRBDModel().isModelHasReliabilityEdited()) {
            JOptionPane.showMessageDialog(null, "Block not Edited", "ERROR", 0);
            return;
        }
        Long time = null;
        try {
            time = Long.parseLong(this.jTextField1.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        String outputString = "";
        outputString = outputString + "***********Reliability Analisys************";
        if (time != null) {
            outputString = outputString + "\nTime: " + time;
        }
        outputString = outputString + "\n";
        if (time != null && this.jCheckBoxReliability.isSelected()) {
            outputString = outputString + "Reliability = " + GraphViewRBD.app.getRBDModel().getModel().calculateReliability(time.longValue());
            outputString = outputString + "\n";
        }
        if (time != null && this.jCheckBoxUnreliability.isSelected()) {
            outputString = outputString + "Unreliability = " + (1.0 - GraphViewRBD.app.getRBDModel().getModel().calculateReliability(time.longValue()));
            outputString = outputString + "\n";
        }
        if (this.jCheckBoxMTTF.isSelected()) {
            double mttf = GraphViewRBD.app.getRBDModel().getModel().calculateMeanTimeToFailure();
            projectDesdac.setMttf(new Double(mttf));
            outputString = outputString + "Mean Time to Failure = " + mttf;
            outputString = outputString + "\n";
        }
        if (this.jCheckBoxMTTR.isSelected()) {
            double mttr = GraphViewRBD.app.getRBDModel().getModel().calculateMeanTimeToRepair();
            projectDesdac.setMttr(new Double(mttr));
            outputString = outputString + "Mean Time to Repair = " + mttr;
            outputString = outputString + "\n";
        }
        if (time != null && this.jCheckBoxAvailabilityInstant.isSelected()) {
            outputString = outputString + "Instantaneous Availability = " + GraphViewRBD.app.getRBDModel().getModel().calculateAvailability(time.longValue());
            outputString = outputString + "\n";
        }
        if (this.jCheckBoxAvailability.isSelected()) {
            double av = GraphViewRBD.app.getRBDModel().getModel().calculateAvailability(9.223372036854776E18);
            outputString = outputString + "Steady-State Availability = " + av;
            outputString = outputString + "\n";
            projectDesdac.setAvailability(av);
        }
        outputString = outputString + "***********End of Analisys************";
        outputString = outputString + "\n";
        ResultAnalisysScreen resultScreen = new ResultAnalisysScreen((Frame)GraphViewRBD.mainScreen, true, outputString);
        resultScreen.setLocationRelativeTo(this);
        resultScreen.setVisible(true);
        this.setVisible(false);
    }

    private void showResults() {
        ProjectDesdac projectDesdac = null;
        if (this.getParent() instanceof JFrameDesdacTool) {
            JFrameDesdacTool jFrameDesdacTool = (JFrameDesdacTool)this.getParent();
            projectDesdac = jFrameDesdacTool.getProjectDesdac();
        }
        if (!GraphViewRBD.app.getRBDModel().isModelHasReliabilityEdited()) {
            JOptionPane.showMessageDialog(null, "Block not Edited", "ERROR", 0);
            return;
        }
        double time = 0.0;
        int sampingPoints = 0;
        try {
            time = Double.parseDouble(this.jTextField1.getText());
            sampingPoints = Integer.parseInt(this.jTextFieldNumSamplingPoints.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        InterfaceCalculatorRBD icalculatorRBD = this.jComboBoxCalculation.getSelectedIndex() == 0 ? GraphViewRBD.app.getRBDModel() : new SDPMethod(GraphViewRBD.app.getRBDModel().getModel());
        JDialogResultsRBD jDialogResultsRBD = new JDialogResultsRBD(null, true);
        jDialogResultsRBD.setLocationRelativeTo(null);
        ParametersResultsRBD parametersResultsRBD = jDialogResultsRBD.getParametersResultsRBD();
        if (time > 0.0) {
            int i;
            ArrayList<Double> doubles;
            parametersResultsRBD.setTotaltime(time);
            parametersResultsRBD.setSamplingPoints(sampingPoints);
            if (this.jCheckBoxReliability.isSelected()) {
                doubles = new ArrayList<Double>();
                for (i = 0; i < sampingPoints; ++i) {
                    double reliabilityValue = icalculatorRBD.getReliability(time / (double)sampingPoints * (double)(i + 1));
                    reliabilityValue = Util.numberOfNines(reliabilityValue);
                    doubles.add(new Double(reliabilityValue));
                }
                parametersResultsRBD.setReliabilityValuesAsNines(doubles);
            }
            if (this.jCheckBoxAvailabilityInstant.isSelected()) {
                doubles = new ArrayList();
                for (i = 0; i < sampingPoints; ++i) {
                    double availabilityValue = icalculatorRBD.getAvailability(time / (double)sampingPoints * (double)(i + 1));
                    availabilityValue = Util.numberOfNines(availabilityValue);
                    doubles.add(new Double(availabilityValue));
                }
                parametersResultsRBD.setInstantAvailabilityValues(doubles);
            }
        }
        if (this.jCheckBoxMTTF.isSelected()) {
            double mttf = GraphViewRBD.app.getRBDModel().getModel().calculateMeanTimeToFailure();
            projectDesdac.setMttf(new Double(mttf));
            parametersResultsRBD.setMttf(mttf);
        }
        if (this.jCheckBoxMTTR.isSelected()) {
            double mttr = GraphViewRBD.app.getRBDModel().getModel().calculateMeanTimeToRepair();
            projectDesdac.setMttr(new Double(mttr));
            parametersResultsRBD.setMttr(mttr);
        }
        if (this.jCheckBoxAvailability.isSelected()) {
            double av = icalculatorRBD.getAvailability();
            projectDesdac.setAvailability(av);
            parametersResultsRBD.setAvailability(av);
        }
        jDialogResultsRBD.updateParameters();
        jDialogResultsRBD.setVisible(true);
        if (this.fromDataCenter) {
            this.jFrame.newRBD();
            this.jFrame.insertRBDView();
            this.jFrame.removeRBDView();
            this.dispose();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.showResults();
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxUnreliabilityActionPerformed(ActionEvent evt) {
    }
}

