/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.TextAnchor;
import org.modcs.tools.rbd.evaluatorrbd.BlockImportance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartCategory {
    private CategoryDataset createDataset() {
        double[][] data = new double[][]{{4.0, 3.0, -2.0, 3.0, 6.0}};
        return DatasetUtilities.createCategoryDataset((String)"Series ", (String)"Category ", (double[][])data);
    }

    public static ChartPanel createChartPanel(ArrayList<BlockImportance> blockImportances) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < blockImportances.size(); ++i) {
            String name = blockImportances.get(i).getName();
            double importance = blockImportances.get(i).getNormalizedImportance();
            dataset.setValue(importance, (Comparable)((Object)"Component"), (Comparable)((Object)name));
        }
        JFreeChart chart2 = ChartFactory.createBarChart3D((String)"Reliability Importance", (String)"Component name", (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        chart2.setBackgroundPaint((Paint)Color.lightGray);
        CategoryPlot plot = chart2.getCategoryPlot();
        plot.setNoDataMessage("NO DATA!");
        CustomRenderer renderer = new CustomRenderer(new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.cyan, Color.magenta, Color.blue, Color.darkGray});
        renderer.setItemLabelsVisible(true);
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 45.0);
        renderer.setPositiveItemLabelPosition(p);
        plot.setRenderer((CategoryItemRenderer)renderer);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        return new ChartPanel(chart2);
    }

    static class CustomRenderer
    extends BarRenderer3D {
        private Paint[] colors;

        public CustomRenderer(Paint[] colors) {
            this.colors = colors;
        }

        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }
    }
}

