/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks.bounds;

import java.util.ArrayList;
import java.util.Arrays;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockBridge;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.BlockKOutOfN;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathsAndCuts {
    private int nodes = 1;
    private ArrayList<Block> blocksOfModel = new ArrayList();
    private MinimalPath[] minPaths;
    private MinimalCut[] minCuts;

    public PathsAndCuts(Block rbdModel) {
        ArrayList<Integer> prevNode = new ArrayList<Integer>();
        ArrayList<Integer> nextNode = new ArrayList<Integer>();
        String pathsExpression = "";
        prevNode.add(0);
        nextNode.add(1);
        this.clearNodes(rbdModel);
        this.insertPerfectNodes(rbdModel, prevNode, nextNode);
        String[][] matrix = this.generateConnMatrix(this.blocksOfModel, rbdModel);
        pathsExpression = matrix.length == 2 ? matrix[0][1] : this.matrixReduction(matrix);
        this.setMinPaths(pathsExpression);
        this.setMinCuts(pathsExpression);
    }

    private String matrixReduction(String[][] matrix) {
        int lengthMatrix = matrix.length - 1;
        String[][] reducedMatrix = new String[lengthMatrix][lengthMatrix];
        for (int j = 0; j < lengthMatrix + 1; ++j) {
            for (int i = 0; i <= j; ++i) {
                int k = i;
                int l = j;
                if (i != 0) {
                    k = i - 1;
                }
                if (j != 0) {
                    l = j - 1;
                }
                if (i != j) {
                    if (i == 1 || j == 1) continue;
                    reducedMatrix[k][l] = this.booleanSimplification(matrix[i][j] + "+" + matrix[i][1] + "*" + matrix[1][j]);
                    reducedMatrix[l][k] = reducedMatrix[k][l];
                    continue;
                }
                reducedMatrix[k][l] = "1";
            }
        }
        if (reducedMatrix.length > 2) {
            return this.matrixReduction(reducedMatrix);
        }
        if (reducedMatrix[0][1].contains("(")) {
            return reducedMatrix[0][1].substring(1, reducedMatrix[0][1].length() - 1);
        }
        return reducedMatrix[0][1];
    }

    private String booleanSimplification(String expression) {
        if (expression.startsWith("0+") || expression.startsWith("1*")) {
            expression = expression.substring(2, expression.length());
        }
        if (expression.contains("*1+")) {
            expression = expression.replace("*1+", "+");
        }
        if (expression.contains("+1*")) {
            expression = expression.replace("+1*", "+");
        }
        if (expression.endsWith("*1")) {
            expression = expression.substring(0, expression.length() - 2);
        }
        if (expression.contains("(")) {
            expression = this.multiplies(expression);
        }
        String finalExpression = "";
        ArrayList<String> terms = new ArrayList<String>(Arrays.asList(expression.split("\\+")));
        for (int i = 0; i < terms.size(); ++i) {
            if (terms.contains("1")) {
                finalExpression = "1";
                terms.set(i, "1");
                continue;
            }
            if (terms.indexOf(terms.get(i)) != i) {
                terms.remove(terms.get(i));
                --i;
                continue;
            }
            ArrayList<String> actualTerm = new ArrayList<String>(Arrays.asList(terms.get(i).split("\\*")));
            for (String str : actualTerm) {
                if (actualTerm.indexOf(str) == actualTerm.lastIndexOf(str)) continue;
                actualTerm.remove(str);
                break;
            }
            if (actualTerm.contains("0")) {
                terms.remove(terms.get(i));
                --i;
                continue;
            }
            String acum = "";
            for (String str : actualTerm) {
                if (acum.equals("")) {
                    acum = str;
                    continue;
                }
                acum = acum + "*" + str;
            }
            terms.set(i, acum);
            for (int j = 0; j < terms.size(); ++j) {
                if (j == i) continue;
                boolean isOrNo = true;
                ArrayList<String> otherTerm = new ArrayList<String>(Arrays.asList(terms.get(j).split("\\*")));
                if (otherTerm.size() > actualTerm.size()) {
                    for (String str : actualTerm) {
                        if (otherTerm.contains(str)) continue;
                        isOrNo = false;
                    }
                    if (!isOrNo) continue;
                    terms.remove(terms.get(j));
                    if (j < i) {
                        --i;
                    }
                    --j;
                    continue;
                }
                if (otherTerm.size() >= actualTerm.size()) continue;
                for (String str : otherTerm) {
                    if (actualTerm.contains(str)) continue;
                    isOrNo = false;
                }
                if (!isOrNo) continue;
                terms.remove(terms.get(i));
                --i;
                j = terms.size();
            }
        }
        if (terms.size() > 0) {
            if (terms.contains("1")) {
                finalExpression = "1";
            } else {
                for (String term : terms) {
                    if (finalExpression.equals("")) {
                        finalExpression = term;
                        continue;
                    }
                    finalExpression = finalExpression + "+" + term;
                }
            }
        } else {
            finalExpression = "0";
        }
        if (finalExpression.equals("")) {
            return "0";
        }
        if (finalExpression.contains("+")) {
            return "(" + finalExpression + ")";
        }
        return finalExpression;
    }

    private String multiplies(String expression) {
        String newExpression = "";
        if (expression.startsWith("(") && expression.contains(")+")) {
            newExpression = expression.substring(expression.indexOf(")") + 2, expression.length());
            expression = expression.substring(1, expression.indexOf(")"));
        } else if (expression.startsWith("(") && !expression.contains(")+")) {
            newExpression = expression;
            expression = "";
        } else {
            newExpression = expression.substring(expression.indexOf("+") + 1);
            expression = expression.substring(0, expression.indexOf("+"));
        }
        if (!newExpression.contains("*(") && !newExpression.contains(")*")) {
            if (newExpression.equals("0")) {
                expression = "";
            } else {
                newExpression = newExpression.replace("(", "");
                newExpression = newExpression.replace(")", "");
                expression = expression + "+" + newExpression;
            }
        } else {
            StringBuilder strExp = new StringBuilder(expression);
            String[] factor1 = null;
            String[] factor2 = null;
            if (newExpression.contains(")*(")) {
                factor1 = newExpression.substring(1, newExpression.indexOf(")*(")).split("\\+");
                factor2 = newExpression.substring(newExpression.indexOf(")*(") + 3, newExpression.length() - 1).split("\\+");
            } else if (newExpression.contains(")*")) {
                factor1 = newExpression.substring(1, newExpression.indexOf(")*")).split("\\+");
                factor2 = newExpression.substring(newExpression.indexOf(")*") + 2, newExpression.length()).split("\\+");
            } else if (newExpression.contains("*(")) {
                factor1 = newExpression.substring(0, newExpression.indexOf("*(")).split("\\+");
                factor2 = newExpression.substring(newExpression.indexOf("*(") + 2, newExpression.length() - 1).split("\\+");
            }
            if (factor2.length == 1 && factor2[0].equals("0")) {
                expression = "0";
            } else {
                for (int i = 0; i < factor1.length; ++i) {
                    for (int j = 0; j < factor2.length; ++j) {
                        String partial = factor1[i].equals(factor2[j]) ? factor1[i] : factor1[i] + "*" + factor2[j];
                        if (strExp.toString().equals("")) {
                            strExp.append(partial);
                            continue;
                        }
                        strExp.append("+" + partial);
                    }
                }
            }
            expression = strExp.toString();
        }
        return expression;
    }

    private String[][] generateConnMatrix(ArrayList<Block> model, Block bk) {
        String[][] matrix = new String[this.nodes + 1][this.nodes + 1];
        if (bk.getNextNode().size() > 1) {
            for (int j = 0; j < bk.getNextNode().size() - 1; ++j) {
                for (int i = j + 1; i < bk.getNextNode().size(); ++i) {
                    matrix[bk.getNextNode().get((int)i).intValue()][bk.getNextNode().get((int)j).intValue()] = "1";
                    matrix[bk.getNextNode().get((int)j).intValue()][bk.getNextNode().get((int)i).intValue()] = "1";
                }
            }
        }
        for (int line = 0; line <= this.nodes; ++line) {
            for (int column = line; column <= this.nodes; ++column) {
                if (line == column) {
                    matrix[line][column] = "1";
                    continue;
                }
                for (int w = 0; w < model.size(); ++w) {
                    if (model.get(w).getPreviewsNode().size() > 1) {
                        for (int i = 0; i < model.get(w).getPreviewsNode().size(); ++i) {
                            for (int j = i + 1; j < model.get(w).getPreviewsNode().size(); ++j) {
                                matrix[model.get((int)w).getPreviewsNode().get((int)i).intValue()][model.get((int)w).getPreviewsNode().get((int)j).intValue()] = "1";
                                matrix[model.get((int)w).getPreviewsNode().get((int)j).intValue()][model.get((int)w).getPreviewsNode().get((int)i).intValue()] = "1";
                            }
                        }
                    }
                    if (!model.get(w).getPreviewsNode().contains(line) || !model.get(w).getNextNode().contains(column)) continue;
                    String string = model.get(w).getName();
                    matrix[line][column] = string;
                    matrix[column][line] = string;
                    break;
                }
                if (matrix[column][line] != null) continue;
                matrix[line][column] = "0";
                matrix[column][line] = "0";
            }
        }
        return matrix;
    }

    private void insertPerfectNodes(Block block, ArrayList<Integer> prev, ArrayList<Integer> next) {
        if (block instanceof BlockSeries) {
            this.insertNodesOnSerieBlock(block, prev, next);
        } else if (block instanceof BlockParallel) {
            this.insertNodesOnParallelBlock(block, prev, next);
        } else if (block instanceof BlockBridge) {
            this.insertNodesOnBridgeBlock(block, prev, next);
        } else {
            next.clear();
            next.add(this.nodes);
            block.addNextNodes(next);
            block.addPreviewsNodes(prev);
            this.blocksOfModel.add(block);
        }
    }

    private void insertNodesOnSerieBlock(Block block, ArrayList<Integer> previews, ArrayList<Integer> next) {
        BlockSeries bSeries = (BlockSeries)block;
        block.addPreviewsNodes(previews);
        for (int i = 0; i < bSeries.getBlocks().size(); ++i) {
            if (i == 0) {
                this.insertPerfectNodes(bSeries.getBlocks().get(i), block.getPreviewsNode(), next);
                continue;
            }
            ++this.nodes;
            next.clear();
            next.add(this.nodes);
            this.insertPerfectNodes(bSeries.getBlocks().get(i), bSeries.getBlocks().get(i - 1).getNextNode(), next);
        }
        block.addNextNodes(bSeries.getBlocks().get(bSeries.getBlocks().size() - 1).getNextNode());
    }

    private void insertNodesOnParallelBlock(Block block, ArrayList<Integer> previews, ArrayList<Integer> next) {
        BlockParallel bParallel = (BlockParallel)block;
        block.addPreviewsNodes(previews);
        for (int i = 0; i < bParallel.getBlocks().size(); ++i) {
            if (i == 0) {
                this.insertPerfectNodes(bParallel.getBlocks().get(i), previews, next);
            } else {
                ++this.nodes;
                next.clear();
                next.add(this.nodes);
                this.insertPerfectNodes(bParallel.getBlocks().get(i), previews, next);
            }
            next.clear();
            next.add(this.nodes);
            block.addNextNodes(bParallel.getBlocks().get(i).getNextNode());
        }
    }

    private void insertNodesOnBridgeBlock(Block block, ArrayList<Integer> previews, ArrayList<Integer> next) {
        BlockBridge bBridge = (BlockBridge)block;
        block.addPreviewsNodes(previews);
        this.insertPerfectNodes(bBridge.getBlocks().get(0), previews, next);
        ++this.nodes;
        next.clear();
        next.add(this.nodes);
        this.insertPerfectNodes(bBridge.getBlocks().get(2), previews, next);
        this.insertPerfectNodes(bBridge.getBlocks().get(4), bBridge.getBlocks().get(0).getNextNode(), next);
        ++this.nodes;
        next.clear();
        next.add(this.nodes);
        this.insertPerfectNodes(bBridge.getBlocks().get(1), bBridge.getBlocks().get(0).getNextNode(), next);
        next.clear();
        next.add(this.nodes);
        this.insertPerfectNodes(bBridge.getBlocks().get(3), bBridge.getBlocks().get(2).getNextNode(), next);
        block.addNextNodes(bBridge.getBlocks().get(3).getNextNode());
    }

    private void clearNodes(Block block) {
        if (block instanceof BlockSeries) {
            BlockSeries bSeries = (BlockSeries)block;
            for (int i = 0; i < bSeries.getBlocks().size(); ++i) {
                this.clearNodes(bSeries.getBlocks().get(i));
            }
        } else if (block instanceof BlockParallel) {
            BlockParallel bParallel = (BlockParallel)block;
            for (int i = 0; i < bParallel.getBlocks().size(); ++i) {
                this.clearNodes(bParallel.getBlocks().get(i));
            }
        } else if (block instanceof BlockBridge) {
            BlockBridge bb = (BlockBridge)block;
            for (int i = 0; i < 5; ++i) {
                this.clearNodes(bb.getBlocks().get(i));
            }
        } else if (block instanceof BlockKOutOfN) {
            block.clearNodes();
        }
        block.clearNodes();
    }

    public MinimalPath[] getMinPaths() {
        return this.minPaths;
    }

    private void setMinPaths(String pathsExpression) {
        MinimalPath minPath = new MinimalPath();
        String[] minimalPaths = pathsExpression.split("\\+");
        this.minPaths = new MinimalPath[minimalPaths.length];
        for (int i = 0; i < minimalPaths.length; ++i) {
            String[] blocksOnPath = minimalPaths[i].split("\\*");
            minPath = new MinimalPath();
            block1: for (String blockName : blocksOnPath) {
                for (Block b : this.blocksOfModel) {
                    if (!b.getName().equals(blockName)) continue;
                    BlockExponential bk = new BlockExponential(b.getName(), null, null);
                    bk.setFailureRate(1.0 / b.calculateMeanTimeToFailure());
                    bk.setRepairRate(1.0 / b.calculateMeanTimeToRepair());
                    bk.setIsMaintainabilityEdited(b.isBlockHasMaintainabilityEdited());
                    bk.setIsReliabilityEdited(b.isBlockHasReliabilityEdited());
                    minPath.add(bk);
                    continue block1;
                }
            }
            this.minPaths[i] = minPath;
        }
        Arrays.sort(this.minPaths);
    }

    public MinimalCut[] getMinCuts() {
        return this.minCuts;
    }

    private void setMinCuts(String pathsExpression) {
        String[] minimalPaths;
        String minPathCompIntersection = "";
        for (String path : minimalPaths = pathsExpression.split("\\+")) {
            String[] blocksOnPath = path.split("\\*");
            String minPathComp = "";
            for (String blockName : blocksOnPath) {
                minPathComp = minPathComp.equals("") ? blockName : minPathComp + "+" + blockName;
            }
            minPathCompIntersection = minPathCompIntersection.equals("") ? "(" + minPathComp + ")" : this.booleanSimplification(minPathCompIntersection + "*(" + minPathComp + ")");
        }
        String[] minimalCuts = minPathCompIntersection.substring(1, minPathCompIntersection.length() - 1).split("\\+");
        this.minCuts = new MinimalCut[minimalCuts.length];
        for (int i = 0; i < minimalCuts.length; ++i) {
            String[] blocksOnCut = minimalCuts[i].split("\\*");
            MinimalCut minCut = new MinimalCut();
            block3: for (String blockName : blocksOnCut) {
                for (Block b : this.blocksOfModel) {
                    if (!b.getName().equals(blockName)) continue;
                    BlockExponential bk = new BlockExponential(b.getName(), null, null);
                    bk.setFailureRate(1.0 / b.calculateMeanTimeToFailure());
                    bk.setRepairRate(1.0 / b.calculateMeanTimeToRepair());
                    bk.setIsMaintainabilityEdited(b.isBlockHasMaintainabilityEdited());
                    bk.setIsReliabilityEdited(b.isBlockHasReliabilityEdited());
                    minCut.add(bk);
                    continue block3;
                }
            }
            this.minCuts[i] = minCut;
        }
        Arrays.sort(this.minCuts);
    }

    private void showConnMatrix(String[][] matrix) {
        System.out.println("\n |-> Matriz de Conex\u00e3o |-> ");
        int space = 12;
        for (int i = 0; i < matrix.length; ++i) {
            System.out.print("|");
            for (int j = 0; j < matrix.length; ++j) {
                if (matrix[i][j] == null) {
                    matrix[i][j] = "0";
                }
                String cell = matrix[i][j];
                while (cell.length() < space) {
                    cell = cell + " ";
                }
                System.out.print(" " + cell + " ");
            }
            System.out.println("|");
        }
    }

    private void showModel(Block block, int tab) {
        if (block instanceof BlockSeries) {
            int i;
            this.endenta(tab++);
            System.out.print("Serie: ");
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.println(")");
            BlockSeries blocoEmSerie = (BlockSeries)block;
            for (int i2 = 0; i2 < blocoEmSerie.getBlocks().size(); ++i2) {
                this.showModel(blocoEmSerie.getBlocks().get(i2), tab);
            }
        } else if (block instanceof BlockParallel) {
            int i;
            this.endenta(tab++);
            System.out.print("Parallel: ");
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.println(")");
            BlockParallel blocoEmParalelo = (BlockParallel)block;
            for (int i3 = 0; i3 < blocoEmParalelo.getBlocks().size(); ++i3) {
                this.showModel(blocoEmParalelo.getBlocks().get(i3), tab);
            }
        } else if (block instanceof BlockBridge) {
            int i;
            this.endenta(tab++);
            System.out.print("Bridge: ");
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.println(")");
            BlockBridge blocoEmBridge = (BlockBridge)block;
            for (int i4 = 0; i4 < blocoEmBridge.getBlocks().size(); ++i4) {
                this.showModel(blocoEmBridge.getBlocks().get(i4), tab);
            }
        } else {
            int i;
            this.endenta(tab--);
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ");
            System.out.print("[" + block.getName() + "]");
            System.out.print(" - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.print(")");
            System.out.println("");
        }
    }

    private void endenta(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
    }
}

