/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.evaluatorrbd.RBDLabel;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.EditScreen;

public class BlockExponential
extends Block
implements Serializable {
    private double failureRate;
    private String state = "DEFAULT";
    private double repairRate;
    private boolean isReliabilityEdited;
    private boolean isMaintainabilityEdited;
    private RBDLabel rBDLabelFailure;
    private RBDLabel rBDLabelRepair;

    public BlockExponential(String name, RBDLabel rBDLabelFailure, RBDLabel rBDLabelRepair) {
        this(name, 0.0, 0.0, rBDLabelFailure, rBDLabelRepair);
    }

    public BlockExponential(String name, double failureRate, double repairRate, RBDLabel rBDLabelFailure, RBDLabel rBDLabelRepair) {
        super(name);
        this.failureRate = failureRate;
        this.repairRate = repairRate;
        if (this.failureRate != 0.0 || rBDLabelFailure != null) {
            this.isReliabilityEdited = true;
        }
        if (this.repairRate != 0.0 || rBDLabelRepair != null) {
            this.isMaintainabilityEdited = true;
        }
        this.rBDLabelFailure = rBDLabelFailure;
        this.rBDLabelRepair = rBDLabelRepair;
        this.state = "DEFAULT";
    }

    public void copy(Block block) {
        if (block instanceof BlockExponential) {
            this.name = block.name;
            this.failureRate = ((BlockExponential)block).failureRate;
            this.repairRate = ((BlockExponential)block).repairRate;
            this.rBDLabelFailure = ((BlockExponential)block).rBDLabelFailure;
            this.rBDLabelRepair = ((BlockExponential)block).rBDLabelRepair;
            this.isReliabilityEdited = ((BlockExponential)block).isReliabilityEdited;
            this.isMaintainabilityEdited = ((BlockExponential)block).isMaintainabilityEdited;
        }
    }

    public boolean getIsReliabilityEdited() {
        return this.isReliabilityEdited;
    }

    public void setIsReliabilityEdited(boolean isReliabilityEdited) {
        this.isReliabilityEdited = isReliabilityEdited;
    }

    public boolean getIsMaintainabilityEdited() {
        return this.isMaintainabilityEdited;
    }

    public void setIsMaintainabilityEdited(boolean isMaintainabilityEdited) {
        this.isMaintainabilityEdited = isMaintainabilityEdited;
    }

    public double getFailureRate() {
        if (this.state.equals("DEFAULT")) {
            if (this.rBDLabelFailure == null) {
                return this.failureRate;
            }
            RBDLabel labelTemp = EditScreen.getLabel(this.rBDLabelFailure.getName());
            if (labelTemp != null) {
                return 1.0 / labelTemp.getValue();
            }
            throw new IllegalArgumentException();
        }
        if (this.state.equals("WORKING")) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public void setFailureRate(double failureRate) {
        this.failureRate = failureRate;
    }

    public double getRepairRate() {
        if (this.rBDLabelRepair == null) {
            return this.repairRate;
        }
        RBDLabel labelTemp = EditScreen.getLabel(this.rBDLabelRepair.getName());
        if (labelTemp != null) {
            return 1.0 / labelTemp.getValue();
        }
        throw new IllegalArgumentException();
    }

    public void setRepairRate(double repairRate) {
        this.repairRate = repairRate;
    }

    public double calculateReliability(double time) {
        if (this.state.equals("DEFAULT")) {
            if (time > 0.0) {
                return Math.exp(-(this.getFailureRate() * time));
            }
            return 1.0;
        }
        if (this.state.equals("WORKING")) {
            return 1.0;
        }
        return 0.0;
    }

    public double calculateMeanTimeToFailure() {
        return 1.0 / this.getFailureRate();
    }

    public Coeficient[] getCoeficientsMeanTimeToFailure() {
        Coeficient[] coeficient = new Coeficient[]{new Coeficient(1, this.getFailureRate())};
        return coeficient;
    }

    public double calculateAvailability(double time) {
        return this.getRepairRate() / (this.getRepairRate() + this.getFailureRate()) + this.getFailureRate() / (this.getRepairRate() + this.getFailureRate()) * Math.exp(-(this.getFailureRate() + this.getRepairRate()) * time);
    }

    public double calculateAvailability() {
        return this.getRepairRate() / (this.getRepairRate() + this.failureRate);
    }

    public void updateJTree(DefaultMutableTreeNode nodeTree) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this);
        nodeTree.add(newNode);
    }

    public int getLengthX() {
        return 1;
    }

    public int getLengthY() {
        return 1;
    }

    public RBDLabel getrBDLabelFailure() {
        return this.rBDLabelFailure;
    }

    public void setrBDLabelFailure(RBDLabel rBDLabelFailure) {
        this.rBDLabelFailure = rBDLabelFailure;
    }

    public RBDLabel getrBDLabelRepair() {
        return this.rBDLabelRepair;
    }

    public void setrBDLabelRepair(RBDLabel rBDLabelRepair) {
        this.rBDLabelRepair = rBDLabelRepair;
    }

    public int getLengthXPixels() {
        return GraphViewRBD.BLOCK_SIZE_X;
    }

    public int getLengthYPixels() {
        return GraphViewRBD.BLOCK_SIZE_Y;
    }

    public ConnectionBlock drawBlock(int x, int y) {
        return GraphViewRBD.drawBlock(this, x, y);
    }

    public boolean isBlockHasReliabilityEdited() {
        return this.isReliabilityEdited;
    }

    public boolean isBlockHasMaintainabilityEdited() {
        return this.isMaintainabilityEdited;
    }

    public double calculateMeanTimeToRepair() {
        return 1.0 / this.getRepairRate();
    }

    public void setStateBroken() {
        this.state = "BROKEN";
    }

    public void setStateWorking() {
        this.state = "WORKING";
    }

    public void setStateDefault() {
        this.state = "DEFAULT";
    }

    public String getState() {
        return this.state;
    }

    public MinimalPath[] getMinimalPaths() {
        MinimalPath[] minPaths = new MinimalPath[1];
        MinimalPath thisPath = new MinimalPath();
        thisPath.add(this);
        minPaths[0] = thisPath;
        return minPaths;
    }

    public int getNumberOfPaths() {
        return 1;
    }

    public MinimalCut[] getMinimalCuts() {
        MinimalCut[] minCuts = new MinimalCut[1];
        MinimalCut thisCut = new MinimalCut();
        thisCut.add(this);
        minCuts[0] = thisCut;
        return minCuts;
    }

    public int getNumberOfCuts() {
        return 1;
    }
}

