/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark.metrics;

import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.Target;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class DeserializationSpeedMetric
implements Metric {
    private final int iterations;
    private final boolean validate;

    public DeserializationSpeedMetric(int iterations) {
        this(iterations, false);
    }

    public DeserializationSpeedMetric(int iterations, boolean validate) {
        this.iterations = iterations;
        this.validate = validate;
    }

    public double run(Product product, Target target) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        product.serialize(target.target(), output);
        byte[] data = output.toByteArray();
        product.deserialize(new ByteArrayInputStream(data));
        Object lastResult = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.iterations; ++i) {
            lastResult = product.deserialize(new ByteArrayInputStream(data));
        }
        long end = System.currentTimeMillis();
        if (this.validate && this.iterations > 0 && !target.isEqual(lastResult)) {
            throw new RuntimeException("Deserialized object is not equal");
        }
        return end - start;
    }

    public double run(Product product, Object object) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        product.serialize(object, output);
        byte[] data = output.toByteArray();
        product.deserialize(new ByteArrayInputStream(data));
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.iterations; ++i) {
            product.deserialize(new ByteArrayInputStream(data));
        }
        long end = System.currentTimeMillis();
        return end - start;
    }

    public String unit() {
        return "ms";
    }

    public boolean biggerIsBetter() {
        return false;
    }

    public String toString() {
        return "Deserialization speed (" + this.iterations + " iteration" + (this.iterations == 1 ? "" : "s") + ")";
    }
}

