/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.examples;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;

public class AddDimensionedImage {
    public static final int EXPAND_ROW = 1;
    public static final int EXPAND_COLUMN = 2;
    public static final int EXPAND_ROW_AND_COLUMN = 3;
    public static final int OVERLAY_ROW_AND_COLUMN = 7;

    public void addImageToSheet(String cellNumber, HSSFSheet sheet, String imageFile, double reqImageWidthMM, double reqImageHeightMM, int resizeBehaviour) throws FileNotFoundException, IOException, IllegalArgumentException {
        CellReference cellRef = new CellReference(cellNumber);
        this.addImageToSheet(cellRef.getCol(), cellRef.getRow(), sheet, imageFile, reqImageWidthMM, reqImageHeightMM, resizeBehaviour);
    }

    private void addImageToSheet(int colNumber, int rowNumber, HSSFSheet sheet, String imageFile, double reqImageWidthMM, double reqImageHeightMM, int resizeBehaviour) throws FileNotFoundException, IOException, IllegalArgumentException {
        HSSFClientAnchor anchor = null;
        HSSFPatriarch patriarch = null;
        ClientAnchorDetail rowClientAnchorDetail = null;
        ClientAnchorDetail colClientAnchorDetail = null;
        if (resizeBehaviour != 2 && resizeBehaviour != 1 && resizeBehaviour != 3 && resizeBehaviour != 7) {
            throw new IllegalArgumentException("Invalid value passed to the resizeBehaviour parameter of AddDimensionedImage.addImageToSheet()");
        }
        colClientAnchorDetail = this.fitImageToColumns(sheet, colNumber, reqImageWidthMM, resizeBehaviour);
        rowClientAnchorDetail = this.fitImageToRows(sheet, rowNumber, reqImageHeightMM, resizeBehaviour);
        anchor = new HSSFClientAnchor(0, 0, colClientAnchorDetail.getInset(), rowClientAnchorDetail.getInset(), (short)colClientAnchorDetail.getFromIndex(), rowClientAnchorDetail.getFromIndex(), (short)colClientAnchorDetail.getToIndex(), rowClientAnchorDetail.getToIndex());
        anchor.setAnchorType(3);
        int index = sheet.getWorkbook().addPicture(this.imageToBytes(imageFile), 5);
        patriarch = sheet.createDrawingPatriarch();
        patriarch.createPicture(anchor, index);
    }

    private ClientAnchorDetail fitImageToColumns(HSSFSheet sheet, int colNumber, double reqImageWidthMM, int resizeBehaviour) {
        double colWidthMM = 0.0;
        double colCoordinatesPerMM = 0.0;
        int pictureWidthCoordinates = 0;
        ClientAnchorDetail colClientAnchorDetail = null;
        colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(colNumber));
        if (colWidthMM < reqImageWidthMM) {
            if (resizeBehaviour == 2 || resizeBehaviour == 3) {
                sheet.setColumnWidth(colNumber, ConvertImageUnits.millimetres2WidthUnits(reqImageWidthMM));
                colWidthMM = reqImageWidthMM;
                colCoordinatesPerMM = 1023.0 / colWidthMM;
                pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
                colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 1) {
                colClientAnchorDetail = this.calculateColumnLocation(sheet, colNumber, reqImageWidthMM);
            }
        } else {
            colCoordinatesPerMM = 1023.0 / colWidthMM;
            pictureWidthCoordinates = (int)(reqImageWidthMM * colCoordinatesPerMM);
            colClientAnchorDetail = new ClientAnchorDetail(colNumber, colNumber, pictureWidthCoordinates);
        }
        return colClientAnchorDetail;
    }

    private ClientAnchorDetail fitImageToRows(HSSFSheet sheet, int rowNumber, double reqImageHeightMM, int resizeBehaviour) {
        HSSFRow row = null;
        double rowHeightMM = 0.0;
        double rowCoordinatesPerMM = 0.0;
        int pictureHeightCoordinates = 0;
        ClientAnchorDetail rowClientAnchorDetail = null;
        row = sheet.getRow(rowNumber);
        if (row == null) {
            row = sheet.createRow(rowNumber);
        }
        if ((rowHeightMM = (double)row.getHeightInPoints() / 2.83) < reqImageHeightMM) {
            if (resizeBehaviour == 1 || resizeBehaviour == 3) {
                row.setHeightInPoints((float)(reqImageHeightMM * 2.83));
                rowHeightMM = reqImageHeightMM;
                rowCoordinatesPerMM = 255.0 / rowHeightMM;
                pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
                rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
            } else if (resizeBehaviour == 7 || resizeBehaviour == 2) {
                rowClientAnchorDetail = this.calculateRowLocation(sheet, rowNumber, reqImageHeightMM);
            }
        } else {
            rowCoordinatesPerMM = 255.0 / rowHeightMM;
            pictureHeightCoordinates = (int)(reqImageHeightMM * rowCoordinatesPerMM);
            rowClientAnchorDetail = new ClientAnchorDetail(rowNumber, rowNumber, pictureHeightCoordinates);
        }
        return rowClientAnchorDetail;
    }

    private ClientAnchorDetail calculateColumnLocation(HSSFSheet sheet, int startingColumn, double reqImageWidthMM) {
        ClientAnchorDetail anchorDetail = null;
        double totalWidthMM = 0.0;
        double colWidthMM = 0.0;
        double overlapMM = 0.0;
        double coordinatePositionsPerMM = 0.0;
        int toColumn = startingColumn;
        int inset = 0;
        while (totalWidthMM < reqImageWidthMM) {
            colWidthMM = ConvertImageUnits.widthUnits2Millimetres((short)sheet.getColumnWidth(toColumn));
            totalWidthMM += colWidthMM + 2.0;
            ++toColumn;
        }
        --toColumn;
        if ((int)totalWidthMM == (int)reqImageWidthMM) {
            anchorDetail = new ClientAnchorDetail(startingColumn, toColumn, 1023);
        } else {
            overlapMM = reqImageWidthMM - (totalWidthMM - colWidthMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            coordinatePositionsPerMM = 1023.0 / colWidthMM;
            inset = (int)(coordinatePositionsPerMM * overlapMM);
            anchorDetail = new ClientAnchorDetail(startingColumn, toColumn, inset);
        }
        return anchorDetail;
    }

    private ClientAnchorDetail calculateRowLocation(HSSFSheet sheet, int startingRow, double reqImageHeightMM) {
        ClientAnchorDetail clientAnchorDetail = null;
        HSSFRow row = null;
        double rowHeightMM = 0.0;
        double totalRowHeightMM = 0.0;
        double overlapMM = 0.0;
        double rowCoordinatesPerMM = 0.0;
        int toRow = startingRow;
        int inset = 0;
        while (totalRowHeightMM < reqImageHeightMM) {
            row = sheet.getRow(toRow);
            if (row == null) {
                row = sheet.createRow(toRow);
            }
            rowHeightMM = (double)row.getHeightInPoints() / 2.83;
            totalRowHeightMM += rowHeightMM;
            ++toRow;
        }
        --toRow;
        if ((int)totalRowHeightMM == (int)reqImageHeightMM) {
            clientAnchorDetail = new ClientAnchorDetail(startingRow, toRow, 255);
        } else {
            overlapMM = reqImageHeightMM - (totalRowHeightMM - rowHeightMM);
            if (overlapMM < 0.0) {
                overlapMM = 0.0;
            }
            rowCoordinatesPerMM = 255.0 / rowHeightMM;
            inset = (int)(overlapMM * rowCoordinatesPerMM);
            clientAnchorDetail = new ClientAnchorDetail(startingRow, toRow, inset);
        }
        return clientAnchorDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] imageToBytes(String imageFilename) throws FileNotFoundException, IOException {
        File imageFile = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        int read = 0;
        try {
            imageFile = new File(imageFilename);
            fis = new FileInputStream(imageFile);
            bos = new ByteArrayOutputStream();
            while ((read = fis.read()) != -1) {
                bos.write(read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException ioEx) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileOutputStream fos = null;
        HSSFWorkbook workbook = null;
        HSSFSheet sheet = null;
        try {
            workbook = new HSSFWorkbook();
            sheet = workbook.createSheet("Picture Test");
            new AddDimensionedImage().addImageToSheet("B5", sheet, "image.jpg", 25.0, 25.0, 7);
            fos = new FileOutputStream("Workbook.xls");
            workbook.write((OutputStream)fos);
        }
        catch (FileNotFoundException fnfEx) {
            System.out.println("Caught an: " + fnfEx.getClass().getName());
            System.out.println("Message: " + fnfEx.getMessage());
            System.out.println("Stacktrace follows...........");
            fnfEx.printStackTrace(System.out);
        }
        catch (IOException ioEx) {
            System.out.println("Caught an: " + ioEx.getClass().getName());
            System.out.println("Message: " + ioEx.getMessage());
            System.out.println("Stacktrace follows...........");
            ioEx.printStackTrace(System.out);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException ioEx) {}
            }
        }
    }

    public static class ConvertImageUnits {
        public static final int TOTAL_COLUMN_COORDINATE_POSITIONS = 1023;
        public static final int TOTAL_ROW_COORDINATE_POSITIONS = 255;
        public static final int PIXELS_PER_INCH = 96;
        public static final double PIXELS_PER_MILLIMETRES = 3.78;
        public static final double POINTS_PER_MILLIMETRE = 2.83;
        public static final double CELL_BORDER_WIDTH_MILLIMETRES = 2.0;
        public static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
        public static final int UNIT_OFFSET_LENGTH = 7;
        public static final int[] UNIT_OFFSET_MAP = new int[]{0, 36, 73, 109, 146, 182, 219};

        public static short pixel2WidthUnits(int pxs) {
            short widthUnits = (short)(256 * (pxs / 7));
            widthUnits = (short)(widthUnits + UNIT_OFFSET_MAP[pxs % 7]);
            return widthUnits;
        }

        public static int widthUnits2Pixel(short widthUnits) {
            int pixels = widthUnits / 256 * 7;
            int offsetWidthUnits = widthUnits % 256;
            return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
        }

        public static double widthUnits2Millimetres(short widthUnits) {
            return (double)ConvertImageUnits.widthUnits2Pixel(widthUnits) / 3.78;
        }

        public static int millimetres2WidthUnits(double millimetres) {
            return ConvertImageUnits.pixel2WidthUnits((int)(millimetres * 3.78));
        }
    }

    public class ClientAnchorDetail {
        public int fromIndex = 0;
        public int toIndex = 0;
        public int inset = 0;

        public ClientAnchorDetail(int fromIndex, int toIndex, int inset) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.inset = inset;
        }

        public int getFromIndex() {
            return this.fromIndex;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public int getInset() {
            return this.inset;
        }
    }
}

