/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics.randomvariatedistribution;

import com.gcap.randomvariategenerator.basics.randomvariatedistribution.RandomVariateGenerator;

public class GeometricRandomVariateGenerator
extends RandomVariateGenerator {
    private double sucessProbability;
    private double denominator;

    public GeometricRandomVariateGenerator(double minValue, double maxValue, double sucessProbability) throws IllegalArgumentException {
        super(minValue, maxValue);
        if (sucessProbability > 1.0) {
            throw new IllegalArgumentException("The parameter must be less than 1");
        }
        this.sucessProbability = sucessProbability;
        this.denominator = Math.log(1.0 - sucessProbability);
    }

    public double generateRandomNumber() {
        return Math.floor(Math.log(Math.random()) / this.denominator);
    }

    public double getValue(double x) {
        int intx = (int)Math.rint(x);
        return Math.pow(1.0 - this.sucessProbability, intx) * this.sucessProbability;
    }

    public boolean isDiscrete() {
        return true;
    }

    public double getCumulativeDistributionFunction(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

