/*
 * Decompiled with CFR 0.152.
 */
package com.gcap.randomvariategenerator.basics;

import com.gcap.randomvariategenerator.control.DataAnalyzer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EmpiricalLoader {
    private ArrayList<DataAnalyzer> binsAnalyzers = null;
    DataAnalyzer dataAnalizer = null;
    private int binCount = 1000;
    private boolean loaded = false;
    private double[] probabilityDensityFunction = null;
    BufferedReader inputStream;

    public EmpiricalLoader(int binCount) {
        this.binCount = binCount;
        this.binsAnalyzers = new ArrayList();
        this.dataAnalizer = new DataAnalyzer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        this.inputStream = new BufferedReader(new FileReader(file));
        try {
            try {
                this.computeStats();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            this.inputStream = new BufferedReader(new FileReader(file));
            this.fillBinStats(this.inputStream);
            this.loaded = true;
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void computeBinStats(double min, double delta) throws IOException {
        String str = null;
        double val = 0.0;
        while ((str = this.inputStream.readLine()) != null && !str.equals("")) {
            val = Double.parseDouble(str);
            DataAnalyzer stats = this.binsAnalyzers.get(Math.max((int)Math.ceil((val - min) / delta) - 1, 0));
            stats.update(val);
        }
        this.inputStream.close();
        this.inputStream = null;
    }

    public void computeStats() throws IOException {
        String str = null;
        double val = 0.0;
        while ((str = this.inputStream.readLine()) != null && !str.equals("")) {
            val = new Double(str);
            this.dataAnalizer.update(val);
        }
        this.inputStream.close();
        this.inputStream = null;
    }

    private void fillBinStats(Object in) throws IOException {
        int i;
        double min = this.dataAnalizer.getMinValue();
        double max = this.dataAnalizer.getMaxValue();
        double delta = (max - min) / new Double(this.binCount);
        if (!this.binsAnalyzers.isEmpty()) {
            this.binsAnalyzers.clear();
        }
        for (i = 0; i < this.binCount; ++i) {
            DataAnalyzer stats = new DataAnalyzer();
            this.binsAnalyzers.add(i, stats);
        }
        try {
            this.computeBinStats(min, delta);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw new RuntimeException(e.getMessage());
            }
            throw new IOException(e.getMessage());
        }
        this.probabilityDensityFunction = new double[this.binCount];
        for (i = 0; i < this.binCount; ++i) {
            this.probabilityDensityFunction[i] = (double)this.binsAnalyzers.get(i).getSamples() / (double)this.dataAnalizer.getSamples();
        }
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List getBinStats() {
        return this.binsAnalyzers;
    }

    public double[] getProbabilityDensityFunction() {
        return this.probabilityDensityFunction;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public DataAnalyzer getDataAnalizer() {
        return this.dataAnalizer;
    }
}

