/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.randomvariates;

import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.simulator.randomvariates.ExponentialRandomVariateGenerator;

public class ErlangRandomVariateGenerator
extends ExponentialRandomVariateGenerator {
    private int shapes = 0;

    public int getShapes() {
        return this.shapes;
    }

    public void setShapes(int shapes) {
        this.shapes = shapes;
    }

    public ErlangRandomVariateGenerator(int shapes) {
        this.shapes = shapes;
    }

    public double generateRandomNumber(double delay) {
        double sum = 0.0;
        for (int i = 0; i < this.shapes; ++i) {
            sum += super.generateRandomNumber(delay);
        }
        return sum;
    }

    public double getValue(double x) {
        double result = 0.0;
        if (x < 0.0) {
            throw new IllegalArgumentException("The Argument must be bigger than 0");
        }
        double rate = this.getRateParameter();
        result = Math.pow(rate, this.shapes - 1) * Math.pow(x, this.shapes - 1) * super.getValue(x) / (double)Util.factorial(this.shapes - 1);
        return result;
    }

    public boolean isDiscrete() {
        return true;
    }
}

