/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.outputanalisys;

import java.util.ArrayList;
import org.modcs.tools.spn.simulator.outputanalisys.StudentTDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAnalyzer {
    private double sum;
    private int samples;
    private double mean;
    private double std;
    private double lowerBoundConfidenceInterval;
    private double upperBoundConfidenceInterval;
    private double error;
    private double variance;
    private double M;
    private double Q;

    public DataAnalyzer() {
        this.reset();
    }

    public double getMean() {
        this.updateMean();
        return this.mean;
    }

    public double getStd() {
        this.updateStd();
        return this.std;
    }

    public double getVariance() {
        this.updateStd();
        this.updateVariance();
        return this.variance;
    }

    public void reset() {
        this.sum = 0.0;
        this.samples = 0;
        this.mean = 0.0;
        this.std = Double.NaN;
        this.variance = 0.0;
        this.lowerBoundConfidenceInterval = 0.0;
        this.upperBoundConfidenceInterval = 0.0;
        this.error = 0.0;
        this.Q = 0.0;
        this.M = 0.0;
    }

    public void updateQ(double sample) {
        this.Q = this.samples == 1 ? 0.0 : (this.Q += (double)(this.samples - 1) * Math.pow(sample - this.M, 2.0) / (double)this.samples);
    }

    public void updateM(double sample) {
        this.M = this.samples == 1 ? sample : (this.M += (sample - this.M) / (double)this.samples);
    }

    public void updateMean() {
        this.mean = this.sum / (double)this.samples;
    }

    public void update(double value) {
        this.sum += value;
        ++this.samples;
        this.updateQ(value);
        this.updateM(value);
    }

    public void RemovePeriodTransient(double value) {
        this.sum = value;
        this.samples = 1;
    }

    public void applyBatchMeans(ArrayList<Double> batchMeans) {
        this.sum = 0.0;
        for (Double currentMean : batchMeans) {
            this.sum += currentMean.doubleValue();
        }
        this.samples = batchMeans.size();
        this.mean = this.sum / (double)this.samples;
    }

    public void updateStd() {
        this.std = Math.sqrt(this.Q / (double)(this.samples - 1));
    }

    public void updateVariance() {
        this.variance = this.std * this.std;
    }

    double updateConfidenceInterval(double confidenceLevel) {
        this.updateMean();
        this.updateStd();
        StudentTDistribution student = new StudentTDistribution(this.samples - 1);
        double param = 1.0 - (1.0 - confidenceLevel) / 2.0;
        double tValue = student.inverseCDF(param);
        double temp = tValue * this.std / Math.sqrt(this.samples);
        this.lowerBoundConfidenceInterval = this.mean - temp;
        this.upperBoundConfidenceInterval = this.mean + temp;
        this.error = temp / this.mean;
        return tValue;
    }

    public double getError(double confidenceLevel) {
        this.updateConfidenceInterval(confidenceLevel);
        return this.error;
    }

    public double getReplications(double confidenceLevel, double desiredError) {
        double tValue = 0.0;
        double replications = 0.0;
        tValue = this.updateConfidenceInterval(confidenceLevel);
        replications = Math.pow(tValue * this.std / desiredError * this.mean, 2.0);
        return replications;
    }

    public double getLowerBoundConfidenceInterval() {
        return this.lowerBoundConfidenceInterval;
    }

    public double getUpperBoundConfidenceInterval() {
        return this.upperBoundConfidenceInterval;
    }
}

