/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import org.modcs.tools.spn.simulator.outputanalisys.DataAnalyzer;

public class TransientConfidenceList {
    private DataAnalyzer[] dataAnalyzers;
    private double confidenceLevel;
    private double error;
    private int maximumReplications;
    private double maximumError;
    private int[] numeroOcorrencias;
    private int[] totalAmostras;

    public TransientConfidenceList(int numberElements) {
        this.dataAnalyzers = new DataAnalyzer[numberElements];
        this.numeroOcorrencias = new int[numberElements];
        this.totalAmostras = new int[numberElements];
        for (int i = 0; i < this.dataAnalyzers.length; ++i) {
            this.dataAnalyzers[i] = new DataAnalyzer();
        }
    }

    TransientConfidenceList(int numberElements, double confidenceLevel, double error) {
        this(numberElements);
        this.confidenceLevel = confidenceLevel;
        this.error = error;
        this.maximumError = 0.0;
        this.maximumReplications = 0;
    }

    public void update(double metric, int i) {
        this.dataAnalyzers[i].update(metric);
        this.updateParams(i);
    }

    public void updateParams(int i) {
        double temp = this.getErrorByIndex(i);
        if (temp > this.maximumError) {
            this.maximumError = temp;
        }
        if ((temp = this.dataAnalyzers[i].getReplications(this.confidenceLevel, this.error)) > (double)this.maximumReplications) {
            this.maximumReplications = (int)temp;
        }
    }

    public void update(boolean eval, int i) {
        double metric = 0.0;
        int n = i;
        this.totalAmostras[n] = this.totalAmostras[n] + 1;
        if (eval) {
            int n2 = i;
            this.numeroOcorrencias[n2] = this.numeroOcorrencias[n2] + 1;
        }
        metric = (double)this.numeroOcorrencias[i] / (double)this.totalAmostras[i];
        this.dataAnalyzers[i].update(metric);
        this.updateParams(i);
    }

    public double getErrorByIndex(int i) {
        return this.dataAnalyzers[i].getError(this.confidenceLevel);
    }

    public double getMaximumError() {
        return this.maximumError;
    }

    public int getMaximumReplications() {
        return this.maximumReplications;
    }

    public DataAnalyzer getDataAnalyzerByIndex(int i) {
        return this.dataAnalyzers[i];
    }

    public void resetMaximumError() {
        this.maximumError = 0.0;
    }

    public void resetMaximumReplications() {
        this.maximumReplications = 0;
    }
}

