/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.simulator.engine;

import java.util.ArrayList;
import org.modcs.tools.spn.simulator.engine.Engine;
import org.modcs.tools.spn.simulator.entities.InterfaceModelGenerator;

public class EngineRemoveTransient
extends Engine {
    private double previousVariance = 0.0;
    private double currentVariance = 0.0;
    private ArrayList<Double> metrics = new ArrayList();

    public EngineRemoveTransient(InterfaceModelGenerator modelGenerator) {
        super(modelGenerator);
    }

    public boolean canStopStationary() throws Exception {
        boolean result = false;
        this.setCounterIntraRun(this.getCounterIntraRun() + 1);
        if (this.getCounterIntraRun() >= this.getRunSize() && this.getFireCounter().isAllTransitionsReachMinFires()) {
            double errorTemp;
            this.setCounterInterRun(this.getCounterInterRun() + 1);
            double metric = this.getMetric();
            this.metrics.add(metric);
            this.getDataAnalyzerInterRuns().update(metric);
            if (this.getCounterInterRun() == this.getExpectedRuns()) {
                this.setExpectedRuns((int)Math.ceil(this.getDataAnalyzerInterRuns().getReplications(this.getConfidenceLevel(), this.getError())));
            }
            if (this.getCounterInterRun() > 1) {
                this.outputText("Count: " + this.getCounterInterRun() + "\tError: " + this.getDataAnalyzerInterRuns().getError(this.getConfidenceLevel()) + "\tMetric: " + metric);
            } else {
                this.outputText("\tMetric: " + metric);
            }
            this.initRunStationary();
            if (this.getCounterInterRun() >= this.getWarmUpPeriod() && (errorTemp = this.getDataAnalyzerInterRuns().getError(this.getConfidenceLevel())) < this.getError()) {
                result = true;
            }
        }
        if (this.getMaxTime() > 0L && System.currentTimeMillis() - this.getStartTime() > this.getMaxTime()) {
            this.outputText("***********************************************************************************");
            this.outputText("the maximum time of simulation was achieved,\nthe desired error may not have been found");
            this.outputText("***********************************************************************************");
            result = true;
        }
        return result;
    }

    public String getResults() {
        this.calculateBatchMeans();
        return super.getResults();
    }

    private void calculateBatchMeans() {
        int batchSizes = 1;
        boolean varianceStartedDecreasing = false;
        ArrayList<Double> variances = new ArrayList<Double>();
        double overallMean = 0.0;
        double sumOfDeviations = 0.0;
        while (!varianceStartedDecreasing) {
            int numberOfBatches = this.metrics.size() / ++batchSizes;
            ArrayList<Double> batchMeans = new ArrayList<Double>();
            double sumOfTheBatch = 0.0;
            sumOfDeviations = 0.0;
            for (int i = 0; i < this.metrics.size() && i < numberOfBatches * batchSizes; ++i) {
                if (i != 0 && (i + 1) % batchSizes == 0) {
                    batchMeans.add((sumOfTheBatch += this.metrics.get(i).doubleValue()) / (double)batchSizes);
                    sumOfTheBatch = 0.0;
                    continue;
                }
                sumOfTheBatch += this.metrics.get(i).doubleValue();
            }
            if (batchSizes == 2) {
                for (Double currentMean : batchMeans) {
                    overallMean += currentMean.doubleValue();
                }
                overallMean /= (double)batchMeans.size();
            }
            for (Double currentMean : batchMeans) {
                sumOfDeviations += Math.pow(currentMean - overallMean, 2.0);
            }
            variances.add(sumOfDeviations / (double)(batchMeans.size() - 1));
            if (variances.size() <= 1) continue;
            if ((Double)variances.get(variances.size() - 1) / (Double)variances.get(0) * 100.0 <= 20.0) {
                varianceStartedDecreasing = true;
                continue;
            }
            if (batchSizes <= this.metrics.size() / 2) continue;
            batchSizes = 1;
            varianceStartedDecreasing = true;
        }
        for (int i = 0; i < batchSizes; ++i) {
            this.metrics.remove(0);
        }
        this.getDataAnalyzerInterRuns().applyBatchMeans(this.metrics);
    }
}

