/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.spn.model.expressions.LogicCondition;

public class Probability
implements Serializable {
    private static final long serialVersionUID = 4552061730717416299L;
    private LogicCondition logicCondition;
    private double totalTime;
    private double timeEvent;

    public Probability(LogicCondition logicCondition) {
        this.logicCondition = logicCondition;
        this.totalTime = 0.0;
        this.timeEvent = 0.0;
    }

    public double getTimeEvent() {
        return this.timeEvent;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    public LogicCondition getLogicCondition() {
        return this.logicCondition;
    }

    public void setLogicCondition(LogicCondition logicCondition) {
        this.logicCondition = logicCondition;
    }

    public static Probability parse(String text) {
        if (!text.substring(0, 2).equals("P{") || !text.substring(text.length() - 1).equals("}")) {
            return null;
        }
        LogicCondition logicCondition = LogicCondition.parse(text.substring(2, text.length() - 1));
        if (logicCondition == null) {
            return null;
        }
        return new Probability(logicCondition);
    }

    public double evaluate() {
        if (this.totalTime == 0.0) {
            try {
                if (this.logicCondition.evaluate()) {
                    return 1.0;
                }
                return 0.0;
            }
            catch (Exception ex) {
                return 0.0;
            }
        }
        return this.timeEvent / this.totalTime;
    }

    public void updateMetrics(double time) throws Exception {
        this.totalTime += time;
        if (this.logicCondition.evaluate()) {
            this.timeEvent += time;
        }
    }
}

