/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model.expressions;

import java.io.Serializable;
import org.modcs.tools.spn.model.expressions.ComparisonOperator;
import org.modcs.tools.spn.model.expressions.MarkingFunction;

public class Comparison
implements Serializable {
    private static final long serialVersionUID = 3643381045019137234L;
    private MarkingFunction markingFunctionLeft;
    private ComparisonOperator comparisonOperator;
    private MarkingFunction markingFunctionRight;

    public Comparison(MarkingFunction markingFunctionLeft, ComparisonOperator comparisonOperator, MarkingFunction markingFunctionRight) {
        this.markingFunctionLeft = markingFunctionLeft;
        this.comparisonOperator = comparisonOperator;
        this.markingFunctionRight = markingFunctionRight;
    }

    public static Comparison parse(String text) {
        Comparison comparison = null;
        ComparisonOperator comparisonOp = null;
        String text1 = "";
        String text2 = "";
        int position = -1;
        int sizeOperator = 0;
        for (int i = 0; i < ComparisonOperator.getOperators().length; ++i) {
            String operator = ComparisonOperator.getOperators()[i];
            position = text.indexOf(operator);
            if (position == -1) continue;
            comparisonOp = new ComparisonOperator(operator);
            sizeOperator = ComparisonOperator.getOperators()[i].length();
            break;
        }
        if (position == -1) {
            return null;
        }
        text1 = text.substring(0, position);
        MarkingFunction markingFunction1 = MarkingFunction.parse(text1);
        if (markingFunction1 == null) {
            return null;
        }
        text2 = text.substring(position + sizeOperator);
        MarkingFunction markingFunction2 = MarkingFunction.parse(text2);
        if (markingFunction2 == null) {
            return null;
        }
        comparison = new Comparison(markingFunction1, comparisonOp, markingFunction2);
        return comparison;
    }

    public boolean evaluate() throws Exception {
        if (this.comparisonOperator.getOperator().equals("=")) {
            return this.markingFunctionLeft.evaluate() == this.markingFunctionRight.evaluate();
        }
        if (this.comparisonOperator.getOperator().equals("/=")) {
            return this.markingFunctionLeft.evaluate() != this.markingFunctionRight.evaluate();
        }
        if (this.comparisonOperator.getOperator().equals(">")) {
            return this.markingFunctionLeft.evaluate() > this.markingFunctionRight.evaluate();
        }
        if (this.comparisonOperator.getOperator().equals("<")) {
            return this.markingFunctionLeft.evaluate() < this.markingFunctionRight.evaluate();
        }
        if (this.comparisonOperator.getOperator().equals(">=")) {
            return this.markingFunctionLeft.evaluate() >= this.markingFunctionRight.evaluate();
        }
        if (this.comparisonOperator.getOperator().equals("<=")) {
            return this.markingFunctionLeft.evaluate() <= this.markingFunctionRight.evaluate();
        }
        return false;
    }
}

