/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.model.ArcInhibitor;
import org.modcs.tools.spn.model.ArcInput;
import org.modcs.tools.spn.model.ArcOutput;
import org.modcs.tools.spn.model.FiringPolicy;
import org.modcs.tools.spn.model.RaceType;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.expressions.LogicCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionImmediate
extends Transition {
    private int priority;
    private LogicCondition logicCondition;
    private String stringLogicCondition;

    public TransitionImmediate(String transitionName) {
        super(transitionName);
    }

    public TransitionImmediate(String name, double delay, FiringPolicy firingPolicy, RaceType raceType, ArrayList<ArcInput> arcInputs, ArrayList<ArcOutput> arcOutputs, ArrayList<ArcInhibitor> arcInhibitors, Point2D posTrans, Point2D posTag, int priority) {
        super(name, delay, firingPolicy, raceType, arcInputs, arcOutputs, arcInhibitors, posTrans, posTag);
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getStringLogicCondition() {
        return this.stringLogicCondition;
    }

    public void setStringLogicCondition(String stringLogicCondition) {
        this.stringLogicCondition = stringLogicCondition;
        stringLogicCondition = Util.removeEndComand(stringLogicCondition);
        this.logicCondition = LogicCondition.parse(stringLogicCondition);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setLogicCondition(String logicCondition) {
        this.stringLogicCondition = logicCondition = Util.removeEndComand(logicCondition);
        this.logicCondition = LogicCondition.parse(logicCondition);
    }

    @Override
    public boolean canFire() throws Exception {
        if (!super.canFire()) {
            return false;
        }
        return this.logicCondition == null || this.logicCondition.evaluate();
    }
}

