/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model;

import java.io.Serializable;
import java.util.ArrayList;
import org.modcs.tools.spn.model.DelayParameter;
import org.modcs.tools.spn.model.LabelModel;
import org.modcs.tools.spn.model.MarkingParameter;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.model.RewardMeasure;
import org.modcs.tools.spn.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDSPN
implements Serializable,
Cloneable {
    private int numberPlaces;
    private int numberTransitions;
    private int numberDelayParameters;
    private int numberMarkingParameters;
    private int numberRewardMeasures;
    private int numberLabelModels;
    private ArrayList<MarkingParameter> markingParameters;
    private ArrayList<Place> places;
    private ArrayList<DelayParameter> delayParameters;
    private ArrayList<Transition> transitions;
    private ArrayList<LabelModel> labelModels;
    private ArrayList<RewardMeasure> rewardMeasures;
    private static EDSPN INSTANCE;

    public EDSPN(int numberPlaces, int numberTransitions, int numberDelayParameters, int numberMarkingParameters, int numberRewardMeasures) {
        this.places = this.places;
        this.transitions = this.transitions;
        this.rewardMeasures = this.rewardMeasures;
        this.numberPlaces = this.places.size();
        this.numberRewardMeasures = this.rewardMeasures.size();
        this.numberTransitions = this.transitions.size();
    }

    public ArrayList<LabelModel> getLabelModels() {
        return this.labelModels;
    }

    public void setLabelModels(ArrayList<LabelModel> labelModels) {
        this.labelModels = labelModels;
    }

    public int getNumberLabelModels() {
        return this.numberLabelModels;
    }

    public void setNumberLabelModels(int numberLabelModels) {
        this.numberLabelModels = numberLabelModels;
    }

    public static EDSPN getINSTANCE() {
        return INSTANCE;
    }

    public static void setINSTANCE(EDSPN INSTANCE) {
        EDSPN.INSTANCE = INSTANCE;
    }

    public int getNumberDelayParameters() {
        return this.numberDelayParameters;
    }

    public void setNumberDelayParameters(int numberDelayParameters) {
        this.numberDelayParameters = numberDelayParameters;
    }

    public int getNumberMarkingParameters() {
        return this.numberMarkingParameters;
    }

    public void setNumberMarkingParameters(int numberMarkingParameters) {
        this.numberMarkingParameters = numberMarkingParameters;
    }

    public int getNumberPlaces() {
        return this.numberPlaces;
    }

    public void setNumberPlaces(int numberPlaces) {
        this.numberPlaces = numberPlaces;
    }

    public int getNumberRewardMeasures() {
        return this.numberRewardMeasures;
    }

    public void setNumberRewardMeasures(int numberRewardMeasures) {
        this.numberRewardMeasures = numberRewardMeasures;
    }

    public int getNumberTransitions() {
        return this.numberTransitions;
    }

    public void setNumberTransitions(int numberTransitions) {
        this.numberTransitions = numberTransitions;
    }

    public static EDSPN getInstance() {
        return INSTANCE;
    }

    public static void setInstance(EDSPN edspn) {
        INSTANCE = edspn;
    }

    public EDSPN clone() throws CloneNotSupportedException {
        return (EDSPN)super.clone();
    }

    public EDSPN(int numberPlaces, int numberTransitions, int numberDelayParameters, int numberMarkingParameters, int numberRewardMeasures, int numberLabelModels) {
        this.numberPlaces = numberPlaces;
        this.numberTransitions = numberTransitions;
        this.numberDelayParameters = numberDelayParameters;
        this.numberMarkingParameters = numberMarkingParameters;
        this.numberRewardMeasures = numberRewardMeasures;
        this.numberLabelModels = numberLabelModels;
    }

    public EDSPN(ArrayList<Place> places, ArrayList<Transition> transitions, ArrayList<RewardMeasure> rewardMeasures) {
        this.places = places;
        this.transitions = transitions;
        this.rewardMeasures = rewardMeasures;
        this.numberPlaces = places.size();
        this.numberRewardMeasures = rewardMeasures.size();
        this.numberTransitions = transitions.size();
    }

    public EDSPN(ArrayList<Place> places, ArrayList<Transition> transitions, ArrayList<RewardMeasure> rewardMeasures, ArrayList<DelayParameter> delayParameters, ArrayList<LabelModel> labelModels) {
        this(places, transitions, rewardMeasures);
        this.delayParameters = delayParameters;
        this.numberDelayParameters = delayParameters.size();
        this.labelModels = labelModels;
    }

    public ArrayList<DelayParameter> getDelayParameters() {
        return this.delayParameters;
    }

    public void setDelayParameters(ArrayList<DelayParameter> delayParameters) {
        this.delayParameters = delayParameters;
    }

    public ArrayList<MarkingParameter> getMarkingParameters() {
        return this.markingParameters;
    }

    public void setMarkingParameters(ArrayList<MarkingParameter> markingParameters) {
        this.markingParameters = markingParameters;
    }

    public ArrayList<Place> getPlaces() {
        return this.places;
    }

    public void setPlaces(ArrayList<Place> places) {
        this.places = places;
    }

    public ArrayList<RewardMeasure> getRewardMeasures() {
        return this.rewardMeasures;
    }

    public void setRewardMeasures(ArrayList<RewardMeasure> rewardMeasures) {
        this.rewardMeasures = rewardMeasures;
    }

    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(ArrayList<Transition> transitions) {
        this.transitions = transitions;
    }

    public void updateMetrics(double time) throws Exception {
        for (int i = 0; i < this.rewardMeasures.size(); ++i) {
            this.rewardMeasures.get(i).updateMetrics(time);
        }
    }

    public ArrayList<Transition> getFeasibles() throws Exception {
        ArrayList<Transition> result = new ArrayList<Transition>();
        for (int i = 0; i < this.getTransitions().size(); ++i) {
            Transition transition = this.getTransitions().get(i);
            if (!transition.canFire()) continue;
            result.add(transition);
        }
        return result;
    }

    public ArrayList<Double> getMetrics() throws Exception {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < this.rewardMeasures.size(); ++i) {
            RewardMeasure rewardMeasure = this.rewardMeasures.get(i);
            result.add(new Double(rewardMeasure.getExpression().evaluate()));
        }
        return result;
    }
}

