/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.model;

import java.io.Serializable;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.expressions.IfElseExpression;

public abstract class Arc
implements Serializable {
    private Place place;
    private int multiplicity;
    private Transition transition;
    IfElseExpression multiplicityExpression;

    public String toString() {
        if (this.multiplicityExpression != null) {
            return this.multiplicityExpression.getStringCondition();
        }
        if (this.getMultiplicity() > 1) {
            return this.getMultiplicity() + "";
        }
        return "";
    }

    public IfElseExpression getMultiplicityExpression() {
        return this.multiplicityExpression;
    }

    public void setMultiplicityExpression(IfElseExpression multiplicityExpression) {
        this.multiplicityExpression = multiplicityExpression;
    }

    public Arc(Place place, int multiplicity) {
        this.place = place;
        this.multiplicity = multiplicity;
    }

    public Arc(Place place, int multiplicity, Transition transition) {
        this.place = place;
        this.multiplicity = multiplicity;
        this.transition = transition;
    }

    public int getMultiplicity() {
        if (this.multiplicityExpression != null) {
            try {
                return (int)this.multiplicityExpression.evaluate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.multiplicity;
    }

    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }
}

