/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexRenderer;

public class JGraphGroupRenderer
extends VertexRenderer {
    public static Rectangle handle = new Rectangle(0, 0, 7, 7);
    protected boolean isGroup = false;
    protected Color handleColor = Color.white;
    protected Color graphForeground = Color.black;

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.handleColor = graph.getHandleColor();
        this.graphForeground = graph.getForeground();
        this.isGroup = DefaultGraphModel.isGroup((GraphModel)graph.getModel(), (Object)view.getCell());
        return super.getRendererComponent(graph, view, sel, focus, preview);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isGroup) {
            g.setColor(this.handleColor);
            g.fill3DRect(JGraphGroupRenderer.handle.x, JGraphGroupRenderer.handle.y, JGraphGroupRenderer.handle.width, JGraphGroupRenderer.handle.height, true);
            g.setColor(this.graphForeground);
            g.drawRect(JGraphGroupRenderer.handle.x, JGraphGroupRenderer.handle.y, JGraphGroupRenderer.handle.width, JGraphGroupRenderer.handle.height);
            g.drawLine(JGraphGroupRenderer.handle.x + 1, JGraphGroupRenderer.handle.y + JGraphGroupRenderer.handle.height / 2, JGraphGroupRenderer.handle.x + JGraphGroupRenderer.handle.width - 2, JGraphGroupRenderer.handle.y + JGraphGroupRenderer.handle.height / 2);
            if (this.view.isLeaf()) {
                g.drawLine(JGraphGroupRenderer.handle.x + JGraphGroupRenderer.handle.width / 2, JGraphGroupRenderer.handle.y + 1, JGraphGroupRenderer.handle.x + JGraphGroupRenderer.handle.width / 2, JGraphGroupRenderer.handle.y + JGraphGroupRenderer.handle.height - 2);
            }
        }
    }

    public boolean inHitRegion(Point2D pt) {
        return handle.contains(pt.getX(), pt.getY());
    }
}

