/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class JGraphGraphFactory {
    public static final int FULLY_CONNECTED = 0;
    public static final int RANDOM_CONNECTED = 1;
    public static final int TREE = 2;
    public static final int FLOW = 3;
    private Random random = new Random();
    private int numVerticesLevel;
    private int edgeIndex;
    private int vertexIndex;
    private boolean insertIntoModel = false;
    protected int numNodes = 36;
    protected int numEdges = 36;
    protected int maxNodesPerTreeLevel = 2;
    protected FactoryConfigDialog dialog;

    public void insertGraph(JGraph graph, int graphType, Map defaultVertexAttributes, Map defaultEdgeAttributes) {
        if (this.dialog == null) {
            this.dialog = new FactoryConfigDialog();
        }
        this.dialog.configureLayout(graph, graphType, defaultVertexAttributes, defaultEdgeAttributes);
        this.dialog.setModal(true);
        JGraphGraphFactory.center(this.dialog);
        this.dialog.setVisible(true);
    }

    public Object insertTreeSampleData(JGraph graph, Map defaultVertexAttributes, Map defaultEdgeAttributes) {
        Object[] cells = new Object[this.numNodes * 2];
        this.initialise(graph);
        this.numVerticesLevel = 1;
        this.edgeIndex = 0;
        this.vertexIndex = 1;
        int gridWidth = (int)Math.sqrt(this.numNodes);
        int arrow = 1;
        GraphConstants.setLineEnd((Map)defaultEdgeAttributes, (int)arrow);
        GraphConstants.setEndFill((Map)defaultEdgeAttributes, (boolean)true);
        for (int i = 0; i < this.numNodes; ++i) {
            Point2D cellPosition = this.calcCellPosition(i, gridWidth);
            DefaultGraphCell cell = this.createVertex(new Integer(i).toString(), cellPosition, defaultVertexAttributes);
            cells[i] = cell;
        }
        this.connectNextLevel(graph.getModel(), cells, defaultEdgeAttributes);
        Object[] cells2 = new Object[this.numNodes + this.numNodes - 1];
        System.arraycopy(cells, this.numNodes, cells2, 0, this.numNodes - 1);
        System.arraycopy(cells, 0, cells2, this.numNodes - 1, this.numNodes);
        this.insertIntoGraph(graph, cells2);
        graph.setSelectionCell(cells[0]);
        return cells[0];
    }

    public Object insertTreeSampleData(GraphModel model, Map defaultVertexAttributes, Map defaultEdgeAttributes) {
        Object[] cells = new Object[this.numNodes * 2];
        Object[] roots = DefaultGraphModel.getRoots((GraphModel)model);
        Object[] descendants = DefaultGraphModel.getDescendants((GraphModel)model, (Object[])roots).toArray();
        model.remove(descendants);
        this.numVerticesLevel = 1;
        this.edgeIndex = 0;
        this.vertexIndex = 1;
        int gridWidth = (int)Math.sqrt(this.numNodes);
        int arrow = 1;
        GraphConstants.setLineEnd((Map)defaultEdgeAttributes, (int)arrow);
        GraphConstants.setEndFill((Map)defaultEdgeAttributes, (boolean)true);
        for (int i = 0; i < this.numNodes; ++i) {
            Point2D cellPosition = this.calcCellPosition(i, gridWidth);
            DefaultGraphCell cell = this.createVertex(new Integer(i).toString(), cellPosition, defaultVertexAttributes);
            cells[i] = cell;
        }
        this.connectNextLevel(model, cells, defaultEdgeAttributes);
        Object[] cells2 = new Object[this.numNodes + this.numNodes - 1];
        System.arraycopy(cells, this.numNodes, cells2, 0, this.numNodes - 1);
        System.arraycopy(cells, 0, cells2, this.numNodes - 1, this.numNodes);
        JGraphGraphFactory.insert(model, cells2);
        return cells[0];
    }

    protected void connectNextLevel(GraphModel model, Object[] cells, Map defaultEdgeAttributes) {
        if (this.vertexIndex < this.numNodes) {
            int localNumVerticesLevel = this.numVerticesLevel;
            this.numVerticesLevel = 0;
            int localVertexCount = this.vertexIndex;
            for (int i = localVertexCount - localNumVerticesLevel; i < localVertexCount; ++i) {
                this.connectChildrenVertices(model, cells, cells[i], defaultEdgeAttributes);
            }
            this.connectNextLevel(model, cells, defaultEdgeAttributes);
        }
    }

    protected void connectChildrenVertices(GraphModel model, Object[] cells, Object parent, Map defaultEdgeAttributes) {
        if (this.vertexIndex < this.numNodes) {
            int numChildren = this.random.nextInt(this.maxNodesPerTreeLevel) + 1;
            Port parentPort = parent instanceof Port ? (Port)parent : (Port)model.getChild(parent, 0);
            for (int i = 0; i < numChildren; ++i) {
                if (this.vertexIndex >= this.numNodes) continue;
                ++this.numVerticesLevel;
                Port childPort = cells[this.vertexIndex] instanceof Port ? (Port)cells[this.vertexIndex++] : (Port)model.getChild(cells[this.vertexIndex++], 0);
                Edge edge = this.createEdge(defaultEdgeAttributes, parentPort, childPort);
                cells[this.edgeIndex++ + this.numNodes] = edge;
            }
        }
    }

    public void insertConnectedGraphSampleData(JGraph graph, Map defaultVertexAttributes, Map defaultEdgeAttributes) {
        int i;
        DefaultGraphCell[] cells = new DefaultGraphCell[this.numNodes + this.numEdges];
        GraphModel model = graph.getModel();
        this.initialise(graph);
        int gridWidth = (int)Math.sqrt(this.numNodes);
        for (i = 0; i < this.numNodes; ++i) {
            DefaultGraphCell cell;
            Point2D cellPosition = this.calcCellPosition(i, gridWidth);
            cells[i] = cell = this.createVertex(new Integer(i).toString(), cellPosition, defaultVertexAttributes);
        }
        for (i = 0; i < Math.min(this.numNodes, this.numEdges); ++i) {
            Port sourcePort = cells[i] instanceof Port ? (Port)cells[i] : (Port)model.getChild((Object)cells[i], 0);
            int node = this.random.nextInt(this.numNodes);
            if (this.numNodes > 1) {
                while (node == i) {
                    node = this.random.nextInt(this.numNodes);
                }
            }
            Port targetPort = cells[node] instanceof Port ? (Port)cells[node] : (Port)model.getChild((Object)cells[node], 0);
            Edge edge = this.createEdge(defaultEdgeAttributes, sourcePort, targetPort);
            cells[i + this.numNodes] = edge;
        }
        for (i = this.numNodes; i < this.numEdges; ++i) {
            int sourceNode = this.random.nextInt(this.numNodes);
            Port sourcePort = cells[sourceNode] instanceof Port ? (Port)cells[sourceNode] : (Port)model.getChild((Object)cells[sourceNode], 0);
            int targetNode = this.random.nextInt(this.numNodes);
            if (this.numNodes > 1) {
                while (targetNode == sourceNode) {
                    targetNode = this.random.nextInt(this.numNodes);
                }
            }
            Port targetPort = cells[targetNode] instanceof Port ? (Port)cells[targetNode] : (Port)model.getChild((Object)cells[targetNode], 0);
            Edge edge = this.createEdge(defaultEdgeAttributes, sourcePort, targetPort);
            cells[i + this.numNodes] = edge;
        }
        Object[] cells2 = new Object[this.numNodes + this.numEdges];
        System.arraycopy(cells, this.numNodes, cells2, 0, this.numEdges);
        System.arraycopy(cells, 0, cells2, this.numEdges, this.numNodes);
        this.insertIntoGraph(graph, cells2);
    }

    public void insertFullyConnectedGraphSampleData(JGraph graph, Map defaultVertexAttributes, Map defaultEdgeAttributes) {
        GraphModel model = graph.getModel();
        int numEdges = (this.numNodes - 1) * this.numNodes / 2;
        Object[] cells = new DefaultGraphCell[this.numNodes + numEdges];
        this.initialise(graph);
        int gridWidth = (int)Math.sqrt(this.numNodes);
        for (int i = 0; i < this.numNodes; ++i) {
            Point2D cellPosition = this.calcCellPosition(i, gridWidth);
            DefaultGraphCell cell = this.createVertex(new Integer(i).toString(), cellPosition, defaultVertexAttributes);
            cells[numEdges + i] = cell;
        }
        int cellCount = 0;
        for (int i = 0; i < this.numNodes; ++i) {
            Port sourcePort = cells[numEdges + i] instanceof Port ? (Port)cells[numEdges + i] : (Port)model.getChild(cells[numEdges + i], 0);
            for (int j = i + 1; j < this.numNodes; ++j) {
                Port targetPort = cells[numEdges + j] instanceof Port ? (Port)cells[numEdges + j] : (Port)model.getChild(cells[numEdges + j], 0);
                Edge edge = this.createEdge(defaultEdgeAttributes, sourcePort, targetPort);
                cells[cellCount++] = edge;
            }
        }
        this.insertIntoGraph(graph, cells);
    }

    public void insertSampleFlowGraph(JGraph graph, Map defaultVertexAttributes, Map defaultEdgeAttributes) {
    }

    private Point2D calcCellPosition(int i, int gridWidth) {
        if (i != 0) {
            return new Point2D.Double(20 + 60 * (i % gridWidth), 20 + 40 * (i / gridWidth));
        }
        return new Point2D.Double(20.0, 20.0);
    }

    protected DefaultGraphCell createVertex(Object userObject, Point2D position, Map defaultVertexAttributes) {
        AttributeMap attributes = new AttributeMap(defaultVertexAttributes);
        GraphConstants.setBounds((Map)attributes, (Rectangle2D)new Rectangle2D.Double(position.getX(), position.getY(), 40.0, 20.0));
        DefaultGraphCell cell = new DefaultGraphCell(userObject, attributes);
        cell.addPort();
        return cell;
    }

    protected Edge createEdge(Map defaultEdgeAttributes, Port sourcePort, Port targetPort) {
        AttributeMap edgeAttrib = null;
        edgeAttrib = defaultEdgeAttributes != null ? new AttributeMap(defaultEdgeAttributes) : new AttributeMap(6);
        DefaultEdge edge = new DefaultEdge(null, edgeAttrib);
        edge.setSource((Object)sourcePort);
        edge.setTarget((Object)targetPort);
        return edge;
    }

    protected void initialise(JGraph graph) {
        graph.getModel().remove(graph.getDescendants(graph.getRoots()));
    }

    protected void insertIntoGraph(JGraph graph, Object[] cells) {
        boolean selectsAll = graph.getGraphLayoutCache().isSelectsAllInsertedCells();
        boolean selectsLocal = graph.getGraphLayoutCache().isSelectsLocalInsertedCells();
        graph.getGraphLayoutCache().setSelectsAllInsertedCells(false);
        graph.getGraphLayoutCache().setSelectsLocalInsertedCells(false);
        if (this.insertIntoModel) {
            graph.getModel().insert(cells, null, null, null, null);
        } else {
            graph.getGraphLayoutCache().insert(cells);
        }
        graph.getGraphLayoutCache().setSelectsAllInsertedCells(selectsAll);
        graph.getGraphLayoutCache().setSelectsLocalInsertedCells(selectsLocal);
    }

    public static void insert(GraphModel model, Object[] cells) {
        JGraphGraphFactory.insert(model, cells, new Hashtable(), new ConnectionSet(), new ParentMap());
    }

    public static void insert(GraphModel model, Object[] cells, Map nested, ConnectionSet cs, ParentMap pm) {
        if (cells != null) {
            if (nested == null) {
                nested = new Hashtable<Object, AttributeMap>();
            }
            if (cs == null) {
                cs = new ConnectionSet();
            }
            if (pm == null) {
                pm = new ParentMap();
            }
            for (int i = 0; i < cells.length; ++i) {
                Object targetPort;
                int childCount = model.getChildCount(cells[i]);
                for (int j = 0; j < childCount; ++j) {
                    Object child = model.getChild(cells[i], j);
                    pm.addEntry(child, cells[i]);
                    AttributeMap attrs = model.getAttributes(child);
                    if (attrs == null) continue;
                    nested.put(child, attrs);
                }
                Map attrsTmp = (Map)nested.get(cells[i]);
                AttributeMap attrs = model.getAttributes(cells[i]);
                if (attrsTmp != null) {
                    attrs.putAll(attrsTmp);
                }
                nested.put(cells[i], attrs);
                Object sourcePort = model.getSource(cells[i]);
                if (sourcePort != null) {
                    cs.connect(cells[i], sourcePort, true);
                }
                if ((targetPort = model.getTarget(cells[i])) == null) continue;
                cs.connect(cells[i], targetPort, false);
            }
            cells = DefaultGraphModel.getDescendants((GraphModel)model, (Object[])cells).toArray();
            model.insert(cells, nested, cs, pm, null);
        }
    }

    public boolean isInsertIntoModel() {
        return this.insertIntoModel;
    }

    public void setInsertIntoModel(boolean insertIntoModel) {
        this.insertIntoModel = insertIntoModel;
    }

    public int getNumEdges() {
        return this.numEdges;
    }

    public void setNumEdges(int numEdges) {
        if (numEdges < 1) {
            numEdges = 1;
        } else if (numEdges > 2000000) {
            numEdges = 2000000;
        }
        this.numEdges = numEdges;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public void setNumNodes(int numNodes) {
        if (numNodes < 1) {
            numNodes = 1;
        } else if (numNodes > 2000000) {
            numNodes = 2000000;
        }
        this.numNodes = numNodes;
    }

    public int getMaxNodesPerTreeLevel() {
        return this.maxNodesPerTreeLevel;
    }

    public void setMaxNodesPerTreeLevel(int maxNodesPerTreeLevel) {
        this.maxNodesPerTreeLevel = maxNodesPerTreeLevel;
    }

    public static void center(Window wnd) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = wnd.getSize();
        wnd.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
    }

    public class FactoryConfigDialog
    extends JDialog {
        protected boolean insertGraph;
        protected JGraph graph;
        protected int graphType;
        protected Map defaultVertexAttributes;
        protected Map defaultEdgeAttributes;
        protected JTextField maxTreeNodeChildren;
        protected JTextField numNodes;
        protected JTextField numEdges;
        protected JCheckBox insertIntoModel;

        public FactoryConfigDialog() {
            super((Frame)null, "Configure Sample Graph", true);
            this.insertGraph = false;
            this.maxTreeNodeChildren = new JTextField();
            this.numNodes = new JTextField();
            this.numEdges = new JTextField();
            this.insertIntoModel = new JCheckBox();
            JPanel panel = new JPanel(new GridLayout(4, 2, 4, 4));
            panel.add(new JLabel("Max Child Nodes in Tree"));
            panel.add(this.maxTreeNodeChildren);
            panel.add(new JLabel("Number of nodes"));
            panel.add(this.numNodes);
            panel.add(new JLabel("Number of edges"));
            panel.add(this.numEdges);
            panel.add(new JLabel("Insert into model"));
            panel.add(this.insertIntoModel);
            JPanel panelBorder = new JPanel();
            panelBorder.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelBorder.add(panel);
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY), BorderFactory.createEmptyBorder(16, 8, 8, 8)));
            JButton applyButton = new JButton("Insert");
            JButton closeButton = new JButton("Cancel");
            buttonPanel.add(closeButton);
            buttonPanel.add(applyButton);
            this.getRootPane().setDefaultButton(applyButton);
            applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FactoryConfigDialog.this.applyValues();
                    if (FactoryConfigDialog.this.graphType == 2) {
                        JGraphGraphFactory.this.insertTreeSampleData(FactoryConfigDialog.this.graph, FactoryConfigDialog.this.defaultVertexAttributes, FactoryConfigDialog.this.defaultEdgeAttributes);
                    } else if (FactoryConfigDialog.this.graphType == 1) {
                        JGraphGraphFactory.this.insertConnectedGraphSampleData(FactoryConfigDialog.this.graph, FactoryConfigDialog.this.defaultVertexAttributes, FactoryConfigDialog.this.defaultEdgeAttributes);
                    } else if (FactoryConfigDialog.this.graphType == 0) {
                        JGraphGraphFactory.this.insertFullyConnectedGraphSampleData(FactoryConfigDialog.this.graph, FactoryConfigDialog.this.defaultVertexAttributes, FactoryConfigDialog.this.defaultEdgeAttributes);
                    } else if (FactoryConfigDialog.this.graphType == 3) {
                        JGraphGraphFactory.this.insertSampleFlowGraph(FactoryConfigDialog.this.graph, FactoryConfigDialog.this.defaultVertexAttributes, FactoryConfigDialog.this.defaultEdgeAttributes);
                    }
                    FactoryConfigDialog.this.setVisible(false);
                }
            });
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FactoryConfigDialog.this.insertGraph = false;
                    FactoryConfigDialog.this.setVisible(false);
                }
            });
            this.getContentPane().add((Component)panelBorder, "Center");
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
            this.setResizable(false);
        }

        public void configureLayout(JGraph graph, int graphType, Map defaultVertexAttributes, Map defaultEdgeAttributes) {
            this.graph = graph;
            this.graphType = graphType;
            this.defaultVertexAttributes = defaultVertexAttributes;
            this.defaultEdgeAttributes = defaultEdgeAttributes;
            this.maxTreeNodeChildren.setText(String.valueOf(JGraphGraphFactory.this.getMaxNodesPerTreeLevel()));
            this.numNodes.setText(String.valueOf(JGraphGraphFactory.this.getNumNodes()));
            this.numEdges.setText(String.valueOf(JGraphGraphFactory.this.getNumEdges()));
            this.insertIntoModel.setSelected(JGraphGraphFactory.this.isInsertIntoModel());
        }

        protected void applyValues() {
            JGraphGraphFactory.this.setMaxNodesPerTreeLevel(Integer.parseInt(this.maxTreeNodeChildren.getText()));
            JGraphGraphFactory.this.setNumNodes(Integer.parseInt(this.numNodes.getText()));
            JGraphGraphFactory.this.setNumEdges(Integer.parseInt(this.numEdges.getText()));
            JGraphGraphFactory.this.setInsertIntoModel(this.insertIntoModel.isSelected());
        }
    }
}

