/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.event.MouseInputAdapter;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;
import org.modcs.tools.spn.gui.graphview.JGraphGroupRenderer;

public class JGraphFoldingManager
extends MouseInputAdapter {
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() instanceof JGraph) {
            JGraph graph = (JGraph)e.getSource();
            CellView view = JGraphFoldingManager.getGroupByFoldingHandle(graph, e.getPoint());
            if (view != null) {
                if (view.isLeaf()) {
                    graph.getGraphLayoutCache().expand(new Object[]{view.getCell()});
                } else {
                    graph.getGraphLayoutCache().collapse(new Object[]{view.getCell()});
                }
            }
            e.consume();
        }
    }

    public static CellView getGroupByFoldingHandle(JGraph graph, Point2D pt) {
        CellView[] views = graph.getGraphLayoutCache().getCellViews();
        for (int i = 0; i < views.length; ++i) {
            JGraphGroupRenderer group;
            Point2D containerPoint = graph.fromScreen((Point2D)pt.clone());
            if (!views[i].getBounds().contains(containerPoint.getX(), containerPoint.getY())) continue;
            Rectangle2D rectBounds = views[i].getBounds();
            containerPoint.setLocation(containerPoint.getX() - rectBounds.getX(), containerPoint.getY() - rectBounds.getY());
            Component renderer = views[i].getRendererComponent(graph, false, false, false);
            if (!(renderer instanceof JGraphGroupRenderer) || !DefaultGraphModel.isGroup((GraphModel)graph.getModel(), (Object)views[i].getCell()) || !(group = (JGraphGroupRenderer)((Object)renderer)).inHitRegion(containerPoint)) continue;
            return views[i];
        }
        return null;
    }
}

