/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class JGraphEllipseView
extends VertexView {
    public static transient JGraphEllipseRenderer renderer;
    private String type;

    public JGraphEllipseView(String type) {
        this();
        this.type = type;
    }

    public JGraphEllipseView() {
        renderer = new JGraphEllipseRenderer();
    }

    public JGraphEllipseView(Object cell) {
        super(cell);
        renderer = new JGraphEllipseRenderer();
    }

    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        double yout;
        double xout;
        double dist2Squared;
        Rectangle2D r1 = this.getBounds();
        if (this.type.equals("TransitionI") || this.type.equals("TransitionE")) {
            return super.getPerimeterPoint(edge, source, p);
        }
        int offsetPos = 6;
        int boundsX = 40;
        int defaultWidth = 49;
        int temp = (int)Math.round((r1.getWidth() - (double)defaultWidth) / 2.0);
        Rectangle2D.Double r = new Rectangle2D.Double(r1.getX() + (double)offsetPos + (double)temp, r1.getY() + (double)offsetPos, boundsX, boundsX);
        double x = ((RectangularShape)r).getX();
        double y = ((RectangularShape)r).getY();
        double a = (((RectangularShape)r).getWidth() + 1.0) / 2.0;
        double b = (((RectangularShape)r).getHeight() + 1.0) / 2.0;
        double x0 = x + a;
        double y0 = y + b;
        double x1 = p.getX();
        double y1 = p.getY();
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (dx == 0.0) {
            return new Point((int)x0, (int)(y0 + b * dy / Math.abs(dy)));
        }
        double d = dy / dx;
        double h = y0 - d * x0;
        double e = a * a * d * d + b * b;
        double f = -2.0 * x0 * e;
        double g = a * a * d * d * x0 * x0 + b * b * x0 * x0 - a * a * b * b;
        double det = Math.sqrt(f * f - 4.0 * e * g);
        double xout1 = (-f + det) / (2.0 * e);
        double xout2 = (-f - det) / (2.0 * e);
        double yout1 = d * xout1 + h;
        double yout2 = d * xout2 + h;
        double dist1Squared = Math.pow(xout1 - x1, 2.0) + Math.pow(yout1 - y1, 2.0);
        if (dist1Squared < (dist2Squared = Math.pow(xout2 - x1, 2.0) + Math.pow(yout2 - y1, 2.0))) {
            xout = xout1;
            yout = yout1;
        } else {
            xout = xout2;
            yout = yout2;
        }
        return this.getAttributes().createPoint(xout, yout);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public static class JGraphEllipseRenderer
    extends VertexRenderer {
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return d;
        }

        public void paint(Graphics g) {
            super.paint(g);
        }
    }
}

