/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import com.local.gui.JFrameDesdacTool;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.filechooser.FileFilter;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.modcs.tools.spn.gui.graphview.GraphEd;
import org.modcs.tools.spn.gui.graphview.GraphView;
import org.modcs.tools.spn.gui.graphview.JGraphFoldingManager;
import org.modcs.tools.spn.gui.graphview.JGraphGraphFactory;
import org.modcs.tools.spn.gui.graphview.JGraphGroupRenderer;
import org.modcs.tools.spn.gui.graphview.JGraphShadowBorder;

public class GraphEdX
extends GraphEd {
    protected JGraphGraphFactory graphFactory = new JGraphGraphFactory();
    protected JGraphFoldingManager foldingManager;
    protected Action hide;
    protected Action collapse;
    protected Action expand;
    protected Action expandAll;
    protected Action configure;
    protected JFileChooser fileChooser = null;
    protected Object parent;
    protected boolean canVerifyGraphChaged = false;

    public GraphEdX(JToolBar toolBar, Object parent, GraphView aThis) {
        this(toolBar, parent);
        super.setGraphView(aThis);
    }

    public void setCanVerifyGraphChaged(boolean canVerifyGraphChaged) {
        this.canVerifyGraphChaged = canVerifyGraphChaged;
    }

    public GraphEdX(JToolBar jToolBar1, Object parent) {
        super(jToolBar1);
        VertexView.renderer = new JGraphGroupRenderer();
        this.parent = parent;
        if (jToolBar1 != null && parent != null) {
            this.valueChanged(null);
        }
    }

    public void init() {
    }

    protected JGraph createGraph() {
        MyGraphModel model = new MyGraphModel();
        GraphLayoutCache layoutCache = new GraphLayoutCache((GraphModel)model, (CellViewFactory)new DefaultCellViewFactory(), true);
        HashSet<String> locals = new HashSet<String>();
        locals.add("bounds");
        layoutCache.setLocalAttributes(locals);
        return new GraphEd.MyGraph((GraphModel)model, layoutCache);
    }

    protected void installListeners(JGraph graph) {
        super.installListeners(graph);
        this.foldingManager = new JGraphFoldingManager();
        graph.addMouseListener((MouseListener)this.foldingManager);
    }

    protected void uninstallListeners(JGraph graph) {
        super.uninstallListeners(graph);
        graph.removeMouseListener((MouseListener)this.foldingManager);
    }

    public void valueChanged(GraphSelectionEvent e) {
        JFrameDesdacTool jFrameDesdacTool;
        boolean enabled;
        super.valueChanged(e);
        boolean bl = enabled = !this.graph.isSelectionEmpty();
        if (this.parent instanceof JFrameDesdacTool && (jFrameDesdacTool = (JFrameDesdacTool)this.parent) != null && this.canVerifyGraphChaged) {
            jFrameDesdacTool.setGraphChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeGraph(File file) {
        if (file != null) {
            Container parent = this.graph.getParent();
            BasicMarqueeHandler marquee = this.graph.getMarqueeHandler();
            this.graph.setMarqueeHandler(null);
            try {
                this.uninstallListeners(this.graph);
                parent.remove((Component)this.graph);
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                out.writeObject(this.graph);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog((Component)this.graph, e.getMessage(), "Error", 0);
            }
            finally {
                this.graph.setMarqueeHandler(marquee);
                if (parent instanceof JViewport) {
                    JViewport viewPort = (JViewport)parent;
                    viewPort.setView((Component)this.graph);
                } else {
                    parent.add((Component)this.graph);
                }
                this.installListeners(this.graph);
            }
        }
    }

    public void deserializeGraph(File file) {
        if (file != null) {
            Container parent = this.graph.getParent();
            BasicMarqueeHandler marqueeHandler = this.graph.getMarqueeHandler();
            try {
                this.uninstallListeners(this.graph);
                parent.remove((Component)this.graph);
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                this.graph = (JGraph)in.readObject();
                this.graph.setMarqueeHandler(marqueeHandler);
                if (parent instanceof JViewport) {
                    JViewport viewPort = (JViewport)parent;
                    viewPort.setView((Component)this.graph);
                } else {
                    parent.add((Component)this.graph);
                }
                this.installListeners(this.graph);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog((Component)this.graph, e.getMessage(), "Error", 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() {
        int returnValue = 1;
        this.initFileChooser();
        returnValue = this.fileChooser.showSaveDialog((Component)this.graph);
        if (returnValue == 0) {
            Container parent = this.graph.getParent();
            try {
                this.uninstallListeners(this.graph);
                parent.remove((Component)this.graph);
                XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(this.fileChooser.getSelectedFile())));
                this.configureEncoder(encoder);
                encoder.writeObject(this.graph);
                encoder.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)this.graph, e.getMessage(), "Error", 0);
            }
            finally {
                if (parent instanceof JViewport) {
                    JViewport viewPort = (JViewport)parent;
                    viewPort.setView((Component)this.graph);
                } else {
                    parent.add((Component)this.graph);
                }
                this.installListeners(this.graph);
            }
        }
    }

    public void openFile() {
        int returnValue = 1;
        this.initFileChooser();
        returnValue = this.fileChooser.showOpenDialog((Component)this.graph);
        if (returnValue == 0) {
            Container parent = this.graph.getParent();
            BasicMarqueeHandler marqueeHandler = this.graph.getMarqueeHandler();
            try {
                this.uninstallListeners(this.graph);
                parent.remove((Component)this.graph);
                XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(this.fileChooser.getSelectedFile())));
                this.graph = (JGraph)decoder.readObject();
                this.graph.setMarqueeHandler(marqueeHandler);
                if (parent instanceof JViewport) {
                    JViewport viewPort = (JViewport)parent;
                    viewPort.setView((Component)this.graph);
                } else {
                    parent.add((Component)this.graph);
                }
                this.installListeners(this.graph);
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog((Component)this.graph, e.getMessage(), "Error", 0);
            }
        }
    }

    protected void initFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.getName() == null) {
                        return false;
                    }
                    if (f.getName().endsWith(".xml")) {
                        return true;
                    }
                    if (f.getName().endsWith(".ser")) {
                        return true;
                    }
                    return f.isDirectory();
                }

                public String getDescription() {
                    return "GraphEd file (.xml, .ser)";
                }
            };
            this.fileChooser.setFileFilter(fileFilter);
        }
    }

    protected void configureEncoder(XMLEncoder encoder) {
        encoder.setExceptionListener(new ExceptionListener(){

            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        });
        encoder.setPersistenceDelegate(DefaultGraphModel.class, new DefaultPersistenceDelegate(new String[]{"roots", "attributes"}));
        encoder.setPersistenceDelegate(MyGraphModel.class, new DefaultPersistenceDelegate(new String[]{"roots", "attributes"}));
        encoder.setPersistenceDelegate(GraphEd.MyGraph.class, new DefaultPersistenceDelegate(new String[]{"model", "graphLayoutCache"}));
        encoder.setPersistenceDelegate(GraphLayoutCache.class, new DefaultPersistenceDelegate(new String[]{"model", "factory", "cellViews", "hiddenCellViews", "partial"}));
        encoder.setPersistenceDelegate(DefaultGraphCell.class, new DefaultPersistenceDelegate(new String[]{"userObject"}));
        encoder.setPersistenceDelegate(DefaultEdge.class, new DefaultPersistenceDelegate(new String[]{"userObject"}));
        encoder.setPersistenceDelegate(DefaultPort.class, new DefaultPersistenceDelegate(new String[]{"userObject"}));
        encoder.setPersistenceDelegate(AbstractCellView.class, new DefaultPersistenceDelegate(new String[]{"cell", "attributes"}));
        encoder.setPersistenceDelegate(DefaultEdge.DefaultRouting.class, new PersistenceDelegate(){

            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, GraphConstants.class, "getROUTING_SIMPLE", null);
            }
        });
        encoder.setPersistenceDelegate(DefaultEdge.LoopRouting.class, new PersistenceDelegate(){

            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, GraphConstants.class, "getROUTING_DEFAULT", null);
            }
        });
        encoder.setPersistenceDelegate(JGraphShadowBorder.class, new PersistenceDelegate(){

            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, JGraphShadowBorder.class, "getSharedInstance", null);
            }
        });
        encoder.setPersistenceDelegate(ArrayList.class, encoder.getPersistenceDelegate(List.class));
    }

    public static void makeCellViewFieldsTransient(Class clazz) {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getName().equals("cell") || pd.getName().equals("attributes")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    static {
        GraphEdX.makeCellViewFieldsTransient(PortView.class);
        GraphEdX.makeCellViewFieldsTransient(VertexView.class);
        GraphEdX.makeCellViewFieldsTransient(EdgeView.class);
        try {
            BeanInfo info = Introspector.getBeanInfo(GraphEd.MyGraph.class);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (!pd.getName().equals("marqueeHandler")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public static class MyGraphModel
    extends DefaultGraphModel {
        public MyGraphModel() {
        }

        public MyGraphModel(List roots, AttributeMap attributes) {
            super(roots, attributes);
        }

        public boolean acceptsSource(Object edge, Object port) {
            return port != null;
        }

        public boolean acceptsTarget(Object edge, Object port) {
            return port != null;
        }
    }
}

