/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui.graphview;

import com.hp.desdac.powerstructure.entities.DataCenterArc;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;
import org.jgraph.plaf.GraphUI;
import org.modcs.tools.spn.gui.JDialogArcProperties;
import org.modcs.tools.spn.gui.JDialogLabelProperties;
import org.modcs.tools.spn.gui.JDialogPlaceProperties;
import org.modcs.tools.spn.gui.JDialogRewardMeasures;
import org.modcs.tools.spn.gui.JDialogTransitionExponentialProperties;
import org.modcs.tools.spn.gui.JDialogTransitionImmediateProperties;
import org.modcs.tools.spn.gui.graphview.GPCellViewFactory;
import org.modcs.tools.spn.gui.graphview.GraphView;
import org.modcs.tools.spn.gui.graphview.IconImpl;
import org.modcs.tools.spn.gui.graphview.MyGraphUI;
import org.modcs.tools.spn.model.Arc;
import org.modcs.tools.spn.model.ArcInhibitor;
import org.modcs.tools.spn.model.ArcInput;
import org.modcs.tools.spn.model.ArcOutput;
import org.modcs.tools.spn.model.DelayParameter;
import org.modcs.tools.spn.model.FiringPolicy;
import org.modcs.tools.spn.model.LabelModel;
import org.modcs.tools.spn.model.Place;
import org.modcs.tools.spn.model.RaceType;
import org.modcs.tools.spn.model.RewardMeasure;
import org.modcs.tools.spn.model.Transition;
import org.modcs.tools.spn.model.TransitionExponential;
import org.modcs.tools.spn.model.TransitionImmediate;
import org.modcs.tools.spn.simulator.randomvariates.ExponentialRandomVariateGenerator;
import org.modcs.tools.spn.simulator.tokengame.TokenGame;

public class GraphEd
extends JPanel
implements GraphSelectionListener,
KeyListener {
    protected JGraph graph = this.createGraph();
    protected GraphUndoManager undoManager;
    protected Action undo;
    protected Action redo;
    protected Action remove;
    protected Action group;
    protected Action ungroup;
    protected Action tofront;
    protected Action toback;
    protected Action cut;
    protected Action copy;
    protected Action paste;
    protected int cellCount = 0;
    protected StatusBarGraphListener statusBar;
    protected JToolBar toolBar;
    protected String nameNextCell;
    protected static int numberNextPlace;
    protected static int numberNextTransitionExp;
    protected static int numberNextTransitionImmediate;
    private int positionRewardMeasureVertical = 0;
    private int positionLabelVertical = 0;
    private boolean arcType;
    protected GraphView graphView;
    public static final boolean ARC_STANDARD = false;
    public static final boolean ARC_INHIBITOR = true;
    protected JToggleButton jToggleButtonAddPlace;
    protected JToggleButton jToggleButtonAddTransI;
    protected JToggleButton jToggleButtonAddTransE;
    protected JToggleButton jToggleButtonCursorStandard;
    protected JToggleButton insertLabelButton;
    protected JToggleButton rewItemButton;
    protected Cursor cursorGraph = null;
    protected boolean preview;

    public int getPositionRewardMeasureVertical() {
        return this.positionRewardMeasureVertical;
    }

    public void setPositionRewardMeasureVertical(int positionRewardMeasureVertical) {
        this.positionRewardMeasureVertical = positionRewardMeasureVertical;
    }

    public void setNameNextCell(String nameNextCell) {
        this.nameNextCell = nameNextCell;
    }

    public void setToolBar(JToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void removeField() {
        this.remove.actionPerformed(null);
        if (this.graphView != null) {
            this.graphView.makeEDSPN();
        }
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
        if (preview && this.statusBar != null) {
            this.statusBar.setVisible(false);
            this.graph.setMarqueeHandler(new BasicMarqueeHandler());
            this.graph.setMoveable(false);
        }
    }

    public boolean isArcType() {
        return this.arcType;
    }

    public void setArcType(boolean arcType) {
        this.arcType = arcType;
    }

    public GraphEd(JToolBar toolBar) {
        this.graph.setMarqueeHandler(this.createMarqueeHandler());
        this.setToolBar(toolBar);
        this.arcType = false;
        this.preview = false;
        if (toolBar != null) {
            this.undoManager = new GraphUndoManager(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    super.undoableEditHappened(e);
                    GraphEd.this.updateHistoryButtons();
                }
            };
        }
        this.populateContentPane();
        this.installListeners(this.graph);
        this.addEventsSPN();
    }

    private void addEventsSPN() {
        this.graph.addGraphSelectionListener(new GraphSelectionListener(){

            public void valueChanged(GraphSelectionEvent arg0) {
                Object object;
                if (!GraphEd.this.graph.isSelectionEmpty() && (object = GraphEd.this.graph.getSelectionCell()) instanceof DefaultGraphCell) {
                    DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
                    Object userObject = defaultGraphCell.getUserObject();
                    if (userObject instanceof DataCenterArc) {
                        return;
                    }
                    if (!(userObject instanceof LabelModel) && !(userObject instanceof com.hp.desdac.powerstructure.entities.LabelModel)) {
                        for (int i = 0; i < GraphEd.this.graph.getGraphLayoutCache().getCellViews().length; ++i) {
                            List<Object> l;
                            if (!userObject.toString().equals(GraphEd.this.graph.getGraphLayoutCache().getCellViews()[i].getCell().toString()) || (l = Arrays.asList(GraphEd.this.graph.getSelectionCell())).contains(GraphEd.this.graph.getGraphLayoutCache().getCellViews()[i].getCell())) continue;
                            GraphEd.this.graph.addSelectionCell(GraphEd.this.graph.getGraphLayoutCache().getCellViews()[i].getCell());
                        }
                    }
                }
            }
        });
    }

    protected void createStandardActions() {
        this.toolBar.addSeparator();
        URL undoUrl = this.getClass().getClassLoader().getResource("gifs/undo.gif");
        ImageIcon undoIcon = new ImageIcon(undoUrl);
        this.undo = new AbstractAction("", undoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.undo();
            }
        };
        this.undo.setEnabled(false);
        this.toolBar.add(this.undo);
        URL redoUrl = this.getClass().getClassLoader().getResource("gifs/redo.gif");
        ImageIcon redoIcon = new ImageIcon(redoUrl);
        this.redo = new AbstractAction("", redoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.redo();
            }
        };
        this.redo.setEnabled(false);
        this.toolBar.add(this.redo);
        this.toolBar.addSeparator();
        Action action = TransferHandler.getCopyAction();
        URL url = this.getClass().getClassLoader().getResource("gifs/copy.gif");
        this.copy = new EventRedirector(action, new ImageIcon(url));
        this.toolBar.add(this.copy);
        action = TransferHandler.getPasteAction();
        url = this.getClass().getClassLoader().getResource("gifs/paste.gif");
        this.paste = new EventRedirector(action, new ImageIcon(url));
        this.toolBar.add(this.paste);
        action = TransferHandler.getCutAction();
        url = this.getClass().getClassLoader().getResource("gifs/cut.gif");
        this.cut = new EventRedirector(action, new ImageIcon(url));
        this.toolBar.add(this.cut);
        URL removeUrl = this.getClass().getClassLoader().getResource("gifs/delete.gif");
        ImageIcon removeIcon = new ImageIcon(removeUrl);
        this.remove = new AbstractAction("", removeIcon){

            public void actionPerformed(ActionEvent e) {
                if (!GraphEd.this.graph.isSelectionEmpty()) {
                    Object[] cells = GraphEd.this.graph.getSelectionCells();
                    cells = GraphEd.this.graph.getDescendants(cells);
                    GraphEd.this.graph.getModel().remove(cells);
                    if (GraphEd.this.graphView != null) {
                        GraphEd.this.graphView.makeEDSPN();
                    }
                }
            }
        };
        this.remove.setEnabled(false);
        this.toolBar.add(this.remove);
        this.toolBar.addSeparator();
        URL zoomUrl = this.getClass().getClassLoader().getResource("gifs/zoom.gif");
        ImageIcon zoomIcon = new ImageIcon(zoomUrl);
        this.toolBar.add(new AbstractAction("", zoomIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setScale(1.0);
            }
        });
        URL zoomInUrl = this.getClass().getClassLoader().getResource("gifs/zoomin.gif");
        ImageIcon zoomInIcon = new ImageIcon(zoomInUrl);
        this.toolBar.add(new AbstractAction("", zoomInIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setScale(1.25 * GraphEd.this.graph.getScale());
            }
        });
        URL zoomOutUrl = this.getClass().getClassLoader().getResource("gifs/zoomout.gif");
        ImageIcon zoomOutIcon = new ImageIcon(zoomOutUrl);
        this.toolBar.add(new AbstractAction("", zoomOutIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setScale(GraphEd.this.graph.getScale() * 0.8);
            }
        });
    }

    void setGraphView(GraphView aThis) {
        this.graphView = aThis;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void destroy() {
        PortView.renderer = new PortRenderer();
        EdgeView.renderer = new EdgeRenderer();
        AbstractCellView.cellEditor = new DefaultGraphCellEditor();
        VertexView.renderer = new VertexRenderer();
    }

    protected void populateContentPane() {
        this.setLayout(new BorderLayout());
        this.createToolBar();
        this.add((Component)new JScrollPane((Component)this.graph), "Center");
        if (!this.isPreview()) {
            this.statusBar = this.createStatusBar();
            this.add((Component)this.statusBar, "South");
        }
    }

    protected JGraph createGraph() {
        MyGraph graph = new MyGraph((GraphModel)new MyModel());
        graph.getGraphLayoutCache().setFactory((CellViewFactory)new DefaultCellViewFactory(){

            protected EdgeView createEdgeView(Object cell) {
                return new EdgeView(cell){

                    public CellHandle getHandle(GraphContext context) {
                        return new MyEdgeHandle(this, context);
                    }
                };
            }
        });
        return graph;
    }

    protected void installListeners(JGraph graph) {
        graph.getModel().addUndoableEditListener((UndoableEditListener)this.undoManager);
        graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        graph.addKeyListener((KeyListener)this);
        graph.getModel().addGraphModelListener((GraphModelListener)this.statusBar);
    }

    protected void uninstallListeners(JGraph graph) {
        graph.getModel().removeUndoableEditListener((UndoableEditListener)this.undoManager);
        graph.getSelectionModel().removeGraphSelectionListener((GraphSelectionListener)this);
        graph.removeKeyListener((KeyListener)this);
        graph.getModel().removeGraphModelListener((GraphModelListener)this.statusBar);
    }

    protected BasicMarqueeHandler createMarqueeHandler() {
        return new MyMarqueeHandler();
    }

    public DefaultGraphCell insert(Point2D local, String type, Object object) {
        DefaultGraphCell vertex = this.createDefaultGraphCell(object);
        int numberTokens = 0;
        if (type.equals("Place")) {
            Place place = (Place)object;
            numberTokens = place.getMarking();
        }
        vertex.getAttributes().applyMap(this.createCellAttributes(local, type, numberTokens));
        this.graph.getGraphLayoutCache().insert((Object)vertex);
        if (this.graphView != null) {
            this.graphView.makeEDSPN();
        }
        if (type.equals("Place")) {
            if (object.toString().contains("_ON")) {
                this.insertLabel(new Point2D.Double(local.getX() + 15.0, local.getY() - 14.0), "LabelModel", new LabelModel(object.toString()));
            } else {
                this.insertLabel(new Point2D.Double(local.getX() + 15.0, local.getY() + 50.0), "LabelModel", new LabelModel(object.toString()));
            }
        } else if (type.equals("TransitionImmediate") || type.equals("TransitionExponential")) {
            this.insertLabel(new Point2D.Double(local.getX(), local.getY() + 50.0), "LabelModel", new LabelModel(object.toString()));
        }
        return vertex;
    }

    public DefaultGraphCell insertLabel(Point2D local, String type, LabelModel labelModel) {
        DefaultGraphCell vertex = new DefaultGraphCell((Object)labelModel);
        vertex.getAttributes().applyMap(this.createCellAttributes(local, type, 0));
        this.graph.getGraphLayoutCache().insert((Object)vertex);
        return vertex;
    }

    public DefaultGraphCell insertWithoutUpdateGraph(Point2D local, String type, Object object) {
        DefaultGraphCell vertex = !type.equals("LabelModel") ? this.createDefaultGraphCell(object) : new DefaultGraphCell(object);
        int numberTokens = 0;
        if (type.equals("Place")) {
            Place place = (Place)object;
            numberTokens = place.getMarking();
        }
        vertex.getAttributes().applyMap(this.createCellAttributes(local, type, numberTokens));
        this.graph.getGraphLayoutCache().insert((Object)vertex);
        return vertex;
    }

    public Icon getIconPlace(int numberTokens) {
        ImageIcon icon = null;
        icon = numberTokens < 4 ? new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/" + numberTokens + "Place.png")) : new IconImpl(this.getClass().getResource("/org/modcs/tools/gui/icons/0Place.png"), "" + numberTokens);
        return icon;
    }

    public Map createCellAttributes(Point2D local, String type, int numberTokens) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        this.getGraph().getGraphLayoutCache().setFactory((CellViewFactory)new GPCellViewFactory());
        if (type.equals("Place")) {
            map.put("viewClassKey", "Place");
            Icon icon = this.getIconPlace(numberTokens);
            GraphConstants.setResize(map, (boolean)true);
            GraphConstants.setAutoSize(map, (boolean)true);
            GraphConstants.setIcon(map, (Icon)icon);
            GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(local.getX(), local.getY(), icon.getIconWidth(), icon.getIconHeight() + 20));
            GraphConstants.setOpaque(map, (boolean)true);
            GraphConstants.setBorderColor(map, (Color)Color.white);
            GraphConstants.setFont(map, (Font)new Font("", 0, 0));
        } else if (type.equals("TransitionImmediate")) {
            map.put("viewClassKey", "TransitionI");
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransImm_Big.png"));
            GraphConstants.setIcon(map, (Icon)icon);
            GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(local.getX(), local.getY(), icon.getIconWidth(), icon.getIconHeight() + 20));
            GraphConstants.setOpaque(map, (boolean)true);
            GraphConstants.setBorderColor(map, (Color)Color.white);
            GraphConstants.setResize(map, (boolean)true);
            GraphConstants.setAutoSize(map, (boolean)true);
            GraphConstants.setFont(map, (Font)new Font("", 0, 0));
        } else if (type.equals("TransitionExponential")) {
            map.put("viewClassKey", "TransitionE");
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransExp_Big.png"));
            GraphConstants.setIcon(map, (Icon)icon);
            GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(local.getX(), local.getY(), icon.getIconWidth(), icon.getIconHeight() + 20));
            GraphConstants.setOpaque(map, (boolean)true);
            GraphConstants.setBorderColor(map, (Color)Color.white);
            GraphConstants.setResize(map, (boolean)true);
            GraphConstants.setAutoSize(map, (boolean)true);
            GraphConstants.setFont(map, (Font)new Font("", 0, 0));
        } else if (type.equals("RewardMeasure")) {
            GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(local.getX(), local.getY(), local.getX() + 10.0, local.getY() + 50.0));
            GraphConstants.setOpaque(map, (boolean)true);
            GraphConstants.setBorderColor(map, (Color)Color.white);
            GraphConstants.setResize(map, (boolean)true);
            GraphConstants.setAutoSize(map, (boolean)true);
            GraphConstants.setConnectable(map, (boolean)false);
        } else if (type.equals("Label")) {
            GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(local.getX(), local.getY(), local.getX() + 10.0, local.getY() + 50.0));
            GraphConstants.setOpaque(map, (boolean)true);
            GraphConstants.setBorderColor(map, (Color)Color.blue);
            GraphConstants.setResize(map, (boolean)true);
            GraphConstants.setAutoSize(map, (boolean)true);
            GraphConstants.setConnectable(map, (boolean)false);
        } else if (type.equals("LabelModel")) {
            GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(local.getX(), local.getY(), local.getX() + 10.0, local.getY() + 60.0));
            GraphConstants.setOpaque(map, (boolean)true);
            GraphConstants.setBorderColor(map, (Color)Color.WHITE);
            GraphConstants.setResize(map, (boolean)true);
            GraphConstants.setAutoSize(map, (boolean)true);
            GraphConstants.setConnectable(map, (boolean)false);
        }
        GraphConstants.setEditable(map, (boolean)false);
        return map;
    }

    protected DefaultGraphCell createDefaultGraphCell(Object object) {
        DefaultGraphCell cell = new DefaultGraphCell(object);
        DefaultPort port = new DefaultPort();
        cell.add((MutableTreeNode)port);
        return cell;
    }

    public boolean connectCells(DefaultGraphCell defaultGraphCellSource, DefaultGraphCell defaultGraphCellTarget) {
        DefaultPort portSource = (DefaultPort)defaultGraphCellSource.getChildren().get(0);
        DefaultPort portTarget = (DefaultPort)defaultGraphCellTarget.getChildren().get(0);
        if (portSource != null && portTarget != null) {
            return this.connect((Port)portSource, (Port)portTarget);
        }
        return false;
    }

    public boolean connect(Port source, Port target) {
        Object objectSource = this.graph.getModel().getParent((Object)source);
        Object objectTarget = this.graph.getModel().getParent((Object)target);
        Arc arc = null;
        if (objectSource instanceof DefaultGraphCell && objectTarget instanceof DefaultGraphCell) {
            objectSource = ((DefaultGraphCell)objectSource).getUserObject();
            objectTarget = ((DefaultGraphCell)objectTarget).getUserObject();
            if (!this.arcType) {
                if (objectSource instanceof Place && objectTarget instanceof Place || objectSource instanceof Transition && objectTarget instanceof Transition) {
                    return false;
                }
                if (objectSource instanceof Place && objectTarget instanceof Transition) {
                    arc = new ArcInput((Place)objectSource, 1);
                    arc.setTransition((Transition)objectTarget);
                } else if (objectTarget instanceof Place && objectSource instanceof Transition) {
                    arc = new ArcOutput((Place)objectTarget, 1);
                    arc.setTransition((Transition)objectSource);
                }
            } else if (this.arcType) {
                if (!(objectSource instanceof Place) || !(objectTarget instanceof Transition)) {
                    return false;
                }
                arc = new ArcInhibitor((Place)objectSource, 1);
                arc.setTransition((Transition)objectTarget);
            }
        }
        DefaultEdge edge = this.createDefaultEdge();
        edge.setUserObject(arc);
        if (this.graph.getModel().acceptsSource((Object)edge, (Object)source) && this.graph.getModel().acceptsTarget((Object)edge, (Object)target)) {
            edge.getAttributes().applyMap(this.createEdgeAttributes());
            this.graph.getGraphLayoutCache().insertEdge((Object)edge, (Object)source, (Object)target);
        }
        return true;
    }

    public void createBlockExponential(Point2D point, String name, double mttf, double mttr) {
        Point2D.Double pointPlaceON = new Point2D.Double(point.getX(), point.getY());
        Point2D.Double pointPlaceOFF = new Point2D.Double(point.getX(), point.getY() + 120.0);
        Point2D.Double pointTransBreak = new Point2D.Double(point.getX() + 90.0, point.getY() + 55.0);
        Point2D.Double pointTransRepair = new Point2D.Double(point.getX() - 75.0, point.getY() + 55.0);
        ExponentialRandomVariateGenerator exponentialfailGenerator = new ExponentialRandomVariateGenerator(1.0 / mttf);
        TransitionExponential transitionExponentialBreak = new TransitionExponential(name + "_F", exponentialfailGenerator, FiringPolicy.SINGLE_SERVER, RaceType.RACE_WITH_ENABLING_MEMORY, null, null, null, null, null, mttf);
        DefaultGraphCell transBreak = this.insert(pointTransBreak, "TransitionExponential", transitionExponentialBreak);
        ExponentialRandomVariateGenerator exponentialRepairGerentor = new ExponentialRandomVariateGenerator(1.0 / mttr);
        TransitionExponential transitionExponentialRepair = new TransitionExponential(name + "_R", exponentialRepairGerentor, FiringPolicy.SINGLE_SERVER, RaceType.RACE_WITH_ENABLING_MEMORY, null, null, null, null, null, mttr);
        DefaultGraphCell transRepais = this.insert(pointTransRepair, "TransitionExponential", transitionExponentialRepair);
        Place placeON = new Place(name + "_ON", 1, pointPlaceON, pointPlaceON);
        DefaultGraphCell cellPlaceON = this.insert(pointPlaceON, "Place", placeON);
        Place placeOFF = new Place(name + "_OFF", 0, pointPlaceON, pointPlaceON);
        DefaultGraphCell cellPlaceOFF = this.insert(pointPlaceOFF, "Place", placeOFF);
        this.connectCells(cellPlaceON, transBreak);
        this.connectCells(transBreak, cellPlaceOFF);
        this.connectCells(cellPlaceOFF, transRepais);
        this.connectCells(transRepais, cellPlaceON);
    }

    public void createBlockLogicalAvailability(Point2D point, String name, String failCondition) {
        Point2D.Double pointPlaceON = new Point2D.Double(point.getX(), point.getY());
        Point2D.Double pointPlaceOFF = new Point2D.Double(point.getX(), point.getY() + 100.0);
        Point2D.Double pointTransBreak = new Point2D.Double(point.getX() + 70.0, point.getY() + 50.0);
        Point2D.Double pointTransRepair = new Point2D.Double(point.getX() - 50.0, point.getY() + 50.0);
        TransitionImmediate transitionImmediateBreak = new TransitionImmediate(name + "_F", 1.0, FiringPolicy.SINGLE_SERVER, RaceType.RACE_WITH_ENABLING_MEMORY, null, null, null, null, null, 1);
        transitionImmediateBreak.setLogicCondition(failCondition);
        DefaultGraphCell transBreak = this.insert(pointTransBreak, "TransitionImmediate", transitionImmediateBreak);
        TransitionImmediate transitionImmediateRepair = new TransitionImmediate(name + "_R", 1.0, FiringPolicy.SINGLE_SERVER, RaceType.RACE_WITH_ENABLING_MEMORY, null, null, null, null, null, 1);
        transitionImmediateRepair.setLogicCondition("NOT(" + failCondition + ")");
        DefaultGraphCell transRepais = this.insert(pointTransRepair, "TransitionImmediate", transitionImmediateRepair);
        DefaultGraphCell placeON = this.insert(pointPlaceON, "Place", new Place(name + "_ON", 1, pointPlaceON, pointPlaceON));
        DefaultGraphCell placeOFF = this.insert(pointPlaceOFF, "Place", new Place(name + "_OFF", 0, pointPlaceOFF, pointPlaceOFF));
        this.connectCells(placeON, transBreak);
        this.connectCells(transBreak, placeOFF);
        this.connectCells(placeOFF, transRepais);
        this.connectCells(transRepais, placeON);
    }

    public void createBlockLogicalReliability(Point2D point, String name, String failCondition) {
        Point2D.Double pointPlaceON = new Point2D.Double(point.getX(), point.getY());
        Point2D.Double pointTransBreak = new Point2D.Double(point.getX() + 70.0, point.getY() + 50.0);
        TransitionImmediate transitionImmediateBreak = new TransitionImmediate(name + "_F", 1.0, FiringPolicy.SINGLE_SERVER, RaceType.RACE_WITH_ENABLING_MEMORY, null, null, null, null, null, 1);
        transitionImmediateBreak.setLogicCondition(failCondition);
        DefaultGraphCell transBreak = this.insert(pointTransBreak, "TransitionImmediate", transitionImmediateBreak);
        DefaultGraphCell placeON = this.insert(pointPlaceON, "Place", new Place(name + "_ON", 1, pointPlaceON, pointPlaceON));
        this.connectCells(placeON, transBreak);
    }

    protected DefaultEdge createDefaultEdge() {
        return new DefaultEdge();
    }

    public Map createEdgeAttributes() {
        Hashtable map = new Hashtable();
        if (!this.arcType) {
            GraphConstants.setLineEnd(map, (int)1);
        } else if (this.arcType) {
            GraphConstants.setLineEnd(map, (int)5);
        }
        GraphConstants.setLabelAlongEdge(map, (boolean)false);
        GraphConstants.setLineStyle(map, (int)13);
        GraphConstants.setLineWidth(map, (float)1.7f);
        GraphConstants.setEditable(map, (boolean)false);
        return map;
    }

    protected int getCellCount(JGraph graph) {
        Object[] cells = graph.getDescendants(graph.getRoots());
        return cells.length;
    }

    public void toFront(Object[] c) {
        this.graph.getGraphLayoutCache().toFront(c);
    }

    public void toBack(Object[] c) {
        this.graph.getGraphLayoutCache().toBack(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        try {
            this.undoManager.undo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        try {
            this.undoManager.redo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    protected void updateHistoryButtons() {
        this.undo.setEnabled(this.undoManager.canUndo((Object)this.graph.getGraphLayoutCache()));
        this.redo.setEnabled(this.undoManager.canRedo((Object)this.graph.getGraphLayoutCache()));
    }

    public void clearHistory() {
        this.undoManager.discardAllEdits();
    }

    public void valueChanged(GraphSelectionEvent e) {
        boolean enabled = !this.graph.isSelectionEmpty();
        this.remove.setEnabled(enabled);
        this.copy.setEnabled(enabled);
        this.cut.setEnabled(enabled);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.removeField();
        }
    }

    public JPopupMenu createPopupMenu(Point pt, Object cell, MouseEvent e, MyMarqueeHandler marqueeHandler) {
        JPopupMenu menu = new JPopupMenu();
        if (!this.graph.isSelectionEmpty()) {
            menu.addSeparator();
            menu.add(new AbstractAction("Remove"){

                public void actionPerformed(ActionEvent e) {
                    DefaultGraphCell defaultGraphCell;
                    Object userObject;
                    Object object = GraphEd.this.graph.getSelectionCell();
                    if (object instanceof DefaultGraphCell && (userObject = (defaultGraphCell = (DefaultGraphCell)object).getUserObject()) instanceof LabelModel) {
                        return;
                    }
                    GraphEd.this.removeField();
                }
            });
        }
        menu.addSeparator();
        if (cell != null) {
            Object object = this.graph.getSelectionCell();
            if (object instanceof DefaultGraphCell) {
                final DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
                final Object userObject = defaultGraphCell.getUserObject();
                if (userObject instanceof TransitionExponential) {
                    menu.add(new AbstractAction("Rotation"){

                        public void actionPerformed(ActionEvent e) {
                            ImageIcon icon;
                            Hashtable<String, String> map = new Hashtable<String, String>();
                            GraphEd.this.getGraph().getGraphLayoutCache().setFactory((CellViewFactory)new GPCellViewFactory());
                            map.put("viewClassKey", "TransitionE");
                            if (((TransitionExponential)userObject).isTurned()) {
                                icon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransExp_Big.png"));
                                ((TransitionExponential)userObject).setTurned(false);
                            } else {
                                icon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransExp_Big_R.png"));
                                ((TransitionExponential)userObject).setTurned(true);
                            }
                            GraphConstants.setIcon(map, (Icon)icon);
                            GraphConstants.setOpaque(map, (boolean)true);
                            GraphConstants.setBorderColor(map, (Color)Color.white);
                            GraphConstants.setResize(map, (boolean)true);
                            GraphConstants.setAutoSize(map, (boolean)true);
                            GraphConstants.setFont(map, (Font)new Font("", 0, 0));
                            GraphConstants.setEditable(map, (boolean)false);
                            defaultGraphCell.getAttributes().applyMap(map);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                        }
                    });
                } else if (userObject instanceof TransitionImmediate) {
                    menu.add(new AbstractAction("Rotation"){

                        public void actionPerformed(ActionEvent e) {
                            ImageIcon icon;
                            Hashtable<String, String> map = new Hashtable<String, String>();
                            GraphEd.this.getGraph().getGraphLayoutCache().setFactory((CellViewFactory)new GPCellViewFactory());
                            map.put("viewClassKey", "TransitionI");
                            if (((TransitionImmediate)userObject).isTurned()) {
                                icon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransImm_Big.png"));
                                ((TransitionImmediate)userObject).setTurned(false);
                            } else {
                                icon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransImm_Big_R.png"));
                                ((TransitionImmediate)userObject).setTurned(true);
                            }
                            GraphConstants.setIcon(map, (Icon)icon);
                            GraphConstants.setOpaque(map, (boolean)true);
                            GraphConstants.setBorderColor(map, (Color)Color.white);
                            GraphConstants.setResize(map, (boolean)true);
                            GraphConstants.setAutoSize(map, (boolean)true);
                            GraphConstants.setFont(map, (Font)new Font("", 0, 0));
                            GraphConstants.setEditable(map, (boolean)false);
                            defaultGraphCell.getAttributes().applyMap(map);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                        }
                    });
                }
            }
            menu.addSeparator();
            menu.add(new AbstractAction("Properties"){

                public void actionPerformed(ActionEvent ev) {
                    Object object = GraphEd.this.graph.getSelectionCell();
                    if (object instanceof DefaultGraphCell) {
                        DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
                        Object userObject = defaultGraphCell.getUserObject();
                        LabelModel labelModel = null;
                        Object componentEdited = null;
                        DefaultGraphCell labelDefaultGraphCell = null;
                        if (GraphEd.this.graph.getSelectionCells().length > 1) {
                            for (int i = 0; i < GraphEd.this.graph.getSelectionCells().length; ++i) {
                                Object labelUserObject;
                                if (!GraphEd.this.graph.getSelectionCells()[i].toString().equals(userObject.toString()) || !((labelUserObject = (labelDefaultGraphCell = (DefaultGraphCell)GraphEd.this.graph.getSelectionCells()[i]).getUserObject()) instanceof LabelModel)) continue;
                                labelModel = (LabelModel)labelUserObject;
                            }
                        }
                        if (userObject instanceof Place) {
                            try {
                                componentEdited = userObject;
                                Place place = (Place)userObject;
                                JDialogPlaceProperties jDialogPlaceProperties = new JDialogPlaceProperties(null, true, place);
                                jDialogPlaceProperties.setVisible(true);
                                Icon icon = GraphEd.this.getIconPlace(place.getMarking());
                                GraphConstants.setIcon((Map)defaultGraphCell.getAttributes(), (Icon)icon);
                                GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                            }
                            catch (Exception ex) {
                                Logger.getLogger(GraphEd.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        } else if (userObject instanceof TransitionExponential) {
                            componentEdited = userObject;
                            TransitionExponential transitionExponential = (TransitionExponential)userObject;
                            JDialogTransitionExponentialProperties jDialogTransitionExponentialProperties = null;
                            try {
                                jDialogTransitionExponentialProperties = new JDialogTransitionExponentialProperties(null, true, transitionExponential);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            jDialogTransitionExponentialProperties.setVisible(true);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                        } else if (userObject instanceof TransitionImmediate) {
                            componentEdited = userObject;
                            TransitionImmediate transitionImmediate = (TransitionImmediate)userObject;
                            JDialogTransitionImmediateProperties jDialogTransitionImmediateProperties = null;
                            try {
                                jDialogTransitionImmediateProperties = new JDialogTransitionImmediateProperties(null, true, transitionImmediate);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            jDialogTransitionImmediateProperties.setVisible(true);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                        } else if (userObject instanceof Arc) {
                            Arc arc = (Arc)userObject;
                            JDialogArcProperties jDialogArcProperties = new JDialogArcProperties(null, true, arc);
                            jDialogArcProperties.setVisible(true);
                            defaultGraphCell.setUserObject((Object)arc);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                        } else if (userObject instanceof RewardMeasure) {
                            RewardMeasure rewardMeasure = (RewardMeasure)userObject;
                            JDialogRewardMeasures jDialogRewardMeasures = new JDialogRewardMeasures(null, true, rewardMeasure);
                            jDialogRewardMeasures.setVisible(true);
                            defaultGraphCell.setUserObject((Object)rewardMeasure);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                        } else if (userObject instanceof DelayParameter) {
                            DelayParameter delayParameter = (DelayParameter)userObject;
                            JDialogLabelProperties jLabelProperties = new JDialogLabelProperties(null, true, delayParameter);
                            jLabelProperties.setVisible(true);
                            defaultGraphCell.setUserObject((Object)delayParameter);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                        }
                        if (labelModel != null && componentEdited != null) {
                            labelModel.setName(componentEdited.toString());
                            try {
                                GraphEd.this.graph.removeSelectionCell((Object)labelDefaultGraphCell);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            GraphEd.this.graph.addSelectionCell((Object)labelDefaultGraphCell);
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{defaultGraphCell}, (Map)defaultGraphCell.getAttributes());
                            GraphEd.this.graph.getGraphLayoutCache().edit((Object[])new DefaultGraphCell[]{labelDefaultGraphCell}, (Map)labelDefaultGraphCell.getAttributes());
                        }
                    }
                }
            });
        }
        return menu;
    }

    public void addRewardMeasure(String logicBlockName) {
        Point2D.Double point = new Point2D.Double(20.0, 20 * this.positionRewardMeasureVertical++);
        RewardMeasure rewardMeasure = new RewardMeasure("RewItem" + this.positionRewardMeasureVertical);
        rewardMeasure.setStringExpression("P{#" + logicBlockName + "_ON=1}");
        this.insert(point, "RewardMeasure", rewardMeasure);
    }

    public void addRewardMeasure(Point point) {
        this.insert(point, "RewardMeasure", new RewardMeasure("RewItem" + this.positionRewardMeasureVertical++));
    }

    public void addLabel(Point point) {
        DelayParameter delayParameter = new DelayParameter("" + this.positionLabelVertical++, 0.0, point);
        JDialogLabelProperties jDialogLabelProperties = new JDialogLabelProperties(null, true, delayParameter);
        jDialogLabelProperties.setLocationRelativeTo(null);
        jDialogLabelProperties.setVisible(true);
        this.jToggleButtonCursorStandard.setSelected(true);
        this.insert(point, "Label", delayParameter);
    }

    private void addMouseListeners() {
        this.graph.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (GraphEd.this.jToggleButtonAddPlace.isSelected()) {
                    Point origin = GraphEd.this.graph.getMousePosition();
                    origin.setLocation(origin.getX() - 7.0, origin.getY() - 8.0);
                    GraphEd.this.insert(origin, "Place", new Place("P" + numberNextPlace++, 0, origin, origin));
                } else if (GraphEd.this.jToggleButtonAddTransE.isSelected()) {
                    Point origin = GraphEd.this.graph.getMousePosition();
                    origin.setLocation(origin.getX(), origin.getY() - 8.0);
                    ExponentialRandomVariateGenerator exponentialGenerator = new ExponentialRandomVariateGenerator();
                    GraphEd.this.insert(origin, "TransitionExponential", new TransitionExponential("TE" + numberNextTransitionExp++, exponentialGenerator, FiringPolicy.SINGLE_SERVER, RaceType.RACE_WITH_ENABLING_MEMORY, null, null, null, null, null, 1.0));
                } else if (GraphEd.this.jToggleButtonAddTransI.isSelected()) {
                    Point origin = GraphEd.this.graph.getMousePosition();
                    origin.setLocation(origin.getX() + 5.0, origin.getY() - 8.0);
                    GraphEd.this.insert(origin, "TransitionImmediate", new TransitionImmediate("TI" + numberNextTransitionImmediate++, 1.0, FiringPolicy.SINGLE_SERVER, RaceType.RACE_WITH_ENABLING_MEMORY, null, null, null, null, null, 1));
                } else if (GraphEd.this.rewItemButton.isSelected()) {
                    GraphEd.this.addRewardMeasure(e.getPoint());
                } else if (GraphEd.this.insertLabelButton.isSelected()) {
                    GraphEd.this.addLabel(e.getPoint());
                } else if (GraphEd.this.jToggleButtonCursorStandard.isSelected()) {
                    // empty if block
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                if (GraphEd.this.jToggleButtonAddPlace.isSelected()) {
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image image = kit.createImage(this.getClass().getResource("/org/modcs/tools/gui/icons/0Place.png"));
                    Point point = new Point(0, 0);
                    String nameCursor = "Place Cursor";
                    Cursor cursor = kit.createCustomCursor(image, point, nameCursor);
                    GraphEd.this.graph.setCursor(cursor);
                } else if (GraphEd.this.jToggleButtonAddTransE.isSelected()) {
                    GraphEd.this.cursorGraph = GraphEd.this.graph.getCursor();
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image image = kit.createImage(this.getClass().getResource("/org/modcs/tools/gui/icons/TransExponential.png"));
                    Point point = new Point(3, 0);
                    String nameCursor = "TransitionE Cursor";
                    Cursor cursor = kit.createCustomCursor(image, point, nameCursor);
                    GraphEd.this.graph.setCursor(cursor);
                } else if (GraphEd.this.jToggleButtonAddTransI.isSelected()) {
                    GraphEd.this.cursorGraph = GraphEd.this.graph.getCursor();
                    Toolkit kit = Toolkit.getDefaultToolkit();
                    Image image = kit.createImage(this.getClass().getResource("/org/modcs/tools/gui/icons/TransImm.png"));
                    Point point = new Point(0, 0);
                    String nameCursor = "TransitionI Cursor";
                    Cursor cursor = kit.createCustomCursor(image, point, nameCursor);
                    GraphEd.this.graph.setCursor(cursor);
                } else if (GraphEd.this.jToggleButtonCursorStandard.isSelected() || GraphEd.this.rewItemButton.isSelected() || GraphEd.this.insertLabelButton.isSelected()) {
                    // empty if block
                }
            }

            public void mouseExited(MouseEvent e) {
                GraphEd.this.graph.setCursor(GraphEd.this.cursorGraph);
            }
        });
    }

    public void createToolBar() {
        this.toolBar.setFloatable(false);
        this.toolBar.removeAll();
        ImageIcon insertIcon0 = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/cursor.png"));
        this.jToggleButtonCursorStandard = new JToggleButton(insertIcon0);
        this.toolBar.add(this.jToggleButtonCursorStandard);
        ImageIcon insertIcon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/Place.png"));
        this.jToggleButtonAddPlace = new JToggleButton(insertIcon);
        this.jToggleButtonAddPlace.setToolTipText("Add new places");
        this.toolBar.add(this.jToggleButtonAddPlace);
        ImageIcon insertIcon2 = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransImm.png"));
        this.jToggleButtonAddTransI = new JToggleButton(insertIcon2);
        this.jToggleButtonAddTransI.setToolTipText("Add new Immediate Transition");
        this.toolBar.add(this.jToggleButtonAddTransI);
        ImageIcon insertIcon3 = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransExponential.png"));
        this.jToggleButtonAddTransE = new JToggleButton(insertIcon3);
        this.jToggleButtonAddTransE.setToolTipText("Add new Exponential Transition");
        this.toolBar.add(this.jToggleButtonAddTransE);
        URL rewItemConnectUrl = this.getClass().getClassLoader().getResource("gifs/script-attribute-m.png");
        ImageIcon rewItemIcon = new ImageIcon(rewItemConnectUrl);
        this.rewItemButton = new JToggleButton(rewItemIcon);
        this.rewItemButton.setToolTipText("Insert new Measure");
        this.toolBar.add(this.rewItemButton);
        URL insertLabelConnectUrl = this.getClass().getClassLoader().getResource("gifs/label.gif");
        ImageIcon labelIcon = new ImageIcon(insertLabelConnectUrl);
        this.insertLabelButton = new JToggleButton(labelIcon);
        this.insertLabelButton.setToolTipText("Insert new Label");
        this.toolBar.add(this.insertLabelButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jToggleButtonAddPlace);
        buttonGroup.add(this.jToggleButtonAddTransE);
        buttonGroup.add(this.jToggleButtonAddTransI);
        buttonGroup.add(this.jToggleButtonCursorStandard);
        buttonGroup.add(this.rewItemButton);
        buttonGroup.add(this.insertLabelButton);
        this.addMouseListeners();
        URL connectUrl = this.getClass().getClassLoader().getResource("gifs/connecton.gif");
        ImageIcon connectIcon = new ImageIcon(connectUrl);
        this.toolBar.add(new AbstractAction("", connectIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.graph.setPortsVisible(!GraphEd.this.graph.isPortsVisible());
                URL connectUrl = GraphEd.this.graph.isPortsVisible() ? this.getClass().getClassLoader().getResource("gifs/connecton.gif") : this.getClass().getClassLoader().getResource("gifs/connectoff.gif");
                ImageIcon connectIcon = new ImageIcon(connectUrl);
                this.putValue("SmallIcon", connectIcon);
            }
        });
        URL graphTypeUrl = this.getClass().getClassLoader().getResource("gifs/ArcStandard.png");
        ImageIcon graphTypeIcon = new ImageIcon(graphTypeUrl);
        this.toolBar.add(new AbstractAction("", graphTypeIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEd.this.arcType = !GraphEd.this.arcType;
                URL connectUrl = !GraphEd.this.arcType ? this.getClass().getClassLoader().getResource("gifs/ArcStandard.png") : this.getClass().getClassLoader().getResource("gifs/ArcoInbitor.png");
                ImageIcon connectIcon = new ImageIcon(connectUrl);
                this.putValue("SmallIcon", connectIcon);
            }
        });
        this.createStandardActions();
        Checkbox cb = new Checkbox("Tokengame");
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int state = itemEvent.getStateChange();
                if (state == 1) {
                    try {
                        GraphEd.this.graphView.setEdspn(GraphEd.this.graphView.makeEDSPN());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
                    }
                    TokenGame.start(GraphEd.this.graphView.getApp().getGraph());
                } else if (state == 2) {
                    TokenGame.stop();
                }
            }
        };
        cb.addItemListener(itemListener);
        this.toolBar.add(cb);
    }

    public void insertLabelButtonActionPerformed(ActionEvent e) {
        if (this.insertLabelButton.isSelected()) {
            System.out.println("Selected");
        } else {
            System.out.println("Deselected");
        }
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public void setGraph(JGraph graph) {
        this.graph = graph;
    }

    protected StatusBarGraphListener createStatusBar() {
        return new EdStatusBar();
    }

    protected String getVersion() {
        return "JGraph (v5.12.2.1)";
    }

    public Action getRedo() {
        return this.redo;
    }

    public void setRedo(Action redo) {
        this.redo = redo;
    }

    public Action getUndo() {
        return this.undo;
    }

    public void setUndo(Action undo) {
        this.undo = undo;
    }

    public Action getCopy() {
        return this.copy;
    }

    public void setCopy(Action copy) {
        this.copy = copy;
    }

    public Action getCut() {
        return this.cut;
    }

    public void setCut(Action cut) {
        this.cut = cut;
    }

    public Action getPaste() {
        return this.paste;
    }

    public void setPaste(Action paste) {
        this.paste = paste;
    }

    public Action getToback() {
        return this.toback;
    }

    public void setToback(Action toback) {
        this.toback = toback;
    }

    public Action getTofront() {
        return this.tofront;
    }

    public void setTofront(Action tofront) {
        this.tofront = tofront;
    }

    public Action getRemove() {
        return this.remove;
    }

    public void setRemove(Action remove) {
        this.remove = remove;
    }

    public class EdStatusBar
    extends StatusBarGraphListener {
        protected JLabel leftSideStatus;
        protected JLabel rightSideStatus;

        public EdStatusBar() {
            this.setLayout(new BorderLayout());
            this.leftSideStatus = new JLabel("Graphic View");
            this.rightSideStatus = new JLabel("0/0Mb");
            this.leftSideStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            this.rightSideStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            this.add((Component)this.leftSideStatus, "Center");
            this.add((Component)this.rightSideStatus, "East");
        }

        protected void updateStatusBar() {
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1024L);
            int totalMemory = (int)(runtime.totalMemory() / 1024L);
            int usedMemory = totalMemory - freeMemory;
            String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
            this.rightSideStatus.setText(str);
        }

        public JLabel getLeftSideStatus() {
            return this.leftSideStatus;
        }

        public void setLeftSideStatus(JLabel leftSideStatus) {
            this.leftSideStatus = leftSideStatus;
        }

        public JLabel getRightSideStatus() {
            return this.rightSideStatus;
        }

        public void setRightSideStatus(JLabel rightSideStatus) {
            this.rightSideStatus = rightSideStatus;
        }
    }

    public class StatusBarGraphListener
    extends JPanel
    implements GraphModelListener {
        public void graphChanged(GraphModelEvent e) {
            this.updateStatusBar();
        }

        protected void updateStatusBar() {
        }
    }

    public class EventRedirector
    extends AbstractAction {
        protected Action action;

        public EventRedirector(Action a, ImageIcon icon) {
            super("", icon);
            this.action = a;
        }

        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(GraphEd.this.graph, e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }

    public class MyMarqueeHandler
    extends BasicMarqueeHandler {
        protected Point2D start;
        protected Point2D current;
        protected PortView port;
        protected PortView firstPort;
        protected JComponent highlight = this.createHighlight();

        public boolean canConnect() {
            Object objectSource = GraphEd.this.graph.getModel().getParent((Object)((Port)this.firstPort.getCell()));
            Object objectTarget = GraphEd.this.graph.getModel().getParent((Object)((Port)this.port.getCell()));
            if (objectSource instanceof DefaultGraphCell && objectTarget instanceof DefaultGraphCell) {
                objectSource = ((DefaultGraphCell)objectSource).getUserObject();
                objectTarget = ((DefaultGraphCell)objectTarget).getUserObject();
                if (objectSource instanceof Place && objectTarget instanceof Place || objectSource instanceof Transition && objectTarget instanceof Transition) {
                    return true;
                }
            }
            return false;
        }

        protected JComponent createHighlight() {
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createBevelBorder(0));
            panel.setVisible(false);
            panel.setOpaque(false);
            return panel;
        }

        public boolean isForceMarqueeEvent(MouseEvent e) {
            if (e.isShiftDown()) {
                return false;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return true;
            }
            this.port = this.getSourcePortAt(e.getPoint());
            if (this.port != null && GraphEd.this.graph.isPortsVisible()) {
                return true;
            }
            if (e.isShiftDown() && SwingUtilities.isRightMouseButton(e)) {
                return false;
            }
            return super.isForceMarqueeEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                Object cell = GraphEd.this.graph.getFirstCellForLocation((double)e.getX(), (double)e.getY());
                if (!GraphEd.this.isPreview()) {
                    JPopupMenu menu = GraphEd.this.createPopupMenu(e.getPoint(), cell, e, this);
                    menu.show((Component)GraphEd.this.graph, e.getX(), e.getY());
                }
            } else if (this.port != null && GraphEd.this.graph.isPortsVisible()) {
                this.start = GraphEd.this.graph.toScreen(this.port.getLocation());
                this.firstPort = this.port;
            } else {
                super.mousePressed(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null) {
                Graphics g = GraphEd.this.graph.getGraphics();
                PortView newPort = this.getTargetPortAt(e.getPoint());
                if (newPort == null || newPort != this.port) {
                    this.paintConnector(Color.black, GraphEd.this.graph.getBackground(), g);
                    this.port = newPort;
                    this.current = this.port != null ? GraphEd.this.graph.toScreen(this.port.getLocation()) : GraphEd.this.graph.snap((Point2D)e.getPoint());
                    this.paintConnector(GraphEd.this.graph.getBackground(), Color.black, g);
                }
            }
            super.mouseDragged(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PortView getSourcePortAt(Point2D point) {
            PortView result;
            GraphEd.this.graph.setJumpToDefaultPort(false);
            try {
                result = GraphEd.this.graph.getPortViewAt(point.getX(), point.getY());
            }
            finally {
                GraphEd.this.graph.setJumpToDefaultPort(true);
            }
            return result;
        }

        protected PortView getTargetPortAt(Point2D point) {
            return GraphEd.this.graph.getPortViewAt(point.getX(), point.getY());
        }

        public void mouseReleased(MouseEvent e) {
            this.highlight(GraphEd.this.graph, null);
            if (e != null && this.port != null && this.firstPort != null && this.firstPort != this.port && GraphEd.this.connect((Port)this.firstPort.getCell(), (Port)this.port.getCell())) {
                e.consume();
            } else {
                GraphEd.this.graph.repaint();
            }
            this.port = null;
            this.firstPort = null;
            this.current = null;
            this.start = null;
            super.mouseReleased(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (e != null && this.getSourcePortAt(e.getPoint()) != null && GraphEd.this.graph.isPortsVisible()) {
                GraphEd.this.graph.setCursor(new Cursor(12));
                e.consume();
            } else {
                super.mouseMoved(e);
            }
        }

        protected void paintConnector(Color fg, Color bg, Graphics g) {
            if (GraphEd.this.graph.isXorEnabled()) {
                g.setColor(fg);
                g.setXORMode(bg);
                this.paintPort(GraphEd.this.graph.getGraphics());
                this.drawConnectorLine(g);
            } else {
                Rectangle dirty = new Rectangle((int)this.start.getX(), (int)this.start.getY(), 1, 1);
                if (this.current != null) {
                    dirty.add(this.current);
                }
                dirty.grow(1, 1);
                GraphEd.this.graph.repaint(dirty);
                this.highlight(GraphEd.this.graph, (CellView)this.port);
            }
        }

        public void paint(JGraph graph, Graphics g) {
            super.paint(graph, g);
            if (!graph.isXorEnabled()) {
                g.setColor(Color.black);
                this.drawConnectorLine(g);
            }
        }

        protected void drawConnectorLine(Graphics g) {
            if (this.firstPort != null && this.start != null && this.current != null) {
                g.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.current.getX(), (int)this.current.getY());
            }
        }

        protected void paintPort(Graphics g) {
            if (this.port != null) {
                boolean o = GraphConstants.getOffset((Map)this.port.getAllAttributes()) != null;
                Rectangle2D r = o ? this.port.getBounds() : this.port.getParentView().getBounds();
                r = GraphEd.this.graph.toScreen((Rectangle2D)r.clone());
                r.setFrame(r.getX() - 3.0, r.getY() - 3.0, r.getWidth() + 6.0, r.getHeight() + 6.0);
                GraphEd.this.graph.getUI().paintCell(g, (CellView)this.port, r, true);
            }
        }

        protected void highlight(JGraph graph, CellView cellView) {
            if (cellView != null) {
                this.highlight.setBounds(this.getHighlightBounds(graph, cellView));
                if (this.highlight.getParent() == null) {
                    graph.add((Component)this.highlight);
                    this.highlight.setVisible(true);
                }
            } else if (this.highlight.getParent() != null) {
                this.highlight.setVisible(false);
                this.highlight.getParent().remove(this.highlight);
            }
        }

        protected Rectangle getHighlightBounds(JGraph graph, CellView cellView) {
            boolean offset = GraphConstants.getOffset((Map)cellView.getAllAttributes()) != null;
            Rectangle2D r = offset ? cellView.getBounds() : cellView.getParentView().getBounds();
            r = graph.toScreen((Rectangle2D)r.clone());
            int s = 3;
            return new Rectangle((int)(r.getX() - (double)s), (int)(r.getY() - (double)s), (int)(r.getWidth() + (double)(2 * s)), (int)(r.getHeight() + (double)(2 * s)));
        }
    }

    public static class MyModel
    extends DefaultGraphModel {
        public boolean acceptsSource(Object edge, Object port) {
            return ((Edge)edge).getTarget() != port;
        }

        public boolean acceptsTarget(Object edge, Object port) {
            return ((Edge)edge).getSource() != port;
        }
    }

    public static class MyEdgeHandle
    extends EdgeView.EdgeHandle {
        public MyEdgeHandle(EdgeView edge, GraphContext ctx) {
            super(edge, ctx);
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return event.isShiftDown();
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return event.isShiftDown();
        }
    }

    public static class MyGraph
    extends JGraph {
        public MyGraph(GraphModel model) {
            this(model, null);
        }

        public MyGraph(GraphModel model, GraphLayoutCache cache) {
            super(model, cache);
            this.setPortsVisible(true);
            this.setGridEnabled(true);
            this.setGridSize(6.0);
            this.setTolerance(2);
            this.setInvokesStopCellEditing(true);
            this.setCloneable(true);
            this.setJumpToDefaultPort(true);
            this.setBendable(true);
            this.setSizeable(true);
            this.repaint();
        }

        public void updateUI() {
            this.setUI((GraphUI)new MyGraphUI(this));
            this.invalidate();
        }
    }
}

