/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.modcs.tools.Util.Util;
import org.modcs.tools.spn.gui.JPanelDataErlang;
import org.modcs.tools.spn.gui.JPanelDataExponential;
import org.modcs.tools.spn.gui.JPanelDataLogNormal;
import org.modcs.tools.spn.gui.JPanelDataNormal;
import org.modcs.tools.spn.model.FiringPolicy;
import org.modcs.tools.spn.model.TransitionExponential;
import org.modcs.tools.spn.model.expressions.IfElseExpression;
import org.modcs.tools.spn.simulator.randomvariates.ErlangRandomVariateGenerator;
import org.modcs.tools.spn.simulator.randomvariates.ExponentialRandomVariateGenerator;
import org.modcs.tools.spn.simulator.randomvariates.LogNormalRandomVariateGenerator;
import org.modcs.tools.spn.simulator.randomvariates.NormalRandomVariateGenerator;

public class JDialogTransitionExponentialProperties
extends JDialog {
    private TransitionExponential transExp;
    private String transitionName;
    private double delay;
    private FiringPolicy firingPolicy;
    private IfElseExpression ifElseExpression;
    private JPanelDataExponential jPanelDataExponential;
    private JPanelDataNormal jPanelDataNormal;
    private JPanelDataErlang jPanelDataErlang;
    private JPanelDataLogNormal jPanelDataLogNormal;
    public static final String PROP_TRANSEXP = "transExp";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox jComboBox1;
    private JComboBox jComboBoxProbabilityDistribution;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanelProbabilityDistribution;
    private JTextField jTextField1;
    private BindingGroup bindingGroup;

    public TransitionExponential getTransExp() {
        return this.transExp;
    }

    public void setTransExp(TransitionExponential transExp) {
        TransitionExponential oldTransExp = this.transExp;
        this.transExp = transExp;
        this.propertyChangeSupport.firePropertyChange(PROP_TRANSEXP, oldTransExp, transExp);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public JDialogTransitionExponentialProperties(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/org/modcs/tools/gui/icons/TransExponential.png"));
        this.setIconImage(icon.getImage());
        this.setLocationRelativeTo(null);
    }

    private void updateStateExponential() throws Exception {
        this.jPanelDataExponential = new JPanelDataExponential();
        Util.refreshScreen(this.jPanelDataExponential, this.jPanelProbabilityDistribution);
        if (this.transExp.getRandomVariateGenerator() instanceof ExponentialRandomVariateGenerator) {
            if (this.transExp.getDelayExpression() != null) {
                this.jPanelDataExponential.jTextFieldAverage.setText(this.transExp.getDelayExpression().getStringCondition());
            } else {
                this.delay = this.transExp.getDelay();
                this.jPanelDataExponential.jTextFieldAverage.setText(this.delay + "");
            }
        }
    }

    private void updateStateErlang() throws Exception {
        this.jPanelDataErlang = new JPanelDataErlang();
        Util.refreshScreen(this.jPanelDataErlang, this.jPanelProbabilityDistribution);
        if (this.transExp.getRandomVariateGenerator() instanceof ErlangRandomVariateGenerator) {
            ErlangRandomVariateGenerator erlangRandomVariateGenerator = (ErlangRandomVariateGenerator)this.transExp.getRandomVariateGenerator();
            this.jPanelDataErlang.jTextFieldShape.setText(erlangRandomVariateGenerator.getShapes() + "");
            if (this.transExp.getDelayExpression() != null) {
                this.jPanelDataErlang.jTextFieldMeanDelay.setText(this.transExp.getDelayExpression().getStringCondition());
            } else {
                this.delay = this.transExp.getDelay();
                this.jPanelDataErlang.jTextFieldMeanDelay.setText(this.delay + "");
            }
        }
    }

    private void updateStateNormal() throws Exception {
        this.jPanelDataNormal = new JPanelDataNormal();
        Util.refreshScreen(this.jPanelDataNormal, this.jPanelProbabilityDistribution);
        if (this.transExp.getRandomVariateGenerator() instanceof NormalRandomVariateGenerator) {
            NormalRandomVariateGenerator normalRandomVariateGenerator = (NormalRandomVariateGenerator)this.transExp.getRandomVariateGenerator();
            this.jPanelDataNormal.jTextFieldVariance.setText(normalRandomVariateGenerator.getVariance() + "");
            if (this.transExp.getDelayExpression() != null) {
                this.jPanelDataNormal.jTextFieldMeanDelay.setText(this.transExp.getDelayExpression().getStringCondition());
            } else {
                this.delay = this.transExp.getDelay();
                this.jPanelDataNormal.jTextFieldMeanDelay.setText(this.delay + "");
            }
        }
    }

    private void updateStateLogNormal() throws Exception {
        this.jPanelDataLogNormal = new JPanelDataLogNormal();
        Util.refreshScreen(this.jPanelDataLogNormal, this.jPanelProbabilityDistribution);
        if (this.transExp.getRandomVariateGenerator() instanceof LogNormalRandomVariateGenerator) {
            LogNormalRandomVariateGenerator logNormalRandomVariateGenerator = (LogNormalRandomVariateGenerator)this.transExp.getRandomVariateGenerator();
            this.jPanelDataLogNormal.jTextFieldVariance.setText(logNormalRandomVariateGenerator.getVariance() + "");
            if (this.transExp.getDelayExpression() != null) {
                this.jPanelDataLogNormal.jTextFieldMeanDelayLog.setText(this.transExp.getDelayExpression().getStringCondition());
            } else {
                this.delay = this.transExp.getDelay();
                this.jPanelDataLogNormal.jTextFieldMeanDelayLog.setText(this.delay + "");
            }
        }
    }

    public JDialogTransitionExponentialProperties(Frame parent, boolean b, TransitionExponential transitionExponential) throws Exception {
        this(parent, b);
        this.setTransExp(transitionExponential);
        this.transitionName = this.transExp.getName();
        this.ifElseExpression = transitionExponential.getDelayExpression();
        if (this.transExp.getRandomVariateGenerator() instanceof ErlangRandomVariateGenerator) {
            this.jComboBoxProbabilityDistribution.setSelectedIndex(2);
        } else if (this.transExp.getRandomVariateGenerator() instanceof ExponentialRandomVariateGenerator) {
            this.jComboBoxProbabilityDistribution.setSelectedIndex(0);
        } else if (this.transExp.getRandomVariateGenerator() instanceof LogNormalRandomVariateGenerator) {
            this.jComboBoxProbabilityDistribution.setSelectedIndex(3);
        } else if (this.transExp.getRandomVariateGenerator() instanceof NormalRandomVariateGenerator) {
            this.jComboBoxProbabilityDistribution.setSelectedIndex(1);
        }
        this.firingPolicy = this.transExp.getFiringPolicy();
        if (this.firingPolicy == FiringPolicy.SINGLE_SERVER) {
            this.jComboBox1.setSelectedIndex(0);
        } else if (this.firingPolicy == FiringPolicy.INFINITY_SERVER) {
            this.jComboBox1.setSelectedIndex(1);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanelProbabilityDistribution = new JPanel();
        this.jLabel4 = new JLabel();
        this.jComboBoxProbabilityDistribution = new JComboBox();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Transition Properties");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Transition Properties"));
        this.jLabel1.setText("Transition Name");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${transExp.name}"), (Object)this.jTextField1, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel3.setText("Server Type");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Single Server", "Infinite Server"}));
        this.jPanelProbabilityDistribution.setBorder(BorderFactory.createTitledBorder("Probability Distribution"));
        GroupLayout jPanelProbabilityDistributionLayout = new GroupLayout(this.jPanelProbabilityDistribution);
        this.jPanelProbabilityDistribution.setLayout(jPanelProbabilityDistributionLayout);
        jPanelProbabilityDistributionLayout.setHorizontalGroup(jPanelProbabilityDistributionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 478, Short.MAX_VALUE));
        jPanelProbabilityDistributionLayout.setVerticalGroup(jPanelProbabilityDistributionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 107, Short.MAX_VALUE));
        this.jLabel4.setText("Probability Distribution");
        this.jComboBoxProbabilityDistribution.setModel(new DefaultComboBoxModel<String>(new String[]{"Exponential", "Normal", "Erlang", "LogNormal"}));
        this.jComboBoxProbabilityDistribution.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogTransitionExponentialProperties.this.jComboBoxProbabilityDistributionActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelProbabilityDistribution, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -1, 323, Short.MAX_VALUE).addComponent(this.jComboBox1, 0, 323, Short.MAX_VALUE).addComponent(this.jComboBoxProbabilityDistribution, 0, 323, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProbabilityDistribution, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelProbabilityDistribution, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jButtonOk.setText("OK");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogTransitionExponentialProperties.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogTransitionExponentialProperties.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOk)).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.transExp.setName(this.transitionName);
        if (this.ifElseExpression == null) {
            this.transExp.setDelay(this.delay);
        } else {
            this.transExp.setDelayExpression(this.ifElseExpression);
        }
        this.transExp.setFiringPolicy(this.firingPolicy);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        NormalRandomVariateGenerator rvg;
        IfElseExpression delayExpression;
        double delayTemp;
        String StringTemp;
        if (this.jComboBox1.getSelectedIndex() == 0) {
            this.transExp.setFiringPolicy(FiringPolicy.SINGLE_SERVER);
        } else if (this.jComboBox1.getSelectedIndex() == 1) {
            this.transExp.setFiringPolicy(FiringPolicy.INFINITY_SERVER);
        }
        if (this.jComboBoxProbabilityDistribution.getSelectedItem().equals("Exponential")) {
            StringTemp = this.jPanelDataExponential.jTextFieldAverage.getText();
            delayTemp = 0.0;
            delayExpression = null;
            delayExpression = IfElseExpression.parse(StringTemp);
            if (delayExpression == null) {
                try {
                    delayTemp = Double.parseDouble(StringTemp);
                    this.transExp.setDelay(delayTemp);
                    ExponentialRandomVariateGenerator exponentialRandomVariateGenerator = new ExponentialRandomVariateGenerator(1.0 / delayTemp);
                    this.transExp.setRandomVariateGenerator(exponentialRandomVariateGenerator);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Error: Delay");
                    ex.printStackTrace();
                }
            } else {
                this.transExp.setDelayExpression(delayExpression);
            }
        }
        if (this.jComboBoxProbabilityDistribution.getSelectedItem().equals("Normal")) {
            StringTemp = this.jPanelDataNormal.jTextFieldMeanDelay.getText();
            delayTemp = 0.0;
            delayExpression = null;
            delayExpression = IfElseExpression.parse(StringTemp);
            double variance = Double.parseDouble(this.jPanelDataNormal.jTextFieldVariance.getText());
            rvg = new NormalRandomVariateGenerator(variance);
            this.transExp.setRandomVariateGenerator(rvg);
            if (delayExpression == null) {
                try {
                    delayTemp = Double.parseDouble(StringTemp);
                    this.transExp.setDelay(delayTemp);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Error: Delay");
                    numberFormatException.printStackTrace();
                }
            } else {
                this.transExp.setDelayExpression(delayExpression);
            }
        }
        if (this.jComboBoxProbabilityDistribution.getSelectedItem().equals("LogNormal")) {
            StringTemp = this.jPanelDataLogNormal.jTextFieldMeanDelayLog.getText();
            delayTemp = 0.0;
            delayExpression = null;
            delayExpression = IfElseExpression.parse(StringTemp);
            double variance = Double.parseDouble(this.jPanelDataLogNormal.jTextFieldVariance.getText());
            rvg = new LogNormalRandomVariateGenerator(variance);
            this.transExp.setRandomVariateGenerator(rvg);
            if (delayExpression == null) {
                try {
                    delayTemp = Double.parseDouble(StringTemp);
                    this.transExp.setDelay(delayTemp);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Error: Delay");
                    numberFormatException.printStackTrace();
                }
            } else {
                this.transExp.setDelayExpression(delayExpression);
            }
        }
        if (this.jComboBoxProbabilityDistribution.getSelectedItem().equals("Erlang")) {
            StringTemp = this.jPanelDataErlang.jTextFieldMeanDelay.getText();
            delayTemp = 0.0;
            delayExpression = null;
            delayExpression = IfElseExpression.parse(StringTemp);
            int shapes = Integer.parseInt(this.jPanelDataErlang.jTextFieldShape.getText());
            ErlangRandomVariateGenerator erlangRandomVariateGenerator = new ErlangRandomVariateGenerator(shapes);
            this.transExp.setRandomVariateGenerator(erlangRandomVariateGenerator);
            if (delayExpression == null) {
                try {
                    delayTemp = Double.parseDouble(StringTemp);
                    this.transExp.setDelay(delayTemp);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Error: Delay");
                    numberFormatException.printStackTrace();
                }
            } else {
                this.transExp.setDelayExpression(delayExpression);
            }
        }
        this.dispose();
    }

    private void jComboBoxProbabilityDistributionActionPerformed(ActionEvent evt) {
        try {
            if (this.jComboBoxProbabilityDistribution.getSelectedIndex() == 0) {
                this.updateStateExponential();
            } else if (this.jComboBoxProbabilityDistribution.getSelectedIndex() == 1) {
                this.updateStateNormal();
            } else if (this.jComboBoxProbabilityDistribution.getSelectedIndex() == 2) {
                this.updateStateErlang();
            } else if (this.jComboBoxProbabilityDistribution.getSelectedIndex() == 3) {
                this.updateStateLogNormal();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JDialogTransitionExponentialProperties dialog = new JDialogTransitionExponentialProperties((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

