/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.spn.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Scanner;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class JDialogMTTFCalculator
extends JDialog {
    private File file;
    private JFileChooser fileChooser = null;
    private double t;
    private double MTTF;
    private double MTTR;
    private double availability;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelFileName;
    private JTextField jTextFieldAvailability;
    private JTextField jTextFieldTimeInterval;

    public JDialogMTTFCalculator(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    protected void initFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.getName() == null) {
                        return false;
                    }
                    if (f.getName().endsWith(".txt")) {
                        return true;
                    }
                    return f.isDirectory();
                }

                public String getDescription() {
                    return "TXT FILES(.txt)";
                }
            };
            this.fileChooser.setFileFilter(fileFilter);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextFieldTimeInterval = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldAvailability = new JTextField();
        this.jLabelFileName = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("MTTR/F Calculator");
        this.jLabel1.setText("TimeInterval");
        this.jButton1.setText("File");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogMTTFCalculator.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Calculate");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogMTTFCalculator.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Availability");
        this.jLabelFileName.setText("...");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelFileName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAvailability, -1, 186, Short.MAX_VALUE).addComponent(this.jTextFieldTimeInterval, -1, 186, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldTimeInterval, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldAvailability, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1).addComponent(this.jLabelFileName)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int returnValue = 1;
        this.initFileChooser();
        returnValue = this.fileChooser.showOpenDialog(this);
        if (returnValue == 0) {
            try {
                this.file = this.fileChooser.getSelectedFile();
                this.jLabelFileName.setText(this.file.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error Open the File", 0);
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.jTextFieldTimeInterval.getText().equals("") || Double.parseDouble(this.jTextFieldTimeInterval.getText()) <= 0.0) {
            JOptionPane.showMessageDialog(null, "Invalid Time Interval", "invalid data", 0);
            return;
        }
        if (this.jTextFieldAvailability.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Invalid Availability", "invalid data", 0);
            return;
        }
        if (this.file == null) {
            JOptionPane.showMessageDialog(null, "Invalid file", "invalid data", 0);
            return;
        }
        this.t = Double.parseDouble(this.jTextFieldTimeInterval.getText());
        this.availability = Double.parseDouble(this.jTextFieldAvailability.getText());
        this.calculate();
    }

    public void calculateMTTF() {
        double valorAtual = 0.0;
        int cont = 0;
        try {
            FileInputStream in = new FileInputStream(this.file);
            Scanner scanner = new Scanner(in);
            while (scanner.hasNext()) {
                if (cont == 0) {
                    valorAtual = Double.parseDouble(scanner.nextLine());
                    ++cont;
                    continue;
                }
                double valorProx = Double.parseDouble(scanner.nextLine());
                double media = (valorAtual + valorProx) / 2.0;
                this.MTTF += (media *= this.t);
                valorAtual = valorProx;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void calculate() {
        this.calculateMTTF();
        this.MTTR = this.MTTF / this.availability - this.MTTF;
        JOptionPane.showMessageDialog(null, "MTTR = " + this.MTTR + "\n" + "MTTF = " + this.MTTF, "Result", -1);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JDialogMTTFCalculator dialog = new JDialogMTTFCalculator((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

