/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import com.thoughtworks.xstream.XStream;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.modcs.tools.rbd.gui.ParametersResultsRBD;
import org.modcs.tools.spn.gui.graphview.ChartTransient;

public class JDialogResultsRBD
extends JDialog {
    private ParametersResultsRBD parametersResultsRBD;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabelEvalTime;
    private JLabel jLabelEvalTime1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldMTTF;
    private JTextField jTextFieldMTTR;
    private JTextField jTextFieldSteadyStateAvailability;
    private JTextField jTextFieldSteadyStateAvailability1;
    private JTextField jTextFieldSteadyStateAvailability2;

    public JDialogResultsRBD(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.parametersResultsRBD = new ParametersResultsRBD();
    }

    public ParametersResultsRBD getParametersResultsRBD() {
        return this.parametersResultsRBD;
    }

    public void setParametersResultsRBD(ParametersResultsRBD parametersResultsRBD) {
        this.parametersResultsRBD = parametersResultsRBD;
    }

    public void updateTextArea() {
        String stringTextArea = "";
        stringTextArea = stringTextArea + " ************ RBD Results  ************ \n";
        stringTextArea = stringTextArea + "MTTF: \t" + this.parametersResultsRBD.getMttf() + "\n";
        stringTextArea = stringTextArea + "MTTR: \t" + this.parametersResultsRBD.getMttr() + "\n";
        stringTextArea = stringTextArea + "Availability: \t" + this.parametersResultsRBD.getAvailability() + "\n";
        stringTextArea = stringTextArea + "Nines: \t" + (2.0 - Math.log10(100.0 - this.parametersResultsRBD.getAvailability() * 100.0)) + "\n\n\n";
        ArrayList<Double> reals = this.parametersResultsRBD.getReliabilityValuesAsNines();
        ArrayList<Double> avails = this.parametersResultsRBD.getInstantAvailabilityValues();
        if (reals != null && avails != null) {
            stringTextArea = stringTextArea + "TIME \t Reliability(9's) \t\t Availability(9's)\n";
            for (int i = 0; i < reals.size() && i < avails.size(); ++i) {
                double currentTime = this.parametersResultsRBD.getTotaltime() / (double)this.parametersResultsRBD.getSamplingPoints() * (double)(i + 1);
                stringTextArea = stringTextArea + currentTime + "\t" + reals.get(i) + "\t" + avails.get(i) + "\n";
            }
        }
        this.jTextArea1.setText(stringTextArea);
    }

    public void updateTextFields() {
        this.jTextFieldMTTF.setText(this.parametersResultsRBD.getMttf() + "");
        this.jTextFieldMTTR.setText(this.parametersResultsRBD.getMttr() + "");
        this.jTextFieldSteadyStateAvailability.setText(this.parametersResultsRBD.getAvailability() + "");
        this.jTextFieldSteadyStateAvailability2.setText(2.0 - Math.log10(100.0 - this.parametersResultsRBD.getAvailability() * 100.0) + "");
        if (this.parametersResultsRBD.getTotaltime() != 0.0) {
            this.jTextFieldSteadyStateAvailability1.setText(this.parametersResultsRBD.getTotaltime() + "");
        } else {
            this.jTextFieldSteadyStateAvailability1.setEnabled(false);
            this.jLabelEvalTime.setEnabled(false);
        }
    }

    public void updateParameters() {
        this.updateTextArea();
        this.updateTextFields();
    }

    private void saveFileAs() {
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.setFileSelectionMode(0);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f == null) {
                    return false;
                }
                if (f.getName() == null) {
                    return false;
                }
                if (f.getName().endsWith(".xml")) {
                    return true;
                }
                return f.isDirectory();
            }

            public String getDescription() {
                return "XML files (.xml)";
            }
        };
        fc.setFileFilter(fileFilter);
        fc.showSaveDialog(this);
        File file = fc.getSelectedFile();
        if (file != null) {
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            try {
                XStream xstream = new XStream();
                try {
                    FileOutputStream fs = new FileOutputStream(file);
                    xstream.toXML((Object)this.parametersResultsRBD, (OutputStream)fs);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextFieldSteadyStateAvailability = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldMTTR = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldMTTF = new JTextField();
        this.jLabelEvalTime = new JLabel();
        this.jTextFieldSteadyStateAvailability1 = new JTextField();
        this.jTextFieldSteadyStateAvailability2 = new JTextField();
        this.jLabelEvalTime1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Steady-State Results"));
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("Steady-State Availability:");
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Mean Time to Repair:");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Mean Time to Failure:");
        this.jLabelEvalTime.setFont(new Font("Tahoma", 1, 11));
        this.jLabelEvalTime.setText("Evaluation Time:");
        this.jLabelEvalTime1.setFont(new Font("Tahoma", 1, 11));
        this.jLabelEvalTime1.setText("Availability(Number 9's)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addGap(35, 35, 35).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldMTTF, -1, 546, Short.MAX_VALUE).addComponent(this.jTextFieldMTTR, -1, 546, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(11, 11, 11).addComponent(this.jTextFieldSteadyStateAvailability, -1, 546, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelEvalTime).addComponent(this.jLabelEvalTime1)).addGap(20, 20, 20).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSteadyStateAvailability2, -1, 546, Short.MAX_VALUE).addComponent(this.jTextFieldSteadyStateAvailability1, -1, 546, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldMTTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMTTR, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldSteadyStateAvailability, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelEvalTime1).addComponent(this.jTextFieldSteadyStateAvailability2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelEvalTime).addComponent(this.jTextFieldSteadyStateAvailability1, -2, -1, -2)).addContainerGap()));
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogResultsRBD.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Export to XML");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogResultsRBD.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Textual Result"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 702, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 339, Short.MAX_VALUE).addContainerGap()));
        this.jButton3.setText("Plot Reliability");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogResultsRBD.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Plot Intantaneous Availability");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogResultsRBD.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 288, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3).addComponent(this.jButton4)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.saveFileAs();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.plotReliability();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.plotInstantaneousAvailability();
    }

    private void plotReliability() {
        if (this.parametersResultsRBD.getReliabilityValuesAsNines() != null && this.parametersResultsRBD.getReliabilityValuesAsNines().size() != 0) {
            ArrayList array = (ArrayList)this.parametersResultsRBD.getReliabilityValuesAsNines().clone();
            Collections.sort(array);
            ChartTransient chartTransient = new ChartTransient();
            JPanel jPanel = null;
            jPanel = array.size() > 2 ? chartTransient.getChart(this.parametersResultsRBD.getReliabilityValuesAsNines(), this.parametersResultsRBD.getTotaltime() / (double)this.parametersResultsRBD.getSamplingPoints(), 0.0, (Double)array.get(array.size() - 2) + 5.0) : chartTransient.getChart(this.parametersResultsRBD.getReliabilityValuesAsNines(), this.parametersResultsRBD.getTotaltime() / (double)this.parametersResultsRBD.getSamplingPoints());
            jPanel.setPreferredSize(new Dimension(500, 270));
            JDialog frame = new JDialog((Dialog)this, true);
            frame.setTitle("Reliability Chart (number of 9's) (Right Click to Save Graph)");
            frame.add(jPanel);
            frame.pack();
            frame.setLocationRelativeTo(this);
            frame.setVisible(true);
        }
    }

    private void plotInstantaneousAvailability() {
        if (this.parametersResultsRBD.getInstantAvailabilityValues() != null && this.parametersResultsRBD.getInstantAvailabilityValues().size() != 0) {
            ArrayList array = (ArrayList)this.parametersResultsRBD.getInstantAvailabilityValues().clone();
            Collections.sort(array);
            ChartTransient chartTransient = new ChartTransient();
            JPanel jPanel = null;
            jPanel = array.size() > 2 ? chartTransient.getChart(this.parametersResultsRBD.getInstantAvailabilityValues(), this.parametersResultsRBD.getTotaltime() / (double)this.parametersResultsRBD.getSamplingPoints(), "Av(T)", "Instaneous Availability Values", 0.0, (Double)array.get(array.size() - 2) + 5.0) : chartTransient.getChart(this.parametersResultsRBD.getInstantAvailabilityValues(), this.parametersResultsRBD.getTotaltime() / (double)this.parametersResultsRBD.getSamplingPoints(), "Av(T)", "Instaneous Availability Values");
            jPanel.setPreferredSize(new Dimension(500, 270));
            JDialog frame = new JDialog((Dialog)this, true);
            frame.setTitle("Instantaneous Availability Chart (number 9's) (Right Click to Save Graph)");
            frame.add(jPanel);
            frame.pack();
            frame.setLocationRelativeTo(this);
            frame.setVisible(true);
        }
    }
}

