/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockBridge;
import org.modcs.tools.rbd.blocks.BlockChain;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.BlockKOutOfN;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.RBDModel;
import org.modcs.tools.rbd.evaluatorrbd.RBDLabel;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.JDEditBlocks;

public class JDInsertBlockKN
extends JDialog {
    private BlockKOutOfN blockKN;
    private Block blockSelected;
    private boolean isSeries;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabelFailure;
    private JLabel jLabelK;
    private JLabel jLabelN;
    private JLabel jLabelRepair;
    private JPanel jPanel1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextFieldFailure;
    private JTextField jTextFieldNumberOfBlocks;
    private JTextField jTextFieldRepair;

    public JDInsertBlockKN(Frame parent, boolean modal, Block blockSelected, boolean isSeries) {
        super(parent, modal);
        this.initComponents();
        this.blockSelected = blockSelected;
        this.isSeries = isSeries;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldNumberOfBlocks = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jLabelRepair = new JLabel();
        this.jLabelFailure = new JLabel();
        this.jTextFieldFailure = new JTextField();
        this.jTextFieldRepair = new JTextField();
        this.jLabelK = new JLabel();
        this.jLabelN = new JLabel();
        this.jTextField3 = new JTextField();
        this.jTextField2 = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Insert Blocks");
        this.jButton1.setText("Ok");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDInsertBlockKN.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDInsertBlockKN.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Number of Blocks");
        this.jTextFieldNumberOfBlocks.setFont(new Font("Tahoma", 1, 11));
        this.jTextFieldNumberOfBlocks.setText("1");
        this.jTextFieldNumberOfBlocks.setEnabled(false);
        this.jLabel2.setText("Parameters Type:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Rates", "Time"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDInsertBlockKN.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Parameters", 1, 0));
        this.jLabelRepair.setText("Repair Rate");
        this.jLabelFailure.setText("Failure Rate");
        this.jTextFieldFailure.setText("0.0");
        this.jTextFieldRepair.setText("0.0");
        this.jLabelK.setText("K");
        this.jLabelN.setText("N");
        this.jTextField3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDInsertBlockKN.this.jTextField3ActionPerformed(evt);
            }
        });
        this.jTextField2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDInsertBlockKN.this.jTextField2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelFailure).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldFailure, -1, 180, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelRepair).addComponent(this.jLabelK)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextField3, -1, 79, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelN, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, 80, -2)).addComponent(this.jTextFieldRepair, -1, 179, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFailure, -2, -1, -2).addComponent(this.jLabelFailure)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRepair).addComponent(this.jTextFieldRepair, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelK).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jLabelN).addComponent(this.jTextField2, -2, -1, -2)).addContainerGap(15, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldNumberOfBlocks, -1, 174, Short.MAX_VALUE).addComponent(this.jComboBox1, 0, 174, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton1, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldNumberOfBlocks, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton1)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            int k = Integer.parseInt(this.jTextField3.getText());
            int n = Integer.parseInt(this.jTextField2.getText());
            double failureRate = 0.0;
            double repairRate = 0.0;
            RBDLabel failureLabel = null;
            RBDLabel repairLabel = null;
            if (this.jComboBox1.getSelectedIndex() == 0) {
                RBDLabel label;
                try {
                    failureRate = Double.parseDouble(this.jTextFieldFailure.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    label = JDEditBlocks.getLabel(this.jTextFieldFailure.getText());
                    if (label != null) {
                        failureLabel = label;
                    }
                    JOptionPane.showMessageDialog(null, "Parameter Error Failure Rate");
                    return;
                }
                try {
                    repairRate = Double.parseDouble(this.jTextFieldRepair.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    label = JDEditBlocks.getLabel(this.jTextFieldRepair.getText());
                    if (label != null) {
                        repairLabel = label;
                    }
                    JOptionPane.showMessageDialog(null, "Parameter Error Repair Rate");
                    return;
                }
            } else {
                RBDLabel label;
                try {
                    failureRate = 1.0 / Double.parseDouble(this.jTextFieldFailure.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    label = JDEditBlocks.getLabel(this.jTextFieldFailure.getText());
                    if (label != null) {
                        failureLabel = label;
                    }
                    JOptionPane.showMessageDialog(null, "Parameter Error Failure Time");
                    return;
                }
                try {
                    repairRate = 1.0 / Double.parseDouble(this.jTextFieldRepair.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    label = JDEditBlocks.getLabel(this.jTextFieldRepair.getText());
                    if (label != null) {
                        repairLabel = label;
                    }
                    JOptionPane.showMessageDialog(null, "Parameter Error Repair Time");
                    return;
                }
            }
            if (k < 0 || n < 0 || k < 0 || n == 0) {
                JOptionPane.showMessageDialog(this.rootPane, "Invalid Parameter", "ERROR", 0);
                this.setVisible(false);
                return;
            }
            RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
            this.blockKN = new BlockKOutOfN("", n, k, new BlockExponential("b" + rBDModel.getIndexOfBlocks() + " " + k + "/" + n, failureRate, repairRate, failureLabel, repairLabel), rBDModel.getIndexOfBlocks());
            rBDModel.incrementNumberOfBlocks();
            this.setVisible(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.rootPane, "Invalid Parameter", "ERROR", 0);
            this.jTextField2.setText("");
            this.jTextField3.setText("");
            return;
        }
        RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
        rBDModel.incrementIndexOfBlocks();
        rBDModel.incrementNumberOfBlocks();
        if (this.isSeries) {
            this.insertKNBlockSeries();
        } else {
            this.insertKNBlockParallel();
        }
        this.setVisible(false);
    }

    public void insertKNBlockParallel() {
        if (GraphViewRBD.app.getRBDModel().getModel() instanceof BlockExponential) {
            BlockParallel newBlock = new BlockParallel("");
            newBlock.addBlock(this.blockSelected);
            newBlock.addBlock(this.blockKN);
            this.blockKN.setFatherBlock(newBlock);
            GraphViewRBD.app.getRBDModel().setModel(newBlock);
            GraphViewRBD.paint();
        } else if (this.blockSelected.getFatherBlock() instanceof BlockParallel) {
            BlockParallel blockFather = (BlockParallel)this.blockSelected.getFatherBlock();
            blockFather.addBlock(this.blockKN);
            this.blockKN.setFatherBlock(blockFather);
            GraphViewRBD.paint();
        } else if (this.blockSelected.getFatherBlock() instanceof BlockSeries) {
            BlockSeries blockFather = (BlockSeries)this.blockSelected.getFatherBlock();
            int index = blockFather.getBlocks().indexOf(this.blockSelected);
            Block blockTemp = null;
            if (this.blockSelected instanceof BlockExponential) {
                blockTemp = new BlockExponential("", null, null);
            } else if (this.blockSelected instanceof BlockKOutOfN) {
                blockTemp = new BlockKOutOfN("", 0, 0, null, 0);
            }
            blockTemp.copy(this.blockSelected);
            BlockParallel newBlock = new BlockParallel("");
            newBlock.addBlock(blockTemp);
            newBlock.addBlock(this.blockKN);
            blockTemp.setFatherBlock(newBlock);
            this.blockKN.setFatherBlock(newBlock);
            blockFather.getBlocks().set(index, newBlock);
            newBlock.setFatherBlock(blockFather);
            GraphViewRBD.paint();
        } else if (this.blockSelected.getFatherBlock() instanceof BlockBridge && this.blockSelected.getFatherBlock().getFatherBlock() != null) {
            if (this.blockSelected.getFatherBlock().getFatherBlock() instanceof BlockParallel) {
                RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
                BlockExponential newBlock = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), null, null);
                ((BlockChain)this.blockSelected.getFatherBlock().getFatherBlock()).addBlock(newBlock);
                newBlock.setFatherBlock(this.blockSelected.getFatherBlock().getFatherBlock());
                GraphViewRBD.paint();
            } else if (this.blockSelected.getFatherBlock().getFatherBlock() instanceof BlockSeries) {
                BlockSeries blockFather = (BlockSeries)this.blockSelected.getFatherBlock().getFatherBlock();
                int index = blockFather.getBlocks().indexOf(this.blockSelected.getFatherBlock());
                BlockParallel newBlock = new BlockParallel("");
                newBlock.addBlock(this.blockSelected.getFatherBlock());
                newBlock.addBlock(this.blockKN);
                this.blockSelected.getFatherBlock().setFatherBlock(newBlock);
                this.blockKN.setFatherBlock(newBlock);
                blockFather.getBlocks().set(index, newBlock);
                newBlock.setFatherBlock(blockFather);
                GraphViewRBD.paint();
            }
        }
    }

    public void insertKNBlockSeries() {
        if (GraphViewRBD.app.getRBDModel().getModel() instanceof BlockExponential) {
            BlockSeries newBlock = new BlockSeries("");
            newBlock.addBlock(this.blockSelected);
            newBlock.addBlock(this.blockKN);
            this.blockKN.setFatherBlock(newBlock);
            GraphViewRBD.app.getRBDModel().setModel(newBlock);
            GraphViewRBD.paint();
        } else if (this.blockSelected.getFatherBlock() instanceof BlockSeries) {
            BlockSeries blockFather = (BlockSeries)this.blockSelected.getFatherBlock();
            blockFather.addBlock(this.blockKN);
            this.blockKN.setFatherBlock(blockFather);
            GraphViewRBD.paint();
        } else if (this.blockSelected.getFatherBlock() instanceof BlockParallel) {
            BlockParallel blockFather = (BlockParallel)this.blockSelected.getFatherBlock();
            int index = blockFather.getBlocks().indexOf(this.blockSelected);
            Block blockTemp = null;
            if (this.blockSelected instanceof BlockExponential) {
                blockTemp = new BlockExponential("", null, null);
            } else if (this.blockSelected instanceof BlockKOutOfN) {
                blockTemp = new BlockKOutOfN("", 0, 0, null, 0);
            }
            blockTemp.copy(this.blockSelected);
            BlockSeries newBlock = new BlockSeries("");
            newBlock.addBlock(blockTemp);
            newBlock.addBlock(this.blockKN);
            blockTemp.setFatherBlock(newBlock);
            this.blockKN.setFatherBlock(newBlock);
            newBlock.setFatherBlock(blockFather);
            blockFather.getBlocks().set(index, newBlock);
            GraphViewRBD.paint();
        } else if (this.blockSelected.getFatherBlock() instanceof BlockBridge && this.blockSelected.getFatherBlock().getFatherBlock() != null) {
            if (this.blockSelected.getFatherBlock().getFatherBlock() instanceof BlockSeries) {
                ((BlockChain)this.blockSelected.getFatherBlock().getFatherBlock()).addBlock(this.blockKN);
                this.blockKN.setFatherBlock(this.blockSelected.getFatherBlock().getFatherBlock());
                GraphViewRBD.paint();
            } else if (this.blockSelected.getFatherBlock().getFatherBlock() instanceof BlockParallel) {
                BlockParallel blockFather = (BlockParallel)this.blockSelected.getFatherBlock().getFatherBlock();
                int index = blockFather.getBlocks().indexOf(this.blockSelected.getFatherBlock());
                BlockSeries newBlock = new BlockSeries("");
                newBlock.addBlock(this.blockSelected.getFatherBlock());
                newBlock.addBlock(this.blockKN);
                this.blockSelected.getFatherBlock().setFatherBlock(newBlock);
                this.blockKN.setFatherBlock(newBlock);
                blockFather.getBlocks().set(index, newBlock);
                newBlock.setFatherBlock(blockFather);
                GraphViewRBD.paint();
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
    }

    private void jTextField3ActionPerformed(ActionEvent evt) {
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (this.jComboBox1.getSelectedIndex() == 0) {
            if (this.jLabelFailure.getText().equals("Failure Time")) {
                this.jLabelFailure.setText("Failure Rate");
                this.jLabelRepair.setText("Repair Rate");
                double ttf = 0.0;
                try {
                    ttf = Double.parseDouble(this.jTextFieldFailure.getText());
                    this.jTextFieldFailure.setText(1.0 / ttf + "");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                double ttr = 0.0;
                try {
                    ttr = Double.parseDouble(this.jTextFieldRepair.getText());
                    this.jTextFieldRepair.setText(1.0 / ttr + "");
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (this.jLabelFailure.getText().equals("Failure Rate")) {
            this.jLabelFailure.setText("Failure Time");
            this.jLabelRepair.setText("Repair Time");
            try {
                double failRate = Double.parseDouble(this.jTextFieldFailure.getText());
                this.jTextFieldFailure.setText(1.0 / failRate + "");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                double repairRate = Double.parseDouble(this.jTextFieldRepair.getText());
                this.jTextFieldRepair.setText(1.0 / repairRate + "");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

