/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.BlockKOutOfN;
import org.modcs.tools.rbd.evaluatorrbd.RBDLabel;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class JDEditBlocks
extends JDialog {
    private Block block;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox jComboBoxState;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabelFailure;
    private JLabel jLabelK;
    private JLabel jLabelN;
    private JLabel jLabelRepair;
    private JPanel jPanel1;
    private JTextField jTextFieldFailure;
    private JTextField jTextFieldK;
    private JTextField jTextFieldN;
    private JTextField jTextFieldName;
    private JTextField jTextFieldRepair;

    public JDEditBlocks(Frame parent, boolean modal, Block block) {
        super(parent, modal);
        this.initComponents();
        this.block = block;
        this.updateState();
    }

    public void updateState() {
        if (this.block instanceof BlockExponential) {
            BlockExponential blockExponential = (BlockExponential)this.block;
            if (blockExponential.getrBDLabelRepair() == null) {
                this.jTextFieldRepair.setText("" + ((BlockExponential)this.block).getRepairRate());
            } else {
                this.jTextFieldRepair.setText(blockExponential.getrBDLabelRepair().getName());
            }
            if (blockExponential.getrBDLabelFailure() == null) {
                this.jTextFieldFailure.setText("" + new String("" + ((BlockExponential)this.block).getFailureRate()));
            } else {
                this.jTextFieldFailure.setText(blockExponential.getrBDLabelFailure().getName());
            }
            this.jTextFieldName.setText("" + ((BlockExponential)this.block).getName());
            this.jLabelK.setVisible(false);
            this.jLabelN.setVisible(false);
            this.jTextFieldK.setVisible(false);
            this.jTextFieldN.setVisible(false);
        } else if (this.block instanceof BlockKOutOfN) {
            BlockExponential blockExponential = (BlockExponential)((BlockKOutOfN)this.block).getBlock();
            if (blockExponential.getrBDLabelRepair() == null) {
                this.jTextFieldRepair.setText("" + blockExponential.getRepairRate());
            } else {
                this.jTextFieldRepair.setText(blockExponential.getrBDLabelRepair().getName());
            }
            if (blockExponential.getrBDLabelFailure() == null) {
                this.jTextFieldFailure.setText("" + blockExponential.getFailureRate());
            } else {
                this.jTextFieldFailure.setText(blockExponential.getrBDLabelFailure().getName());
            }
            this.jTextFieldName.setText("" + blockExponential.getName());
            this.jTextFieldK.setText("" + ((BlockKOutOfN)this.block).getK());
            this.jTextFieldN.setText("" + ((BlockKOutOfN)this.block).getN());
        }
        if (this.block.getState().equals("DEFAULT")) {
            this.jComboBoxState.setSelectedIndex(0);
        } else if (this.block.getState().equals("BROKEN")) {
            this.jComboBoxState.setSelectedIndex(1);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelRepair = new JLabel();
        this.jLabelFailure = new JLabel();
        this.jTextFieldFailure = new JTextField();
        this.jTextFieldRepair = new JTextField();
        this.jLabelK = new JLabel();
        this.jTextFieldK = new JTextField();
        this.jLabelN = new JLabel();
        this.jTextFieldN = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxState = new JComboBox();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Block");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Parameters", 1, 0));
        this.jLabelRepair.setText("Repair Rate");
        this.jLabelFailure.setText("Failure Rate");
        this.jLabelK.setText("K");
        this.jTextFieldK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDEditBlocks.this.jTextFieldKActionPerformed(evt);
            }
        });
        this.jLabelN.setText("N");
        this.jTextFieldN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDEditBlocks.this.jTextFieldNActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelFailure).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldFailure, -1, 232, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelRepair).addComponent(this.jLabelK)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldK, -2, 102, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelN, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldN, -1, 103, Short.MAX_VALUE)).addComponent(this.jTextFieldRepair, -1, 231, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFailure, -2, -1, -2).addComponent(this.jLabelFailure)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRepair).addComponent(this.jTextFieldRepair, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldN, -2, -1, -2).addComponent(this.jTextFieldK, -2, -1, -2).addComponent(this.jLabelK).addComponent(this.jLabelN)).addContainerGap(10, Short.MAX_VALUE)));
        this.jLabel5.setText("Block Name:");
        this.jTextFieldName.setFont(new Font("Tahoma", 1, 11));
        this.jButtonOk.setText("Ok");
        this.jButtonOk.setName("");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDEditBlocks.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDEditBlocks.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"Rates", "Time"}));
        this.jComboBoxType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDEditBlocks.this.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Parameters Type:");
        this.jComboBoxState.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "Failed"}));
        this.jComboBoxState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDEditBlocks.this.jComboBoxStateActionPerformed(evt);
            }
        });
        this.jLabel1.setText("State:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxType, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxState, -2, 91, -2)).addComponent(this.jTextFieldName, -1, 222, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOk, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxType, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jComboBoxState, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    public static void removeLabel(String temp) {
        ArrayList<RBDLabel> labels = GraphViewRBD.app.getLabelSet().getLabels();
        int index = labels.indexOf(new RBDLabel(temp, 0.0));
        if (index >= 0) {
            labels.remove(index);
        }
    }

    public static RBDLabel getLabel(String text) {
        ArrayList<RBDLabel> labels = GraphViewRBD.app.getLabelSet().getLabels();
        int index = labels.indexOf(new RBDLabel(text, 0.0));
        if (index >= 0) {
            RBDLabel label = labels.get(index);
            return label;
        }
        return null;
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        try {
            RBDLabel label;
            double failParameter = 0.0;
            double repairParameter = 0.0;
            RBDLabel labelFail = null;
            RBDLabel labelRepair = null;
            int state = this.jComboBoxState.getSelectedIndex();
            if (state == 0) {
                this.block.setStateDefault();
                GraphViewRBD.app.getRBDModel().setStateOfEqualBlocks(this.block);
            } else if (state == 1) {
                this.block.setStateBroken();
                GraphViewRBD.app.getRBDModel().setStateOfEqualBlocks(this.block);
            }
            try {
                failParameter = Double.parseDouble(this.jTextFieldFailure.getText());
                if (this.jLabelFailure.getText().equals("Failure Time")) {
                    failParameter = 1.0 / failParameter;
                }
            }
            catch (NumberFormatException numberFormatException) {
                label = JDEditBlocks.getLabel(this.jTextFieldFailure.getText());
                if (label != null) {
                    labelFail = label;
                }
                JOptionPane.showMessageDialog(null, "Parameter Error Failure Rate");
                return;
            }
            try {
                repairParameter = Double.parseDouble(this.jTextFieldRepair.getText());
                if (this.jLabelFailure.getText().equals("Failure Time")) {
                    repairParameter = 1.0 / repairParameter;
                }
            }
            catch (NumberFormatException numberFormatException) {
                label = JDEditBlocks.getLabel(this.jTextFieldRepair.getText());
                if (label != null) {
                    labelRepair = label;
                }
                JOptionPane.showMessageDialog(null, "Parameter Error Repair Rate");
                return;
            }
            if (this.block instanceof BlockExponential) {
                if (labelRepair != null) {
                    ((BlockExponential)this.block).setrBDLabelRepair(labelRepair);
                    ((BlockExponential)this.block).setIsMaintainabilityEdited(true);
                } else if (repairParameter != 0.0) {
                    ((BlockExponential)this.block).setRepairRate(repairParameter);
                    ((BlockExponential)this.block).setrBDLabelRepair(null);
                    ((BlockExponential)this.block).setIsMaintainabilityEdited(true);
                }
                if (labelFail != null) {
                    ((BlockExponential)this.block).setrBDLabelFailure(labelFail);
                    ((BlockExponential)this.block).setIsReliabilityEdited(true);
                }
                if (failParameter != 0.0) {
                    ((BlockExponential)this.block).setFailureRate(failParameter);
                    ((BlockExponential)this.block).setrBDLabelFailure(null);
                    ((BlockExponential)this.block).setIsReliabilityEdited(true);
                }
                ((BlockExponential)this.block).setName(this.jTextFieldName.getText());
            } else if (this.block instanceof BlockKOutOfN) {
                if (labelRepair != null) {
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setrBDLabelRepair(labelRepair);
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setIsMaintainabilityEdited(true);
                } else if (repairParameter != 0.0) {
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setRepairRate(repairParameter);
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setrBDLabelRepair(null);
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setIsMaintainabilityEdited(true);
                }
                if (labelFail != null) {
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setrBDLabelFailure(labelFail);
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setIsReliabilityEdited(true);
                }
                if (failParameter != 0.0) {
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setFailureRate(failParameter);
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setrBDLabelFailure(null);
                    ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setIsReliabilityEdited(true);
                }
                ((BlockExponential)((BlockKOutOfN)this.block).getBlock()).setName(this.jTextFieldName.getText());
                ((BlockKOutOfN)this.block).setK(Integer.parseInt(this.jTextFieldK.getText()));
                ((BlockKOutOfN)this.block).setN(Integer.parseInt(this.jTextFieldN.getText()));
            }
            GraphViewRBD.paint();
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.rootPane, "Invalid Parameter", "ERROR", 0);
            this.jTextFieldRepair.setText("");
            this.jTextFieldFailure.setText("");
            this.dispose();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        if (this.jComboBoxType.getSelectedIndex() == 0) {
            if (this.jLabelFailure.getText().equals("Failure Time")) {
                this.jLabelFailure.setText("Failure Rate");
                this.jLabelRepair.setText("Repair Rate");
                double ttf = 0.0;
                try {
                    ttf = Double.parseDouble(this.jTextFieldFailure.getText());
                    this.jTextFieldFailure.setText(1.0 / ttf + "");
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                double ttr = 0.0;
                try {
                    ttr = Double.parseDouble(this.jTextFieldRepair.getText());
                    this.jTextFieldRepair.setText(1.0 / ttr + "");
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (this.jLabelFailure.getText().equals("Failure Rate")) {
            this.jLabelFailure.setText("Failure Time");
            this.jLabelRepair.setText("Repair Time");
            try {
                double failRate = Double.parseDouble(this.jTextFieldFailure.getText());
                this.jTextFieldFailure.setText(1.0 / failRate + "");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                double repairRate = Double.parseDouble(this.jTextFieldRepair.getText());
                this.jTextFieldRepair.setText(1.0 / repairRate + "");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void jTextFieldKActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldNActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxStateActionPerformed(ActionEvent evt) {
    }
}

