/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.modcs.tools.Util.Util;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.blocks.bounds.PathsAndCuts;
import org.modcs.tools.rbd.blocks.bounds.SDPMethod;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class BoundsAnalisysScreen
extends JDialog {
    private double time;
    private SDPMethod sdpMethod;
    private PathsAndCuts pathcut;
    private Integer numberOfPaths;
    private Integer numberOfCuts;
    private MinimalPath[] minPaths;
    private MinimalCut[] minCuts;
    private boolean useLastCalc = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonRun;
    private JButton jButtonStart;
    private JCheckBox jCheckBoxAvaliability;
    private JCheckBox jCheckBoxDowntime;
    private JCheckBox jCheckBoxReliability;
    private JCheckBox jCheckBoxSSAvaliability;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel4;
    private JPanel jPanelMetrics;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTabbedPane jTabbedPane1;
    private JTextField jtfLowerAv;
    private JTextField jtfLowerAv1;
    private JTextField jtfLowerDowntime;
    private JTextField jtfLowerRe;
    private JTextField jtfUpperAv;
    private JTextField jtfUpperAv1;
    private JTextField jtfUpperDowntime;
    private JTextField jtfUpperRe;
    private JPanel panelAvailability;
    private JPanel panelAvailability1;
    private JPanel panelAvailability2;
    private JPanel panelReliability;
    private JSpinner spinnerLBA;
    private JSpinner spinnerLBA1;
    private JSpinner spinnerLBR;
    private JSpinner spinnerLowerDowntime;
    private JSpinner spinnerUBA;
    private JSpinner spinnerUBA1;
    private JSpinner spinnerUBR;
    private JSpinner spinnerUpperDowntime;
    private JTextArea textAreaAv;
    private JTextArea textAreaAv1;
    private JTextArea textAreaDowntime;
    private JTextArea textAreaRe;
    private JTextField textLowerAvailability;
    private JTextField textLowerDowntime;
    private JTextField textLowerReliability;
    private JTextField textLowerSSAvailability;
    private JTextField textTime;
    private JTextField textUpperAvailability;
    private JTextField textUpperDowntime;
    private JTextField textUpperReliability;
    private JTextField textUpperSSAvailability;

    public BoundsAnalisysScreen(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.minPaths = GraphViewRBD.app.getRBDModel().getMinimalPaths(true);
        this.minCuts = GraphViewRBD.app.getRBDModel().getMinimalCuts(true);
        this.numberOfPaths = this.minPaths.length;
        this.numberOfCuts = this.minCuts.length;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanelMetrics = new JPanel();
        this.jCheckBoxAvaliability = new JCheckBox();
        this.jCheckBoxReliability = new JCheckBox();
        this.jCheckBoxSSAvaliability = new JCheckBox();
        this.jCheckBoxDowntime = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.textTime = new JTextField();
        this.jButtonStart = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.panelAvailability1 = new JPanel();
        this.jLabel15 = new JLabel();
        this.spinnerUBA1 = new JSpinner();
        this.spinnerLBA1 = new JSpinner();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.textUpperSSAvailability = new JTextField();
        this.textLowerSSAvailability = new JTextField();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jtfUpperAv1 = new JTextField();
        this.jtfLowerAv1 = new JTextField();
        this.jScrollPane4 = new JScrollPane();
        this.textAreaAv1 = new JTextArea();
        this.jLabel33 = new JLabel();
        this.panelAvailability = new JPanel();
        this.jLabel13 = new JLabel();
        this.spinnerUBA = new JSpinner();
        this.spinnerLBA = new JSpinner();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.textUpperAvailability = new JTextField();
        this.textLowerAvailability = new JTextField();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jtfUpperAv = new JTextField();
        this.jtfLowerAv = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.textAreaAv = new JTextArea();
        this.jLabel2 = new JLabel();
        this.panelReliability = new JPanel();
        this.jLabel14 = new JLabel();
        this.spinnerUBR = new JSpinner();
        this.spinnerLBR = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.textUpperReliability = new JTextField();
        this.textLowerReliability = new JTextField();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.jtfUpperRe = new JTextField();
        this.jtfLowerRe = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.textAreaRe = new JTextArea();
        this.jLabel1 = new JLabel();
        this.panelAvailability2 = new JPanel();
        this.jLabel28 = new JLabel();
        this.spinnerUpperDowntime = new JSpinner();
        this.spinnerLowerDowntime = new JSpinner();
        this.jLabel29 = new JLabel();
        this.jLabel30 = new JLabel();
        this.textUpperDowntime = new JTextField();
        this.textLowerDowntime = new JTextField();
        this.jLabel31 = new JLabel();
        this.jLabel32 = new JLabel();
        this.jtfUpperDowntime = new JTextField();
        this.jtfLowerDowntime = new JTextField();
        this.jScrollPane5 = new JScrollPane();
        this.textAreaDowntime = new JTextArea();
        this.jLabel34 = new JLabel();
        this.jButtonRun = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("RBD Bounds Analisys");
        this.jPanelMetrics.setBorder(BorderFactory.createTitledBorder("Metrics"));
        this.jCheckBoxAvaliability.setSelected(true);
        this.jCheckBoxAvaliability.setText("Instantaneous Availability");
        this.jCheckBoxReliability.setSelected(true);
        this.jCheckBoxReliability.setText("Reliability");
        this.jCheckBoxSSAvaliability.setSelected(true);
        this.jCheckBoxSSAvaliability.setText("Stead State Availability");
        this.jCheckBoxDowntime.setSelected(true);
        this.jCheckBoxDowntime.setText("DownTime");
        GroupLayout jPanelMetricsLayout = new GroupLayout(this.jPanelMetrics);
        this.jPanelMetrics.setLayout(jPanelMetricsLayout);
        jPanelMetricsLayout.setHorizontalGroup(jPanelMetricsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMetricsLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxSSAvaliability).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAvaliability).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxReliability).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxDowntime).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelMetricsLayout.setVerticalGroup(jPanelMetricsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxSSAvaliability, -1, 23, Short.MAX_VALUE).addComponent(this.jCheckBoxAvaliability).addComponent(this.jCheckBoxReliability).addComponent(this.jCheckBoxDowntime));
        this.jLabel4.setText("Time");
        this.jButtonStart.setText("Get Initial Values");
        this.jButtonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoundsAnalisysScreen.this.jButtonStartActionPerformed(evt);
            }
        });
        this.panelAvailability1.setBorder(BorderFactory.createTitledBorder("Stead State Availability"));
        this.jLabel15.setText("Iteractions");
        this.spinnerUBA1.setEditor(new JSpinner.NumberEditor(this.spinnerUBA1, ""));
        this.spinnerUBA1.setEnabled(false);
        this.spinnerUBA1.setValue(1);
        this.spinnerUBA1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerUBA1StateChanged(evt);
            }
        });
        this.spinnerLBA1.setEditor(new JSpinner.NumberEditor(this.spinnerLBA1, ""));
        this.spinnerLBA1.setEnabled(false);
        this.spinnerLBA1.setValue(1);
        this.spinnerLBA1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerLBA1StateChanged(evt);
            }
        });
        this.jLabel24.setText("Upper:");
        this.jLabel25.setText("Lower:");
        this.textUpperSSAvailability.setEditable(false);
        this.textLowerSSAvailability.setEditable(false);
        this.jLabel26.setText("of");
        this.jLabel27.setText("of");
        this.jtfUpperAv1.setEditable(false);
        this.jtfLowerAv1.setEditable(false);
        this.textAreaAv1.setColumns(20);
        this.textAreaAv1.setEditable(false);
        this.textAreaAv1.setRows(5);
        this.textAreaAv1.setBorder(BorderFactory.createTitledBorder("Availability Stead State Iterations Results"));
        this.jScrollPane4.setViewportView(this.textAreaAv1);
        this.jLabel33.setText("Bounds Availability");
        GroupLayout panelAvailability1Layout = new GroupLayout(this.panelAvailability1);
        this.panelAvailability1.setLayout(panelAvailability1Layout);
        panelAvailability1Layout.setHorizontalGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailability1Layout.createSequentialGroup().addContainerGap().addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailability1Layout.createSequentialGroup().addComponent(this.jScrollPane4, -1, 425, Short.MAX_VALUE).addContainerGap()).addGroup(panelAvailability1Layout.createSequentialGroup().addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailability1Layout.createSequentialGroup().addComponent(this.jLabel25).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textLowerSSAvailability, -2, 146, -2)).addGroup(panelAvailability1Layout.createSequentialGroup().addComponent(this.jLabel24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel33).addComponent(this.textUpperSSAvailability, -2, 146, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15).addGroup(GroupLayout.Alignment.TRAILING, panelAvailability1Layout.createSequentialGroup().addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.spinnerLBA1, -1, 39, Short.MAX_VALUE).addComponent(this.spinnerUBA1, -1, 39, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel26).addComponent(this.jLabel27)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtfLowerAv1, -1, 37, Short.MAX_VALUE).addComponent(this.jtfUpperAv1, -1, 37, Short.MAX_VALUE)))).addGap(150, 150, 150)))));
        panelAvailability1Layout.setVerticalGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailability1Layout.createSequentialGroup().addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jLabel33)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panelAvailability1Layout.createSequentialGroup().addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel24).addComponent(this.textUpperSSAvailability, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLowerSSAvailability, -2, -1, -2).addComponent(this.jLabel25))).addGroup(panelAvailability1Layout.createSequentialGroup().addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel26).addComponent(this.spinnerUBA1, -2, -1, -2).addComponent(this.jtfUpperAv1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel27).addComponent(this.spinnerLBA1, -2, -1, -2).addComponent(this.jtfLowerAv1, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 259, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Stead State Availability", this.panelAvailability1);
        this.panelAvailability.setBorder(BorderFactory.createTitledBorder("Instantaneous Availability"));
        this.jLabel13.setText("Iteractions");
        this.spinnerUBA.setEditor(new JSpinner.NumberEditor(this.spinnerUBA, ""));
        this.spinnerUBA.setEnabled(false);
        this.spinnerUBA.setValue(1);
        this.spinnerUBA.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerUBAStateChanged(evt);
            }
        });
        this.spinnerLBA.setEditor(new JSpinner.NumberEditor(this.spinnerLBA, ""));
        this.spinnerLBA.setEnabled(false);
        this.spinnerLBA.setValue(1);
        this.spinnerLBA.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerLBAStateChanged(evt);
            }
        });
        this.jLabel16.setText("Bounds Availability");
        this.jLabel17.setText("Lower:");
        this.textUpperAvailability.setEditable(false);
        this.textLowerAvailability.setEditable(false);
        this.jLabel18.setText("of");
        this.jLabel19.setText("of");
        this.jtfUpperAv.setEditable(false);
        this.jtfLowerAv.setEditable(false);
        this.jtfLowerAv.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoundsAnalisysScreen.this.jtfLowerAvActionPerformed(evt);
            }
        });
        this.textAreaAv.setColumns(20);
        this.textAreaAv.setEditable(false);
        this.textAreaAv.setRows(5);
        this.textAreaAv.setBorder(BorderFactory.createTitledBorder("Availability Iterations Results"));
        this.jScrollPane2.setViewportView(this.textAreaAv);
        this.jLabel2.setText("Upper:");
        GroupLayout panelAvailabilityLayout = new GroupLayout(this.panelAvailability);
        this.panelAvailability.setLayout(panelAvailabilityLayout);
        panelAvailabilityLayout.setHorizontalGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailabilityLayout.createSequentialGroup().addContainerGap().addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 425, Short.MAX_VALUE).addGroup(panelAvailabilityLayout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.jLabel16).addGap(46, 46, 46).addComponent(this.jLabel13)).addGroup(panelAvailabilityLayout.createSequentialGroup().addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textLowerAvailability, -1, 128, Short.MAX_VALUE).addComponent(this.textUpperAvailability, -1, 128, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerUBA, -1, 48, Short.MAX_VALUE).addComponent(this.spinnerLBA, -1, 48, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel18).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jtfUpperAv, -1, 42, Short.MAX_VALUE).addComponent(this.jtfLowerAv, -1, 42, Short.MAX_VALUE)).addGap(140, 140, 140))).addContainerGap()));
        panelAvailabilityLayout.setVerticalGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailabilityLayout.createSequentialGroup().addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel16).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(panelAvailabilityLayout.createSequentialGroup().addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.textUpperAvailability, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLowerAvailability, -2, 20, -2).addComponent(this.jLabel17))).addGroup(panelAvailabilityLayout.createSequentialGroup().addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel19).addComponent(this.spinnerUBA, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent(this.spinnerLBA, -2, -1, -2))).addGroup(panelAvailabilityLayout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jtfUpperAv, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jtfLowerAv, -2, -1, -2))).addGap(7, 7, 7).addComponent(this.jScrollPane2, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Instantaneous Availability", this.panelAvailability);
        this.panelReliability.setBorder(BorderFactory.createTitledBorder("Reliability"));
        this.jLabel14.setText("Iteractions");
        this.spinnerUBR.setEditor(new JSpinner.NumberEditor(this.spinnerUBR, ""));
        this.spinnerUBR.setEnabled(false);
        this.spinnerUBR.setValue(1);
        this.spinnerUBR.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerUBRStateChanged(evt);
            }
        });
        this.spinnerLBR.setEditor(new JSpinner.NumberEditor(this.spinnerLBR, ""));
        this.spinnerLBR.setEnabled(false);
        this.spinnerLBR.setValue(1);
        this.spinnerLBR.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerLBRStateChanged(evt);
            }
        });
        this.jLabel20.setText("Upper:");
        this.jLabel21.setText("Lower:");
        this.textUpperReliability.setEditable(false);
        this.textLowerReliability.setEditable(false);
        this.jLabel22.setText("of");
        this.jLabel23.setText("of");
        this.jtfUpperRe.setEditable(false);
        this.jtfLowerRe.setEditable(false);
        this.textAreaRe.setColumns(20);
        this.textAreaRe.setEditable(false);
        this.textAreaRe.setRows(5);
        this.textAreaRe.setBorder(BorderFactory.createTitledBorder("Reliability Iterations Results"));
        this.jScrollPane3.setViewportView(this.textAreaRe);
        this.jLabel1.setText("Bound Reliability");
        GroupLayout panelReliabilityLayout = new GroupLayout(this.panelReliability);
        this.panelReliability.setLayout(panelReliabilityLayout);
        panelReliabilityLayout.setHorizontalGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelReliabilityLayout.createSequentialGroup().addContainerGap().addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelReliabilityLayout.createSequentialGroup().addComponent(this.jScrollPane3, -1, 425, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, panelReliabilityLayout.createSequentialGroup().addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21).addComponent(this.jLabel20, -1, 39, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panelReliabilityLayout.createSequentialGroup().addComponent(this.jLabel1, -1, 89, Short.MAX_VALUE).addGap(56, 56, 56)).addGroup(panelReliabilityLayout.createSequentialGroup().addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.textLowerReliability, GroupLayout.Alignment.LEADING, -1, 135, Short.MAX_VALUE).addComponent(this.textUpperReliability, GroupLayout.Alignment.LEADING, -1, 135, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE).addComponent(this.spinnerUBR, -1, 52, Short.MAX_VALUE).addComponent(this.spinnerLBR, -1, 52, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel23, -1, 18, Short.MAX_VALUE).addComponent(this.jLabel22, -1, 18, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtfLowerRe, -1, 25, Short.MAX_VALUE).addComponent(this.jtfUpperRe, -1, 25, Short.MAX_VALUE)).addGap(140, 140, 140)))));
        panelReliabilityLayout.setVerticalGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelReliabilityLayout.createSequentialGroup().addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelReliabilityLayout.createSequentialGroup().addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.textUpperReliability, -2, -1, -2)).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerUBR, -2, -1, -2).addComponent(this.jLabel22))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLowerReliability, -2, -1, -2).addComponent(this.spinnerLBR, -2, -1, -2).addComponent(this.jLabel21))).addGroup(panelReliabilityLayout.createSequentialGroup().addComponent(this.jtfUpperRe, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelReliabilityLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtfLowerRe, -2, -1, -2).addComponent(this.jLabel23)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 259, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Reliability", this.panelReliability);
        this.panelAvailability2.setBorder(BorderFactory.createTitledBorder("Downtime"));
        this.jLabel28.setText("Iteractions");
        this.spinnerUpperDowntime.setEditor(new JSpinner.NumberEditor(this.spinnerUpperDowntime, ""));
        this.spinnerUpperDowntime.setEnabled(false);
        this.spinnerUpperDowntime.setValue(1);
        this.spinnerUpperDowntime.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerUpperDowntimeStateChanged(evt);
            }
        });
        this.spinnerLowerDowntime.setEditor(new JSpinner.NumberEditor(this.spinnerLowerDowntime, ""));
        this.spinnerLowerDowntime.setEnabled(false);
        this.spinnerLowerDowntime.setValue(1);
        this.spinnerLowerDowntime.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoundsAnalisysScreen.this.spinnerLowerDowntimeStateChanged(evt);
            }
        });
        this.jLabel29.setText("Bounds Downtime");
        this.jLabel30.setText("Lower:");
        this.textUpperDowntime.setEditable(false);
        this.textLowerDowntime.setEditable(false);
        this.jLabel31.setText("of");
        this.jLabel32.setText("of");
        this.jtfUpperDowntime.setEditable(false);
        this.jtfLowerDowntime.setEditable(false);
        this.textAreaDowntime.setColumns(20);
        this.textAreaDowntime.setEditable(false);
        this.textAreaDowntime.setRows(5);
        this.textAreaDowntime.setBorder(BorderFactory.createTitledBorder("Downtime Iterations Results"));
        this.jScrollPane5.setViewportView(this.textAreaDowntime);
        this.jLabel34.setText("Upper:");
        GroupLayout panelAvailability2Layout = new GroupLayout(this.panelAvailability2);
        this.panelAvailability2.setLayout(panelAvailability2Layout);
        panelAvailability2Layout.setHorizontalGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailability2Layout.createSequentialGroup().addContainerGap().addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 425, Short.MAX_VALUE).addGroup(panelAvailability2Layout.createSequentialGroup().addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel34).addComponent(this.jLabel30)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textLowerDowntime, -1, 126, Short.MAX_VALUE).addComponent(this.textUpperDowntime, -1, 126, Short.MAX_VALUE).addComponent(this.jLabel29)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel28).addGroup(panelAvailability2Layout.createSequentialGroup().addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.spinnerUpperDowntime, GroupLayout.Alignment.LEADING, -1, 45, Short.MAX_VALUE).addComponent(this.spinnerLowerDowntime, GroupLayout.Alignment.LEADING, -1, 45, Short.MAX_VALUE)).addGap(9, 9, 9))).addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailability2Layout.createSequentialGroup().addComponent(this.jLabel31).addGap(4, 4, 4).addComponent(this.jtfUpperDowntime, -1, 42, Short.MAX_VALUE)).addGroup(panelAvailability2Layout.createSequentialGroup().addComponent(this.jLabel32).addGap(4, 4, 4).addComponent(this.jtfLowerDowntime, -1, 42, Short.MAX_VALUE))).addGap(144, 144, 144))).addContainerGap()));
        panelAvailability2Layout.setVerticalGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAvailability2Layout.createSequentialGroup().addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel28).addComponent(this.jLabel29)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(panelAvailability2Layout.createSequentialGroup().addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textUpperDowntime, -2, -1, -2).addComponent(this.jLabel34)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLowerDowntime, -2, -1, -2).addComponent(this.jtfLowerDowntime, -2, -1, -2).addComponent(this.jLabel32).addComponent(this.spinnerUpperDowntime, -2, -1, -2).addComponent(this.jLabel30))).addGroup(panelAvailability2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel31).addComponent(this.jtfUpperDowntime, -2, -1, -2).addComponent(this.spinnerLowerDowntime, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 259, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Downtime", this.panelAvailability2);
        this.jButtonRun.setText("Run Iterations ");
        this.jButtonRun.setEnabled(false);
        this.jButtonRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoundsAnalisysScreen.this.jButtonRunActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoundsAnalisysScreen.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMetrics, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1, -1, 462, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.textTime, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonStart).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonRun).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelMetrics, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textTime, -2, -1, -2).addComponent(this.jButtonStart).addComponent(this.jLabel4).addComponent(this.jButtonRun).addComponent(this.jButtonCancel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1, -1, 397, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButtonStartActionPerformed(ActionEvent evt) {
        if (this.jButtonRun.isEnabled()) {
            this.clearFields();
        }
        if (!GraphViewRBD.app.getRBDModel().isModelHasReliabilityEdited()) {
            JOptionPane.showMessageDialog(null, "Blocks not Edited", "ERROR", 0);
            return;
        }
        if (this.jCheckBoxAvaliability.isSelected() || this.jCheckBoxReliability.isSelected() || this.jCheckBoxSSAvaliability.isSelected() || this.jCheckBoxDowntime.isSelected()) {
            if (this.textTime.getText().equals("") && !this.jCheckBoxSSAvaliability.isSelected()) {
                JOptionPane.showMessageDialog(null, "Time is required!", "ERROR", 0);
                return;
            }
            if (this.textTime.getText().equals("")) {
                this.setTime(Double.MAX_VALUE);
            } else {
                this.setTime(Double.parseDouble(this.textTime.getText()));
            }
            if (this.jCheckBoxSSAvaliability.isSelected()) {
                this.textUpperSSAvailability.setText(String.valueOf(1.0 - this.minCuts[0].calculateAvailability(Double.MAX_VALUE)));
                this.textLowerSSAvailability.setText(String.valueOf(this.minPaths[0].calculateAvailability(Double.MAX_VALUE)));
                this.spinnerLBA1.setEnabled(true);
                this.spinnerUBA1.setEnabled(true);
                this.jtfLowerAv1.setText(String.valueOf(this.numberOfPaths));
                this.jtfUpperAv1.setText(String.valueOf(this.numberOfCuts));
                this.jButtonRun.setEnabled(true);
            }
            if (this.getTime() < Double.MAX_VALUE && this.getTime() > 0.0) {
                if (this.jCheckBoxAvaliability.isSelected()) {
                    this.textUpperAvailability.setText(String.valueOf(1.0 - this.minCuts[0].calculateAvailability(this.time)));
                    this.textLowerAvailability.setText(String.valueOf(this.minPaths[0].calculateAvailability(this.time)));
                    this.spinnerLBA.setEnabled(true);
                    this.spinnerUBA.setEnabled(true);
                    this.jtfLowerAv.setText(String.valueOf(this.numberOfPaths));
                    this.jtfUpperAv.setText(String.valueOf(this.numberOfCuts));
                    this.jButtonRun.setEnabled(true);
                }
                if (this.jCheckBoxReliability.isSelected()) {
                    this.textUpperReliability.setText(String.valueOf(1.0 - this.minCuts[0].calculateReliability(this.time)));
                    this.textLowerReliability.setText(String.valueOf(this.minPaths[0].calculateReliability(this.time)));
                    this.spinnerUBR.setEnabled(true);
                    this.spinnerLBR.setEnabled(true);
                    this.jtfLowerRe.setText(String.valueOf(this.numberOfPaths));
                    this.jtfUpperRe.setText(String.valueOf(this.numberOfCuts));
                    this.jButtonRun.setEnabled(true);
                }
                if (this.jCheckBoxDowntime.isSelected()) {
                    this.textLowerDowntime.setText(String.valueOf(this.time * this.minCuts[0].calculateAvailability(Double.MAX_VALUE)));
                    this.textUpperDowntime.setText(String.valueOf(this.time * (1.0 - this.minPaths[0].calculateAvailability(Double.MAX_VALUE))));
                    this.spinnerLowerDowntime.setEnabled(true);
                    this.spinnerUpperDowntime.setEnabled(true);
                    this.jtfLowerDowntime.setText(String.valueOf(this.numberOfCuts));
                    this.jtfUpperDowntime.setText(String.valueOf(this.numberOfPaths));
                    this.jButtonRun.setEnabled(true);
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "You need to choose a metric", "ERROR", 0);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void spinnerLBRStateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerLBR.getModel().getValue().toString()) < 1) {
            this.spinnerLBR.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerLBR.getModel().getValue().toString()) > this.numberOfPaths) {
            this.spinnerLBR.getModel().setValue(this.numberOfPaths);
        }
    }

    private void jButtonRunActionPerformed(ActionEvent evt) {
        this.sdpMethod = this.useLastCalc ? new SDPMethod(this.pathcut) : new SDPMethod(GraphViewRBD.app.getRBDModel());
        String result = "";
        if (this.jCheckBoxSSAvaliability.isSelected()) {
            result = "";
            result = this.showBounds("Upper Values", this.sdpMethod.getUpperValuesOfAvailability(Integer.parseInt(this.spinnerUBA1.getValue().toString()), (Double)Double.MAX_VALUE), true);
            result = result + "\n\n" + this.showBounds("Lower Values", this.sdpMethod.getLowerValuesOfAvailability(Integer.parseInt(this.spinnerLBA1.getValue().toString()), (Double)Double.MAX_VALUE), true);
            this.textAreaAv1.setText(result);
        }
        if (this.getTime() > 0.0 && this.getTime() < Double.MAX_VALUE) {
            if (this.jCheckBoxReliability.isSelected()) {
                result = "";
                result = this.showBounds("Upper Values", this.sdpMethod.getUpperValuesOfReliability(Integer.parseInt(this.spinnerUBR.getValue().toString()), this.getTime()), false);
                result = result + "\n\n" + this.showBounds("Lower Values", this.sdpMethod.getLowerValuesOfReliability(Integer.parseInt(this.spinnerLBR.getValue().toString()), this.getTime()), false);
                this.textAreaRe.setText(result);
            }
            if (this.jCheckBoxAvaliability.isSelected()) {
                result = "";
                result = this.showBounds("Upper Values", this.sdpMethod.getUpperValuesOfAvailability(Integer.parseInt(this.spinnerUBA.getValue().toString()), this.getTime()), true);
                result = result + "\n\n" + this.showBounds("Lower Values", this.sdpMethod.getLowerValuesOfAvailability(Integer.parseInt(this.spinnerLBA.getValue().toString()), this.getTime()), true);
                this.textAreaAv.setText(result);
            }
            if (this.jCheckBoxDowntime.isSelected()) {
                result = "";
                result = this.showBounds("Upper Values", this.sdpMethod.getUpperDowntime(Integer.parseInt(this.spinnerLowerDowntime.getValue().toString()), this.getTime()), false);
                result = result + "\n\n" + this.showBounds("Lower Values", this.sdpMethod.getLowerDowntime(Integer.parseInt(this.spinnerUpperDowntime.getValue().toString()), this.getTime()), false);
                this.textAreaDowntime.setText(result);
            }
        }
    }

    private void spinnerUBRStateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerUBR.getModel().getValue().toString()) < 1) {
            this.spinnerUBR.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerUBR.getModel().getValue().toString()) > this.numberOfCuts) {
            this.spinnerUBR.getModel().setValue(this.numberOfCuts);
        }
    }

    private void spinnerUBAStateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerUBA.getModel().getValue().toString()) < 1) {
            this.spinnerUBA.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerUBA.getModel().getValue().toString()) > this.numberOfCuts) {
            this.spinnerUBA.getModel().setValue(this.numberOfCuts);
        }
    }

    private void spinnerLBAStateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerLBA.getModel().getValue().toString()) < 1) {
            this.spinnerLBA.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerLBA.getModel().getValue().toString()) > this.numberOfPaths) {
            this.spinnerLBA.getModel().setValue(this.numberOfPaths);
        }
    }

    private void spinnerUBA1StateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerUBA1.getModel().getValue().toString()) < 1) {
            this.spinnerUBA1.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerUBA1.getModel().getValue().toString()) > this.numberOfCuts) {
            this.spinnerUBA1.getModel().setValue(this.numberOfCuts);
        }
    }

    private void spinnerLBA1StateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerLBA1.getModel().getValue().toString()) < 1) {
            this.spinnerLBA1.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerLBA1.getModel().getValue().toString()) > this.numberOfPaths) {
            this.spinnerLBA1.getModel().setValue(this.numberOfPaths);
        }
    }

    private void spinnerUpperDowntimeStateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerUpperDowntime.getModel().getValue().toString()) < 1) {
            this.spinnerUpperDowntime.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerUpperDowntime.getModel().getValue().toString()) > this.numberOfCuts) {
            this.spinnerUpperDowntime.getModel().setValue(this.numberOfCuts);
        }
    }

    private void spinnerLowerDowntimeStateChanged(ChangeEvent evt) {
        if (Integer.valueOf(this.spinnerLowerDowntime.getModel().getValue().toString()) < 1) {
            this.spinnerLowerDowntime.getModel().setValue(1);
        }
        if (Integer.valueOf(this.spinnerLowerDowntime.getModel().getValue().toString()) > this.numberOfPaths) {
            this.spinnerLowerDowntime.getModel().setValue(this.numberOfPaths);
        }
    }

    private void jtfLowerAvActionPerformed(ActionEvent evt) {
    }

    private void clearFields() {
        this.textAreaAv.setText("");
        this.textLowerAvailability.setText("");
        this.textUpperAvailability.setText("");
        this.spinnerLBA.setEnabled(false);
        this.spinnerUBA.setEnabled(false);
        this.jtfLowerAv.setText("");
        this.jtfUpperAv.setText("");
        this.textAreaAv1.setText("");
        this.textLowerSSAvailability.setText("");
        this.textUpperSSAvailability.setText("");
        this.spinnerLBA1.setEnabled(false);
        this.spinnerUBA1.setEnabled(false);
        this.jtfLowerAv1.setText("");
        this.jtfUpperAv1.setText("");
        this.textAreaRe.setText("");
        this.textLowerReliability.setText("");
        this.textUpperReliability.setText("");
        this.jtfLowerRe.setText("");
        this.jtfUpperRe.setText("");
        this.spinnerLBR.setEnabled(false);
        this.spinnerUBR.setEnabled(false);
        this.textAreaDowntime.setText("");
        this.textLowerDowntime.setText("");
        this.textUpperDowntime.setText("");
        this.spinnerLowerDowntime.setEnabled(false);
        this.spinnerUpperDowntime.setEnabled(false);
        this.jtfLowerDowntime.setText("");
        this.jtfUpperDowntime.setText("");
    }

    private void setPathcut(PathsAndCuts pathAndCut) {
        this.pathcut = pathAndCut;
    }

    private double getTime() {
        return this.time;
    }

    private void setTime(double time) {
        this.time = time;
    }

    private String showBounds(String header, Double[] bounds, boolean showNumberOfNines) {
        StringBuilder result = new StringBuilder();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(12);
        result.append(" ++ " + header + " +");
        if (showNumberOfNines) {
            result.append("\t\t\t++ Number of nines +");
        }
        for (int i = 1; i <= bounds.length; ++i) {
            result.append("\n\t- Step " + i + "  =  " + nf.format(bounds[i - 1]));
            if (!showNumberOfNines) continue;
            result.append("\t\t" + nf.format(Util.numberOfNines(bounds[i - 1])));
        }
        return result.toString();
    }
}

