/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.graphrbd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.UndoableEditListener;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockBridge;
import org.modcs.tools.rbd.blocks.BlockChain;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.BlockKOutOfN;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.RBDModel;
import org.modcs.tools.rbd.evaluatorrbd.ApplicationRBD;
import org.modcs.tools.rbd.evaluatorrbd.LabelSet;
import org.modcs.tools.rbd.evaluatorrbd.RBDLabel;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.JDEditBlocks;
import org.modcs.tools.rbd.gui.JDInsertBlock;
import org.modcs.tools.rbd.gui.JDInsertBlockKN;
import org.modcs.tools.spn.gui.JDialogLabelProperties;

public class GraphEdRBD
extends JApplet
implements GraphSelectionListener,
KeyListener {
    ApplicationRBD app;
    JScrollPane jScroll;
    protected JGraph graph;
    protected GraphUndoManager undoManager;
    protected Action undo;
    protected Action redo;
    protected Action remove;
    protected Action group;
    protected Action ungroup;
    protected Action tofront;
    protected Action toback;
    protected Action cut;
    protected Action copy;
    protected Action paste;
    protected int cellCount = 0;
    protected StatusBarGraphListener statusBar;

    public GraphEdRBD(ApplicationRBD app, JScrollPane jScroll, JGraph graph) {
        this.app = app;
        this.jScroll = jScroll;
        this.graph = graph;
        this.graph.setMarqueeHandler(this.createMarqueeHandler());
        this.installListeners(graph);
    }

    public void destroy() {
        super.destroy();
        PortView.renderer = new PortRenderer();
        EdgeView.renderer = new EdgeRenderer();
        AbstractCellView.cellEditor = new DefaultGraphCellEditor();
        VertexView.renderer = new VertexRenderer();
    }

    protected void populateContentPane() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane((Component)this.graph), "Center");
        this.statusBar = this.createStatusBar();
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    protected JGraph createGraph() {
        MyGraph graph = new MyGraph((GraphModel)new MyModel());
        graph.getGraphLayoutCache().setFactory((CellViewFactory)new DefaultCellViewFactory(){

            protected EdgeView createEdgeView(Object cell) {
                return new EdgeView(cell){

                    public CellHandle getHandle(GraphContext context) {
                        return new MyEdgeHandle(this, context);
                    }
                };
            }
        });
        return graph;
    }

    protected void installListeners(JGraph graph) {
        graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        graph.addKeyListener((KeyListener)this);
    }

    protected void uninstallListeners(JGraph graph) {
        graph.getModel().removeUndoableEditListener((UndoableEditListener)this.undoManager);
        graph.getSelectionModel().removeGraphSelectionListener((GraphSelectionListener)this);
        graph.removeKeyListener((KeyListener)this);
        graph.getModel().removeGraphModelListener((GraphModelListener)this.statusBar);
    }

    protected BasicMarqueeHandler createMarqueeHandler() {
        return new MyMarqueeHandler();
    }

    public void insert(Point2D point) {
        DefaultGraphCell vertex = this.createDefaultGraphCell();
        vertex.getAttributes().applyMap(this.createCellAttributes(point));
        this.graph.getGraphLayoutCache().insert((Object)vertex);
    }

    public Map createCellAttributes(Point2D point) {
        Hashtable map = new Hashtable();
        point = this.graph != null ? this.graph.snap((Point2D)point.clone()) : (Point2D)point.clone();
        GraphConstants.setBounds(map, (Rectangle2D)new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0));
        GraphConstants.setResize(map, (boolean)true);
        GraphConstants.setGradientColor(map, (Color)Color.blue);
        GraphConstants.setBorderColor(map, (Color)Color.black);
        GraphConstants.setBackground(map, (Color)Color.white);
        GraphConstants.setOpaque(map, (boolean)true);
        return map;
    }

    protected DefaultGraphCell createDefaultGraphCell() {
        DefaultGraphCell cell = new DefaultGraphCell((Object)("Cell " + new Integer(this.cellCount++)));
        cell.addPort();
        return cell;
    }

    public void connect(Port source, Port target) {
        DefaultEdge edge = this.createDefaultEdge();
        if (this.graph.getModel().acceptsSource((Object)edge, (Object)source) && this.graph.getModel().acceptsTarget((Object)edge, (Object)target)) {
            edge.getAttributes().applyMap(this.createEdgeAttributes());
            this.graph.getGraphLayoutCache().insertEdge((Object)edge, (Object)source, (Object)target);
        }
    }

    protected DefaultEdge createDefaultEdge() {
        return new DefaultEdge();
    }

    public Map createEdgeAttributes() {
        Hashtable map = new Hashtable();
        GraphConstants.setLineEnd(map, (int)4);
        GraphConstants.setLabelAlongEdge(map, (boolean)true);
        return map;
    }

    public void group(Object[] cells) {
        if ((cells = this.graph.order(cells)) != null && cells.length > 0) {
            DefaultGraphCell group = this.createGroupCell();
            this.graph.getGraphLayoutCache().insertGroup((Object)group, cells);
        }
    }

    protected DefaultGraphCell createGroupCell() {
        return new DefaultGraphCell();
    }

    protected int getCellCount(JGraph graph) {
        Object[] cells = graph.getDescendants(graph.getRoots());
        return cells.length;
    }

    public void ungroup(Object[] cells) {
        this.graph.getGraphLayoutCache().ungroup(cells);
    }

    public boolean isGroup(Object cell) {
        CellView view = this.graph.getGraphLayoutCache().getMapping(cell, false);
        if (view != null) {
            return !view.isLeaf();
        }
        return false;
    }

    public void toFront(Object[] c) {
        this.graph.getGraphLayoutCache().toFront(c);
    }

    public void toBack(Object[] c) {
        this.graph.getGraphLayoutCache().toBack(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        try {
            this.undoManager.undo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        try {
            this.undoManager.redo((Object)this.graph.getGraphLayoutCache());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            this.updateHistoryButtons();
        }
    }

    protected void updateHistoryButtons() {
        this.undo.setEnabled(this.undoManager.canUndo((Object)this.graph.getGraphLayoutCache()));
        this.redo.setEnabled(this.undoManager.canRedo((Object)this.graph.getGraphLayoutCache()));
    }

    public void valueChanged(GraphSelectionEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.remove.actionPerformed(null);
        }
    }

    public Block addSeriesBridgeBlock(Block block, JDInsertBlock.BlockParameters blockParameters) {
        RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
        if (GraphViewRBD.app.getRBDModel().getModel() instanceof BlockExponential) {
            BlockSeries newBlock = new BlockSeries("");
            newBlock.addBlock(block);
            BlockBridge newBlock1 = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            newBlock.addBlock(newBlock1);
            newBlock1.setFatherBlock(newBlock);
            rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
            rBDModel.incrementNumberOfBlocks();
            GraphViewRBD.app.getRBDModel().setModel(newBlock);
        } else if (block.getFatherBlock() instanceof BlockSeries) {
            BlockSeries blockFather = (BlockSeries)block.getFatherBlock();
            BlockBridge newBlock = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            blockFather.addBlock(newBlock);
            newBlock.setFatherBlock(blockFather);
            rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
            rBDModel.incrementNumberOfBlocks();
        } else {
            if (block.getFatherBlock() instanceof BlockParallel) {
                BlockParallel blockFather = (BlockParallel)block.getFatherBlock();
                int index = blockFather.getBlocks().indexOf(block);
                Block blockTemp = null;
                if (block instanceof BlockExponential) {
                    blockTemp = new BlockExponential("", null, null);
                } else if (block instanceof BlockKOutOfN) {
                    blockTemp = new BlockKOutOfN("", 0, 0, null, 0);
                }
                blockTemp.copy(block);
                BlockSeries newBlock = new BlockSeries("");
                newBlock.addBlock(blockTemp);
                BlockBridge newBlock1 = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                newBlock.addBlock(newBlock1);
                blockTemp.setFatherBlock(newBlock);
                newBlock1.setFatherBlock(newBlock);
                rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
                rBDModel.incrementNumberOfBlocks();
                newBlock.setFatherBlock(blockFather);
                blockFather.getBlocks().set(index, newBlock);
                return blockTemp;
            }
            if (block.getFatherBlock() instanceof BlockBridge) {
                if (block.getFatherBlock().getFatherBlock() != null && block.getFatherBlock().getFatherBlock() instanceof BlockSeries) {
                    BlockBridge newBlock = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                    ((BlockChain)block.getFatherBlock().getFatherBlock()).addBlock(newBlock);
                    newBlock.setFatherBlock(block.getFatherBlock().getFatherBlock());
                    rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
                    rBDModel.incrementNumberOfBlocks();
                } else if (block.getFatherBlock().getFatherBlock() != null && block.getFatherBlock().getFatherBlock() instanceof BlockParallel) {
                    BlockParallel fatherBlock = (BlockParallel)block.getFatherBlock().getFatherBlock();
                    BlockSeries newBlock = new BlockSeries("");
                    int index = fatherBlock.getBlocks().indexOf(block.getFatherBlock());
                    newBlock.addBlock(block.getFatherBlock());
                    BlockBridge newBlock1 = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                    newBlock.addBlock(newBlock1);
                    fatherBlock.getBlocks().set(index, newBlock);
                    newBlock.setFatherBlock(fatherBlock);
                    block.getFatherBlock().setFatherBlock(newBlock);
                    newBlock1.setFatherBlock(newBlock);
                    rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
                    rBDModel.incrementNumberOfBlocks();
                }
            }
        }
        return block;
    }

    public Block addSeriesExponentialBlock(Block block, JDInsertBlock.BlockParameters blockParameters) {
        RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
        if (GraphViewRBD.app.getRBDModel().getModel() instanceof BlockExponential) {
            BlockSeries newSeriesBlock = new BlockSeries("");
            newSeriesBlock.addBlock(block);
            BlockExponential newExponentialBlock = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            newSeriesBlock.addBlock(newExponentialBlock);
            newExponentialBlock.setFatherBlock(newSeriesBlock);
            rBDModel.incrementIndexOfBlocks();
            rBDModel.incrementNumberOfBlocks();
            GraphViewRBD.app.getRBDModel().setModel(newSeriesBlock);
        } else if (block.getFatherBlock() instanceof BlockSeries) {
            BlockSeries blockFather = (BlockSeries)block.getFatherBlock();
            BlockExponential newBlock = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            blockFather.addBlock(newBlock);
            newBlock.setFatherBlock(blockFather);
            rBDModel.incrementIndexOfBlocks();
            rBDModel.incrementNumberOfBlocks();
        } else {
            if (block.getFatherBlock() instanceof BlockParallel) {
                BlockParallel blockFather = (BlockParallel)block.getFatherBlock();
                int index = blockFather.getBlocks().indexOf(block);
                Block blockTemp = null;
                if (block instanceof BlockExponential) {
                    blockTemp = new BlockExponential("", null, null);
                } else if (block instanceof BlockKOutOfN) {
                    blockTemp = new BlockKOutOfN("", 0, 0, null, 0);
                }
                blockTemp.copy(block);
                BlockSeries newBlock = new BlockSeries("");
                newBlock.addBlock(blockTemp);
                BlockExponential newBlock1 = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                newBlock.addBlock(newBlock1);
                blockTemp.setFatherBlock(newBlock);
                newBlock1.setFatherBlock(newBlock);
                rBDModel.incrementIndexOfBlocks();
                rBDModel.incrementNumberOfBlocks();
                newBlock.setFatherBlock(blockFather);
                blockFather.getBlocks().set(index, newBlock);
                return blockTemp;
            }
            if (block.getFatherBlock() instanceof BlockBridge && block.getFatherBlock().getFatherBlock() != null) {
                if (block.getFatherBlock().getFatherBlock() instanceof BlockSeries) {
                    BlockExponential newBlock = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                    rBDModel.incrementIndexOfBlocks();
                    rBDModel.incrementNumberOfBlocks();
                    ((BlockChain)block.getFatherBlock().getFatherBlock()).addBlock(newBlock);
                    newBlock.setFatherBlock(block.getFatherBlock().getFatherBlock());
                } else if (block.getFatherBlock().getFatherBlock() instanceof BlockParallel) {
                    BlockParallel blockFather = (BlockParallel)block.getFatherBlock().getFatherBlock();
                    int index = blockFather.getBlocks().indexOf(block.getFatherBlock());
                    BlockSeries newBlock = new BlockSeries("");
                    newBlock.addBlock(block.getFatherBlock());
                    BlockExponential newBlock1 = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                    newBlock.addBlock(newBlock1);
                    rBDModel.incrementIndexOfBlocks();
                    rBDModel.incrementNumberOfBlocks();
                    block.getFatherBlock().setFatherBlock(newBlock);
                    newBlock1.setFatherBlock(newBlock);
                    blockFather.getBlocks().set(index, newBlock);
                    newBlock.setFatherBlock(blockFather);
                }
            }
        }
        return block;
    }

    public void AddSeriesKOUTN(Object cell) {
        Block block = (Block)((DefaultGraphCell)cell).getUserObject();
        JDInsertBlockKN screen = new JDInsertBlockKN((Frame)GraphViewRBD.jFrameDesdacTool, false, block, true);
        screen.setLocationRelativeTo(GraphViewRBD.jFrameDesdacTool);
        screen.setVisible(true);
    }

    public Block addParallelBidgeBlock(Block block, JDInsertBlock.BlockParameters blockParameters) {
        RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
        if (GraphViewRBD.app.getRBDModel().getModel() instanceof BlockExponential) {
            BlockParallel newBlock = new BlockParallel("");
            newBlock.addBlock(block);
            BlockBridge newBlock1 = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            newBlock.addBlock(newBlock1);
            newBlock1.setFatherBlock(newBlock);
            rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
            rBDModel.incrementNumberOfBlocks();
            GraphViewRBD.app.getRBDModel().setModel(newBlock);
        } else if (block.getFatherBlock() instanceof BlockParallel) {
            BlockParallel blockFather = (BlockParallel)block.getFatherBlock();
            BlockBridge newBlock = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            blockFather.addBlock(newBlock);
            newBlock.setFatherBlock(blockFather);
            rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
            rBDModel.incrementNumberOfBlocks();
        } else {
            if (block.getFatherBlock() instanceof BlockSeries) {
                BlockSeries blockFather = (BlockSeries)block.getFatherBlock();
                int index = blockFather.getBlocks().indexOf(block);
                Block blockTemp = null;
                if (block instanceof BlockExponential) {
                    blockTemp = new BlockExponential("", null, null);
                } else if (block instanceof BlockKOutOfN) {
                    blockTemp = new BlockKOutOfN("", 0, 0, null, 0);
                }
                blockTemp.copy(block);
                BlockParallel newBlock = new BlockParallel("");
                newBlock.addBlock(blockTemp);
                BlockBridge newBlock1 = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                newBlock.addBlock(newBlock1);
                rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
                rBDModel.incrementNumberOfBlocks();
                blockTemp.setFatherBlock(newBlock);
                newBlock1.setFatherBlock(newBlock);
                blockFather.getBlocks().set(index, newBlock);
                newBlock.setFatherBlock(blockFather);
                return blockTemp;
            }
            if (block.getFatherBlock() instanceof BlockBridge) {
                if (block.getFatherBlock().getFatherBlock() != null && block.getFatherBlock().getFatherBlock() instanceof BlockParallel) {
                    BlockBridge newBlock = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                    ((BlockChain)block.getFatherBlock().getFatherBlock()).addBlock(newBlock);
                    newBlock.setFatherBlock(block.getFatherBlock().getFatherBlock());
                    rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
                    rBDModel.incrementNumberOfBlocks();
                } else if (block.getFatherBlock().getFatherBlock() != null && block.getFatherBlock().getFatherBlock() instanceof BlockSeries) {
                    BlockSeries fatherBlock = (BlockSeries)block.getFatherBlock().getFatherBlock();
                    BlockParallel newBlock = new BlockParallel("");
                    int index = fatherBlock.getBlocks().indexOf(block.getFatherBlock());
                    newBlock.addBlock(block.getFatherBlock());
                    BlockBridge newBlock1 = new BlockBridge("", rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                    newBlock.addBlock(newBlock1);
                    fatherBlock.getBlocks().set(index, newBlock);
                    newBlock.setFatherBlock(fatherBlock);
                    block.getFatherBlock().setFatherBlock(newBlock);
                    newBlock1.setFatherBlock(newBlock);
                    rBDModel.setIndexOfBlocks(rBDModel.getIndexOfBlocks() + 5);
                    rBDModel.incrementNumberOfBlocks();
                }
            }
        }
        return block;
    }

    public Block addParallelExponentialBlock(Block block, JDInsertBlock.BlockParameters blockParameters) {
        RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
        if (GraphViewRBD.app.getRBDModel().getModel() instanceof BlockExponential) {
            BlockParallel newBlock = new BlockParallel("");
            newBlock.addBlock(block);
            BlockExponential newBlock1 = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            newBlock.addBlock(newBlock1);
            newBlock1.setFatherBlock(newBlock);
            rBDModel.incrementIndexOfBlocks();
            rBDModel.incrementNumberOfBlocks();
            GraphViewRBD.app.getRBDModel().setModel(newBlock);
        } else if (block.getFatherBlock() instanceof BlockParallel) {
            BlockParallel blockFather = (BlockParallel)block.getFatherBlock();
            BlockExponential newBlock = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
            blockFather.addBlock(newBlock);
            newBlock.setFatherBlock(blockFather);
            rBDModel.incrementIndexOfBlocks();
            rBDModel.incrementNumberOfBlocks();
        } else {
            if (block.getFatherBlock() instanceof BlockSeries) {
                BlockSeries blockFather = (BlockSeries)block.getFatherBlock();
                int index = blockFather.getBlocks().indexOf(block);
                Block blockTemp = null;
                if (block instanceof BlockExponential) {
                    blockTemp = new BlockExponential("", null, null);
                } else if (block instanceof BlockKOutOfN) {
                    blockTemp = new BlockKOutOfN("", 0, 0, null, 0);
                }
                blockTemp.copy(block);
                BlockParallel newBlock = new BlockParallel("");
                newBlock.addBlock(blockTemp);
                BlockExponential newBlock1 = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                newBlock.addBlock(newBlock1);
                rBDModel.incrementIndexOfBlocks();
                rBDModel.incrementNumberOfBlocks();
                blockTemp.setFatherBlock(newBlock);
                newBlock1.setFatherBlock(newBlock);
                blockFather.getBlocks().set(index, newBlock);
                newBlock.setFatherBlock(blockFather);
                return blockTemp;
            }
            if (block.getFatherBlock() instanceof BlockBridge) {
                System.out.println("Oa");
                if (block.getFatherBlock().getFatherBlock() != null) {
                    if (block.getFatherBlock().getFatherBlock() instanceof BlockParallel) {
                        BlockExponential newBlock = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                        rBDModel.incrementIndexOfBlocks();
                        rBDModel.incrementNumberOfBlocks();
                        ((BlockChain)block.getFatherBlock().getFatherBlock()).addBlock(newBlock);
                        newBlock.setFatherBlock(block.getFatherBlock().getFatherBlock());
                    } else if (block.getFatherBlock().getFatherBlock() instanceof BlockSeries) {
                        BlockSeries blockFather = (BlockSeries)block.getFatherBlock().getFatherBlock();
                        int index = blockFather.getBlocks().indexOf(block.getFatherBlock());
                        BlockParallel newBlock = new BlockParallel("");
                        newBlock.addBlock(block.getFatherBlock());
                        BlockExponential newBlock1 = new BlockExponential("b" + rBDModel.getIndexOfBlocks(), blockParameters.getFailureRate(), blockParameters.getRepairRate(), blockParameters.getFailureLabel(), blockParameters.getRepairLabel());
                        newBlock.addBlock(newBlock1);
                        rBDModel.incrementIndexOfBlocks();
                        rBDModel.incrementNumberOfBlocks();
                        block.getFatherBlock().setFatherBlock(newBlock);
                        newBlock1.setFatherBlock(newBlock);
                        blockFather.getBlocks().set(index, newBlock);
                        newBlock.setFatherBlock(blockFather);
                    }
                }
            }
        }
        return block;
    }

    public void addParallelKOUTN(Object cell) {
        Block block = (Block)((DefaultGraphCell)cell).getUserObject();
        JDInsertBlockKN screen = new JDInsertBlockKN((Frame)GraphViewRBD.jFrameDesdacTool, false, block, false);
        screen.setLocationRelativeTo(GraphViewRBD.jFrameDesdacTool);
        screen.setVisible(true);
    }

    public JDInsertBlock.BlockParameters showDialogBlockParameters() {
        JDInsertBlock jDialogEditBlocksRBD = new JDInsertBlock(null, true);
        JDInsertBlock.BlockParameters blockParameters = jDialogEditBlocksRBD.getBlockParameters();
        jDialogEditBlocksRBD.setLocationRelativeTo(null);
        jDialogEditBlocksRBD.setVisible(true);
        return blockParameters;
    }

    public static void insertLabel() {
        RBDLabel rBDLabel = new RBDLabel();
        JDialogLabelProperties jDialogLabelProperties = new JDialogLabelProperties(null, true, rBDLabel);
        jDialogLabelProperties.setVisible(true);
        LabelSet labelSet = GraphViewRBD.app.getLabelSet();
        if (!labelSet.getLabels().contains(rBDLabel) && rBDLabel.getValue() != 0.0 && rBDLabel.getName() != null && !rBDLabel.getName().equals("")) {
            labelSet.getLabels().add(rBDLabel);
            GraphViewRBD.paint();
        } else if (rBDLabel.getValue() == 0.0) {
            JOptionPane.showMessageDialog(null, "Rate 0! Not Created");
        } else {
            JOptionPane.showMessageDialog(null, "Label Already Exist");
        }
    }

    public JPopupMenu createPopupMenu(final Object cell) {
        if (cell != null) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new AbstractAction("Insert label"){

                public void actionPerformed(ActionEvent ex) {
                    GraphEdRBD.insertLabel();
                }
            });
            menu.addSeparator();
            JMenu jMenuInsert = new JMenu("Insert block");
            JMenu jMenuSeries = new JMenu("Series");
            JMenu jMenuParallel = new JMenu("Parallel");
            jMenuInsert.add(jMenuSeries);
            jMenuInsert.add(jMenuParallel);
            jMenuSeries.add(new AbstractAction("Exponential Block"){

                public void actionPerformed(ActionEvent ex) {
                    JDInsertBlock.BlockParameters blockParameters = GraphEdRBD.this.showDialogBlockParameters();
                    if (blockParameters.getIsEdited()) {
                        Block block = (Block)((DefaultGraphCell)cell).getUserObject();
                        for (int i = 0; i < blockParameters.getNumberBlocks(); ++i) {
                            block = GraphEdRBD.this.addSeriesExponentialBlock(block, blockParameters);
                        }
                    }
                    GraphViewRBD.paint();
                }
            });
            jMenuSeries.add(new AbstractAction("Bridge Block"){

                public void actionPerformed(ActionEvent e) {
                    JDInsertBlock.BlockParameters blockParameters = GraphEdRBD.this.showDialogBlockParameters();
                    if (blockParameters.getIsEdited()) {
                        Block block = (Block)((DefaultGraphCell)cell).getUserObject();
                        for (int i = 0; i < blockParameters.getNumberBlocks(); ++i) {
                            block = GraphEdRBD.this.addSeriesBridgeBlock(block, blockParameters);
                        }
                    }
                    GraphViewRBD.paint();
                }
            });
            jMenuSeries.add(new AbstractAction("k-out-of-n Block"){

                public void actionPerformed(ActionEvent e) {
                    GraphEdRBD.this.AddSeriesKOUTN(cell);
                }
            });
            jMenuParallel.add(new AbstractAction("Exponential Block"){

                public void actionPerformed(ActionEvent e) {
                    JDInsertBlock.BlockParameters blockParameters = GraphEdRBD.this.showDialogBlockParameters();
                    if (blockParameters.getIsEdited()) {
                        Block block = (Block)((DefaultGraphCell)cell).getUserObject();
                        for (int i = 0; i < blockParameters.getNumberBlocks(); ++i) {
                            block = GraphEdRBD.this.addParallelExponentialBlock(block, blockParameters);
                        }
                    }
                    GraphViewRBD.paint();
                }
            });
            jMenuParallel.add(new AbstractAction("Bridge Block"){

                public void actionPerformed(ActionEvent e) {
                    JDInsertBlock.BlockParameters blockParameters = GraphEdRBD.this.showDialogBlockParameters();
                    if (blockParameters.getIsEdited()) {
                        Block block = (Block)((DefaultGraphCell)cell).getUserObject();
                        for (int i = 0; i < blockParameters.getNumberBlocks(); ++i) {
                            block = GraphEdRBD.this.addParallelBidgeBlock(block, blockParameters);
                        }
                    }
                    GraphViewRBD.paint();
                }
            });
            jMenuParallel.add(new AbstractAction("k-out-of-n Block"){

                public void actionPerformed(ActionEvent e) {
                    GraphEdRBD.this.addParallelKOUTN(cell);
                }
            });
            menu.add(jMenuInsert);
            menu.addSeparator();
            menu.add(new AbstractAction("Remove"){

                public void actionPerformed(ActionEvent e) {
                    RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
                    Block block = (Block)((DefaultGraphCell)cell).getUserObject();
                    Block fatherBlock = block.getFatherBlock();
                    if (fatherBlock.getFatherBlock() != null && fatherBlock instanceof BlockBridge) {
                        ((BlockChain)fatherBlock.getFatherBlock()).getBlocks().remove(fatherBlock);
                        fatherBlock = fatherBlock.getFatherBlock();
                    }
                    if (rBDModel.getNumberOfBlocks() == 1) {
                        JOptionPane.showMessageDialog(GraphEdRBD.this.rootPane, "Can not remove this block", "WARNING", 2);
                        return;
                    }
                    if (fatherBlock instanceof BlockChain) {
                        ((BlockChain)fatherBlock).getBlocks().remove(block);
                        if (((BlockChain)fatherBlock).getBlocks().size() == 0 && (BlockChain)fatherBlock.getFatherBlock() instanceof BlockChain) {
                            ((BlockChain)((BlockChain)fatherBlock).getFatherBlock()).getBlocks().remove(fatherBlock);
                            fatherBlock = (BlockChain)fatherBlock.getFatherBlock();
                        }
                        if ((fatherBlock instanceof BlockParallel || fatherBlock instanceof BlockSeries) && fatherBlock != null && ((BlockChain)fatherBlock).getBlocks().size() == 1 && fatherBlock.getFatherBlock() != null) {
                            Block newBlock = ((BlockChain)fatherBlock).getBlocks().get(0);
                            ((BlockChain)fatherBlock.getFatherBlock()).getBlocks().remove(fatherBlock);
                            ((BlockChain)fatherBlock.getFatherBlock()).addBlock(newBlock);
                            newBlock.setFatherBlock(fatherBlock.getFatherBlock());
                        }
                        GraphViewRBD.paint();
                        rBDModel.decrementNumberOfBlocks();
                    } else {
                        JOptionPane.showMessageDialog(GraphEdRBD.this.rootPane, "Can not remove this block", "WARNING", 2);
                    }
                }
            });
            menu.addSeparator();
            menu.add(new AbstractAction("Apply Reduction"){

                public void actionPerformed(ActionEvent e) {
                    Block block = (Block)((DefaultGraphCell)cell).getUserObject();
                    GraphEdRBD.this.applyReduction(block.getFatherBlock());
                }
            });
            menu.addSeparator();
            menu.add(new AbstractAction("Properties"){

                public void actionPerformed(ActionEvent e) {
                    Block block = (Block)((DefaultGraphCell)cell).getUserObject();
                    JDEditBlocks editScreen = new JDEditBlocks((Frame)GraphViewRBD.jFrameDesdacTool, true, block);
                    editScreen.setLocationRelativeTo(GraphViewRBD.jFrameDesdacTool);
                    editScreen.setVisible(true);
                }
            });
            return menu;
        }
        return null;
    }

    public JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        URL insertUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/insert.gif");
        ImageIcon insertIcon = new ImageIcon(insertUrl);
        toolbar.add(new AbstractAction("", insertIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.insert(new Point(10, 10));
            }
        });
        URL connectUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connecton.gif");
        ImageIcon connectIcon = new ImageIcon(connectUrl);
        toolbar.add(new AbstractAction("", connectIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.graph.setPortsVisible(!GraphEdRBD.this.graph.isPortsVisible());
                URL connectUrl = GraphEdRBD.this.graph.isPortsVisible() ? this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connecton.gif") : this.getClass().getClassLoader().getResource("org/jgraph/example/resources/connectoff.gif");
                ImageIcon connectIcon = new ImageIcon(connectUrl);
                this.putValue("SmallIcon", connectIcon);
            }
        });
        toolbar.addSeparator();
        URL undoUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/undo.gif");
        ImageIcon undoIcon = new ImageIcon(undoUrl);
        this.undo = new AbstractAction("", undoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.undo();
            }
        };
        this.undo.setEnabled(false);
        toolbar.add(this.undo);
        URL redoUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/redo.gif");
        ImageIcon redoIcon = new ImageIcon(redoUrl);
        this.redo = new AbstractAction("", redoIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.redo();
            }
        };
        this.redo.setEnabled(false);
        toolbar.add(this.redo);
        toolbar.addSeparator();
        Action action = TransferHandler.getCopyAction();
        URL url = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/copy.gif");
        this.copy = new EventRedirector(action, new ImageIcon(url));
        toolbar.add(this.copy);
        action = TransferHandler.getPasteAction();
        url = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/paste.gif");
        this.paste = new EventRedirector(action, new ImageIcon(url));
        toolbar.add(this.paste);
        action = TransferHandler.getCutAction();
        url = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/cut.gif");
        this.cut = new EventRedirector(action, new ImageIcon(url));
        toolbar.add(this.cut);
        URL removeUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/delete.gif");
        ImageIcon removeIcon = new ImageIcon(removeUrl);
        this.remove = new AbstractAction("", removeIcon){

            public void actionPerformed(ActionEvent e) {
                if (!GraphEdRBD.this.graph.isSelectionEmpty()) {
                    Object[] cells = GraphEdRBD.this.graph.getSelectionCells();
                    cells = GraphEdRBD.this.graph.getDescendants(cells);
                    GraphEdRBD.this.graph.getModel().remove(cells);
                }
            }
        };
        this.remove.setEnabled(false);
        toolbar.add(this.remove);
        toolbar.addSeparator();
        URL toFrontUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/tofront.gif");
        ImageIcon toFrontIcon = new ImageIcon(toFrontUrl);
        this.tofront = new AbstractAction("", toFrontIcon){

            public void actionPerformed(ActionEvent e) {
                if (!GraphEdRBD.this.graph.isSelectionEmpty()) {
                    GraphEdRBD.this.toFront(GraphEdRBD.this.graph.getSelectionCells());
                }
            }
        };
        this.tofront.setEnabled(false);
        toolbar.add(this.tofront);
        URL toBackUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/toback.gif");
        ImageIcon toBackIcon = new ImageIcon(toBackUrl);
        this.toback = new AbstractAction("", toBackIcon){

            public void actionPerformed(ActionEvent e) {
                if (!GraphEdRBD.this.graph.isSelectionEmpty()) {
                    GraphEdRBD.this.toBack(GraphEdRBD.this.graph.getSelectionCells());
                }
            }
        };
        this.toback.setEnabled(false);
        toolbar.add(this.toback);
        toolbar.addSeparator();
        URL zoomUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoom.gif");
        ImageIcon zoomIcon = new ImageIcon(zoomUrl);
        toolbar.add(new AbstractAction("", zoomIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.graph.setScale(1.0);
            }
        });
        URL zoomInUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoomin.gif");
        ImageIcon zoomInIcon = new ImageIcon(zoomInUrl);
        toolbar.add(new AbstractAction("", zoomInIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.graph.setScale(2.0 * GraphEdRBD.this.graph.getScale());
            }
        });
        URL zoomOutUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/zoomout.gif");
        ImageIcon zoomOutIcon = new ImageIcon(zoomOutUrl);
        toolbar.add(new AbstractAction("", zoomOutIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.graph.setScale(GraphEdRBD.this.graph.getScale() / 2.0);
            }
        });
        toolbar.addSeparator();
        URL groupUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/group.gif");
        ImageIcon groupIcon = new ImageIcon(groupUrl);
        this.group = new AbstractAction("", groupIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.group(GraphEdRBD.this.graph.getSelectionCells());
            }
        };
        this.group.setEnabled(false);
        toolbar.add(this.group);
        URL ungroupUrl = this.getClass().getClassLoader().getResource("org/jgraph/example/resources/ungroup.gif");
        ImageIcon ungroupIcon = new ImageIcon(ungroupUrl);
        this.ungroup = new AbstractAction("", ungroupIcon){

            public void actionPerformed(ActionEvent e) {
                GraphEdRBD.this.ungroup(GraphEdRBD.this.graph.getSelectionCells());
            }
        };
        this.ungroup.setEnabled(false);
        toolbar.add(this.ungroup);
        return toolbar;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public void setGraph(JGraph graph) {
        this.graph = graph;
    }

    protected StatusBarGraphListener createStatusBar() {
        return new EdStatusBar();
    }

    protected String getVersion() {
        return "JGraph (v5.12.2.1)";
    }

    public Action getRedo() {
        return this.redo;
    }

    public void setRedo(Action redo) {
        this.redo = redo;
    }

    public Action getUndo() {
        return this.undo;
    }

    public void setUndo(Action undo) {
        this.undo = undo;
    }

    public Action getCopy() {
        return this.copy;
    }

    public void setCopy(Action copy) {
        this.copy = copy;
    }

    public Action getCut() {
        return this.cut;
    }

    public void setCut(Action cut) {
        this.cut = cut;
    }

    public Action getPaste() {
        return this.paste;
    }

    public void setPaste(Action paste) {
        this.paste = paste;
    }

    public Action getToback() {
        return this.toback;
    }

    public void setToback(Action toback) {
        this.toback = toback;
    }

    public Action getTofront() {
        return this.tofront;
    }

    public void setTofront(Action tofront) {
        this.tofront = tofront;
    }

    public Action getRemove() {
        return this.remove;
    }

    public void setRemove(Action remove) {
        this.remove = remove;
    }

    private void applyReduction(Block fatherBlock) {
        RBDModel rBDModel = GraphViewRBD.app.getRBDModel();
        BlockExponential newBlock = new BlockExponential("subModel" + rBDModel.getIndexOfBlocks(), 64.0, 64.0, null, null);
        if (fatherBlock instanceof BlockBridge) {
            boolean deltastar = false;
            if (deltastar) {
                BlockBridge bridge = (BlockBridge)fatherBlock;
                double time = 100.0;
                double alfaReliability = bridge.getBlocks().get(0).calculateReliability(time) + (1.0 - bridge.getBlocks().get(0).calculateReliability(time)) * bridge.getBlocks().get(2).calculateReliability(time) * bridge.getBlocks().get(4).calculateReliability(time);
                double betaReliability = bridge.getBlocks().get(2).calculateReliability(time) + (1.0 - bridge.getBlocks().get(2).calculateReliability(time)) * bridge.getBlocks().get(0).calculateReliability(time) * bridge.getBlocks().get(4).calculateReliability(time);
                double gammaReliability = bridge.getBlocks().get(0).calculateReliability(time) * bridge.getBlocks().get(2).calculateReliability(time) + (1.0 - bridge.getBlocks().get(0).calculateReliability(time)) * bridge.getBlocks().get(2).calculateReliability(time) * bridge.getBlocks().get(4).calculateReliability(time) + (1.0 - bridge.getBlocks().get(2).calculateReliability(time)) * bridge.getBlocks().get(0).calculateReliability(time) * bridge.getBlocks().get(4).calculateReliability(time);
                double rI = alfaReliability * betaReliability / gammaReliability;
                double rII = gammaReliability / betaReliability;
                double rIII = gammaReliability / alfaReliability;
                double alfaAvailability = ((BlockExponential)bridge.getBlocks().get(0)).calculateAvailability() + (1.0 - ((BlockExponential)bridge.getBlocks().get(0)).calculateAvailability()) * ((BlockExponential)bridge.getBlocks().get(2)).calculateAvailability() * ((BlockExponential)bridge.getBlocks().get(4)).calculateAvailability();
                double betaAvailability = ((BlockExponential)bridge.getBlocks().get(2)).calculateAvailability() + (1.0 - ((BlockExponential)bridge.getBlocks().get(2)).calculateAvailability()) * ((BlockExponential)bridge.getBlocks().get(0)).calculateAvailability() * ((BlockExponential)bridge.getBlocks().get(4)).calculateAvailability();
                double gammaAvailability = ((BlockExponential)bridge.getBlocks().get(0)).calculateAvailability() * ((BlockExponential)bridge.getBlocks().get(2)).calculateAvailability() + (1.0 - ((BlockExponential)bridge.getBlocks().get(0)).calculateAvailability()) * ((BlockExponential)bridge.getBlocks().get(2)).calculateAvailability() * ((BlockExponential)bridge.getBlocks().get(4)).calculateAvailability() + (1.0 - ((BlockExponential)bridge.getBlocks().get(2)).calculateAvailability()) * ((BlockExponential)bridge.getBlocks().get(0)).calculateAvailability() * ((BlockExponential)bridge.getBlocks().get(4)).calculateAvailability();
                double aI = alfaAvailability * betaAvailability / gammaAvailability;
                double aII = gammaAvailability / betaAvailability;
                double aIII = gammaAvailability / alfaAvailability;
                double fRate = -Math.log(rI) / time;
                double rRate = aI * fRate / (1.0 - aI);
                BlockExponential bI = new BlockExponential("bI", fRate, rRate, null, null);
                fRate = -Math.log(rII) / time;
                rRate = aII * fRate / (1.0 - aII);
                BlockExponential bII = new BlockExponential("bII", fRate, rRate, null, null);
                fRate = -Math.log(rIII) / time;
                rRate = aIII * fRate / (1.0 - aIII);
                BlockExponential bIII = new BlockExponential("bIII", fRate, rRate, null, null);
                BlockSeries bs1 = new BlockSeries(null);
                bs1.addBlock(bII);
                bII.setFatherBlock(bs1);
                bs1.addBlock(bridge.getBlocks().get(1));
                bridge.getBlocks().get(1).setFatherBlock(bs1);
                BlockSeries bs2 = new BlockSeries(null);
                bs2.addBlock(bIII);
                bIII.setFatherBlock(bs2);
                bs2.addBlock(bridge.getBlocks().get(3));
                bridge.getBlocks().get(3).setFatherBlock(bs2);
                BlockParallel bp1 = new BlockParallel(null);
                bp1.addBlock(bs1);
                bp1.addBlock(bs2);
                bs1.setFatherBlock(bp1);
                bs2.setFatherBlock(bp1);
                BlockSeries bs3 = new BlockSeries(null);
                bs3.addBlock(bI);
                bI.setFatherBlock(bs3);
                bs3.addBlock(bp1);
                bp1.setFatherBlock(bs3);
                bs3.setFatherBlock(fatherBlock.getFatherBlock());
                ((BlockChain)fatherBlock.getFatherBlock()).getBlocks().remove(fatherBlock);
                ((BlockChain)fatherBlock.getFatherBlock()).addBlock(bs3);
            } else {
                for (int i = 0; i < 4; ++i) {
                    rBDModel.decrementNumberOfBlocks();
                }
                newBlock.setName("subModelBridge" + rBDModel.getIndexOfBlocks());
                rBDModel.incrementIndexOfBlocks();
                rBDModel.incrementNumberOfBlocks();
                newBlock.setFailureRate(1.0 / fatherBlock.calculateMeanTimeToFailure());
                newBlock.setRepairRate(1.0 / fatherBlock.calculateMeanTimeToRepair());
                newBlock.setFatherBlock(fatherBlock.getFatherBlock());
                ((BlockChain)fatherBlock.getFatherBlock()).getBlocks().remove(fatherBlock);
                ((BlockChain)fatherBlock.getFatherBlock()).addBlock(newBlock);
            }
            GraphViewRBD.paint();
        } else if (this.hasOneMoreExponencial(fatherBlock)) {
            BlockChain newFather = new BlockSeries("");
            newBlock.setName("subModelSeries" + rBDModel.getIndexOfBlocks());
            if (fatherBlock instanceof BlockParallel) {
                newFather = new BlockParallel("");
                newBlock.setName("subModelParallel" + rBDModel.getIndexOfBlocks());
            }
            for (int i = 0; i < ((BlockChain)fatherBlock).getBlocks().size(); ++i) {
                if (!(((BlockChain)fatherBlock).getBlocks().get(i) instanceof BlockExponential) && !(((BlockChain)fatherBlock).getBlocks().get(i) instanceof BlockKOutOfN)) continue;
                newFather.addBlock(((BlockChain)fatherBlock).getBlocks().get(i));
                ((BlockChain)fatherBlock).getBlocks().remove(((BlockChain)fatherBlock).getBlocks().get(i));
                rBDModel.decrementNumberOfBlocks();
                --i;
            }
            rBDModel.incrementIndexOfBlocks();
            rBDModel.incrementNumberOfBlocks();
            newBlock.setFailureRate(1.0 / newFather.calculateMeanTimeToFailure());
            newBlock.setRepairRate(1.0 / newFather.calculateMeanTimeToRepair());
            if (((BlockChain)fatherBlock).getBlocks().size() == 0) {
                if (fatherBlock.getFatherBlock() != null) {
                    newBlock.setFatherBlock(fatherBlock.getFatherBlock());
                    ((BlockChain)fatherBlock.getFatherBlock()).addBlock(newBlock);
                    ((BlockChain)fatherBlock.getFatherBlock()).getBlocks().remove(fatherBlock);
                    rBDModel.incrementNumberOfBlocks();
                } else {
                    rBDModel.setModel(newBlock);
                }
            } else {
                ((BlockChain)fatherBlock).getBlocks().add(newBlock);
                newBlock.setFatherBlock(fatherBlock);
            }
            GraphViewRBD.paint();
        } else {
            JOptionPane.showMessageDialog(null, "Reduction can't applyed on this level!", "Error", 0);
        }
    }

    private boolean hasOneMoreExponencial(Block fatherBlock) {
        if (fatherBlock == null) {
            return false;
        }
        int i = 0;
        for (Block b : ((BlockChain)fatherBlock).getBlocks()) {
            if (b instanceof BlockExponential) {
                ++i;
            }
            if (i <= 1) continue;
            return true;
        }
        return false;
    }

    private static class AbstractActionImpl
    extends AbstractAction {
        public AbstractActionImpl(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class EdStatusBar
    extends StatusBarGraphListener {
        protected JLabel leftSideStatus;
        protected JLabel rightSideStatus;

        public EdStatusBar() {
            this.setLayout(new BorderLayout());
            this.leftSideStatus = new JLabel(GraphEdRBD.this.getVersion());
            this.rightSideStatus = new JLabel("0/0Mb");
            this.leftSideStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            this.rightSideStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            this.add((Component)this.leftSideStatus, "Center");
            this.add((Component)this.rightSideStatus, "East");
        }

        protected void updateStatusBar() {
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1024L);
            int totalMemory = (int)(runtime.totalMemory() / 1024L);
            int usedMemory = totalMemory - freeMemory;
            String str = usedMemory / 1024 + "/" + totalMemory / 1024 + "Mb";
            this.rightSideStatus.setText(str);
        }

        public JLabel getLeftSideStatus() {
            return this.leftSideStatus;
        }

        public void setLeftSideStatus(JLabel leftSideStatus) {
            this.leftSideStatus = leftSideStatus;
        }

        public JLabel getRightSideStatus() {
            return this.rightSideStatus;
        }

        public void setRightSideStatus(JLabel rightSideStatus) {
            this.rightSideStatus = rightSideStatus;
        }
    }

    public class StatusBarGraphListener
    extends JPanel
    implements GraphModelListener {
        public void graphChanged(GraphModelEvent e) {
            this.updateStatusBar();
        }

        protected void updateStatusBar() {
        }
    }

    public class EventRedirector
    extends AbstractAction {
        protected Action action;

        public EventRedirector(Action a, ImageIcon icon) {
            super("", icon);
            this.action = a;
        }

        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(GraphEdRBD.this.graph, e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }

    public class MyMarqueeHandler
    extends BasicMarqueeHandler {
        protected Point2D start;
        protected Point2D current;
        protected PortView port;
        protected PortView firstPort;

        public boolean isForceMarqueeEvent(MouseEvent e) {
            if (e.isShiftDown()) {
                return false;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return true;
            }
            this.port = this.getSourcePortAt(e.getPoint());
            if (this.port != null && GraphEdRBD.this.graph.isPortsVisible()) {
                return true;
            }
            return super.isForceMarqueeEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            Object cell = GraphEdRBD.this.graph.getFirstCellForLocation((double)e.getX(), (double)e.getY());
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                if (cell != null) {
                    this.showBlockEditScreen(cell);
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                JPopupMenu menu = GraphEdRBD.this.createPopupMenu(cell);
                if (menu != null) {
                    menu.show((Component)GraphEdRBD.this.graph, e.getX(), e.getY());
                }
            } else {
                super.mousePressed(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null) {
                Graphics g = GraphEdRBD.this.graph.getGraphics();
                PortView newPort = this.getTargetPortAt(e.getPoint());
                if (newPort == null || newPort != this.port) {
                    this.paintConnector(Color.black, GraphEdRBD.this.graph.getBackground(), g);
                    this.port = newPort;
                    this.current = this.port != null ? GraphEdRBD.this.graph.toScreen(this.port.getLocation()) : GraphEdRBD.this.graph.snap((Point2D)e.getPoint());
                    this.paintConnector(GraphEdRBD.this.graph.getBackground(), Color.black, g);
                }
            }
            super.mouseDragged(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PortView getSourcePortAt(Point2D point) {
            PortView result;
            GraphEdRBD.this.graph.setJumpToDefaultPort(false);
            try {
                result = GraphEdRBD.this.graph.getPortViewAt(point.getX(), point.getY());
            }
            finally {
                GraphEdRBD.this.graph.setJumpToDefaultPort(true);
            }
            return result;
        }

        protected PortView getTargetPortAt(Point2D point) {
            return GraphEdRBD.this.graph.getPortViewAt(point.getX(), point.getY());
        }

        public void mouseReleased(MouseEvent e) {
            if (e != null && this.port != null && this.firstPort != null && this.firstPort != this.port) {
                GraphEdRBD.this.connect((Port)this.firstPort.getCell(), (Port)this.port.getCell());
                e.consume();
            } else {
                GraphEdRBD.this.graph.repaint();
            }
            this.port = null;
            this.firstPort = null;
            this.current = null;
            this.start = null;
            super.mouseReleased(e);
        }

        public void mouseMoved(MouseEvent e) {
            if (e != null && this.getSourcePortAt(e.getPoint()) != null && GraphEdRBD.this.graph.isPortsVisible()) {
                GraphEdRBD.this.graph.setCursor(new Cursor(12));
                e.consume();
            } else {
                super.mouseMoved(e);
            }
        }

        protected void paintConnector(Color fg, Color bg, Graphics g) {
            g.setColor(fg);
            g.setXORMode(bg);
            this.paintPort(GraphEdRBD.this.graph.getGraphics());
            if (this.firstPort != null && this.start != null && this.current != null) {
                g.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.current.getX(), (int)this.current.getY());
            }
        }

        protected void paintPort(Graphics g) {
            if (this.port != null) {
                boolean o = GraphConstants.getOffset((Map)this.port.getAllAttributes()) != null;
                Rectangle2D r = o ? this.port.getBounds() : this.port.getParentView().getBounds();
                r = GraphEdRBD.this.graph.toScreen((Rectangle2D)r.clone());
                r.setFrame(r.getX() - 3.0, r.getY() - 3.0, r.getWidth() + 6.0, r.getHeight() + 6.0);
                GraphEdRBD.this.graph.getUI().paintCell(g, (CellView)this.port, r, true);
            }
        }

        protected void showBlockEditScreen(Object cell) {
            Block block = (Block)((DefaultGraphCell)cell).getUserObject();
            JDEditBlocks editScreen = new JDEditBlocks((Frame)GraphViewRBD.jFrameDesdacTool, true, block);
            editScreen.setLocationRelativeTo(GraphViewRBD.jFrameDesdacTool);
            editScreen.setVisible(true);
        }
    }

    public static class MyModel
    extends DefaultGraphModel {
        public boolean acceptsSource(Object edge, Object port) {
            return ((Edge)edge).getTarget() != port;
        }

        public boolean acceptsTarget(Object edge, Object port) {
            return ((Edge)edge).getSource() != port;
        }
    }

    public static class MyEdgeHandle
    extends EdgeView.EdgeHandle {
        public MyEdgeHandle(EdgeView edge, GraphContext ctx) {
            super(edge, ctx);
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return event.isShiftDown();
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return event.isShiftDown();
        }
    }

    public static class MyGraph
    extends JGraph {
        public MyGraph(GraphModel model) {
            this(model, null);
        }

        public MyGraph(GraphModel model, GraphLayoutCache cache) {
            super(model, cache);
            this.setPortsVisible(true);
            this.setGridEnabled(true);
            this.setGridSize(6.0);
            this.setTolerance(2);
            this.setInvokesStopCellEditing(true);
            this.setCloneable(true);
            this.setJumpToDefaultPort(true);
        }
    }
}

