/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.evaluatorrbd;

import java.util.ArrayList;
import org.modcs.tools.rbd.evaluatorrbd.EvaluationType;
import org.modcs.tools.rbd.evaluatorrbd.ExperimentParametersRBD;
import org.modcs.tools.rbd.evaluatorrbd.ExperimentResultRBD;
import org.modcs.tools.rbd.evaluatorrbd.RBDLabel;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.JDEditBlocks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineExperimentRBD {
    public static int getNumberPoints(ExperimentParametersRBD experimentParametersRBD) {
        double finalValue = experimentParametersRBD.getMaxValue();
        double initialValue = experimentParametersRBD.getMinValue();
        double interval = experimentParametersRBD.getInterVal();
        int numberPoints = (int)((finalValue - initialValue) / interval);
        return numberPoints;
    }

    public static ArrayList<ExperimentResultRBD> executeExperimentRBD(ExperimentParametersRBD experimentParametersRBD) {
        ArrayList<ExperimentResultRBD> results = new ArrayList<ExperimentResultRBD>();
        RBDLabel rBDLabel = JDEditBlocks.getLabel(experimentParametersRBD.getNameDelayRBD());
        double initialValueLabel = rBDLabel.getValue();
        double initialValue = experimentParametersRBD.getMinValue();
        double interval = experimentParametersRBD.getInterVal();
        for (int i = 0; i < EngineExperimentRBD.getNumberPoints(experimentParametersRBD) + 1; ++i) {
            double delayParameterValue = initialValue + (double)i * interval;
            rBDLabel.setValue(delayParameterValue);
            double resultTemp = 0.0;
            EvaluationType evaluationType = experimentParametersRBD.getEvaluationType();
            switch (evaluationType) {
                case INSTANTANEOUS_AVAILABILITY_EVAL: {
                    resultTemp = GraphViewRBD.app.getRBDModel().getModel().calculateAvailability(experimentParametersRBD.getEvaluationTime());
                    break;
                }
                case MTTF_EVAL: {
                    resultTemp = GraphViewRBD.app.getRBDModel().getModel().calculateMeanTimeToFailure();
                    break;
                }
                case MTTR_EVAL: {
                    resultTemp = GraphViewRBD.app.getRBDModel().getModel().calculateMeanTimeToRepair();
                    break;
                }
                case RELIABILITY_EVAL: {
                    resultTemp = GraphViewRBD.app.getRBDModel().getModel().calculateReliability(experimentParametersRBD.getEvaluationTime());
                    break;
                }
                case STEADY_STATE_AVAILABILITY_EVAL: {
                    resultTemp = GraphViewRBD.app.getRBDModel().getModel().calculateAvailability(9.223372036854776E18);
                    break;
                }
                case UNRELIABILITY_EVAL: {
                    resultTemp = GraphViewRBD.app.getRBDModel().getModel().calculateReliability(experimentParametersRBD.getEvaluationTime());
                    resultTemp = 1.0 - resultTemp;
                }
            }
            results.add(new ExperimentResultRBD(delayParameterValue, resultTemp));
        }
        rBDLabel.setValue(initialValueLabel);
        return results;
    }
}

