/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks.bounds;

import java.util.ArrayList;
import java.util.Arrays;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.InterfaceCalculatorRBD;
import org.modcs.tools.rbd.blocks.RBDModel;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.blocks.bounds.PathsAndCuts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDPMethod
implements InterfaceCalculatorRBD {
    private ArrayList<MinimalPath> minPaths;
    private ArrayList<MinimalCut> minCuts;

    public int getNumberOfLowerIteractions() {
        return this.minPaths.size();
    }

    public int getNumberOfUpperIteractions() {
        return this.minCuts.size();
    }

    public SDPMethod(PathsAndCuts pathsAndCuts) {
        this.minPaths = pathsAndCuts.getMinPaths();
        this.minCuts = pathsAndCuts.getMinCuts();
    }

    public SDPMethod(RBDModel rbdModel) {
        MinimalPath[] newMinPaths = rbdModel.getMinimalPaths(true);
        MinimalCut[] newMinCuts = rbdModel.getMinimalCuts(true);
        this.minPaths = new ArrayList<MinimalPath>(Arrays.asList(newMinPaths));
        this.minCuts = new ArrayList<MinimalCut>(Arrays.asList(newMinCuts));
    }

    public Double[] getLowerValuesOfAvailability(Integer numberOfIteractions, Double time) {
        Double[] lowerValues = new Double[numberOfIteractions.intValue()];
        Double lowerAvailability = 0.0;
        Double value = 0.0;
        for (int i = 0; i < numberOfIteractions; ++i) {
            lowerValues[i] = lowerAvailability = (value = Double.valueOf(value + SDPMethod.getLowerBoundAvailability(this.minPaths, i, time)));
        }
        return lowerValues;
    }

    public Double[] getLowerValuesOfAvailability(Double time) {
        Double[] lowerValues = new Double[this.minPaths.size()];
        Double lowerAvailability = 0.0;
        Double value = 0.0;
        for (int i = 0; i < this.minPaths.size(); ++i) {
            lowerValues[i] = lowerAvailability = (value = Double.valueOf(value + SDPMethod.getLowerBoundAvailability(this.minPaths, i, time)));
        }
        return lowerValues;
    }

    public Double[] getUpperValuesOfAvailability(Integer numberOfIteractions, Double time) {
        Double[] upperValues = new Double[numberOfIteractions.intValue()];
        Double upperAvailability = 0.0;
        Double value = 0.0;
        for (int i = 0; i < numberOfIteractions; ++i) {
            value = value + SDPMethod.getUpperBoundAvailability(this.minCuts, i, time);
            upperValues[i] = upperAvailability = Double.valueOf(1.0 - value);
        }
        return upperValues;
    }

    public Double[] getUpperValuesOfReliability(Integer numberOfIteractions, Double time) {
        Double[] upperValues = new Double[numberOfIteractions.intValue()];
        double value = 0.0;
        double upperValue = 0.0;
        for (int i = 0; i < numberOfIteractions; ++i) {
            upperValue = 1.0 - (value += SDPMethod.getUpperBoundReliability(this.minCuts, i, time));
            upperValues[i] = upperValue;
        }
        return upperValues;
    }

    public Double[] getLowerValuesOfReliability(Integer numberOfIteractions, Double time) {
        Double[] lowerValues = new Double[numberOfIteractions.intValue()];
        double value = 0.0;
        double lowerValue = 0.0;
        for (int i = 0; i < numberOfIteractions; ++i) {
            lowerValue = value += SDPMethod.getLowerBoundReliability(this.minPaths, i, time);
            lowerValues[i] = lowerValue;
        }
        return lowerValues;
    }

    public Double[] getLowerValuesOfReliability(Double time) {
        Double[] lowerValues = new Double[this.minPaths.size()];
        double value = 0.0;
        double lowerValue = 0.0;
        for (int i = 0; i < this.minPaths.size(); ++i) {
            lowerValue = value += SDPMethod.getLowerBoundReliability(this.minPaths, i, time);
            lowerValues[i] = lowerValue;
        }
        return lowerValues;
    }

    public Double[] getLowerDowntime(Integer numberOfIteractions, Double time) {
        Double[] upperValues = new Double[numberOfIteractions.intValue()];
        Double value = 0.0;
        for (int i = 0; i < numberOfIteractions; ++i) {
            Double upperValue;
            value = value + SDPMethod.getUpperBoundAvailability(this.minCuts, i, Double.MAX_VALUE);
            upperValues[i] = upperValue = Double.valueOf(time * value);
        }
        return upperValues;
    }

    public Double[] getLowerDowntime(Double time) {
        Double[] upperValues = new Double[this.minPaths.size()];
        Double value = 0.0;
        for (int i = 0; i < this.minPaths.size(); ++i) {
            Double upperValue;
            value = value + SDPMethod.getUpperBoundAvailability(this.minCuts, i, Double.MAX_VALUE);
            upperValues[i] = upperValue = Double.valueOf(time * value);
        }
        return upperValues;
    }

    public Double[] getUpperDowntime(Integer numberOfIteractions, Double time) {
        Double[] lowerValues = new Double[numberOfIteractions.intValue()];
        double lowerValue = 0.0;
        double value = 0.0;
        for (int i = 0; i < numberOfIteractions; ++i) {
            lowerValue = time * (1.0 - (value += SDPMethod.getLowerBoundAvailability(this.minPaths, i, Double.MAX_VALUE)));
            lowerValues[i] = lowerValue;
        }
        return lowerValues;
    }

    private static double getUpperBoundAvailability(ArrayList<MinimalCut> minCuts, int indexCut, double time) {
        if (indexCut == 0) {
            return minCuts.get(0).calculateAvailability(time);
        }
        ArrayList<MinimalCut> previewsCuts = new ArrayList<MinimalCut>();
        for (int i = 0; i < indexCut; ++i) {
            previewsCuts.add(minCuts.get(i).copyCut());
        }
        ArrayList<String> newArray = SDPMethod.complementCuts(previewsCuts = SDPMethod.removeCutRepeated(previewsCuts, minCuts.get(indexCut)));
        if (newArray.size() > 1) {
            newArray = SDPMethod.multiplies(newArray);
        }
        if (newArray.size() > 1) {
            newArray = SDPMethod.simplify(newArray);
        }
        newArray = SDPMethod.changeSDP(newArray);
        double auxAv = 1.0;
        double limitAvailability = 0.0;
        boolean noComplement = false;
        for (String str : newArray) {
            auxAv = 1.0;
            for (String blockName : new ArrayList<String>(Arrays.asList(str.split("\\*")))) {
                if (blockName.startsWith("#")) {
                    noComplement = true;
                    blockName = blockName.substring(1);
                } else {
                    noComplement = false;
                }
                for (int i = 0; i < minCuts.size(); ++i) {
                    for (Block b : minCuts.get(i).getBlocks()) {
                        if (!b.getName().equals(blockName)) continue;
                        auxAv = noComplement ? (auxAv *= b.calculateAvailability(time)) : (auxAv *= 1.0 - b.calculateAvailability(time));
                        i = minCuts.size();
                    }
                }
            }
            limitAvailability += (auxAv *= minCuts.get(indexCut).calculateAvailability(time).doubleValue());
        }
        return limitAvailability;
    }

    private static double getLowerBoundAvailability(ArrayList<MinimalPath> paths, int indexPath, double time) {
        if (indexPath == 0) {
            return paths.get(0).calculateAvailability(time);
        }
        ArrayList<MinimalPath> previewsPaths = new ArrayList<MinimalPath>();
        for (int i = 0; i < indexPath; ++i) {
            previewsPaths.add(paths.get(i).copyPath());
        }
        ArrayList<String> newArray = SDPMethod.complementPaths(previewsPaths = SDPMethod.removePathRepeated(previewsPaths, paths.get(indexPath)));
        if (newArray.size() > 1) {
            newArray = SDPMethod.multiplies(newArray);
        }
        if (newArray.size() > 1) {
            newArray = SDPMethod.simplify(newArray);
        }
        newArray = SDPMethod.changeSDP(newArray);
        double auxAv = 1.0;
        double availability = 0.0;
        boolean isComplement = false;
        for (String str : newArray) {
            auxAv = 1.0;
            for (String blockName : new ArrayList<String>(Arrays.asList(str.split("\\*")))) {
                if (blockName.startsWith("#")) {
                    isComplement = true;
                    blockName = blockName.substring(1);
                } else {
                    isComplement = false;
                }
                for (int i = 0; i < paths.size(); ++i) {
                    for (Block b : paths.get(i).getBlocks()) {
                        if (!b.getName().equals(blockName)) continue;
                        auxAv = isComplement ? (auxAv *= 1.0 - b.calculateAvailability(time)) : (auxAv *= b.calculateAvailability(time));
                        i = paths.size();
                    }
                }
            }
            availability += (auxAv *= paths.get(indexPath).calculateAvailability(time).doubleValue());
        }
        return availability;
    }

    private static double getLowerBoundReliability(ArrayList<MinimalPath> paths, int indexPath, double time) {
        if (indexPath == 0) {
            return paths.get(0).calculateReliability(time);
        }
        ArrayList<MinimalPath> previewsPaths = new ArrayList<MinimalPath>();
        for (int i = 0; i < indexPath; ++i) {
            previewsPaths.add(paths.get(i).copyPath());
        }
        ArrayList<String> newArray = SDPMethod.complementPaths(previewsPaths = SDPMethod.removePathRepeated(previewsPaths, paths.get(indexPath)));
        if (newArray.size() > 1) {
            newArray = SDPMethod.multiplies(newArray);
        }
        if (newArray.size() > 1) {
            newArray = SDPMethod.simplify(newArray);
        }
        newArray = SDPMethod.changeSDP(newArray);
        double auxReliability = 1.0;
        double limitReliability = 0.0;
        boolean isComplement = false;
        for (String str : newArray) {
            auxReliability = 1.0;
            for (String blockName : new ArrayList<String>(Arrays.asList(str.split("\\*")))) {
                if (blockName.startsWith("#")) {
                    isComplement = true;
                    blockName = blockName.substring(1);
                } else {
                    isComplement = false;
                }
                for (int i = 0; i < paths.size(); ++i) {
                    for (Block b : paths.get(i).getBlocks()) {
                        if (!b.getName().equals(blockName)) continue;
                        auxReliability = isComplement ? (auxReliability *= 1.0 - b.calculateReliability(time)) : (auxReliability *= b.calculateReliability(time));
                        i = paths.size();
                    }
                }
            }
            limitReliability += (auxReliability *= paths.get(indexPath).calculateReliability(time).doubleValue());
        }
        return limitReliability;
    }

    private static double getUpperBoundReliability(ArrayList<MinimalCut> minCuts, int indexCut, double time) {
        if (indexCut == 0) {
            return minCuts.get(0).calculateReliability(time);
        }
        ArrayList<MinimalCut> previewsCuts = new ArrayList<MinimalCut>();
        for (int i = 0; i < indexCut; ++i) {
            previewsCuts.add(minCuts.get(i).copyCut());
        }
        ArrayList<String> newArray = SDPMethod.complementCuts(previewsCuts = SDPMethod.removeCutRepeated(previewsCuts, minCuts.get(indexCut)));
        if (newArray.size() > 1) {
            newArray = SDPMethod.multiplies(newArray);
        }
        if (newArray.size() > 1) {
            newArray = SDPMethod.simplify(newArray);
        }
        newArray = SDPMethod.changeSDP(newArray);
        double auxReliability = 1.0;
        double limitReliability = 0.0;
        boolean noComplement = false;
        for (String str : newArray) {
            auxReliability = 1.0;
            for (String blockName : new ArrayList<String>(Arrays.asList(str.split("\\*")))) {
                if (blockName.startsWith("#")) {
                    noComplement = true;
                    blockName = blockName.substring(1);
                } else {
                    noComplement = false;
                }
                for (int i = 0; i < minCuts.size(); ++i) {
                    for (Block b : minCuts.get(i).getBlocks()) {
                        if (!b.getName().equals(blockName)) continue;
                        auxReliability = noComplement ? (auxReliability *= b.calculateReliability(time)) : (auxReliability *= 1.0 - b.calculateReliability(time));
                        i = minCuts.size();
                    }
                }
            }
            limitReliability += (auxReliability *= minCuts.get(indexCut).calculateReliability(time).doubleValue());
        }
        return limitReliability;
    }

    private static ArrayList<MinimalPath> removePathRepeated(ArrayList<MinimalPath> paths, MinimalPath path) {
        int i;
        for (i = 0; i < paths.size(); ++i) {
            for (Block be : path.getBlocks()) {
                paths.get(i).remove(be);
            }
        }
        for (i = 1; i < paths.size(); ++i) {
            for (int j = i - 1; j >= 0; --j) {
                if (paths.get(i).getBlocks().size() > paths.get(j).getBlocks().size()) {
                    if (!paths.get(i).isContained(paths.get(j))) continue;
                    paths.remove(i);
                    --i;
                    continue;
                }
                if (!paths.get(j).isContained(paths.get(i))) continue;
                paths.remove(j);
                --i;
            }
        }
        return paths;
    }

    private static ArrayList<MinimalCut> removeCutRepeated(ArrayList<MinimalCut> cuts, MinimalCut cut) {
        int i;
        for (i = 0; i < cuts.size(); ++i) {
            for (Block be : cut.getBlocks()) {
                cuts.get(i).remove(be);
            }
        }
        for (i = 1; i < cuts.size(); ++i) {
            for (int j = i - 1; j >= 0; --j) {
                if (cuts.get(i).getBlocks().size() > cuts.get(j).getBlocks().size()) {
                    if (!cuts.get(i).isContained(cuts.get(j))) continue;
                    cuts.remove(i);
                    --i;
                    continue;
                }
                if (!cuts.get(j).isContained(cuts.get(i))) continue;
                cuts.remove(j);
                --i;
            }
        }
        return cuts;
    }

    private static ArrayList<String> complementPaths(ArrayList<MinimalPath> previewsPaths) {
        ArrayList<String> exp = new ArrayList<String>();
        String aux = "";
        if (previewsPaths.size() == 1) {
            if (previewsPaths.get(0).getBlocks().size() == 1) {
                exp.add("#" + previewsPaths.get(0).getBlocks().get(0).getName());
                return exp;
            }
            for (Block be : previewsPaths.get(0).getBlocks()) {
                if (aux.equals("")) {
                    aux = "#" + be.getName();
                    continue;
                }
                aux = aux + "+#" + be.getName();
            }
            exp.add(aux);
            return exp;
        }
        for (MinimalPath subpath : previewsPaths) {
            aux = "";
            if (subpath.getBlocks().size() == 1) {
                exp.add("#" + subpath.getBlocks().get(0).getName());
                continue;
            }
            for (Block be : subpath.getBlocks()) {
                if (aux.equals("")) {
                    aux = "#" + be.getName();
                    continue;
                }
                aux = aux + "+#" + be.getName();
            }
            exp.add(aux);
        }
        return exp;
    }

    private static ArrayList<String> complementCuts(ArrayList<MinimalCut> previewsCuts) {
        ArrayList<String> exp = new ArrayList<String>();
        String aux = "";
        if (previewsCuts.size() == 1) {
            if (previewsCuts.get(0).getBlocks().size() == 1) {
                exp.add("#" + previewsCuts.get(0).getBlocks().get(0).getName());
                return exp;
            }
            for (Block be : previewsCuts.get(0).getBlocks()) {
                if (aux.equals("")) {
                    aux = "#" + be.getName();
                    continue;
                }
                aux = aux + "+#" + be.getName();
            }
            exp.add(aux);
            return exp;
        }
        for (MinimalCut subcut : previewsCuts) {
            aux = "";
            if (subcut.getBlocks().size() == 1) {
                exp.add("#" + subcut.getBlocks().get(0).getName());
                continue;
            }
            for (Block be : subcut.getBlocks()) {
                if (aux.equals("")) {
                    aux = "#" + be.getName();
                    continue;
                }
                aux = aux + "+#" + be.getName();
            }
            exp.add(aux);
        }
        return exp;
    }

    private static ArrayList<String> multiplies(ArrayList<String> factors) {
        String aux = "";
        for (int i = 0; i < factors.size() - 1; ++i) {
            ArrayList<String> operator;
            if (aux.equals("")) {
                operator = new ArrayList<String>(Arrays.asList(factors.get(i).split("\\+")));
            } else {
                operator = new ArrayList<String>(Arrays.asList(aux.split("\\+")));
                aux = "";
            }
            ArrayList<String> operator2 = new ArrayList<String>(Arrays.asList(factors.get(i + 1).split("\\+")));
            for (int j = 0; j < operator.size(); ++j) {
                for (int k = 0; k < operator2.size(); ++k) {
                    if (!aux.equals("")) {
                        aux = aux + "+";
                    }
                    aux = !operator.get(j).contains(operator2.get(k)) ? aux + operator.get(j) + "*" + operator2.get(k) : aux + operator.get(j);
                }
            }
        }
        return new ArrayList<String>(Arrays.asList(aux.split("\\+")));
    }

    private static ArrayList<String> simplify(ArrayList<String> expression) {
        for (int i = 0; i < expression.size() - 1; ++i) {
            if (expression.get(i).length() >= expression.get(i + 1).length()) {
                if (!expression.get(i).contains(expression.get(i + 1)) && !SDPMethod.isContained(expression.get(i + 1), expression.get(i))) continue;
                expression.remove(i);
                --i;
                continue;
            }
            if (!expression.get(i + 1).contains(expression.get(i)) && !SDPMethod.isContained(expression.get(i), expression.get(i + 1))) continue;
            expression.remove(i + 1);
            --i;
        }
        return expression;
    }

    private static ArrayList<String> changeSDP(ArrayList<String> previewsPaths) {
        ArrayList<String> astr = new ArrayList<String>();
        String aux = "";
        if (previewsPaths.size() == 1) {
            if (previewsPaths.get(0).contains("+")) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(previewsPaths.get(0).split("\\+")));
                for (int i = 0; i < list.size(); ++i) {
                    if (i == 0) {
                        aux = list.get(i);
                    } else {
                        aux = "";
                        for (int j = i - 1; j >= 0; --j) {
                            if (!aux.equals("")) {
                                aux = aux + "*";
                            }
                            aux = list.get(j).startsWith("#") ? aux + list.get(j).substring(1) : aux + list.get(j);
                        }
                        aux = aux + "*" + list.get(i);
                    }
                    astr.add(aux);
                }
                return astr;
            }
            return previewsPaths;
        }
        for (int i = 0; i < previewsPaths.size(); ++i) {
            if (i == 0) {
                astr.add(previewsPaths.get(i));
                continue;
            }
            aux = "";
            for (int j = i - 1; j >= 0; --j) {
                for (String s : new ArrayList<String>(Arrays.asList(previewsPaths.get(j).split("\\*")))) {
                    if (previewsPaths.get(i).contains(s)) continue;
                    if (!aux.equals("")) {
                        aux = aux + "*";
                    }
                    if (s.startsWith("#")) {
                        aux = aux + s.substring(1);
                        continue;
                    }
                    aux = aux + s;
                }
            }
            aux = aux + "*" + previewsPaths.get(i);
            astr.add(aux);
        }
        return astr;
    }

    private static boolean isContained(String smaller, String bigger) {
        ArrayList<String> astr = new ArrayList<String>(Arrays.asList(smaller.split("\\*")));
        for (String s1 : astr) {
            if (bigger.contains(s1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getAvailability() {
        int lenght = this.getNumberOfUpperIteractions();
        return this.getUpperValuesOfAvailability(lenght, (Double)Double.MAX_VALUE)[lenght - 1];
    }

    @Override
    public double getAvailability(double time) {
        return this.getUpperValuesOfAvailability(this.getNumberOfUpperIteractions(), (Double)Double.MAX_VALUE)[this.getNumberOfUpperIteractions() - 1];
    }

    @Override
    public double getReliability(double time) {
        return this.getUpperValuesOfReliability(this.getNumberOfUpperIteractions(), time)[this.getNumberOfUpperIteractions() - 1];
    }

    @Override
    public double getMeanTimeToRepair() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getMeanTimeToFailure() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getDowntime(double time) {
        return this.getLowerDowntime(time)[this.getNumberOfLowerIteractions() - 1];
    }

    @Override
    public double getUptime(double time) {
        return 1.0 - this.getLowerDowntime(time)[this.getNumberOfLowerIteractions() - 1];
    }
}

