/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks.bounds;

import java.util.ArrayList;
import org.modcs.tools.rbd.blocks.Block;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalPath
implements Comparable {
    private ArrayList<Block> blocksOnPath = new ArrayList();

    public MinimalPath(ArrayList<Block> blocks) {
        this.blocksOnPath.addAll(blocks);
    }

    public MinimalPath() {
    }

    public ArrayList<Block> getBlocks() {
        return this.blocksOnPath;
    }

    public int size() {
        return this.blocksOnPath.size();
    }

    public void setBlocks(ArrayList<Block> blocks) {
        if (blocks != null) {
            this.blocksOnPath.addAll(blocks);
        }
    }

    public boolean remove(Block block) {
        for (int i = 0; i < this.blocksOnPath.size(); ++i) {
            if (!this.blocksOnPath.get(i).getName().equals(block.getName())) continue;
            return this.remove(i);
        }
        return false;
    }

    public boolean remove(int index) {
        if (index < this.blocksOnPath.size()) {
            this.blocksOnPath.remove(index);
            return true;
        }
        return false;
    }

    public boolean add(Block block) {
        if (block != null && !this.contains(block)) {
            this.blocksOnPath.add(block);
            return true;
        }
        return false;
    }

    public boolean append(MinimalPath mp) {
        if (mp != null) {
            for (Block b : mp.getBlocks()) {
                this.add(b);
            }
            return true;
        }
        return false;
    }

    public Block getBlock(int index) {
        if (index >= 0 && index < this.blocksOnPath.size()) {
            return this.blocksOnPath.get(index);
        }
        return null;
    }

    public MinimalPath copyPath() {
        MinimalPath newPath = new MinimalPath(this.getBlocks());
        return newPath;
    }

    public boolean isEqual(MinimalPath p) {
        boolean part1 = true;
        boolean part2 = true;
        for (Block be : this.blocksOnPath) {
            if (p.contains(be)) continue;
            part1 = false;
        }
        for (Block be : p.getBlocks()) {
            if (this.contains(be)) continue;
            part2 = false;
        }
        return part1 && part2;
    }

    public boolean isContained(MinimalPath p) {
        for (Block be2 : p.getBlocks()) {
            if (this.contains(be2)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Block b) {
        for (Block be : this.getBlocks()) {
            if (!b.getName().equals(be.getName())) continue;
            return true;
        }
        return false;
    }

    public Double calculateReliability(double time) {
        double reliability = 1.0;
        for (Block block : this.blocksOnPath) {
            reliability *= block.calculateReliability(time);
        }
        return reliability;
    }

    public Double calculateAvailability(double time) {
        double availability = 1.0;
        for (Block block : this.blocksOnPath) {
            availability *= block.calculateAvailability(time);
        }
        return availability;
    }

    public int compareTo(Object o) {
        if (((MinimalPath)o).size() > this.blocksOnPath.size()) {
            return -1;
        }
        return 1;
    }
}

