/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks.bounds;

import java.util.ArrayList;
import org.modcs.tools.rbd.blocks.Block;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalCut
implements Comparable {
    private ArrayList<Block> blocksOnCut = new ArrayList();

    public MinimalCut(ArrayList<Block> blocks) {
        this.blocksOnCut.addAll(blocks);
    }

    public int size() {
        return this.blocksOnCut.size();
    }

    public MinimalCut() {
    }

    public ArrayList<Block> getBlocks() {
        return this.blocksOnCut;
    }

    public void setBlocks(ArrayList<Block> blocks) {
        if (blocks != null) {
            this.blocksOnCut.addAll(blocks);
        }
    }

    public boolean remove(Block block) {
        for (int i = 0; i < this.blocksOnCut.size(); ++i) {
            if (!this.blocksOnCut.get(i).getName().equals(block.getName())) continue;
            return this.remove(i);
        }
        return false;
    }

    public boolean remove(int index) {
        if (index < this.blocksOnCut.size()) {
            this.blocksOnCut.remove(index);
            return true;
        }
        return false;
    }

    public boolean add(Block block) {
        if (block != null && !this.contains(block)) {
            this.blocksOnCut.add(block);
            return true;
        }
        return false;
    }

    public boolean append(MinimalCut mc) {
        if (mc != null) {
            for (Block b : mc.getBlocks()) {
                this.add(b);
            }
            return true;
        }
        return false;
    }

    public Block getBlock(int index) {
        if (index >= 0 && index < this.blocksOnCut.size()) {
            return this.blocksOnCut.get(index);
        }
        return null;
    }

    public MinimalCut copyCut() {
        MinimalCut newCut = new MinimalCut(this.getBlocks());
        return newCut;
    }

    public boolean isEqual(MinimalCut p) {
        boolean part1 = true;
        boolean part2 = true;
        for (Block be : this.blocksOnCut) {
            if (p.contains(be)) continue;
            part1 = false;
        }
        for (Block be : p.getBlocks()) {
            if (this.contains(be)) continue;
            part2 = false;
        }
        return part1 && part2;
    }

    public boolean isContained(MinimalCut p) {
        for (Block be2 : p.getBlocks()) {
            if (this.contains(be2)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Block b) {
        for (Block be : this.getBlocks()) {
            if (!b.getName().equals(be.getName())) continue;
            return true;
        }
        return false;
    }

    public Double calculateReliability(double time) {
        double reliability = 1.0;
        for (Block block : this.blocksOnCut) {
            reliability *= 1.0 - block.calculateReliability(time);
        }
        return reliability;
    }

    public Double calculateAvailability(double time) {
        double availability = 1.0;
        for (Block block : this.blocksOnCut) {
            availability *= 1.0 - block.calculateAvailability(time);
        }
        return availability;
    }

    public int compareTo(Object o) {
        if (((MinimalCut)o).size() > this.blocksOnCut.size()) {
            return -1;
        }
        return 1;
    }
}

