/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.modcs.tools.Util.ArrayListOperation;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockBridge;
import org.modcs.tools.rbd.blocks.BlockParallel;
import org.modcs.tools.rbd.blocks.BlockSeries;
import org.modcs.tools.rbd.blocks.InterfaceCalculatorRBD;
import org.modcs.tools.rbd.blocks.bounds.BinaryDecisionDiagram;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.evaluatorrbd.SystemsFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RBDModel
implements Serializable,
InterfaceCalculatorRBD {
    private ArrayList<Block> blocksOfModel = new ArrayList();
    private Block model;
    private String name;
    private int indexOfBlocks = 1;
    private int numberOfBlocks = 1;
    private MinimalPath[] minPaths;
    private MinimalCut[] minCuts;
    BinaryDecisionDiagram bdd;

    public RBDModel() {
        this.model = null;
        this.name = null;
        this.indexOfBlocks = 1;
        this.numberOfBlocks = 1;
    }

    public RBDModel(String name) {
        this.model = new BlockSeries("root");
        this.name = name;
        this.indexOfBlocks = 1;
        this.numberOfBlocks = 1;
    }

    public int getIndexOfBlocks() {
        return this.indexOfBlocks;
    }

    public void setIndexOfBlocks(int numberOfBlocks) {
        this.indexOfBlocks = numberOfBlocks;
    }

    public void incrementIndexOfBlocks() {
        ++this.indexOfBlocks;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public void incrementNumberOfBlocks() {
        ++this.numberOfBlocks;
    }

    public void decrementNumberOfBlocks() {
        --this.numberOfBlocks;
    }

    public ArrayList<Block> getBlocksOfModel() {
        return this.blocksOfModel;
    }

    public void setBlocksOfModel(ArrayList<Block> blocksOfModel) {
        this.blocksOfModel = blocksOfModel;
    }

    public Block getModel() {
        return this.model;
    }

    public void setModel(Block block) {
        this.model = block;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addBlock(Block block) {
        ArrayListOperation.addBlock(this.blocksOfModel, block);
    }

    public boolean isModelHasReliabilityEdited() {
        return this.model.isBlockHasReliabilityEdited();
    }

    public void printModel() {
        this.showModel(this.model, 0);
    }

    private void showModel(Block block, int tab) {
        if (block instanceof BlockSeries) {
            int i;
            this.endenta(tab++);
            System.out.print("Serie: ");
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.println(")");
            BlockSeries blocoEmSerie = (BlockSeries)block;
            for (int i2 = 0; i2 < blocoEmSerie.getBlocks().size(); ++i2) {
                this.showModel(blocoEmSerie.getBlocks().get(i2), tab);
            }
        } else if (block instanceof BlockParallel) {
            int i;
            this.endenta(tab++);
            System.out.print("Parallel: ");
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.println(")");
            BlockParallel blocoEmParalelo = (BlockParallel)block;
            for (int i3 = 0; i3 < blocoEmParalelo.getBlocks().size(); ++i3) {
                this.showModel(blocoEmParalelo.getBlocks().get(i3), tab);
            }
        } else if (block instanceof BlockBridge) {
            int i;
            this.endenta(tab++);
            System.out.print("Bridge: ");
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.println(")");
            BlockBridge blocoEmBridge = (BlockBridge)block;
            for (int i4 = 0; i4 < blocoEmBridge.getBlocks().size(); ++i4) {
                this.showModel(blocoEmBridge.getBlocks().get(i4), tab);
            }
        } else {
            int i;
            this.endenta(tab--);
            System.out.print("( ");
            for (i = 0; i < block.getPreviewsNode().size(); ++i) {
                System.out.print(block.getPreviewsNode().get(i) + " ");
            }
            System.out.print(") - ");
            System.out.print("[" + block.getName() + "]");
            System.out.print(" - ( ");
            for (i = 0; i < block.getNextNode().size(); ++i) {
                System.out.print(block.getNextNode().get(i) + " ");
            }
            System.out.print(")");
            System.out.println("");
        }
    }

    private void endenta(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
    }

    @Override
    public double getAvailability() {
        return this.model.calculateAvailability(Double.MAX_VALUE);
    }

    @Override
    public double getReliability(double time) {
        return this.model.calculateReliability(time);
    }

    @Override
    public double getAvailability(double time) {
        return this.model.calculateAvailability(time);
    }

    @Override
    public double getMeanTimeToRepair() {
        return this.model.calculateMeanTimeToRepair();
    }

    @Override
    public double getMeanTimeToFailure() {
        return this.model.calculateMeanTimeToFailure();
    }

    @Override
    public double getDowntime(double time) {
        return 1.0 - time * this.model.calculateAvailability(Double.MAX_VALUE);
    }

    @Override
    public double getUptime(double time) {
        return time * this.model.calculateAvailability(Double.MAX_VALUE);
    }

    public MinimalPath[] getMinimalPaths() {
        if (this.minPaths == null) {
            this.setMinimalPaths();
        }
        return this.minPaths;
    }

    public MinimalPath[] getMinimalPaths(boolean redo) {
        if (redo) {
            this.setMinimalPaths();
        }
        return this.minPaths;
    }

    private void setMinimalPaths() {
        this.minPaths = this.model.getMinimalPaths();
        Arrays.sort(this.minPaths);
        this.minPaths = this.excludeRepeatedComponents(this.minPaths);
    }

    public MinimalCut[] getMinimalCuts() {
        if (this.minCuts == null) {
            this.setMinimalCuts();
        }
        return this.minCuts;
    }

    public MinimalCut[] getMinimalCuts(boolean redo) {
        if (redo) {
            this.setMinimalCuts();
        }
        if (this.minCuts == null) {
            this.setMinimalCuts();
        }
        return this.minCuts;
    }

    private void setMinimalCuts() {
        this.minCuts = this.model.getMinimalCuts();
        Arrays.sort(this.minCuts);
        this.minCuts = this.excludeRepeatedComponents(this.minCuts);
    }

    private MinimalPath[] excludeRepeatedComponents(MinimalPath[] mpaths) {
        int j;
        int numberOfPaths = 1;
        for (int i = 0; i < mpaths.length; ++i) {
            for (j = i + 1; j < mpaths.length; ++j) {
                if (mpaths[j] == null || mpaths[i] == null || !mpaths[j].isContained(mpaths[i])) continue;
                mpaths[j] = null;
            }
            if (mpaths[i] == null) continue;
            ++numberOfPaths;
        }
        if (mpaths.length == numberOfPaths) {
            return mpaths;
        }
        MinimalPath[] newMinPaths = new MinimalPath[numberOfPaths - 1];
        j = 0;
        for (int i = 0; i < mpaths.length; ++i) {
            if (mpaths[i] == null) continue;
            newMinPaths[j++] = mpaths[i];
        }
        return newMinPaths;
    }

    private MinimalCut[] excludeRepeatedComponents(MinimalCut[] mcuts) {
        int j;
        int numberOfCuts = 1;
        for (int i = 0; i < mcuts.length; ++i) {
            for (j = i + 1; j < mcuts.length; ++j) {
                if (mcuts[j] == null || mcuts[i] == null || !mcuts[j].isContained(mcuts[i])) continue;
                mcuts[j] = null;
            }
            if (mcuts[i] == null) continue;
            ++numberOfCuts;
        }
        if (mcuts.length == numberOfCuts) {
            return mcuts;
        }
        MinimalCut[] newMinCuts = new MinimalCut[numberOfCuts - 1];
        j = 0;
        for (int i = 0; i < mcuts.length; ++i) {
            if (mcuts[i] == null) continue;
            newMinCuts[j++] = mcuts[i];
        }
        return newMinCuts;
    }

    public void generateBDD() {
        this.showModel(this.model, 0);
        this.model.clearBdd();
        this.bdd = this.model.generateBDD();
        System.out.println("\n===== BDD =====");
        this.showBDD(this.bdd);
    }

    public void showBDD(BinaryDecisionDiagram node) {
        System.out.print(" " + node.getNodeId() + " ( ");
        if (node.getLowNode() != null) {
            System.out.print(node.getLowNode().getNodeId());
        } else {
            System.out.print("0 ");
        }
        System.out.print(" , ");
        if (node.getHighNode() != null) {
            System.out.print(node.getHighNode().getNodeId() + " )");
        } else {
            System.out.print("1  )");
        }
        System.out.println();
        if (node.getLowNode() != null) {
            this.showBDD(node.getLowNode());
        }
        if (node.getHighNode() != null) {
            this.showBDD(node.getHighNode());
        }
    }

    public boolean calculateStructuralFunction(SystemsFunction st) {
        return this.model.calculateStructuralFunction(st) == 1;
    }

    public SystemsFunction getStructuralFunction() {
        SystemsFunction st = new SystemsFunction();
        st.setFunction(this.model.getStructuralFunction());
        st.setState(this.calculateStructuralFunction(st));
        return st;
    }

    public SystemsFunction getLogicFunction() {
        SystemsFunction st = new SystemsFunction();
        st.setFunction(this.model.getLogicFunction());
        st.setState(this.model.calculateLogicFunction(st));
        return st;
    }

    public void setStateOfEqualBlocks(Block block) {
        this.getModel().setStateOfEqualBlocks(block);
    }

    public boolean hasRepeatedComponent() {
        this.blocksOfModel = new ArrayList();
        this.updateBlocksList(this.getModel());
        for (int i = 0; i < this.blocksOfModel.size(); ++i) {
            for (int j = i + 1; j < this.blocksOfModel.size(); ++j) {
                if (!this.blocksOfModel.get(i).getName().equals(this.blocksOfModel.get(j).getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void updateBlocksOfModel() {
        this.updateBlocksList(this.getModel());
    }

    private void updateBlocksList(Block model) {
        if (model instanceof BlockSeries) {
            BlockSeries blocoEmSerie = (BlockSeries)model;
            for (int i = 0; i < blocoEmSerie.getBlocks().size(); ++i) {
                this.updateBlocksList(blocoEmSerie.getBlocks().get(i));
            }
        } else if (model instanceof BlockParallel) {
            BlockParallel blocoEmParalelo = (BlockParallel)model;
            for (int i = 0; i < blocoEmParalelo.getBlocks().size(); ++i) {
                this.updateBlocksList(blocoEmParalelo.getBlocks().get(i));
            }
        } else if (model instanceof BlockBridge) {
            BlockBridge blocoEmBridge = (BlockBridge)model;
            for (int i = 0; i < blocoEmBridge.getBlocks().size(); ++i) {
                this.updateBlocksList(blocoEmBridge.getBlocks().get(i));
            }
        } else {
            this.blocksOfModel.add(model);
        }
    }
}

