/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.Util.CoeficientsOperation;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockChain;
import org.modcs.tools.rbd.blocks.bounds.BinaryDecisionDiagram;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.evaluatorrbd.SystemsFunction;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class BlockSeries
extends BlockChain
implements Serializable {
    public BlockSeries(String name) {
        super(name);
    }

    public double calculateReliability(double time) {
        double reliabilityTemp = 1.0;
        if (time > 0.0) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                reliabilityTemp *= ((Block)this.blocks.get(i)).calculateReliability(time);
            }
            return reliabilityTemp;
        }
        return 1.0;
    }

    public double calculateAvailability(double time) {
        double availabilityTemp = 1.0;
        if (time > 0.0) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                availabilityTemp *= ((Block)this.blocks.get(i)).calculateAvailability(time);
            }
            return availabilityTemp;
        }
        return 1.0;
    }

    public int getLengthX() {
        int lengthX = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthX += ((Block)this.blocks.get(i)).getLengthX();
        }
        return lengthX;
    }

    public int getLengthY() {
        int lengthY = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthY = Math.max(lengthY, ((Block)this.blocks.get(i)).getLengthY());
        }
        return lengthY;
    }

    public int getLengthXPixels() {
        int lengthXPixels = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthXPixels += ((Block)this.blocks.get(i)).getLengthXPixels();
        }
        return lengthXPixels += (this.blocks.size() - 1) * GraphViewRBD.BLOCK_SEPARATION;
    }

    public int getLengthYPixels() {
        int lengthYPixels = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            lengthYPixels = Math.max(lengthYPixels, ((Block)this.blocks.get(i)).getLengthYPixels());
        }
        return lengthYPixels;
    }

    public ConnectionBlock drawBlock(int x, int y) {
        ConnectionBlock connectionBlock = new ConnectionBlock();
        ConnectionBlock[] connectionBlocks = new ConnectionBlock[2];
        int indexOfConnectionBlocks = 0;
        boolean isLeftRight = true;
        for (int i = 0; i < this.blocks.size(); ++i) {
            connectionBlocks[indexOfConnectionBlocks] = ((Block)this.blocks.get(i)).drawBlock(x, y);
            if (i == 0) {
                connectionBlock.setLeftPort(connectionBlocks[indexOfConnectionBlocks].getLeftPort());
            }
            if (i == this.blocks.size() - 1) {
                connectionBlock.setRightPort(connectionBlocks[indexOfConnectionBlocks].getRightPort());
            }
            if (connectionBlocks[0] != null && connectionBlocks[1] != null) {
                if (isLeftRight) {
                    GraphViewRBD.connectBlocks(connectionBlocks[0].getRightPort(), connectionBlocks[1].getLeftPort());
                    isLeftRight = false;
                } else {
                    GraphViewRBD.connectBlocks(connectionBlocks[0].getLeftPort(), connectionBlocks[1].getRightPort());
                    isLeftRight = true;
                }
            }
            ++indexOfConnectionBlocks;
            indexOfConnectionBlocks &= 1;
            x += ((Block)this.blocks.get(i)).getLengthXPixels() + GraphViewRBD.BLOCK_SEPARATION;
        }
        return connectionBlock;
    }

    public double calculateMeanTimeToFailure() {
        double tempMTTF = 0.0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            tempMTTF += 1.0 / ((Block)this.blocks.get(i)).calculateMeanTimeToFailure();
        }
        return 1.0 / tempMTTF;
    }

    public Coeficient[] getCoeficientsMeanTimeToFailure() {
        Coeficient[] temp = ((Block)this.blocks.get(0)).getCoeficientsMeanTimeToFailure();
        if (this.blocks.size() == 1) {
            return temp;
        }
        for (int i = 1; i < this.blocks.size(); ++i) {
            temp = CoeficientsOperation.multiply(temp, ((Block)this.blocks.get(i)).getCoeficientsMeanTimeToFailure());
        }
        return temp;
    }

    public void copy(Block block) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MinimalPath[] getMinimalPaths() {
        MinimalPath[] minPaths = new MinimalPath[this.getNumberOfPaths()];
        MinimalPath thisPath = new MinimalPath();
        if (minPaths.length == 1) {
            for (int i = 0; i < this.blocks.size(); ++i) {
                thisPath.append(((Block)this.blocks.get(i)).getMinimalPaths()[0]);
            }
            minPaths[0] = thisPath;
        } else {
            int i;
            int control = minPaths.length;
            for (i = 0; i < this.blocks.size(); ++i) {
                control /= ((Block)this.blocks.get(i)).getNumberOfPaths();
                if (((Block)this.blocks.get(i)).getNumberOfPaths() == 1) {
                    thisPath.append(((Block)this.blocks.get(i)).getMinimalPaths()[0]);
                    continue;
                }
                int j = 0;
                while (j < minPaths.length) {
                    for (int k = 0; k < ((Block)this.blocks.get(i)).getNumberOfPaths(); ++k) {
                        for (int z = 0; z < control; ++z) {
                            if (minPaths[j] == null) {
                                minPaths[j++] = ((Block)this.blocks.get(i)).getMinimalPaths()[k];
                                continue;
                            }
                            minPaths[j++].append(((Block)this.blocks.get(i)).getMinimalPaths()[k]);
                        }
                    }
                }
            }
            for (i = 0; i < minPaths.length; ++i) {
                minPaths[i].append(thisPath);
            }
            if (minPaths.length == 1) {
                minPaths[0] = thisPath;
            }
        }
        return minPaths;
    }

    public int getNumberOfPaths() {
        int numberOfPaths = 1;
        for (int i = 0; i < this.blocks.size(); ++i) {
            numberOfPaths *= ((Block)this.blocks.get(i)).getNumberOfPaths();
        }
        return numberOfPaths;
    }

    public MinimalCut[] getMinimalCuts() {
        MinimalCut[] minCuts = new MinimalCut[this.getNumberOfCuts()];
        int iterator = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (((Block)this.blocks.get(i)).getNumberOfCuts() == 1) {
                minCuts[iterator++] = ((Block)this.blocks.get(i)).getMinimalCuts()[0];
                continue;
            }
            int k = 0;
            while (k < ((Block)this.blocks.get(i)).getNumberOfCuts()) {
                minCuts[iterator++] = ((Block)this.blocks.get(i)).getMinimalCuts()[k++];
            }
        }
        return minCuts;
    }

    public int getNumberOfCuts() {
        int numberOfCuts = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            numberOfCuts += ((Block)this.blocks.get(i)).getNumberOfCuts();
        }
        return numberOfCuts;
    }

    public BinaryDecisionDiagram generateBDD() {
        if (this.getNodeBDD() == null) {
            for (int i = 1; i < this.blocks.size(); ++i) {
                this.setAllRighNode(((Block)this.blocks.get(i - 1)).generateBDD(), ((Block)this.blocks.get(i)).generateBDD());
            }
            this.setNodeBDD(((Block)this.blocks.get(0)).generateBDD());
            return ((Block)this.blocks.get(0)).generateBDD();
        }
        return this.getNodeBDD();
    }

    private void setAllRighNode(BinaryDecisionDiagram node, BinaryDecisionDiagram highNode) {
        if (node.getHighNode() == null) {
            if (node.getNodeId().equals(highNode.getNodeId())) {
                return;
            }
            node.setHighNode(highNode);
        } else {
            this.setAllRighNode(node.getHighNode(), highNode);
        }
        if (node.getLowNode() != null) {
            this.setAllRighNode(node.getLowNode(), highNode);
        }
    }

    public void clearBdd() {
        this.setNodeBDD(null);
        for (int i = 0; i < this.blocks.size(); ++i) {
            ((Block)this.blocks.get(i)).clearBdd();
        }
    }

    public String getStructuralFunction() {
        String function = "";
        for (int i = 0; i < this.blocks.size(); ++i) {
            function = function + "(" + ((Block)this.blocks.get(i)).getStructuralFunction() + ")";
            if (i + 1 >= this.blocks.size()) continue;
            function = function + "*";
        }
        return function;
    }

    public int calculateStructuralFunction(SystemsFunction st) {
        int state = 1;
        for (int i = 0; i < this.blocks.size(); ++i) {
            state *= ((Block)this.blocks.get(i)).calculateStructuralFunction(st);
        }
        return state;
    }

    public void setStateOfEqualBlocks(Block block) {
        for (int i = 0; i < this.blocks.size(); ++i) {
            ((Block)this.blocks.get(i)).setStateOfEqualBlocks(block);
        }
    }

    public String getLogicFunction() {
        String function = "";
        for (int i = 0; i < this.blocks.size(); ++i) {
            function = function + "(" + ((Block)this.blocks.get(i)).getLogicFunction() + ")";
            if (i + 1 >= this.blocks.size()) continue;
            function = function + "^";
        }
        return function;
    }

    public boolean calculateLogicFunction(SystemsFunction st) {
        boolean state = true;
        for (int i = 0; i < this.blocks.size(); ++i) {
            state = ((Block)this.blocks.get(i)).calculateLogicFunction(st) && state;
        }
        return state;
    }
}

