/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.modcs.tools.Util.ApplicationMath;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.blocks.bounds.BinaryDecisionDiagram;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.evaluatorrbd.SystemsFunction;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class BlockKOutOfN
extends Block
implements Serializable {
    private int n;
    private int k;
    private BlockExponential block;
    private int indexOfBlock;

    public BlockKOutOfN(String name, int n, int k, BlockExponential block, int indexOfBlock) {
        super(name);
        this.indexOfBlock = indexOfBlock;
        if (n >= k && n != 0 && k != 0) {
            this.n = n;
            this.k = k;
        } else {
            System.out.println("K-OUT-OF-N ERROR");
        }
        if (block != null) {
            this.block = block;
        } else {
            System.out.println("NULL POINTER");
        }
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(BlockExponential block) {
        if (this.block != null) {
            block.setFatherBlock(this);
            this.block = block;
        }
    }

    private double calculateBinomialProbability(double probability, int x) {
        return (double)ApplicationMath.calculateCombination(this.n, x) * Math.pow(probability, x) * Math.pow(1.0 - probability, this.n - x);
    }

    public double calculateReliability(double time) {
        if (this.block.getState().equals("DEFAULT")) {
            double reliabilityTemp = 0.0;
            for (int i = this.k; i <= this.n; ++i) {
                reliabilityTemp += this.calculateBinomialProbability(this.block.calculateReliability(time), i);
            }
            return reliabilityTemp;
        }
        if (this.block.getState().equals("WORKING")) {
            return 1.0;
        }
        return 0.0;
    }

    public double calculateAvailability(double time) {
        double availabilityTemp = 0.0;
        for (int i = this.k; i <= this.n; ++i) {
            availabilityTemp += this.calculateBinomialProbability(this.block.calculateAvailability(time), i);
        }
        return availabilityTemp;
    }

    public void updateJTree(DefaultMutableTreeNode nodeTree) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this);
        nodeTree.add(newNode);
        this.block.updateJTree(newNode);
    }

    public int getLengthX() {
        return this.block.getLengthX();
    }

    public int getLengthXPixels() {
        return this.block.getLengthXPixels();
    }

    public int getLengthYPixels() {
        return this.block.getLengthYPixels();
    }

    public int getLengthY() {
        return this.block.getLengthY();
    }

    public ConnectionBlock drawBlock(int x, int y) {
        this.block.setName(this.toString());
        return GraphViewRBD.drawBlock(this, x, y);
    }

    public double calculateMeanTimeToFailure() {
        double tempMTTF = 0.0;
        tempMTTF = this.block.calculateMeanTimeToFailure();
        for (int i = this.k; i <= this.n; ++i) {
            tempMTTF += (double)(1 / i);
        }
        return tempMTTF;
    }

    public boolean isBlockHasReliabilityEdited() {
        return this.block.isBlockHasReliabilityEdited();
    }

    public boolean isBlockHasMaintainabilityEdited() {
        return this.block.isBlockHasMaintainabilityEdited();
    }

    public String toString() {
        return "b" + this.indexOfBlock + " " + this.k + "/" + this.n;
    }

    public void copy(Block block) {
        if (block instanceof BlockKOutOfN) {
            this.block = ((BlockKOutOfN)block).block;
            this.fatherBlock = block.getFatherBlock();
            this.indexOfBlock = ((BlockKOutOfN)block).indexOfBlock;
            this.k = ((BlockKOutOfN)block).k;
            this.n = ((BlockKOutOfN)block).n;
            this.name = block.name;
            this.setEqualStateOfThis(block);
        }
    }

    public double calculateMeanTimeToRepair() {
        return (double)this.n * this.block.calculateMeanTimeToRepair() * (1.0 / this.block.calculateMeanTimeToFailure());
    }

    public Coeficient[] getCoeficientsMeanTimeToFailure() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MinimalPath[] getMinimalPaths() {
        MinimalPath[] minPaths = new MinimalPath[1];
        MinimalPath thisPath = new MinimalPath();
        thisPath.add(this);
        minPaths[0] = thisPath;
        return minPaths;
    }

    public int getNumberOfPaths() {
        return 1;
    }

    public MinimalCut[] getMinimalCuts() {
        MinimalCut[] minCuts = new MinimalCut[1];
        MinimalCut thisCut = new MinimalCut();
        thisCut.add(this);
        minCuts[0] = thisCut;
        return minCuts;
    }

    public int getNumberOfCuts() {
        return 1;
    }

    public BinaryDecisionDiagram generateBDD() {
        if (this.getNodeBDD() == null) {
            BinaryDecisionDiagram node = new BinaryDecisionDiagram(this);
            this.setNodeBDD(node);
        }
        return this.getNodeBDD();
    }

    public void clearBdd() {
        if (this.getNodeBDD() != null) {
            this.getNodeBDD().setHighNode(null);
            this.getNodeBDD().setLowNode(null);
        }
    }

    public String getStructuralFunction() {
        return this.getName();
    }

    public void setStateBroken() {
        this.setStateBroken();
        this.block.setStateBroken();
    }

    public void setStateWorking() {
        this.setStateWorking();
        this.block.setStateWorking();
    }

    public void setStateDefault() {
        this.setStateDefault();
        this.block.setStateDefault();
    }

    public int calculateStructuralFunction(SystemsFunction st) {
        if (this.isFailed()) {
            st.addOutageComponent(this.block);
            return 0;
        }
        return 1;
    }

    public void setStateOfEqualBlocks(Block block) {
        if (this.getName().equals(block.getName())) {
            this.setEqualStateOfThis(block);
        }
    }

    private void setEqualStateOfThis(Block block) {
        if (block.getState().equals("DEFAULT")) {
            this.setStateDefault();
        } else if (block.getState().equals("BROKEN")) {
            this.setStateBroken();
        } else if (block.getState().equals("WORKING")) {
            this.setStateWorking();
        }
    }

    public String getLogicFunction() {
        return this.getName();
    }

    public boolean calculateLogicFunction(SystemsFunction st) {
        if (this.isFailed()) {
            st.addOutageComponent(this.block);
            return false;
        }
        return true;
    }
}

