/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.bounds.BinaryDecisionDiagram;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.evaluatorrbd.RBDLabel;
import org.modcs.tools.rbd.evaluatorrbd.SystemsFunction;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;
import org.modcs.tools.rbd.gui.JDEditBlocks;

public class BlockExponential
extends Block
implements Serializable {
    private double failureRate;
    private double repairRate;
    private boolean isReliabilityEdited;
    private boolean isMaintainabilityEdited;
    private RBDLabel rBDLabelFailure;
    private RBDLabel rBDLabelRepair;

    public BlockExponential(String name, RBDLabel rBDLabelFailure, RBDLabel rBDLabelRepair) {
        this(name, 0.0, 0.0, rBDLabelFailure, rBDLabelRepair);
    }

    public BlockExponential(String name, double failureRate, double repairRate, RBDLabel rBDLabelFailure, RBDLabel rBDLabelRepair) {
        super(name);
        this.failureRate = failureRate;
        this.repairRate = repairRate;
        if (this.failureRate != 0.0 || rBDLabelFailure != null) {
            this.isReliabilityEdited = true;
        }
        if (this.repairRate != 0.0 || rBDLabelRepair != null) {
            this.isMaintainabilityEdited = true;
        }
        this.rBDLabelFailure = rBDLabelFailure;
        this.rBDLabelRepair = rBDLabelRepair;
        this.setStateDefault();
    }

    public void copy(Block block) {
        if (block instanceof BlockExponential) {
            this.name = block.name;
            this.failureRate = ((BlockExponential)block).failureRate;
            this.repairRate = ((BlockExponential)block).repairRate;
            this.rBDLabelFailure = ((BlockExponential)block).rBDLabelFailure;
            this.rBDLabelRepair = ((BlockExponential)block).rBDLabelRepair;
            this.isReliabilityEdited = ((BlockExponential)block).isReliabilityEdited;
            this.isMaintainabilityEdited = ((BlockExponential)block).isMaintainabilityEdited;
            this.setEqualStateOfThis(block);
        }
    }

    public boolean getIsReliabilityEdited() {
        return this.isReliabilityEdited;
    }

    public void setIsReliabilityEdited(boolean isReliabilityEdited) {
        this.isReliabilityEdited = isReliabilityEdited;
    }

    public boolean getIsMaintainabilityEdited() {
        return this.isMaintainabilityEdited;
    }

    public void setIsMaintainabilityEdited(boolean isMaintainabilityEdited) {
        this.isMaintainabilityEdited = isMaintainabilityEdited;
    }

    public double getFailureRate() {
        if (this.rBDLabelFailure == null) {
            return this.failureRate;
        }
        RBDLabel labelTemp = JDEditBlocks.getLabel(this.rBDLabelFailure.getName());
        if (labelTemp != null) {
            return 1.0 / labelTemp.getValue();
        }
        throw new IllegalArgumentException();
    }

    public void setFailureRate(double failureRate) {
        this.failureRate = failureRate;
    }

    public double getRepairRate() {
        if (this.rBDLabelRepair == null) {
            return this.repairRate;
        }
        RBDLabel labelTemp = JDEditBlocks.getLabel(this.rBDLabelRepair.getName());
        if (labelTemp != null) {
            return 1.0 / labelTemp.getValue();
        }
        throw new IllegalArgumentException();
    }

    public void setRepairRate(double repairRate) {
        this.repairRate = repairRate;
    }

    public double calculateReliability(double time) {
        if (this.getState().equals("DEFAULT")) {
            if (time > 0.0) {
                return Math.exp(-(this.getFailureRate() * time));
            }
            return 1.0;
        }
        if (this.getState().equals("WORKING")) {
            return 1.0;
        }
        return 0.0;
    }

    public double calculateMeanTimeToFailure() {
        if (this.getState().equals("DEFAULT")) {
            return 1.0 / this.getFailureRate();
        }
        if (this.getState().equals("WORKING")) {
            return Double.MAX_VALUE;
        }
        return 0.0;
    }

    public double calculateMeanTimeToRepair() {
        if (this.getState().equals("DEFAULT")) {
            return 1.0 / this.getRepairRate();
        }
        if (this.getState().equals("WORKING")) {
            return 0.0;
        }
        return Double.MAX_VALUE;
    }

    public Coeficient[] getCoeficientsMeanTimeToFailure() {
        Coeficient[] coeficient = new Coeficient[]{new Coeficient(1, this.getFailureRate())};
        return coeficient;
    }

    public double calculateAvailability(double time) {
        if (this.getState().equals("DEFAULT")) {
            return this.getRepairRate() / (this.getRepairRate() + this.getFailureRate()) + this.getFailureRate() / (this.getRepairRate() + this.getFailureRate()) * Math.exp(-(this.getFailureRate() + this.getRepairRate()) * time);
        }
        if (this.getState().equals("WORKING")) {
            return 1.0;
        }
        return 0.0;
    }

    public double calculateAvailability() {
        if (this.getState().equals("DEFAULT")) {
            return this.getRepairRate() / (this.getRepairRate() + this.failureRate);
        }
        if (this.getState().equals("WORKING")) {
            return 1.0;
        }
        return 0.0;
    }

    public void updateJTree(DefaultMutableTreeNode nodeTree) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this);
        nodeTree.add(newNode);
    }

    public int getLengthX() {
        return 1;
    }

    public int getLengthY() {
        return 1;
    }

    public RBDLabel getrBDLabelFailure() {
        return this.rBDLabelFailure;
    }

    public void setrBDLabelFailure(RBDLabel rBDLabelFailure) {
        this.rBDLabelFailure = rBDLabelFailure;
    }

    public RBDLabel getrBDLabelRepair() {
        return this.rBDLabelRepair;
    }

    public void setrBDLabelRepair(RBDLabel rBDLabelRepair) {
        this.rBDLabelRepair = rBDLabelRepair;
    }

    public int getLengthXPixels() {
        return GraphViewRBD.BLOCK_SIZE_X;
    }

    public int getLengthYPixels() {
        return GraphViewRBD.BLOCK_SIZE_Y;
    }

    public ConnectionBlock drawBlock(int x, int y) {
        return GraphViewRBD.drawBlock(this, x, y);
    }

    public boolean isBlockHasReliabilityEdited() {
        return this.isReliabilityEdited;
    }

    public boolean isBlockHasMaintainabilityEdited() {
        return this.isMaintainabilityEdited;
    }

    public MinimalPath[] getMinimalPaths() {
        MinimalPath[] minPaths = new MinimalPath[1];
        MinimalPath thisPath = new MinimalPath();
        thisPath.add(this);
        minPaths[0] = thisPath;
        return minPaths;
    }

    public int getNumberOfPaths() {
        return 1;
    }

    public MinimalCut[] getMinimalCuts() {
        MinimalCut[] minCuts = new MinimalCut[1];
        MinimalCut thisCut = new MinimalCut();
        thisCut.add(this);
        minCuts[0] = thisCut;
        return minCuts;
    }

    public int getNumberOfCuts() {
        return 1;
    }

    public BinaryDecisionDiagram generateBDD() {
        if (this.getNodeBDD() == null) {
            BinaryDecisionDiagram node = new BinaryDecisionDiagram(this);
            this.setNodeBDD(node);
        }
        return this.getNodeBDD();
    }

    public void clearBdd() {
        if (this.getNodeBDD() != null) {
            this.getNodeBDD().setHighNode(null);
            this.getNodeBDD().setLowNode(null);
        }
    }

    public String getStructuralFunction() {
        return this.getName();
    }

    public int calculateStructuralFunction(SystemsFunction st) {
        if (this.isFailed()) {
            st.addOutageComponent(this);
            return 0;
        }
        return 1;
    }

    public void setStateOfEqualBlocks(Block block) {
        if (this.getName().equals(block.getName())) {
            this.setEqualStateOfThis(block);
        }
    }

    private void setEqualStateOfThis(Block block) {
        if (block.getState().equals("DEFAULT")) {
            this.setStateDefault();
        } else if (block.getState().equals("BROKEN")) {
            this.setStateBroken();
        } else if (block.getState().equals("WORKING")) {
            this.setStateWorking();
        }
    }

    public String getLogicFunction() {
        return this.getName();
    }

    public boolean calculateLogicFunction(SystemsFunction st) {
        if (this.isFailed()) {
            st.addOutageComponent(this);
            return false;
        }
        return true;
    }
}

