/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.modcs.tools.Util.ArrayListOperation;
import org.modcs.tools.rbd.blocks.Block;
import org.modcs.tools.rbd.blocks.BlockExponential;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockChain
extends Block
implements Serializable {
    protected ArrayList<Block> blocks = new ArrayList();
    public static double sum = 0.0;

    public BlockChain(String name) {
        super(name);
    }

    public ArrayList<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<Block> val) {
        this.blocks = val;
    }

    public void addBlock(Block block) {
        block.setFatherBlock(this);
        ArrayListOperation.addBlock(this.blocks, block);
    }

    @Override
    public void updateJTree(DefaultMutableTreeNode nodeTree) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(this);
        nodeTree.add(newNode);
        for (int i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).updateJTree(newNode);
        }
    }

    @Override
    public abstract double calculateReliability(double var1);

    @Override
    public abstract double calculateMeanTimeToFailure();

    @Override
    public double calculateMeanTimeToRepair() {
        double tempMTTR = 0.0;
        double sumOfFailureRate = 0.0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            tempMTTR += this.blocks.get(i).calculateMeanTimeToRepair() * (1.0 / this.blocks.get(i).calculateMeanTimeToFailure());
            sumOfFailureRate += 1.0 / this.blocks.get(i).calculateMeanTimeToFailure();
        }
        return tempMTTR / sumOfFailureRate;
    }

    public double calculateMeanTimeToRepair2() {
        double tempMTTR = 0.0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (this.blocks.get(i) instanceof BlockExponential) {
                tempMTTR += this.blocks.get(i).calculateMeanTimeToRepair() * 1.0 / this.blocks.get(i).calculateMeanTimeToFailure();
                sum += 1.0 / this.blocks.get(i).calculateMeanTimeToFailure();
                continue;
            }
            tempMTTR += ((BlockChain)this.blocks.get(i)).calculateMeanTimeToRepair2();
        }
        return tempMTTR;
    }

    @Override
    public abstract double calculateAvailability(double var1);

    @Override
    public abstract ConnectionBlock drawBlock(int var1, int var2);

    @Override
    public boolean isBlockHasReliabilityEdited() {
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (this.blocks.get(i).isBlockHasReliabilityEdited()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBlockHasMaintainabilityEdited() {
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (this.blocks.get(i).isBlockHasMaintainabilityEdited()) continue;
            return false;
        }
        return true;
    }
}

