/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.rbd.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.modcs.tools.Util.Coeficient;
import org.modcs.tools.rbd.blocks.bounds.BinaryDecisionDiagram;
import org.modcs.tools.rbd.blocks.bounds.MinimalCut;
import org.modcs.tools.rbd.blocks.bounds.MinimalPath;
import org.modcs.tools.rbd.evaluatorrbd.SystemsFunction;
import org.modcs.tools.rbd.graphrbd.ConnectionBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Block
implements Serializable {
    protected String name;
    protected Block fatherBlock;
    private String state = "DEFAULT";
    private ArrayList<Integer> previewsNode;
    private ArrayList<Integer> nextNode;
    private BinaryDecisionDiagram bdd;

    public Block(String name) {
        this.name = name;
        this.previewsNode = new ArrayList();
        this.nextNode = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFatherBlock(Block fatherBlock) {
        this.fatherBlock = fatherBlock;
    }

    public Block getFatherBlock() {
        return this.fatherBlock;
    }

    public abstract double calculateReliability(double var1);

    public abstract double calculateMeanTimeToFailure();

    public abstract Coeficient[] getCoeficientsMeanTimeToFailure();

    public abstract double calculateMeanTimeToRepair();

    public abstract double calculateAvailability(double var1);

    public abstract boolean isBlockHasReliabilityEdited();

    public abstract boolean isBlockHasMaintainabilityEdited();

    public abstract void updateJTree(DefaultMutableTreeNode var1);

    public abstract int getLengthX();

    public abstract int getLengthY();

    public abstract int getLengthXPixels();

    public abstract int getLengthYPixels();

    public abstract ConnectionBlock drawBlock(int var1, int var2);

    public abstract void copy(Block var1);

    public abstract MinimalPath[] getMinimalPaths();

    public abstract MinimalCut[] getMinimalCuts();

    public abstract int getNumberOfPaths();

    public abstract int getNumberOfCuts();

    public abstract BinaryDecisionDiagram generateBDD();

    public abstract void clearBdd();

    public abstract void setStateOfEqualBlocks(Block var1);

    public abstract String getStructuralFunction();

    public abstract int calculateStructuralFunction(SystemsFunction var1);

    public abstract String getLogicFunction();

    public abstract boolean calculateLogicFunction(SystemsFunction var1);

    public String toString() {
        return this.getName();
    }

    public ArrayList<Integer> getPreviewsNode() {
        return this.previewsNode;
    }

    public void addPreviewsNodes(ArrayList<Integer> newPreviewsNodes) {
        for (int i = 0; i < newPreviewsNodes.size(); ++i) {
            if (this.previewsNode.contains(newPreviewsNodes.get(i))) continue;
            this.previewsNode.add(newPreviewsNodes.get(i));
        }
    }

    public ArrayList<Integer> getNextNode() {
        return this.nextNode;
    }

    public void addNextNodes(ArrayList<Integer> newNextNodes) {
        for (int i = 0; i < newNextNodes.size(); ++i) {
            if (this.nextNode.contains(newNextNodes.get(i))) continue;
            this.nextNode.add(newNextNodes.get(i));
        }
    }

    public boolean clearNodes() {
        try {
            this.nextNode.clear();
            this.previewsNode.clear();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BinaryDecisionDiagram getNodeBDD() {
        return this.bdd;
    }

    public void setNodeBDD(BinaryDecisionDiagram node) {
        this.bdd = node;
    }

    public String getState() {
        return this.state;
    }

    public void setStateBroken() {
        this.state = "BROKEN";
    }

    public void setStateWorking() {
        this.state = "WORKING";
    }

    public void setStateDefault() {
        this.state = "DEFAULT";
    }

    public boolean isFailed() {
        return this.state.equals("BROKEN");
    }
}

