/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.Util.booleanreduction;

import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.modcs.tools.Util.booleanreduction.BitManipulation;
import org.modcs.tools.Util.booleanreduction.CharStack;
import org.modcs.tools.Util.booleanreduction.ProductTerm;

public class TruthTable
extends AbstractTableModel {
    static final long serialVersionUID = 4284762403096738378L;
    protected static final char LP = '(';
    protected static final char RP = ')';
    protected static final char AND = '*';
    protected static final char OR = '+';
    protected static final char XOR = '^';
    protected static final char NOT = '\'';
    protected static final char ZERO = '0';
    protected static final char ONE = '1';
    protected int numVars = 0;
    protected int numRows = 0;
    protected int numMinterms = 0;
    protected char[] variableNames = null;
    protected char[] namesReversed;
    protected String normalized = "Not Given";
    protected boolean[] theTable = null;
    protected int mintermMask;
    protected ProductTerm[] minterms = null;

    public int getNumVars() {
        return this.numVars;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumMinterms() {
        return this.numMinterms;
    }

    public int getRowCount() {
        return this.numMinterms;
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return new Integer(this.minterms[row].getValue());
            }
            case 1: {
                return this.minterms[row].toString();
            }
        }
        throw new RuntimeException("Program Error: Bad switch");
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Minterm Number";
            }
            case 1: {
                return "Product Term";
            }
        }
        throw new RuntimeException("Program Error: Bad switch");
    }

    public char[] getVars() {
        char[] v = new char[this.numVars];
        System.arraycopy(this.variableNames, 0, v, 0, this.numVars);
        return v;
    }

    public String expString() {
        return this.normalized;
    }

    public boolean[] getTruthValues() {
        return this.theTable;
    }

    public ProductTerm[] getMinterms() {
        return this.minterms;
    }

    public TruthTable(String str) {
        int i;
        char x;
        int i2;
        char x2;
        int i3;
        StringBuffer sb = new StringBuffer(str.trim());
        for (i3 = 0; i3 < sb.length(); ++i3) {
            x2 = sb.charAt(i3);
            if (x2 == ' ') {
                sb.deleteCharAt(i3--);
                continue;
            }
            if (Character.isLetter(x2) || x2 == '(' || x2 == ')' || x2 == '\'' || x2 == '*' || x2 == '+' || x2 == '^' || x2 == '0' || x2 == '1') continue;
            throw new RuntimeException("Invalid character in expression: " + x2 + "\n" + "  * = AND\n  + = OR\n  ^ = XOR\n  ' = NOT (postfix)\n" + "  Parentheses, 0, and 1 are okay too.");
        }
        for (i3 = 0; i3 < sb.length() - 1; ++i3) {
            boolean isOperandY;
            x2 = sb.charAt(i3);
            char y = sb.charAt(i3 + 1);
            if (x2 == '(' && y == ')') {
                sb.insert(i3 + 1, '1');
                continue;
            }
            boolean isOperandX = Character.isLetter(x2) || x2 == '0' || x2 == '1';
            boolean bl = isOperandY = Character.isLetter(y) || y == '0' || y == '1';
            if ((x2 != ')' || y != '(' && !isOperandY) && (!isOperandX || y != '(' && !isOperandY) && (x2 != '\'' || y != '(' && !isOperandY)) continue;
            sb.insert(i3 + 1, '*');
        }
        int parens = 0;
        for (i2 = 0; i2 < sb.length(); ++i2) {
            x = sb.charAt(i2);
            if (x == '(') {
                ++parens;
            }
            if (x == ')') {
                --parens;
            }
            if (parens >= 0) continue;
            throw new RuntimeException("Badly nested parentheses");
        }
        if (parens != 0) {
            throw new RuntimeException("Unbalanced parentheses");
        }
        this.normalized = new String(sb);
        this.variableNames = new char[2];
        for (i2 = 0; i2 < sb.length(); ++i2) {
            x = sb.charAt(i2);
            if (!Character.isLetter(x)) continue;
            boolean found = false;
            for (int v = 0; v < this.numVars; ++v) {
                if (x != this.variableNames[v]) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (this.numVars == this.variableNames.length) {
                char[] newVars = new char[2 * this.variableNames.length];
                System.arraycopy(this.variableNames, 0, newVars, 0, this.variableNames.length);
                this.variableNames = newVars;
                newVars = null;
            }
            this.variableNames[this.numVars++] = x;
        }
        char[] newVars = new char[this.numVars];
        System.arraycopy(this.variableNames, 0, newVars, 0, this.numVars);
        this.variableNames = newVars;
        newVars = null;
        Arrays.sort(this.variableNames, 0, this.numVars);
        this.namesReversed = new char[this.numVars];
        for (i = 0; i < this.numVars; ++i) {
            this.namesReversed[i] = this.variableNames[this.numVars - i - 1];
        }
        this.numRows = this.numVars > 0 ? (int)Math.pow(2.0, this.numVars) : 1;
        this.theTable = new boolean[this.numRows];
        this.numMinterms = 0;
        for (i = 0; i < this.numRows; ++i) {
            this.theTable[i] = this.evaluateBoolean(BitManipulation.reverseBits(i, this.numVars), this.variableNames, this.normalized);
            if (!this.theTable[i]) continue;
            ++this.numMinterms;
        }
        this.minterms = new ProductTerm[this.numMinterms];
        this.mintermMask = (int)Math.pow(2.0, this.numVars) - 1;
        int m = 0;
        for (int i4 = 0; i4 < this.numRows; ++i4) {
            if (!this.theTable[i4]) continue;
            this.minterms[m++] = new ProductTerm(i4, this.mintermMask, this.variableNames);
        }
        int swapped = -1;
        do {
            for (int i5 = swapped = 0; i5 < this.minterms.length - 1; ++i5) {
                if (this.minterms[i5].getValue() <= this.minterms[i5 + 1].getValue()) continue;
                ProductTerm temp = this.minterms[i5];
                this.minterms[i5] = this.minterms[i5 + 1];
                this.minterms[i5 + 1] = temp;
                swapped = i5 + 1;
            }
        } while (swapped != 0);
    }

    public TruthTable(int[] mintermNumbers) {
        int i;
        int lb;
        this.numMinterms = mintermNumbers.length;
        if (this.numMinterms == 0) {
            this.numVars = 0;
            this.numRows = 0;
            this.variableNames = new char[0];
            this.namesReversed = this.variableNames;
            this.normalized = "";
            this.theTable = new boolean[0];
            this.mintermMask = 0;
            this.minterms = new ProductTerm[0];
            return;
        }
        Arrays.sort(mintermNumbers);
        int maxMintermNumber = mintermNumbers[this.numMinterms - 1];
        if (maxMintermNumber < 0) {
            maxMintermNumber = 0;
        }
        if ((lb = TruthTable.leftBit(maxMintermNumber)) < 0) {
            lb = 0;
        }
        this.numRows = (int)Math.pow(2.0, lb + 1);
        this.mintermMask = this.numRows - 1;
        this.numVars = (int)Math.ceil(Math.log(this.numRows) / Math.log(2.0));
        this.variableNames = new char[this.numVars];
        for (i = 0; i < this.numVars; ++i) {
            this.variableNames[i] = (char)(97 + i);
        }
        this.theTable = new boolean[this.numRows];
        Arrays.fill(this.theTable, false);
        this.minterms = new ProductTerm[this.numMinterms];
        for (i = 0; i < this.numMinterms; ++i) {
            this.theTable[mintermNumbers[i]] = true;
            this.minterms[i] = new ProductTerm(mintermNumbers[i], this.mintermMask, this.variableNames);
        }
    }

    protected boolean evaluateBoolean(int value, char[] variableNames, String exp) {
        int i;
        StringBuffer sb = new StringBuffer(exp);
        for (int v = 0; v < this.numVars; ++v) {
            char val = (1 << v & value) == 0 ? (char)'0' : '1';
            for (i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != variableNames[v]) continue;
                sb.setCharAt(i, val);
            }
        }
        CharStack operator = new CharStack();
        CharStack operand = new CharStack();
        block10: for (i = 0; i < sb.length(); ++i) {
            char x = sb.charAt(i);
            switch (x) {
                case '(': {
                    operator.push(x);
                    continue block10;
                }
                case ')': {
                    char op;
                    while ((op = operator.pop()) != '(') {
                        this.eval(operand, op);
                    }
                    continue block10;
                }
                case '\'': {
                    if (operand.isEmpty()) {
                        throw new RuntimeException("Syntax Error: Postfix NOT with no operand");
                    }
                    char arg = operand.pop();
                    operand.push(arg == '0' ? (char)'1' : '0');
                    continue block10;
                }
                case '*': {
                    if (operator.peek() == '\'') {
                        this.eval(operand, operator.pop());
                    }
                    operator.push(x);
                    continue block10;
                }
                case '+': 
                case '^': {
                    if (operator.peek() == '\'') {
                        this.eval(operand, operator.pop());
                    }
                    while (operator.peek() == '*') {
                        this.eval(operand, operator.pop());
                    }
                    operator.push(x);
                    continue block10;
                }
                case '0': 
                case '1': {
                    operand.push(x);
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Program Error: BadSwitch");
                }
            }
        }
        while (!operator.isEmpty()) {
            this.eval(operand, operator.pop());
        }
        return operand.pop() == '1';
    }

    protected void eval(CharStack operand, char operator) {
        switch (operator) {
            case '*': {
                if (operand.isEmpty()) {
                    throw new RuntimeException("Syntax Error: AND with no operands.");
                }
                char arg_1 = operand.pop();
                if (operand.isEmpty()) {
                    throw new RuntimeException("Syntax Error: AND missing right operand.");
                }
                char arg_2 = operand.pop();
                operand.push((char)(arg_1 == '1' && arg_2 == '1' ? 49 : 48));
                break;
            }
            case '+': {
                if (operand.isEmpty()) {
                    throw new RuntimeException("Syntax Error: OR with no operands.");
                }
                char arg_1 = operand.pop();
                if (operand.isEmpty()) {
                    throw new RuntimeException("Syntax Error: OR missing right operand.");
                }
                char arg_2 = operand.pop();
                operand.push((char)(arg_1 == '1' || arg_2 == '1' ? 49 : 48));
                break;
            }
            case '^': {
                if (operand.isEmpty()) {
                    throw new RuntimeException("Syntax Error: XOR with no operands.");
                }
                char arg_1 = operand.pop();
                if (operand.isEmpty()) {
                    throw new RuntimeException("Syntax Error: XOR missing right operand.");
                }
                char arg_2 = operand.pop();
                operand.push(arg_1 == '1' && arg_2 == '0' || arg_1 == '0' && arg_2 == '1' ? (char)'1' : '0');
                break;
            }
            default: {
                throw new RuntimeException("Program Error: " + operator + " is not an operator");
            }
        }
    }

    public static int leftBit(int x) {
        for (int i = 31; i >= 0; --i) {
            if ((x & 1 << i) == 0) continue;
            return i;
        }
        return -1;
    }

    public String sopString() {
        StringBuffer sb = new StringBuffer();
        for (int s = 0; s < this.numMinterms; ++s) {
            sb.append(this.minterms[s].toString());
            if (s >= this.numMinterms - 1) continue;
            sb.append(" + ");
        }
        return new String(sb);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        for (int m = 0; m < this.minterms.length; ++m) {
            sb.append(this.minterms[m].value + ",");
        }
        if (this.minterms.length == 0) {
            sb.append(']');
        } else {
            sb.setCharAt(sb.length() - 1, ']');
        }
        return new String(sb);
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.err.println("Usage: java TruthTable <boolean expression>");
            System.err.println("       java TruthTable <list of minterms>");
            System.exit(1);
        }
        int minterm_1 = -1;
        try {
            minterm_1 = Integer.parseInt(argv[0]);
        }
        catch (NumberFormatException nfe) {
            minterm_1 = -1;
        }
        if (argv.length == 1 && minterm_1 == -1) {
            System.out.println(new TruthTable(argv[0]));
            System.exit(0);
        }
        int[] minterms = new int[argv.length];
        int i = 0;
        try {
            for (i = 0; i < argv.length; ++i) {
                minterms[i] = Integer.parseInt(argv[i]);
                for (int j = 0; j < i; ++j) {
                    if (minterms[i] != minterms[j]) continue;
                    System.err.println("Error: " + minterms[i] + " is a duplicate minterm.");
                    System.exit(1);
                }
            }
            System.out.println(new TruthTable(minterms));
            System.exit(0);
        }
        catch (NumberFormatException nfe) {
            System.err.println("Error: " + argv[i] + " is not a valid minterm number.");
            System.exit(1);
        }
    }
}

