/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.Util.booleanreduction;

import org.modcs.tools.Util.booleanreduction.BitManipulation;

public class ProductTerm
implements Comparable {
    public static final ProductTerm identity = new ProductTerm(0, 0, new char[0]);
    int value;
    int mask;
    int numLiterals;
    char[] variableNames;
    int numVars;
    int coverCount;

    public ProductTerm(int value, int mask, char[] variableNames) {
        this.value = value;
        this.mask = mask;
        this.numLiterals = BitManipulation.countBits(mask);
        this.variableNames = variableNames;
        this.numVars = variableNames.length;
        this.coverCount = 0;
    }

    public int getValue() {
        return this.value;
    }

    public int getMask() {
        return this.mask;
    }

    public char[] getVariableNames() {
        return this.variableNames;
    }

    public int getNumLiterals() {
        return this.numLiterals;
    }

    public boolean isMinterm() {
        return this.numLiterals == this.numVars;
    }

    public void clearCoverCount() {
        this.coverCount = 0;
    }

    public void incrementCoverCount() {
        ++this.coverCount;
    }

    public int getCoverCount() {
        return this.coverCount;
    }

    public int compareTo(Object x) {
        return ((ProductTerm)x).numLiterals - this.numLiterals;
    }

    public ProductTerm reduces(ProductTerm target) {
        if (target.mask == this.mask) {
            if (this.mask == 0) {
                return identity;
            }
            int difference = target.value & this.mask ^ this.value & this.mask;
            if (1 == BitManipulation.countBits(difference)) {
                ProductTerm reduced = new ProductTerm(~difference & this.value, ~difference & this.mask, this.variableNames);
                return reduced;
            }
        }
        return null;
    }

    public boolean equals(ProductTerm target) {
        return this.value == target.getValue() && this.mask == target.getMask();
    }

    public boolean covers(ProductTerm target) {
        return (this.value & this.mask) == (target.getValue() & this.mask);
    }

    public String ptString() {
        if (this.mask == 0) {
            return "1";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = this.numVars - 1; i >= 0; --i) {
            if ((this.mask & 1 << i) == 0) continue;
            sb.append(this.variableNames[this.numVars - 1 - i]);
            if ((this.value & 1 << i) != 0) continue;
            sb.append('\'');
        }
        return new String(sb);
    }

    public int getMinimizedValue() {
        return ~this.mask;
    }

    public String toString() {
        return this.ptString();
    }
}

