/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.Util.booleanreduction;

import java.util.Vector;
import org.modcs.tools.Util.booleanreduction.ProductTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimeImplicant
extends ProductTerm
implements Comparable {
    protected Vector<ProductTerm> covers = new Vector();

    public PrimeImplicant(ProductTerm pt, ProductTerm[] minterms) {
        super(pt.getValue(), pt.getMask(), pt.getVariableNames());
        boolean found = false;
        for (int m = 0; m < minterms.length; ++m) {
            if (!this.covers(minterms[m])) continue;
            found = true;
            this.covers.add(minterms[m]);
        }
        if (!found) {
            throw new RuntimeException("Attempt to create a prime implicant that covers no minterms.");
        }
    }

    public void addCover(ProductTerm pt) {
        if (!pt.isMinterm()) {
            throw new RuntimeException("Attempt to add " + pt.toString() + " to the list of minterms covered by prime implicant " + super.toString() + ", but " + pt.toString() + " is not a minterm.");
        }
        if (!this.covers(pt)) {
            throw new RuntimeException("Attempt to add " + pt + " to the list of minterms covered by prime implicant " + super.toString() + ", but " + pt + " is not covered by " + super.toString());
        }
        this.covers.add(pt);
    }

    public void removeCover(ProductTerm pt) {
        this.covers.removeElement(pt);
    }

    public Vector<ProductTerm> getCovers() {
        return this.covers;
    }

    @Override
    public int getCoverCount() {
        return this.covers.size();
    }

    public String getImplicantString() {
        return super.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[ " + super.toString() + " => ");
        for (int i = 0; i < this.covers.size(); ++i) {
            sb.append(this.covers.elementAt(i));
            if (i >= this.covers.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" ]");
        return new String(sb);
    }
}

