/*
 * Decompiled with CFR 0.152.
 */
package org.modcs.tools.Util.booleanreduction;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.modcs.tools.Util.booleanreduction.BitManipulation;
import org.modcs.tools.Util.booleanreduction.PrimeImplicant;
import org.modcs.tools.Util.booleanreduction.ProductTerm;
import org.modcs.tools.Util.booleanreduction.TruthTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimizedTable
extends TruthTable {
    static final long serialVersionUID = 6365229939599366603L;
    protected final int numLevels;
    protected Vector<ProductTerm>[] levelTerms;
    protected Vector<PrimeImplicant> primeImplicants;
    Vector<ProductTerm> minimum;

    @Override
    public int getRowCount() {
        return this.primeImplicants.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Vector<ProductTerm> getMinimum() {
        return this.minimum;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Prime Implicant";
            }
            case 1: {
                return "Implied Terms";
            }
        }
        throw new RuntimeException("Program Error: Bad switch");
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.primeImplicants.elementAt(row).getImplicantString();
            }
            case 1: {
                return this.primeImplicants.elementAt(row).getCovers();
            }
        }
        throw new RuntimeException("Program Error: Bad switch");
    }

    public MinimizedTable(String s) {
        super(s);
        this.numLevels = this.numVars + 1;
        this.levelTerms = new Vector[this.numLevels];
        this.minimizeIt();
    }

    public MinimizedTable(int[] m) {
        super(m);
        this.numLevels = this.numVars + 1;
        this.levelTerms = new Vector[this.numLevels];
        this.minimizeIt();
    }

    private void minimizeIt() {
        this.levelTerms[0] = new Vector();
        for (int m = 0; m < this.numMinterms; ++m) {
            this.levelTerms[0].add(this.minterms[m]);
        }
        ProductTerm targetTerm = null;
        ProductTerm candidateTerm = null;
        ProductTerm reducedTerm = null;
        int level = 0;
        if (this.numVars > 0) {
            block1: for (level = 1; level < this.numLevels; ++level) {
                int numReduced = 0;
                this.levelTerms[level] = new Vector();
                Enumeration<ProductTerm> termsToReduce = this.levelTerms[level - 1].elements();
                while (termsToReduce.hasMoreElements()) {
                    targetTerm = termsToReduce.nextElement();
                    boolean isReduced = false;
                    Enumeration<ProductTerm> candidateTerms = this.levelTerms[level - 1].elements();
                    while (candidateTerms.hasMoreElements()) {
                        candidateTerm = candidateTerms.nextElement();
                        reducedTerm = candidateTerm.reduces(targetTerm);
                        if (reducedTerm == null) continue;
                        ++numReduced;
                        boolean found = false;
                        Enumeration<ProductTerm> e = this.levelTerms[level].elements();
                        while (e.hasMoreElements()) {
                            if (!reducedTerm.equals(e.nextElement())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.levelTerms[level].add(reducedTerm);
                            if (ProductTerm.identity.equals(reducedTerm)) break block1;
                        }
                        isReduced = true;
                    }
                    if (isReduced) continue;
                    this.levelTerms[level].add(targetTerm);
                }
                if (numReduced == 0) break;
            }
        }
        this.primeImplicants = new Vector();
        Enumeration<ProductTerm> piEnum = this.levelTerms[level].elements();
        while (piEnum.hasMoreElements()) {
            PrimeImplicant pi = new PrimeImplicant(piEnum.nextElement(), this.minterms);
            this.primeImplicants.add(pi);
        }
        Collections.sort(this.primeImplicants);
        Vector<ProductTerm> uncoveredMinterms = new Vector<ProductTerm>(this.minterms.length);
        Vector<PrimeImplicant> unusedPrimeImplicants = new Vector<PrimeImplicant>(this.primeImplicants);
        for (int m = 0; m < this.numMinterms; ++m) {
            ProductTerm mt = this.minterms[m];
            uncoveredMinterms.add(mt);
            int numCovers = this.countCovers(mt, unusedPrimeImplicants);
        }
        this.minimum = new Vector();
        while (uncoveredMinterms.size() > 0) {
            while (this.addEssentialPrimeImplicants(this.minimum, uncoveredMinterms, unusedPrimeImplicants)) {
            }
            this.doDomination(unusedPrimeImplicants, uncoveredMinterms);
            if (uncoveredMinterms.size() == 0) break;
            ProductTerm least = uncoveredMinterms.elementAt(0);
            int min = this.countCovers(least, unusedPrimeImplicants);
            for (int m = 1; m < uncoveredMinterms.size(); ++m) {
                ProductTerm minterm = uncoveredMinterms.elementAt(m);
                int numCovers = this.countCovers(minterm, unusedPrimeImplicants);
                if (numCovers >= min) continue;
                least = minterm;
                min = numCovers;
            }
            for (int p = 0; p < unusedPrimeImplicants.size(); ++p) {
                PrimeImplicant pi = unusedPrimeImplicants.elementAt(p);
                if (!pi.covers(least)) continue;
                this.minimum.add(pi);
                unusedPrimeImplicants.remove(pi);
                Enumeration<ProductTerm> e = pi.getCovers().elements();
                while (e.hasMoreElements()) {
                    ProductTerm pt = e.nextElement();
                    boolean removed = uncoveredMinterms.remove(pt);
                }
            }
        }
    }

    private boolean addEssentialPrimeImplicants(Vector<ProductTerm> minimum, Vector<ProductTerm> minterms, Vector<PrimeImplicant> primeImplicants) {
        for (int m = 0; m < minterms.size(); ++m) {
            ProductTerm minterm = minterms.elementAt(m);
            int numCovers = this.countCovers(minterm, primeImplicants);
            if (numCovers != 1) continue;
            for (int p = 0; p < primeImplicants.size(); ++p) {
                PrimeImplicant pi = primeImplicants.elementAt(p);
                if (!pi.covers(minterm)) continue;
                minimum.add(pi);
                primeImplicants.remove(pi);
                Enumeration<ProductTerm> e = pi.getCovers().elements();
                while (e.hasMoreElements()) {
                    boolean removed = minterms.remove(e.nextElement());
                }
                return true;
            }
        }
        return false;
    }

    private void doDomination(Vector<PrimeImplicant> primeImplicants, Vector<ProductTerm> minterms) {
        boolean piDominated = true;
        block0: while (piDominated) {
            piDominated = false;
            int numPI = primeImplicants.size();
            Vector[] implies = new Vector[numPI];
            boolean[] dominated = new boolean[numPI];
            Arrays.fill(dominated, false);
            for (int pix = 0; pix < numPI; ++pix) {
                PrimeImplicant pi = primeImplicants.elementAt(pix);
                implies[pix] = new Vector();
                for (int m = 0; m < minterms.size(); ++m) {
                    if (!pi.covers(minterms.elementAt(m))) continue;
                    implies[pix].add(minterms.elementAt(m));
                }
            }
            for (int i = 0; i < numPI; ++i) {
                for (int j = 0; j < numPI; ++j) {
                    if (i == j || !implies[i].containsAll(implies[j]) || implies[i].size() <= implies[j].size()) continue;
                    primeImplicants.removeElementAt(j);
                    piDominated = true;
                    break block0;
                }
            }
        }
    }

    private int countCovers(ProductTerm minterm, Vector<PrimeImplicant> primeImplicants) {
        minterm.clearCoverCount();
        Enumeration<PrimeImplicant> e = primeImplicants.elements();
        while (e.hasMoreElements()) {
            PrimeImplicant pi = e.nextElement();
            if (!pi.covers(minterm)) continue;
            minterm.incrementCoverCount();
        }
        int numCovers = minterm.getCoverCount();
        if (numCovers == 0) {
            throw new RuntimeException("Minterm " + BitManipulation.reverseBits(minterm.value, this.numVars) + " is not covered by any prime implicants.");
        }
        return numCovers;
    }

    public String priString() {
        if (0 == this.primeImplicants.size()) {
            return "none";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.primeImplicants.size(); ++i) {
            sb.append(this.primeImplicants.elementAt(i).toString());
            if (i >= this.primeImplicants.size() - 1) continue;
            sb.append(", ");
        }
        return new String(sb);
    }

    @Override
    public String toString() {
        if (0 == this.minimum.size()) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.minimum.size(); ++i) {
            ProductTerm pt = this.minimum.elementAt(i);
            sb.append(pt.ptString());
            if (i >= this.minimum.size() - 1) continue;
            sb.append(" + ");
        }
        return new String(sb);
    }
}

