/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.sustainability.gui;

import com.hp.desdac.sustainability.SustainabilityResults;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDialogSustainabilityResults
extends JDialog {
    private ArrayList<SustainabilityResults> arraySustainabilityResults;
    private JButton jButtonClose;
    private JButton jButtonPlotGraph;
    private JButton jButton_Export;
    private JComboBox jComboBoxGraphParameters;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public JDialogSustainabilityResults(Frame parent, boolean modal, String results) {
        super(parent, modal);
        this.initComponents();
        this.jTextArea1.setText(results);
    }

    public JDialogSustainabilityResults(Frame parent, boolean modal, String results, ArrayList<SustainabilityResults> arraySustainabilityResults) {
        super(parent, modal);
        this.initComponents();
        this.jTextArea1.setText(results);
        this.arraySustainabilityResults = new ArrayList<SustainabilityResults>(arraySustainabilityResults);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButtonClose = new JButton();
        this.jButton_Export = new JButton();
        this.jButtonPlotGraph = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxGraphParameters = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Sustainability Evaluation Results");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Sustainability Results"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 404, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE).addContainerGap()));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityResults.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButton_Export.setText("Export");
        this.jButton_Export.setToolTipText("Export to Excel");
        this.jButton_Export.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityResults.this.jButton_ExportActionPerformed(evt);
            }
        });
        this.jButtonPlotGraph.setText("Plot Graph");
        this.jButtonPlotGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityResults.this.jButtonPlotGraphActionPerformed(evt);
            }
        });
        this.jComboBoxGraphParameters.setModel(new DefaultComboBoxModel<String>(new String[]{"Select a Metric", "Exergy", "TCO", "Availability", "System Efficiency"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButtonClose).addGap(18, 18, 18).addComponent(this.jButton_Export).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBoxGraphParameters, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonPlotGraph).addGap(11, 11, 11)).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButton_Export).addComponent(this.jComboBoxGraphParameters, -2, -1, -2).addComponent(this.jButtonPlotGraph))).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jLabel1))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private static HSSFWorkbook readFile(String filename) throws IOException {
        return new HSSFWorkbook((InputStream)new FileInputStream(filename));
    }

    private void jButton_ExportActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
            fc.setFileSelectionMode(0);
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.getName() == null) {
                        return false;
                    }
                    if (f.getName().endsWith(".xls")) {
                        return true;
                    }
                    return f.isDirectory();
                }

                public String getDescription() {
                    return "excel files (.xls)";
                }
            };
            fc.setFileFilter(fileFilter);
            fc.showSaveDialog(this);
            File file = fc.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!file.getName().endsWith(".xls")) {
                file = new File(file.getAbsolutePath() + ".xls");
            }
            if (file.length() > 0L) {
                HSSFWorkbook wb = JDialogSustainabilityResults.readFile(file.getAbsolutePath());
                HSSFSheet sheet = wb.getSheetAt(0);
                int rows = sheet.getPhysicalNumberOfRows();
                int cells = 0;
                for (int r = 0; r < rows; ++r) {
                    int cell;
                    HSSFRow row = sheet.getRow(r);
                    if (row == null || (cell = row.getPhysicalNumberOfCells()) <= cells) continue;
                    cells = cell;
                }
                HSSFRow r = null;
                HSSFCell c = null;
                String data = this.jTextArea1.getText();
                String[] dataString = data.split("\n");
                for (int i = 0; i < dataString.length; ++i) {
                    r = sheet.getRow(i);
                    String[] dataString2 = dataString[i].split(":");
                    for (int j = cells; j < dataString2.length + cells - 1; ++j) {
                        c = r.createCell(j);
                        c.setCellValue(Double.parseDouble(dataString2[j - cells + 1]));
                    }
                }
                FileOutputStream output = new FileOutputStream(file);
                wb.write((OutputStream)output);
                output.close();
                JOptionPane.showMessageDialog(null, "File " + file.getName() + " updated.");
            } else {
                this.saveData(file);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void jButtonPlotGraphActionPerformed(ActionEvent evt) {
        this.setSize(1000, 450);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String data = this.jTextArea1.getText();
        String yLabel = "";
        String[] dataString = data.split("\n");
        for (int i = 0; i < dataString.length; ++i) {
            int j;
            if (this.jComboBoxGraphParameters.getSelectedItem().toString().equals("Exergy")) {
                yLabel = "Exergy Consumption (GJ)";
                for (j = 0; j < this.arraySustainabilityResults.size(); ++j) {
                    dataset.setValue(this.arraySustainabilityResults.get(j).getEmbeddedExergy(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"Embedded"));
                    dataset.setValue(this.arraySustainabilityResults.get(j).getOperationalExergy(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"Operational"));
                    dataset.setValue(this.arraySustainabilityResults.get(j).getLifetimeExergy(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"Lifetime"));
                }
                continue;
            }
            if (this.jComboBoxGraphParameters.getSelectedItem().toString().equals("TCO")) {
                yLabel = "Unit Cost";
                for (j = 0; j < this.arraySustainabilityResults.size(); ++j) {
                    dataset.setValue(this.arraySustainabilityResults.get(j).getInitialCost(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"Initial"));
                    dataset.setValue(this.arraySustainabilityResults.get(j).getOperationalCost(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"Operational"));
                    dataset.setValue(this.arraySustainabilityResults.get(j).getTotalCost(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"Total"));
                }
                continue;
            }
            if (this.jComboBoxGraphParameters.getSelectedItem().toString().equals("System Efficiency")) {
                yLabel = "(%)";
                for (j = 0; j < this.arraySustainabilityResults.size(); ++j) {
                    dataset.setValue(this.arraySustainabilityResults.get(j).getEfficiency(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"System Efficiency"));
                }
                continue;
            }
            if (!this.jComboBoxGraphParameters.getSelectedItem().toString().equals("Availability")) continue;
            yLabel = "(%)";
            for (j = 0; j < this.arraySustainabilityResults.size(); ++j) {
                dataset.setValue(this.arraySustainabilityResults.get(j).getAvailability(), (Comparable)((Object)this.arraySustainabilityResults.get(j).getLegend()), (Comparable)((Object)"System Availability"));
            }
        }
        JFreeChart chart2 = ChartFactory.createBarChart((String)"Sustainability Results", (String)"", (String)yLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        BufferedImage image = chart2.createBufferedImage(500, 300);
        this.jLabel1.setIcon(new ImageIcon(image));
    }

    private void saveData(File file) throws FileNotFoundException, IOException {
        String data = this.jTextArea1.getText();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s = wb.createSheet("Sustainability");
        HSSFRow r = null;
        HSSFCell c = null;
        int cont = 0;
        boolean test = data.contains("----------------------------------------------");
        if (test) {
            String[] dataStr = data.split("----------------------------------------------");
            for (int exp = 1; exp < dataStr.length; ++exp) {
                String[] dataString = dataStr[exp].split("\n");
                for (int i = 1; i < dataString.length; ++i) {
                    r = s.getRow(i);
                    if (r == null) {
                        r = s.createRow(i);
                    }
                    String[] dataString2 = dataString[i].split(":");
                    for (int j = 0; j < dataString2.length; ++j) {
                        if (dataString2[j].contains("= ")) {
                            String[] parameter = dataString[1].split("= ");
                            if (cont == 0) {
                                ++cont;
                                c = r.createCell(0);
                                c.setCellValue(parameter[0]);
                                c = r.createCell(j + exp);
                                c.setCellValue(Double.parseDouble(parameter[1]));
                                continue;
                            }
                            c = r.createCell(j + exp);
                            c.setCellValue(Double.parseDouble(parameter[1]));
                            continue;
                        }
                        if (j == 0 && exp == 1) {
                            c = r.createCell(j + exp - 1);
                            c.setCellValue(dataString2[j]);
                            continue;
                        }
                        if (j <= 0) continue;
                        c = r.createCell(j + exp - 1);
                        c.setCellValue(Double.parseDouble(dataString2[j]));
                    }
                }
            }
        } else {
            String[] dataString = data.split("\n");
            for (int i = 0; i < dataString.length; ++i) {
                r = s.createRow(i);
                String[] dataString2 = dataString[i].split(":");
                for (int j = 0; j < dataString2.length; ++j) {
                    c = r.createCell(j);
                    if (j == 0) {
                        c.setCellValue(dataString2[j]);
                        continue;
                    }
                    c.setCellValue(Double.parseDouble(dataString2[j]));
                }
            }
        }
        FileOutputStream output = new FileOutputStream(file);
        wb.write((OutputStream)output);
        output.close();
        JOptionPane.showMessageDialog(null, "File " + file.getName() + " created.");
    }
}

