/*
 * Decompiled with CFR 0.152.
 */
package com.hp.desdac.sustainability.gui;

import com.hp.desdac.powerstructure.entities.ApplicationPowerStructure;
import com.hp.desdac.powerstructure.entities.DataCenterComponent;
import com.hp.desdac.powerstructure.gui.graphview.GraphEdXPowerDataCenter;
import com.hp.desdac.powerstructure.gui.graphview.GraphicalConnectionDataCenter;
import com.hp.desdac.sustainability.EmbeddedExergy;
import com.hp.desdac.sustainability.OperationalExergy;
import com.hp.desdac.sustainability.SustainabilityComponent;
import com.hp.desdac.sustainability.SustainabilityResults;
import com.hp.desdac.sustainability.Tco;
import com.hp.desdac.sustainability.gui.JDialogSustainabilityResults;
import com.local.entities.ProjectDesdac;
import com.local.gui.JFrameDesdacTool;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.modcs.tools.rbd.blocks.bounds.SDPMethod;
import org.modcs.tools.rbd.graphrbd.GraphViewRBD;

public class JDialogSustainabilityParameterEvaluation
extends JDialog {
    private double fwr;
    private double msle;
    private double availability;
    private double ambTemp;
    private double systemOutputPower;
    private double lifeTime;
    private double eletricityCost;
    private double compTemp;
    private ProjectDesdac projectDesdac;
    private JFrameDesdacTool jFrameDesdacTool;
    private ApplicationPowerStructure applicationPowerStructure;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxComponent;
    private JComboBox jComboBoxComponentParameter;
    private JComboBox jComboBoxGlobalParameter;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonComponent;
    private JRadioButton jRadioButtonGlobalParameter;
    private JTextField jTextFieldFinal;
    private JTextField jTextFieldInitial;
    private JTextField jTextFieldStep;

    public JDialogSustainabilityParameterEvaluation(Frame parent, boolean modal, double fwr, double msle, double availability, double ambTemp, double systemOutputPower, double lifeTime, double eletricityCost, double compTemp, JFrameDesdacTool jFrameDesdacTool, ApplicationPowerStructure applicationPowerStructure) {
        super(parent, modal);
        this.initComponents();
        this.fwr = fwr;
        this.msle = msle;
        this.availability = availability;
        this.ambTemp = ambTemp;
        this.systemOutputPower = systemOutputPower;
        this.lifeTime = lifeTime;
        this.eletricityCost = eletricityCost;
        this.compTemp = compTemp;
        this.projectDesdac = jFrameDesdacTool.getProjectDesdac();
        this.jFrameDesdacTool = jFrameDesdacTool;
        this.applicationPowerStructure = applicationPowerStructure;
        this.setComboBox();
        this.jRadioButtonGlobalParameter.setSelected(false);
        this.jRadioButtonComponent.setSelected(false);
    }

    private void setComboBox() {
        int i;
        GraphEdXPowerDataCenter graphEdXDataCenter = this.applicationPowerStructure.getGraphViewDataCenter().getApp();
        GraphicalConnectionDataCenter graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
        ArrayList<String> components = new ArrayList<String>();
        for (i = 0; i < graphicalConnectionDataCenter.getComponentGraphicalElements().size(); ++i) {
            String type = graphicalConnectionDataCenter.getComponentGraphicalElements().get(i).getDataCenterComponent().getType();
            if (type.equals("SourcePoint") || type.equals("TargetPoint")) continue;
            String componentName = graphicalConnectionDataCenter.getComponentGraphicalElements().get(i).getDataCenterComponent().getName();
            components.add(componentName);
        }
        Collections.sort(components);
        for (i = 0; i < components.size(); ++i) {
            this.jComboBoxComponent.addItem(components.get(i));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxGlobalParameter = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldInitial = new JTextField();
        this.jTextFieldFinal = new JTextField();
        this.jTextFieldStep = new JTextField();
        this.jComboBoxComponent = new JComboBox();
        this.jComboBoxComponentParameter = new JComboBox();
        this.jRadioButtonComponent = new JRadioButton();
        this.jRadioButtonGlobalParameter = new JRadioButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        this.jComboBoxGlobalParameter.setModel(new DefaultComboBoxModel<String>(new String[]{"Select a Global Parameter", "Manufacturing second-law efficiency", "Fraction of waste reused (%)", "Availability", "Ambient Operating Temperature(C)", "System Output Power(kw)", "Total Lifetime (h)", "Electricity Cost (per KWH)"}));
        this.jComboBoxGlobalParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityParameterEvaluation.this.jComboBoxGlobalParameterActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Initial Value:");
        this.jLabel2.setText("Final Value:");
        this.jLabel3.setText("Step:");
        this.jComboBoxComponent.setModel(new DefaultComboBoxModel<String>(new String[]{"Select a Component"}));
        this.jComboBoxComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityParameterEvaluation.this.jComboBoxComponentActionPerformed(evt);
            }
        });
        this.jComboBoxComponentParameter.setModel(new DefaultComboBoxModel<String>(new String[]{"Select a Component Parameter", "Efficiency(%)", "Embedded Energy(GJ)", "Max. Power(kW)", "MTTF", "MTTR", "Retail Price", " "}));
        this.jComboBoxComponentParameter.setEnabled(false);
        this.jRadioButtonComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityParameterEvaluation.this.jRadioButtonComponentActionPerformed(evt);
            }
        });
        this.jRadioButtonGlobalParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityParameterEvaluation.this.jRadioButtonGlobalParameterActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldInitial, -1, 193, Short.MAX_VALUE).addComponent(this.jTextFieldFinal, -1, 193, Short.MAX_VALUE).addComponent(this.jTextFieldStep, -1, 193, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jRadioButtonGlobalParameter).addComponent(this.jRadioButtonComponent)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxComponent, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxComponentParameter, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxGlobalParameter, GroupLayout.Alignment.TRAILING, 0, 255, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxComponent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxComponentParameter, -2, -1, -2)).addComponent(this.jRadioButtonComponent)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxGlobalParameter, -2, -1, -2).addComponent(this.jRadioButtonGlobalParameter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldInitial, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldFinal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldStep, -2, -1, -2)).addGap(42, 42, 42)));
        this.jButtonOK.setText("Ok");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityParameterEvaluation.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDialogSustainabilityParameterEvaluation.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(82, 82, 82).addComponent(this.jButtonOK, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jComboBoxGlobalParameterActionPerformed(ActionEvent evt) {
        this.jComboBoxComponent.setSelectedIndex(0);
        this.jRadioButtonGlobalParameter.setSelected(true);
        this.jRadioButtonComponent.setSelected(false);
        this.jComboBoxComponentParameter.setEnabled(false);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        ArrayList<SustainabilityResults> arraySustainabilityResults = new ArrayList<SustainabilityResults>();
        if (this.jRadioButtonGlobalParameter.isSelected()) {
            int selected = this.jComboBoxGlobalParameter.getSelectedIndex();
            if (selected != 0) {
                double initialValue = Double.parseDouble(this.jTextFieldInitial.getText());
                double finalValue = Double.parseDouble(this.jTextFieldFinal.getText());
                double step = Double.parseDouble(this.jTextFieldStep.getText());
                String result = "";
                double ef = 0.0;
                while (initialValue <= finalValue) {
                    if (this.jComboBoxGlobalParameter.getSelectedItem().toString().equals("Manufacturing second-law efficiency")) {
                        this.msle = initialValue;
                    } else if (this.jComboBoxGlobalParameter.getSelectedItem().toString().equals("Fraction of waste reused (%)")) {
                        this.fwr = initialValue;
                    } else if (this.jComboBoxGlobalParameter.getSelectedItem().toString().equals("Availability")) {
                        this.availability = initialValue;
                    } else if (this.jComboBoxGlobalParameter.getSelectedItem().toString().equals("Ambient Operating Temperature(C)")) {
                        this.ambTemp = initialValue;
                    } else if (this.jComboBoxGlobalParameter.getSelectedItem().toString().equals("System Output Power(kw)")) {
                        this.systemOutputPower = initialValue;
                    } else if (this.jComboBoxGlobalParameter.getSelectedItem().toString().equals("Total Lifetime (h)")) {
                        this.lifeTime = initialValue;
                    } else if (this.jComboBoxGlobalParameter.getSelectedItem().toString().equals("Electricity Cost (per KWH)")) {
                        this.eletricityCost = initialValue;
                    }
                    result = result + "----------------------------------------------\n";
                    result = result + this.jComboBoxGlobalParameter.getSelectedItem().toString() + "= " + initialValue;
                    SustainabilityResults sustainabilityResults = new SustainabilityResults();
                    sustainabilityResults.setLegend(this.jComboBoxGlobalParameter.getSelectedItem().toString() + "=" + initialValue);
                    initialValue += step;
                    try {
                        this.jFrameDesdacTool.translateRBD();
                        SDPMethod icalculatorRBD = new SDPMethod(GraphViewRBD.app.getRBDModel());
                        this.availability = icalculatorRBD.getAvailability();
                        EmbeddedExergy embeddedExergy = new EmbeddedExergy(this.msle, this.fwr, this.applicationPowerStructure);
                        double embExergy = embeddedExergy.computeEmbeddedExergy();
                        result = result + "\n\nExergy\n======\nEmbedded Exergy Consumption (GJ): " + embExergy;
                        double systemEfficiency = 0.0;
                        SustainabilityComponent sustainabilityComponent = new SustainabilityComponent(this.ambTemp, this.compTemp, this.systemOutputPower, this.lifeTime, systemEfficiency, this.availability);
                        OperationalExergy operationalExergy = new OperationalExergy(sustainabilityComponent, this.applicationPowerStructure);
                        double operExergy = operationalExergy.computeOperationalExergy();
                        double in = operationalExergy.getSystemInputPower();
                        double out = this.systemOutputPower;
                        ef = out / in;
                        result = result + "\nOperational Exergy Consumption (GJ): " + operExergy;
                        double lifeTimeExergy = operExergy + embExergy;
                        result = result + "\nLifetime Exergy Consumption (GJ): " + lifeTimeExergy;
                        Tco tCO = new Tco(this.eletricityCost, this.applicationPowerStructure);
                        double operCost = tCO.computeOperationalCost(in, this.lifeTime, ef);
                        double iniCost = tCO.computeInitialCost();
                        result = result + "\n\nTCO\n======\nInitial Cost: " + iniCost + "\nOperational Cost: " + operCost + "\nTotal Cost: " + (operCost + iniCost) + "\n";
                        result = result + "\nAvailability: " + this.availability;
                        result = initialValue > finalValue ? result + "\nSystem Efficiency: " + ef : result + "\nSystem Efficiency: " + ef + "\n\n";
                        sustainabilityResults.setEmbeddedExergy(embExergy);
                        sustainabilityResults.setOperationalExergy(operExergy);
                        sustainabilityResults.setLifetimeExergy(lifeTimeExergy);
                        sustainabilityResults.setOperationalCost(operCost);
                        sustainabilityResults.setInitialCost(iniCost);
                        sustainabilityResults.setTotalCost(operCost + iniCost);
                        sustainabilityResults.setEfficiency(ef);
                        sustainabilityResults.setAvailability(this.availability);
                        arraySustainabilityResults.add(sustainabilityResults);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, "Incorret Number format.");
                    }
                }
                JDialogSustainabilityResults susResults = new JDialogSustainabilityResults(null, true, result, arraySustainabilityResults);
                susResults.setLocationRelativeTo(this);
                susResults.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(null, "Select a Parameter");
            }
        } else if (this.jRadioButtonComponent.isSelected()) {
            int selected = this.jComboBoxComponent.getSelectedIndex();
            if (selected == 0) {
                JOptionPane.showMessageDialog(null, "Select a Parameter");
            } else {
                String componentName = this.jComboBoxComponent.getSelectedItem().toString();
                String componentParameter = this.jComboBoxComponentParameter.getSelectedItem().toString();
                GraphEdXPowerDataCenter graphEdXDataCenter = this.applicationPowerStructure.getGraphViewDataCenter().getApp();
                GraphicalConnectionDataCenter graphicalConnectionDataCenter = GraphicalConnectionDataCenter.createGraphicalConnectionDataCenter(graphEdXDataCenter);
                DataCenterComponent dataCenterComponent = null;
                SustainabilityComponent sustainabilitycomponent = null;
                for (int i = 0; i < graphicalConnectionDataCenter.getComponentGraphicalElements().size(); ++i) {
                    String name = graphicalConnectionDataCenter.getComponentGraphicalElements().get(i).getDataCenterComponent().getName();
                    if (!name.equals(componentName)) continue;
                    dataCenterComponent = graphicalConnectionDataCenter.getComponentGraphicalElements().get(i).getDataCenterComponent();
                    sustainabilitycomponent = dataCenterComponent.getSustainabilityComponent();
                    break;
                }
                double initialValue = Double.parseDouble(this.jTextFieldInitial.getText());
                double finalValue = Double.parseDouble(this.jTextFieldFinal.getText());
                double step = Double.parseDouble(this.jTextFieldStep.getText());
                String result = "";
                double ef = 0.0;
                while (initialValue <= finalValue) {
                    if (componentParameter.equals("MTTR")) {
                        dataCenterComponent.setMttr(initialValue);
                    } else if (componentParameter.equals("MTTF")) {
                        dataCenterComponent.setMttf(initialValue);
                    } else if (componentParameter.equals("Max. Power(kW)")) {
                        sustainabilitycomponent.setMaxPower(initialValue);
                    } else if (componentParameter.equals("Efficiency(%)")) {
                        sustainabilitycomponent.setDeliEff(initialValue);
                    } else if (componentParameter.equals("Embedded Energy(GJ)")) {
                        sustainabilitycomponent.setEmbeddedEnergy(initialValue);
                    } else if (componentParameter.equals("Retail Price")) {
                        sustainabilitycomponent.setProducerPrice(initialValue);
                    }
                    result = result + "----------------------------------------------\n";
                    result = result + componentName + " " + componentParameter + "= " + initialValue;
                    SustainabilityResults sustainabilityResults = new SustainabilityResults();
                    sustainabilityResults.setLegend(componentParameter + "=" + initialValue);
                    initialValue += step;
                    try {
                        this.jFrameDesdacTool.translateRBD();
                        SDPMethod icalculatorRBD = new SDPMethod(GraphViewRBD.app.getRBDModel());
                        this.availability = icalculatorRBD.getAvailability();
                        EmbeddedExergy embeddedExergy = new EmbeddedExergy(this.msle, this.fwr, this.applicationPowerStructure);
                        double embExergy = embeddedExergy.computeEmbeddedExergy();
                        result = result + "\n\nExergy\n======\nEmbedded Exergy Consumption (GJ): " + embExergy;
                        double systemEfficiency = 0.0;
                        SustainabilityComponent sustainabilityComponent = new SustainabilityComponent(this.ambTemp, this.compTemp, this.systemOutputPower, this.lifeTime, systemEfficiency, this.availability);
                        OperationalExergy operationalExergy = new OperationalExergy(sustainabilityComponent, this.applicationPowerStructure);
                        double operExergy = operationalExergy.computeOperationalExergy();
                        double in = operationalExergy.getSystemInputPower();
                        double out = this.systemOutputPower;
                        ef = out / in;
                        result = result + "\nOperational Exergy Consumption (GJ): " + operExergy;
                        double lifeTimeExergy = operExergy + embExergy;
                        result = result + "\nLifetime Exergy Consumption (GJ): " + lifeTimeExergy;
                        Tco tCO = new Tco(this.eletricityCost, this.applicationPowerStructure);
                        double operCost = tCO.computeOperationalCost(in, this.lifeTime, ef);
                        double iniCost = tCO.computeInitialCost();
                        result = result + "\n\nTCO\n======\nInitial Cost: " + iniCost + "\nOperational Cost: " + operCost + "\nTotal Cost: " + (operCost + iniCost) + "\n";
                        result = result + "\nAvailability: " + this.availability;
                        result = initialValue > finalValue ? result + "\nSystem Efficiency: " + ef : result + "\nSystem Efficiency: " + ef + "\n\n";
                        sustainabilityResults.setEmbeddedExergy(embExergy);
                        sustainabilityResults.setOperationalExergy(operExergy);
                        sustainabilityResults.setLifetimeExergy(lifeTimeExergy);
                        sustainabilityResults.setOperationalCost(operCost);
                        sustainabilityResults.setInitialCost(iniCost);
                        sustainabilityResults.setTotalCost(operCost + iniCost);
                        sustainabilityResults.setEfficiency(ef);
                        sustainabilityResults.setAvailability(this.availability);
                        arraySustainabilityResults.add(sustainabilityResults);
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, "Incorret Number format.");
                    }
                }
                JDialogSustainabilityResults susResults = new JDialogSustainabilityResults(null, true, result, arraySustainabilityResults);
                susResults.setLocationRelativeTo(this);
                susResults.setVisible(true);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxComponentActionPerformed(ActionEvent evt) {
        this.jRadioButtonGlobalParameter.setSelected(false);
        this.jRadioButtonComponent.setSelected(true);
        this.jComboBoxComponentParameter.setEnabled(true);
    }

    private void jRadioButtonGlobalParameterActionPerformed(ActionEvent evt) {
        this.jRadioButtonGlobalParameter.setSelected(true);
        this.jRadioButtonComponent.setSelected(false);
        this.jComboBoxComponentParameter.setEnabled(false);
    }

    private void jRadioButtonComponentActionPerformed(ActionEvent evt) {
        this.jRadioButtonGlobalParameter.setSelected(false);
        this.jRadioButtonComponent.setSelected(true);
        this.jComboBoxComponentParameter.setEnabled(true);
    }
}

